/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxRsClientSSLOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientSSLOutInterceptor.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    private static final String HTTPS_SCHEMA = "https";
    private static final boolean overrideUserTLS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
        static final long serialVersionUID = -5832624655761249765L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.ws.jaxrs.client.security.overrideUserTLSConfig");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor$1", 1.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
        }
    });
    private TLSConfiguration secConfig = null;
    static final long serialVersionUID = 5301461117519296372L;

    public LibertyJaxRsClientSSLOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        SSLSocketFactory socketFactory;
        String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        if (!address.startsWith(HTTPS_SCHEMA)) {
            return;
        }
        if (!overrideUserTLS && PropertyUtils.isTrue((Object)message.get((Object)"org.apache.cxf.microprofile.client.sslConfigProvided"))) {
            return;
        }
        Object sslRefObj = message.get((Object)"com.ibm.ws.jaxrs.client.ssl.config");
        String sslRef = null;
        if (sslRefObj != null) {
            sslRef = (String)sslRefObj;
        }
        if ((socketFactory = this.getSocketFactory(sslRef, message)) != null) {
            Object disableCNCheckObj = message.get((Object)"com.ibm.ws.jaxrs.client.disableCNCheck");
            Conduit cd = message.getExchange().getConduit(message);
            this.configClientSSL(cd, sslRef, PropertyUtils.isTrue((Object)disableCNCheckObj), socketFactory);
        }
    }

    private void configClientSSL(Conduit conduit, String sslRef, boolean disableCNCheck, SSLSocketFactory socketFactory) {
        HTTPConduit httpConduit;
        TLSClientParameters tlsClientParams;
        if (conduit instanceof HTTPConduit && null != (tlsClientParams = this.retriveHTTPTLSClientParametersUsingSSLRef(httpConduit = (HTTPConduit)conduit, sslRef, disableCNCheck, socketFactory))) {
            httpConduit.setTlsClientParameters(tlsClientParams);
        }
    }

    private TLSClientParameters retriveHTTPTLSClientParametersUsingSSLRef(HTTPConduit httpConduit, String sslRef, boolean disableCNCheck, SSLSocketFactory sslSocketFactory) {
        TLSClientParameters tlsClientParams = null;
        tlsClientParams = this.secConfig == null ? httpConduit.getTlsClientParameters() : this.secConfig.getTlsClientParams();
        if (!StringUtils.isEmpty((String)sslRef)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Use the sslRef = " + sslRef + " to create the SSLSocketFactory."), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Get Liberty default SSLSocketFactory.", (Object[])new Object[0]);
        }
        if (null != sslSocketFactory) {
            if (null == tlsClientParams) {
                tlsClientParams = new TLSClientParameters();
            }
            tlsClientParams.setSSLSocketFactory(sslSocketFactory);
            tlsClientParams.setDisableCNCheck(disableCNCheck);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"May not enable feature ssl-1.0 or appSecurity-2.0.", (Object[])new Object[0]);
        }
        return tlsClientParams;
    }

    public void setTLSConfiguration(TLSConfiguration secConfig) {
        this.secConfig = secConfig;
    }

    /*
     * WARNING - void declaration
     */
    private SSLSocketFactory getSocketFactory(String sslRef, Message message) {
        try {
            final Class<?> jaxrsSslMgrClass = Class.forName("com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager");
            if (jaxrsSslMgrClass == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getSocketFactory could not find JaxRsSSLManager class", (Object[])new Object[0]);
                }
                return null;
            }
            Object classObject = jaxrsSslMgrClass.newInstance();
            Method m = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                static final long serialVersionUID = -7732514283823579852L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Method run() throws NoSuchMethodException, SecurityException {
                    return jaxrsSslMgrClass.getDeclaredMethod("getSSLSocketFactoryBySSLRef", String.class, String.class, String.class);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor$2", 2.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
                }
            });
            String uriString = (String)message.get((Object)"org.apache.cxf.request.uri");
            URI uri = URI.create(uriString);
            int port = uri.getPort();
            if (port == -1 && !uriString.contains(":-1")) {
                port = 443;
            }
            Object[] parameters = new Object[]{sslRef, uri.getHost(), Integer.toString(port)};
            SSLSocketFactory ssLSocketFactory = (SSLSocketFactory)m.invoke(classObject, parameters);
            return ssLSocketFactory;
        }
        catch (Exception jaxrsSslMgrClass) {
            FFDCFilter.processException((Throwable)jaxrsSslMgrClass, (String)"com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor", (String)"171", (Object)((Object)this), (Object[])new Object[]{sslRef, message});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("getSocketFactory reflection failed with exception " + e.toString()), (Object[])new Object[0]);
            }
            return null;
        }
    }
}

