/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.policy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.policy.URIDomainExpressionBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.attachment.AbstractPolicyProvider;
import org.apache.cxf.ws.policy.attachment.external.DomainExpression;
import org.apache.cxf.ws.policy.attachment.external.DomainExpressionBuilderRegistry;
import org.apache.cxf.ws.policy.attachment.external.PolicyAttachment;
import org.apache.cxf.ws.policy.attachment.reference.LocalDocumentReferenceResolver;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NoJSR250Annotations
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DynamicAttachmentProvider
extends AbstractPolicyProvider
implements PolicyProvider {
    private static final TraceComponent tc = Tr.register(DynamicAttachmentProvider.class, null, null);
    private String location = null;
    private Collection<PolicyAttachment> attachments;
    static final long serialVersionUID = 59256520548996894L;

    public DynamicAttachmentProvider() {
    }

    public DynamicAttachmentProvider(Bus b) {
        super(b);
    }

    public void setLocation(String u) {
        this.location = u;
    }

    public String getLocation() {
        return this.location;
    }

    public Policy getEffectivePolicy(BindingFaultInfo bfi) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEffectivePolicy for BindingFaultInfo", (Object[])new Object[]{bfi != null ? bfi : null});
        }
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            boolean merge = pa.appliesTo(bfi);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"If merges BindingFaultInfo Policy by using this PolicyAttachment", (Object[])new Object[]{pa.getPolicy().getAttributes(), merge});
            }
            if (!merge) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(BindingMessageInfo bmi) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEffectivePolicy for BindingMessageInfo", (Object[])new Object[]{bmi != null ? bmi.getMessageInfo() : null});
        }
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            boolean merge = pa.appliesTo(bmi);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"If merges BindingMessageInfo Policy by using this PolicyAttachment", (Object[])new Object[]{pa.getPolicy().getAttributes(), merge});
            }
            if (!merge) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(BindingOperationInfo boi) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEffectivePolicy for BindingOperationInfo", (Object[])new Object[]{boi != null ? boi : null});
        }
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            boolean merge = pa.appliesTo(boi);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"If merges BindingOperationInfo Policy by using this PolicyAttachment", (Object[])new Object[]{pa.getPolicy().getAttributes(), merge});
            }
            if (!merge) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(EndpointInfo ei) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEffectivePolicy for EndpointInfo", (Object[])new Object[]{ei != null ? ei : null});
        }
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            boolean merge = pa.appliesTo(ei);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"If merges EndpointInfo Policy by using this PolicyAttachment", (Object[])new Object[]{pa.getPolicy().getAttributes(), merge});
            }
            if (!merge) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(ServiceInfo si) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEffectivePolicy for ServiceInfo", (Object[])new Object[]{si != null ? si.getName() : null});
        }
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            boolean merge = pa.appliesTo(si);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"If merges ServiceInfo Policy by using this PolicyAttachment", (Object[])new Object[]{pa.getPolicy().getAttributes(), merge});
            }
            if (!merge) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void readDocument() {
        if (null != this.attachments) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Policy already loaded, return", (Object[])new Object[0]);
            }
            return;
        }
        this.attachments = new ArrayList<PolicyAttachment>();
        Document doc = null;
        try {
            InputStream is = null;
            ClassLoader classLoader = this.getThreadContextClassLoader();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Start to load policy from template", (Object[])new Object[]{classLoader.getResource(this.location)});
            }
            if (classLoader.getResource(this.location) != null) {
                is = classLoader.getResourceAsStream(this.location);
            }
            if (null == is) {
                throw new PolicyException((Throwable)new Exception("Could not open the special policy attachment file because getResourceAsStream is null"));
            }
            doc = DOMUtils.readXml((InputStream)is);
        }
        catch (Exception is) {
            void ex;
            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.jaxws.policy.DynamicAttachmentProvider", (String)"196", (Object)((Object)this), (Object[])new Object[0]);
            throw new PolicyException((Throwable)ex);
        }
        for (Element ae : PolicyConstants.findAllPolicyElementsOfLocalName((Document)doc, (String)"PolicyAttachment")) {
            PolicyAttachment attachment = new PolicyAttachment();
            for (Node nd = ae.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                PolicyReference ref;
                if (1 != nd.getNodeType()) continue;
                QName qn = new QName(nd.getNamespaceURI(), nd.getLocalName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parse attachment element", (Object[])new Object[]{nd.getNamespaceURI(), nd.getLocalName()});
                }
                if (Constants.isAppliesToElem((QName)qn)) {
                    Collection<DomainExpression> des = this.readDomainExpressions((Element)nd);
                    if (des.isEmpty()) continue;
                    attachment.setDomainExpressions(des);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Size of attachment element for AppliesTo", (Object[])new Object[]{des.size()});
                    continue;
                }
                if (Constants.isPolicyElement((QName)qn)) {
                    Policy p = this.builder.getPolicy((Object)nd);
                    if (null != attachment.getPolicy()) {
                        p = p.merge(attachment.getPolicy());
                    }
                    attachment.setPolicy(p);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Parse attachment element for Policy", (Object[])new Object[]{p != null ? p.getAttributes() : null});
                    continue;
                }
                if (!Constants.isPolicyRef((QName)qn) || null == (ref = this.builder.getPolicyReference((Object)nd))) continue;
                Policy p = this.resolveReference(ref, doc);
                if (null != attachment.getPolicy()) {
                    p = p.merge(attachment.getPolicy());
                }
                attachment.setPolicy(p);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Parse attachment element for PolicyReference", (Object[])new Object[]{p != null ? p.getAttributes() : null});
            }
            if (null == attachment.getPolicy() || null == attachment.getDomainExpressions()) continue;
            this.attachments.add(attachment);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Size of final policy attachment", (Object[])new Object[]{this.attachments.size()});
        }
    }

    Policy resolveReference(PolicyReference ref, Document doc) {
        Policy p = null;
        p = this.isExternal(ref) ? this.resolveExternal(ref, doc.getBaseURI()) : this.resolveLocal(ref, doc);
        this.checkResolved(ref, p);
        return p;
    }

    Policy resolveLocal(PolicyReference ref, Document doc) {
        String relativeURI = ref.getURI().substring(1);
        String absoluteURI = doc.getBaseURI() + ref.getURI();
        Policy resolved = this.registry.lookup(absoluteURI);
        if (null != resolved) {
            return resolved;
        }
        LocalDocumentReferenceResolver resolver = new LocalDocumentReferenceResolver(doc, this.builder);
        resolved = resolver.resolveReference(relativeURI);
        if (null != resolved) {
            ref.setURI(absoluteURI);
            this.registry.register(absoluteURI, resolved);
        }
        return resolved;
    }

    Collection<DomainExpression> readDomainExpressions(Element appliesToElem) {
        ArrayList<DomainExpression> des = new ArrayList<DomainExpression>();
        for (Node nd = appliesToElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            DomainExpression de;
            URIDomainExpressionBuilder debr;
            if (1 != nd.getNodeType()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readDomainExpressions by using", (Object[])new Object[]{nd.getNamespaceURI(), nd.getLocalName()});
            }
            if (nd.getLocalName().equals("URI")) {
                debr = (URIDomainExpressionBuilder)this.bus.getExtension(URIDomainExpressionBuilder.class);
                assert (null != debr);
                de = debr.build((Element)nd);
                des.add(de);
                continue;
            }
            if (nd.getLocalName().equals("EndpointReference")) {
                debr = (DomainExpressionBuilderRegistry)this.bus.getExtension(DomainExpressionBuilderRegistry.class);
                assert (null != debr);
                de = debr.build((Element)nd);
                des.add(de);
                continue;
            }
            throw new PolicyException((Throwable)new Exception("No Related DomainExpressionBuilder"));
        }
        return des;
    }

    void setAttachments(Collection<PolicyAttachment> a) {
        this.attachments = a;
    }

    public Collection<PolicyAttachment> getAttachments() {
        return this.attachments;
    }

    private ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 4320617775965565212L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.policy.DynamicAttachmentProvider$1", 1.class, null, null);
            }
        });
    }
}

