/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASMechConfig;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CSSSASMechConfig
implements Serializable {
    private static final TraceComponent tc = Tr.register(CSSSASMechConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    public static final String TYPE_ITTAnonymous = "ITTAnonymous";
    public static final String TYPE_ITTPrincipalName = "ITTPrincipalName";
    public static final String TYPE_ITTX509CertChain = "ITTX509CertChain";
    public static final String TYPE_ITTDistinguishedName = "ITTDistinguishedName";
    protected short supports;
    protected final Map<Integer, CSSSASIdentityToken> idTokens = new HashMap<Integer, CSSSASIdentityToken>();
    private short requires;
    private boolean required;
    private CSSSASIdentityToken identityToken;
    private String trustedIdentity;
    private SerializableProtectedString trustedPassword;
    private int supportedIdentityTypes;
    private String cantHandleMsg = null;
    private final List<String> configuredTypes = new ArrayList<String>();
    static final long serialVersionUID = -5727345326876120621L;

    public short getSupports() {
        return this.supports;
    }

    public short getRequires() {
        return this.requires;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public CSSSASIdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(CSSSASIdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    public void addIdentityToken(CSSSASIdentityToken identityToken) {
        short type = (short)identityToken.getType();
        this.supportedIdentityTypes |= type;
        this.idTokens.put(identityToken.getType(), identityToken);
        if (identityToken.getType() > 0) {
            this.supports = (short)(this.supports | 0x400);
            if (type != 1) {
                this.configuredTypes.add(this.typesToString(type));
            }
        }
    }

    public boolean canHandle(TSSSASMechConfig sasMech, String clientMech) {
        if ((this.supports & sasMech.getRequires()) != sasMech.getRequires()) {
            this.buildSupportsFailedMsg(sasMech, clientMech);
            return false;
        }
        if ((this.requires & sasMech.getSupports()) != this.requires) {
            this.buildRequiresFailedMsg(sasMech, clientMech);
            return false;
        }
        int targetServerSupportedTypes = sasMech.getSupportedIdentityTypes();
        if (this.supportedIdentityTypes != 0 && targetServerSupportedTypes != 0 && (this.supportedIdentityTypes & targetServerSupportedTypes) == 0) {
            this.buildIdentityAssertionFailedMsg(sasMech, clientMech);
            return false;
        }
        return true;
    }

    public String getCantHandleMsg() {
        return this.cantHandleMsg;
    }

    public AuthorizationElement[] encodeAuthorizationElement() {
        return new AuthorizationElement[0];
    }

    public IdentityToken encodeIdentityToken(TSSSASMechConfig tsssasMechConfig, Codec codec) {
        CSSSASIdentityToken identityToken = this.idTokens.get(0);
        if (this.supports != 0) {
            Subject subject = this.getClientSubject();
            SubjectHelper subjectHelper = new SubjectHelper();
            int targetServerSupportedTypes = tsssasMechConfig.getSupportedIdentityTypes();
            identityToken = subjectHelper.isUnauthenticated(subject) ? this.getAnonymousIdentityToken(targetServerSupportedTypes) : this.getIdentityTokenBasedOnConfiguredTypes(targetServerSupportedTypes);
        }
        return identityToken.encodeIdentityToken(codec);
    }

    protected Subject getClientSubject() {
        SubjectManager subjectManager = new SubjectManager();
        Subject subject = subjectManager.getInvocationSubject();
        if (subject == null) {
            subject = subjectManager.getCallerSubject();
        }
        return subject;
    }

    private CSSSASIdentityToken getAnonymousIdentityToken(int targetServerSupportedTypes) {
        CSSSASIdentityToken identityToken = null;
        if (this.idTokens.get(1) != null) {
            if ((targetServerSupportedTypes & 1) != 0) {
                identityToken = this.idTokens.get(1);
            } else {
                this.debugAndThrowNoPermissionException("The client cannot create the ITTAnonymous identity assertion token because it is not supported by the configuration of the remote server.", "CSIv2_CLIENT_ANONYMOUS_ASSERTION_NOT_SUPPORTED_BY_SERVER", "CWWKS9545E: The client cannot create the ITTAnonymous identity assertion token because it is not supported by the configuration of the remote server.");
            }
        } else {
            this.debugAndThrowNoPermissionException("The client cannot create the ITTAnonymous identity assertion token because it is not supported by the configuration of this client.", "CSIv2_CLIENT_ANONYMOUS_ASSERTION_NOT_SUPPORTED_BY_CLIENT", "CWWKS9546E: The client cannot create the ITTAnonymous identity assertion token because it is not supported by the configuration of this client.");
        }
        return identityToken;
    }

    private void debugAndThrowNoPermissionException(String debugMsg, String formattedMsgKey, String backupMsg) throws NO_PERMISSION {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)debugMsg, (Object[])new Object[0]);
        }
        String messageFromBundle = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)formattedMsgKey, (Object[])new Object[0], (String)backupMsg);
        throw new NO_PERMISSION(messageFromBundle, 1229066387, CompletionStatus.COMPLETED_NO);
    }

    private CSSSASIdentityToken getIdentityTokenBasedOnConfiguredTypes(int targetServerSupportedTypes) {
        CSSSASIdentityToken identityToken = null;
        for (String assertionType : this.configuredTypes) {
            int tokenType = this.stringToType(assertionType);
            if (!this.canPerformAssertionWith(tokenType, targetServerSupportedTypes)) continue;
            identityToken = this.idTokens.get(tokenType);
            break;
        }
        this.ensureThereIsAnIdentityToken(identityToken);
        return identityToken;
    }

    private int stringToType(String typeString) {
        int result = 0;
        if (TYPE_ITTAnonymous.equals(typeString)) {
            result = 1;
        } else if (TYPE_ITTPrincipalName.equals(typeString)) {
            result = 2;
        } else if (TYPE_ITTX509CertChain.equals(typeString)) {
            result = 4;
        } else if (TYPE_ITTDistinguishedName.equals(typeString)) {
            result = 8;
        }
        return result;
    }

    private boolean canPerformAssertionWith(int tokenType, int targetServerSupportedTypes) {
        return (this.supportedIdentityTypes & tokenType) != 0 && (targetServerSupportedTypes & tokenType) != 0;
    }

    private void ensureThereIsAnIdentityToken(CSSSASIdentityToken identityToken) {
        if (identityToken == null) {
            String messageFromBundle = null;
            if (this.supportedIdentityTypes == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The client cannot assert an authenticated subject because it supports identity assertions with ITTAnonymous only.", (Object[])new Object[0]);
                }
                messageFromBundle = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_ANONYMOUS_ASSERTION_ONLY", (Object[])new Object[0], (String)"CWWKS9547E: The client cannot assert an authenticated subject because it supports identity assertions with ITTAnonymous only.");
            } else {
                String configuredTypesExcludingAnonymous = this.typesToString(this.supportedIdentityTypes & 0xE);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The client cannot assert an authenticated subject because the configuration of the remote server does not support identity assertions with types:", (Object[])new Object[]{configuredTypesExcludingAnonymous});
                }
                messageFromBundle = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_ASSERTION_TYPE_NOT_SUPPORTED", (Object[])new Object[]{configuredTypesExcludingAnonymous}, (String)"CWWKS9548E: The client cannot assert an authenticated subject because the configuration of the remote server does not support identity assertions with types <{0}>.");
            }
            throw new NO_PERMISSION(messageFromBundle, 1229066387, CompletionStatus.COMPLETED_NO);
        }
    }

    @Trivial
    private String typesToString(int type) {
        String result = "";
        String SPACE = " ";
        if ((1 & type) != 0) {
            result = result + "ITTAnonymous ";
        }
        if ((2 & type) != 0) {
            result = result + "ITTPrincipalName ";
        }
        if ((4 & type) != 0) {
            result = result + "ITTX509CertChain ";
        }
        if ((8 & type) != 0) {
            result = result + TYPE_ITTDistinguishedName;
        }
        if (result.isEmpty()) {
            return "None";
        }
        return result.trim();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSSASMechConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS: ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES: ").append(ConfigUtil.flags(this.requires)).append("\n");
        if (this.identityToken != null) {
            this.identityToken.toString(moreSpaces, buf);
        }
        buf.append("\n");
        for (CSSSASIdentityToken identityToken : this.idTokens.values()) {
            identityToken.toString(moreSpaces, buf);
        }
        buf.append(spaces).append("]\n");
    }

    public boolean isAsserting() {
        return this.trustedIdentity != null;
    }

    public void setTrustedIdentity(String trustedIdentity) {
        this.trustedIdentity = trustedIdentity;
    }

    public String getTrustedIdentity() {
        return this.trustedIdentity;
    }

    public void setTrustedPassword(SerializableProtectedString trustedPassword) {
        this.trustedPassword = trustedPassword;
    }

    public SerializableProtectedString getTrustedPassword() {
        return this.trustedPassword;
    }

    public int getSupportedIdentityTypes() {
        return this.supportedIdentityTypes;
    }

    public boolean isAssertingITTAbsent(TSSSASMechConfig tsssasMechConfig) {
        int targetServerSupportedTypes = tsssasMechConfig.getSupportedIdentityTypes();
        return (this.supportedIdentityTypes & targetServerSupportedTypes) == 0;
    }

    private void buildSupportsFailedMsg(TSSSASMechConfig sasMech, String clientMech) {
        this.cantHandleMsg = !clientMech.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_SUPPORTS_FAILED", (Object[])new Object[]{clientMech, ConfigUtil.flags(this.supports), ConfigUtil.flags(sasMech.getRequires())}, (String)"CWWKS9559E: The client security policy has the attribute layer configured for {0} with <{1}> as Supported in the server.xml file and the server security policy is configured with <{2}> as Required.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_SUPPORTS_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.supports), ConfigUtil.flags(sasMech.getRequires())}, (String)"CWWKS9560E: The client security policy has the attribute layer configured with <{0}> as Supported in the server.xml file and the server security policy is configured with <{1}> as Required.");
    }

    private void buildRequiresFailedMsg(TSSSASMechConfig sasMech, String clientMech) {
        this.cantHandleMsg = !clientMech.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_REQUIRES_FAILED", (Object[])new Object[]{clientMech, ConfigUtil.flags(this.requires), ConfigUtil.flags(sasMech.getSupports())}, (String)"CWWKS9561E: The client security policy has the attribute layer configured for {0} with <{1}> as Required in the server.xml file and the server security policy is configured with <{2}> as Supported.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_REQUIRES_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.requires), ConfigUtil.flags(sasMech.getSupports())}, (String)"CWWKS9562E: The client security policy has the attribute layer configured with <{0}> as Required in the server.xml file and the server security policy is configured with <{1}> as Supported.");
    }

    private void buildIdentityAssertionFailedMsg(TSSSASMechConfig sasMech, String clientMech) {
        this.cantHandleMsg = !clientMech.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_IDENTITY_ASSERTION_FAILED", (Object[])new Object[]{clientMech, ConfigUtil.flags(this.supports), ConfigUtil.flags(sasMech.getRequires())}, (String)"CWWKS9563E: The client security policy has the attribute layer configured for <{0}> with identity assertion type <{1}> in the server.xml file and the server security policy is configured with identity assertion type <{2}>.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_ATTRIBUTE_IDENTITY_ASSERTION_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.supports), ConfigUtil.flags(sasMech.getRequires())}, (String)"CWWKS9564E: The client security policy has the attribute layer configured with identity assertion type <{0}> in the server.xml file and the server security policy is configured with identity assertion type <{1}>.");
    }
}

