/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.impl.SimpleTimer30Impl;
import java.time.Duration;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorSimpleTimer
extends SimpleTimer30Impl {
    private static final TraceComponent tc = Tr.register(MonitorSimpleTimer.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.monitor.resources.MonitorMetrics");
    MBeanServer mbs;
    String objectName;
    String counterAttribute;
    String counterSubAttribute;
    String gaugeAttribute;
    String gaugeSubAttribute;
    long time;
    boolean isComposite = false;
    HashSet<Long> usedTimes = new HashSet();
    private long cachedMBPreviousMinute_max = 0L;
    private long cachedMBPreviousMinute_min = 0L;
    private long cachedMBLatestMinute_max = 0L;
    private long cachedMBLatestMinute_min = 0L;
    private long displayMaxLatest_forThisMinute = 0L;
    private long displayMinLatest_forThisMinute = 0L;
    private long displayMaxLatest_forThisMinute_val = 0L;
    private long displayMinLatest_forThisMinute_val = 0L;
    private long displayMaxPrev_forThisMinute = 0L;
    private long displayMinPrev_forThisMinute = 0L;
    private long mbean_latest_min;
    private long mbean_latest_max;
    private long mbean_latestMinute;
    private long mbean_previous_min;
    private long mbean_previous_max;
    private long mbean_prevMinute;
    private long rollingBaseMinute = 0L;
    static final long serialVersionUID = 6976591446811104039L;

    public MonitorSimpleTimer(MBeanServer mbs, String objectName, String counterAttribute, String counterSubAttribute, String gaugeAttribute, String gaugeSubAttribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.counterAttribute = counterAttribute;
        this.counterSubAttribute = counterSubAttribute;
        this.gaugeAttribute = gaugeAttribute;
        this.gaugeSubAttribute = gaugeSubAttribute;
    }

    /*
     * WARNING - void declaration
     */
    public long getCount() {
        try {
            if (this.counterSubAttribute != null) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.counterAttribute);
                Number numValue = (Number)value.get(this.counterSubAttribute);
                return numValue.longValue();
            }
            Number value = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.counterAttribute);
            return value.longValue();
        }
        catch (Exception value) {
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorSimpleTimer", (String)"82", (Object)((Object)this), (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getCount exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCount:Exception");
            }
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Duration getElapsedTime() {
        try {
            if (this.gaugeSubAttribute != null) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.gaugeAttribute);
                Number numValue = (Number)value.get(this.gaugeSubAttribute);
                return Duration.ofNanos(numValue.longValue());
            }
            Number numValue = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.gaugeAttribute);
            return Duration.ofNanos(numValue.longValue());
        }
        catch (Exception numValue) {
            FFDCFilter.processException((Throwable)numValue, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorSimpleTimer", (String)"103", (Object)((Object)this), (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getElapsedTime exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getElapsedTime:Exception");
            }
            return Duration.ZERO;
        }
    }

    public synchronized Duration getMaxTimeDuration() {
        this.getMinMaxValues();
        long currentMinute = this.getCurrentMinuteFromSystem();
        if ((this.cachedMBPreviousMinute_max != this.mbean_prevMinute || this.displayMaxPrev_forThisMinute == currentMinute) && currentMinute != this.mbean_prevMinute && this.mbean_prevMinute != 0L && (this.mbean_prevMinute > this.rollingBaseMinute || currentMinute == this.displayMaxLatest_forThisMinute && this.mbean_previous_max == this.displayMaxLatest_forThisMinute_val)) {
            this.cachedMBPreviousMinute_max = this.mbean_prevMinute;
            this.displayMaxPrev_forThisMinute = currentMinute;
            return Duration.ofNanos(this.mbean_previous_max);
        }
        if ((this.cachedMBLatestMinute_max != this.mbean_latestMinute || this.displayMaxLatest_forThisMinute == currentMinute) && currentMinute != this.mbean_latestMinute) {
            this.cachedMBLatestMinute_max = this.mbean_latestMinute;
            this.displayMaxLatest_forThisMinute = currentMinute;
            this.displayMaxLatest_forThisMinute_val = this.mbean_latest_max;
            this.rollingBaseMinute = currentMinute;
            return Duration.ofNanos(this.mbean_latest_max);
        }
        return null;
    }

    public synchronized Duration getMinTimeDuration() {
        this.getMinMaxValues();
        long currentMinute = this.getCurrentMinuteFromSystem();
        if ((this.cachedMBPreviousMinute_min != this.mbean_prevMinute || this.displayMinPrev_forThisMinute == currentMinute) && currentMinute != this.mbean_prevMinute && this.mbean_prevMinute != 0L && (this.mbean_prevMinute > this.rollingBaseMinute || currentMinute == this.displayMinLatest_forThisMinute && this.displayMinLatest_forThisMinute_val == this.mbean_previous_min)) {
            this.cachedMBPreviousMinute_min = this.mbean_prevMinute;
            this.displayMinPrev_forThisMinute = currentMinute;
            return Duration.ofNanos(this.mbean_previous_min);
        }
        if ((this.cachedMBLatestMinute_min != this.mbean_latestMinute || this.displayMinLatest_forThisMinute == currentMinute) && currentMinute != this.mbean_latestMinute) {
            this.cachedMBLatestMinute_min = this.mbean_latestMinute;
            this.displayMinLatest_forThisMinute = currentMinute;
            this.displayMinLatest_forThisMinute_val = this.mbean_latest_min;
            this.rollingBaseMinute = currentMinute;
            return Duration.ofNanos(this.mbean_latest_min);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void getMinMaxValues() {
        block5: {
            try {
                MonitorSimpleTimer monitorSimpleTimer = this;
                synchronized (monitorSimpleTimer) {
                    this.mbean_latest_min = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinuteLatestMinimumDuration")).longValue();
                    this.mbean_latest_max = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinuteLatestMaximumDuration")).longValue();
                    this.mbean_latestMinute = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinuteLatest")).longValue();
                    this.mbean_previous_min = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinutePreviousMinimumDuration")).longValue();
                    this.mbean_previous_max = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinutePreviousMaximumDuration")).longValue();
                    this.mbean_previous_max = ((Number)this.mbs.getAttribute(new ObjectName(this.objectName), "MinutePrevious")).longValue();
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorSimpleTimer", (String)"336", (Object)((Object)this), (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"getMinMaxValues exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getMinMaxValues:Exception");
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }
}

