/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileContainerUtils;
import com.ibm.ws.artifact.zip.internal.ZipFileEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileNestedDirContainer
implements ArtifactContainer {
    private final ZipFileContainer rootContainer;
    private final String name;
    private final String a_path;
    private final ZipFileEntry entryInEnclosingContainer;
    static final long serialVersionUID = 1970683401068267611L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ZipFileNestedDirContainer(ZipFileContainer rootContainer, ZipFileEntry entryInEnclosingContainer, String name, String a_path) {
        this.rootContainer = rootContainer;
        this.entryInEnclosingContainer = entryInEnclosingContainer;
        this.name = name;
        this.a_path = a_path;
    }

    @Trivial
    public boolean isRoot() {
        return false;
    }

    @Trivial
    public ZipFileContainer getRoot() {
        return this.rootContainer;
    }

    @Trivial
    public ArtifactNotifier getArtifactNotifier() {
        return this.rootContainer.getArtifactNotifier();
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    public String getPath() {
        return this.a_path;
    }

    @Trivial
    public String getAbsolutePath() {
        return this.a_path;
    }

    @Trivial
    public String getRelativePath() {
        return this.a_path.substring(1);
    }

    @Deprecated
    public String getPhysicalPath() {
        return null;
    }

    @Trivial
    public ArtifactContainer getEnclosingContainer() {
        return this.getEntryInEnclosingContainer().getEnclosingContainer();
    }

    @Trivial
    public ZipFileEntry getEntryInEnclosingContainer() {
        return this.entryInEnclosingContainer;
    }

    @Trivial
    public Iterator<ArtifactEntry> iterator() {
        ZipFileContainerUtils.ZipEntryData[] allEntryData = this.rootContainer.getZipEntryData();
        if (allEntryData.length == 0) {
            return Collections.emptyIterator();
        }
        Map<String, ZipFileContainerUtils.IteratorData> allIteratorData = this.rootContainer.getIteratorData();
        ZipFileContainerUtils.IteratorData thisIteratorData = allIteratorData.get(this.getRelativePath());
        if (thisIteratorData == null) {
            return Collections.emptyIterator();
        }
        return new ZipFileContainerUtils.ZipFileEntryIterator(this.rootContainer, this, allEntryData, thisIteratorData);
    }

    @Trivial
    public void useFastMode() {
        this.getRoot().useFastMode();
    }

    @Trivial
    public void stopUsingFastMode() {
        this.getRoot().stopUsingFastMode();
    }

    public ZipFileEntry getEntry(String entryPath) {
        String a_entryPath = entryPath.isEmpty() || entryPath.charAt(0) != '/' ? this.getAbsolutePath() + "/" + entryPath : entryPath;
        return this.getRoot().getEntry(a_entryPath);
    }

    public Collection<URL> getURLs() {
        try {
            URL entryUrl = this.rootContainer.createEntryUri(this.getRelativePath() + "/").toURL();
            return Collections.singleton(entryUrl);
        }
        catch (MalformedURLException entryUrl) {
            FFDCFilter.processException((Throwable)entryUrl, (String)"com.ibm.ws.artifact.zip.internal.ZipFileNestedDirContainer", (String)"227", (Object)this, (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileNestedDirContainer", ZipFileNestedDirContainer.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
    }
}

