/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.credentials.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.credentials.CredentialProvider;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CredentialsServiceImpl
implements CredentialsService {
    private static final String KEY_BASIC_AUTH_REALM = "com.ibm.ws.security.cred.realm";
    private static final String KEY_BASIC_AUTH_USER = "com.ibm.ws.security.cred.user";
    private static final String KEY_BASIC_AUTH_PASSWORD = "com.ibm.ws.security.cred.password";
    static final String KEY_CREDENTIAL_PROVIDER = "credentialProvider";
    public static final String KEY_BASIC_AUTH_CREDENTIAL_PROVIDER = "basicAuthCredentialProvider";
    private final ConcurrentServiceReferenceSet<CredentialProvider> credentialProviders = new ConcurrentServiceReferenceSet("credentialProvider");
    private final AtomicServiceReference<CredentialProvider> basicAuthCredentialProvider = new AtomicServiceReference("basicAuthCredentialProvider");
    private String unauthenticatedUser = "UNAUTHENTICATED";
    static final long serialVersionUID = -5877378954712003958L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setCredentialProvider(ServiceReference<CredentialProvider> reference) {
        this.credentialProviders.addReference(reference);
    }

    protected void unsetCredentialProvider(ServiceReference<CredentialProvider> reference) {
        this.credentialProviders.removeReference(reference);
    }

    public void setBasicAuthCredentialProvider(ServiceReference<CredentialProvider> reference) {
        this.basicAuthCredentialProvider.setReference(reference);
    }

    protected void unsetBasicAuthCredentialProvider(ServiceReference<CredentialProvider> reference) {
        this.basicAuthCredentialProvider.unsetReference(reference);
    }

    public void activate(ComponentContext cc) {
        this.credentialProviders.activate(cc);
        this.basicAuthCredentialProvider.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.credentialProviders.deactivate(cc);
        this.basicAuthCredentialProvider.deactivate(cc);
    }

    @Override
    public void setCredentials(Subject subject) throws CredentialException {
        Iterator itr = this.credentialProviders.getServices();
        while (itr.hasNext()) {
            CredentialProvider provider = (CredentialProvider)itr.next();
            provider.setCredential(subject);
        }
    }

    @Override
    public void setBasicAuthCredential(Subject basicAuthSubject, String realm, String username, @Sensitive String password) throws CredentialException {
        CredentialProvider provider = (CredentialProvider)this.basicAuthCredentialProvider.getService();
        if (provider != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(KEY_BASIC_AUTH_REALM, realm);
            hashtable.put(KEY_BASIC_AUTH_USER, username);
            hashtable.put(KEY_BASIC_AUTH_PASSWORD, (String)new SerializableProtectedString(password.toCharArray()));
            basicAuthSubject.getPrivateCredentials().add(hashtable);
            provider.setCredential(basicAuthSubject);
        }
    }

    @Override
    public void setUnauthenticatedUserid(String userid) {
        this.unauthenticatedUser = userid;
    }

    @Override
    public String getUnauthenticatedUserid() {
        return this.unauthenticatedUser;
    }

    @Override
    public boolean isSubjectValid(Subject subject) {
        boolean isValid = true;
        Iterator itr = this.credentialProviders.getServices();
        while (itr.hasNext()) {
            CredentialProvider provider = (CredentialProvider)itr.next();
            if (isValid = isValid && provider.isSubjectValid(subject)) continue;
            break;
        }
        return isValid;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.credentials.internal.CredentialsServiceImpl", CredentialsServiceImpl.class, null, null);
    }
}

