/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherConfig;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherFactory;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpDispatcherChannel
implements InboundChannel,
Discriminator {
    private static final TraceComponent tc = Tr.register(HttpDispatcherChannel.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherChannel");
    private HttpDispatcherFactory myFactory;
    private HttpDispatcherConfig myConfig;
    private ChannelData chfwConfig = null;
    private final AtomicInteger activeConnections = new AtomicInteger(0);
    private boolean quiescing = false;
    private volatile boolean stop0Called = false;
    static final long serialVersionUID = -5133447759493145932L;

    public HttpDispatcherChannel(ChannelData config, HttpDispatcherFactory factory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Created channel: " + this), (Object[])new Object[0]);
        }
        this.myFactory = factory;
        this.update(config);
    }

    @Trivial
    public Discriminator getDiscriminator() {
        return this;
    }

    public void destroy() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Destroy channel: " + this), (Object[])new Object[0]);
        }
        if (null != this.myFactory) {
            this.myFactory.removeChannel(this.getName());
            this.myFactory = null;
        }
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        HttpDispatcherLink link = (HttpDispatcherLink)vc.getStateMap().get("HttpDispatcherLink");
        if (null == link) {
            link = new HttpDispatcherLink();
            link.init(vc, this);
        }
        return link;
    }

    protected void incrementActiveConns() {
        int count = this.activeConnections.incrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Increment active, current=" + count), (Object[])new Object[0]);
        }
    }

    protected void decrementActiveConns() {
        int count = this.activeConnections.decrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Decrement active, current=" + count), (Object[])new Object[0]);
        }
        if (0 == count && this.quiescing) {
            this.signalNoConnections();
        }
    }

    @Trivial
    public Class<?> getDeviceInterface() {
        return HttpInboundServiceContext.class;
    }

    @Trivial
    public void init() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Init channel: " + this), (Object[])new Object[0]);
        }
    }

    @Trivial
    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Start channel: " + this), (Object[])new Object[0]);
        }
        this.stop0Called = false;
    }

    private void signalNoConnections() {
        EventEngine events = HttpDispatcher.getEventService();
        if (null == events) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to send event, missing service", (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"No active connections, sending stop chain event", (Object[])new Object[0]);
        }
        Event event = events.createEvent(ChannelFramework.EVENT_STOPCHAIN);
        event.setProperty("ChannelName", (Object)this.chfwConfig.getExternalName());
        events.postEvent(event);
    }

    public void stop(long millisec) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Stop channel: " + this + " time=" + millisec), (Object[])new Object[0]);
        }
        if (0L < millisec) {
            this.quiescing = true;
            if (0 == this.activeConnections.get()) {
                this.signalNoConnections();
            }
        } else {
            this.quiescing = false;
            this.stop0Called = true;
        }
    }

    public void update(ChannelData cc) {
        this.chfwConfig = cc;
        this.myConfig = new HttpDispatcherConfig(cc.getPropertyBag());
    }

    @Trivial
    public void cleanUpState(VirtualConnection vc) {
        vc.getStateMap().remove("HttpDispatcherLink");
    }

    @Trivial
    public int discriminate(VirtualConnection vc, Object discrimData) {
        return 1;
    }

    @Trivial
    public Channel getChannel() {
        return this;
    }

    @Trivial
    public Class<?> getDiscriminatoryDataType() {
        return HttpRequestMessage.class;
    }

    @Trivial
    public int getWeight() {
        return this.chfwConfig.getDiscriminatorWeight();
    }

    @Trivial
    protected HttpDispatcherConfig getDispConfig() {
        return this.myConfig;
    }

    @Trivial
    public String getName() {
        return this.chfwConfig.getName();
    }

    @Trivial
    public DiscriminationProcess getDiscriminationProcess() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    @Trivial
    public void setDiscriminationProcess(DiscriminationProcess dp) {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    @Trivial
    public Class<?> getApplicationInterface() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    @Trivial
    public Class<?> getDiscriminatoryType() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    public String getEndpointPid() {
        return this.myConfig.getEndpointPid();
    }

    public boolean getStop0Called() {
        return this.stop0Called;
    }
}

