/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResourceRefConfigImpl
implements ResourceRefConfig,
Serializable {
    private static final TraceComponent tc = Tr.register(ResourceRefConfigImpl.class, (String)"resource", (String)"com.ibm.ws.resource.internal.resources.Runtime");
    private static final long serialVersionUID = -6326427478067188694L;
    private static final String[] ISOLATION_LEVEL_NAMES = new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_READ_COMMITTED", "3", "TRANSACTION_REPEATABLE_READ", "5", "6", "7", "TRANSACTION_SERIALIZABLE"};
    private static final String[] BRANCH_COUPLING_NAMES = new String[]{"LOOSE", "TIGHT"};
    private final String name;
    private String description;
    private String type;
    private int auth = 1;
    private int sharingScope = 0;
    private String bindingName;
    private String loginConfigurationName;
    private transient List<ResourceRefInfo.Property> loginProperties;
    private int isolationLevel = 0;
    private int commitPriority;
    private int branchCoupling = -1;
    private static final String AUTHENTICATION_ALIAS_LOGIN_NAME = "DefaultPrincipalMapping";

    ResourceRefConfigImpl(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", auth=" + this.toStringAuth() + ", sharingScope=" + this.toStringSharingScope() + ", bindingName=" + this.bindingName + ", loginConfigurationName=" + this.loginConfigurationName + ", loginProperties=" + this.loginProperties + ", isolationLevel=" + this.toStringIsolationLevel() + ", commitPriority=" + this.commitPriority + ", branchCoupling=" + this.toStringBranchCoupling() + "]";
    }

    @Trivial
    private String toStringAuth() {
        switch (this.auth) {
            case 0: {
                return "Container";
            }
            case 1: {
                return "Application";
            }
        }
        return null;
    }

    @Trivial
    private String toStringSharingScope() {
        switch (this.sharingScope) {
            case 0: {
                return "Shareable";
            }
            case 1: {
                return "Unshareable";
            }
        }
        return null;
    }

    @Trivial
    private String toStringIsolationLevel() {
        switch (this.isolationLevel) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATEDABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return null;
    }

    @Trivial
    private String toStringBranchCoupling() {
        switch (this.branchCoupling) {
            case -1: {
                return "UNSET";
            }
            case 0: {
                return "LOOSE";
            }
            case 1: {
                return "TIGHT";
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.loginProperties == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.loginProperties.size());
            for (ResourceRefInfo.Property loginProperty : this.loginProperties) {
                out.writeObject(loginProperty.getName());
                out.writeObject(loginProperty.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numLoginProperties = in.readInt();
        for (int i = 0; i < numLoginProperties; ++i) {
            String name = (String)in.readObject();
            String value = (String)in.readObject();
            this.addLoginProperty(name, value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String className) {
        this.type = className;
    }

    @Override
    public int getAuth() {
        return this.auth;
    }

    @Override
    public void setResAuthType(int auth) {
        this.auth = auth;
    }

    @Override
    public int getSharingScope() {
        return this.sharingScope;
    }

    @Override
    public void setSharingScope(int sharingScope) {
        this.sharingScope = sharingScope;
    }

    @Override
    public String getJNDIName() {
        return this.bindingName;
    }

    @Override
    public void setJNDIName(String bindingName) {
        this.bindingName = bindingName;
    }

    @Override
    public String getLoginConfigurationName() {
        return this.loginConfigurationName;
    }

    @Override
    public void setLoginConfigurationName(String loginConfigurationName) {
        this.loginConfigurationName = loginConfigurationName;
    }

    @Override
    public List<? extends ResourceRefInfo.Property> getLoginPropertyList() {
        if (this.loginProperties != null) {
            return this.loginProperties;
        }
        return Collections.emptyList();
    }

    @Override
    public void clearLoginProperties() {
        this.loginProperties = null;
    }

    @Override
    public void addLoginProperty(String name, String value) {
        if (this.loginProperties == null) {
            this.loginProperties = new ArrayList<ResourceRefInfo.Property>();
        }
        this.loginProperties.add(new PropertyImpl(name, value));
    }

    @Override
    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Override
    public int getCommitPriority() {
        return this.commitPriority;
    }

    @Override
    public void setCommitPriority(int commitPriority) {
        this.commitPriority = commitPriority;
    }

    @Override
    public int getBranchCoupling() {
        return this.branchCoupling;
    }

    @Override
    public void setBranchCoupling(int branchCoupling) {
        this.branchCoupling = branchCoupling;
    }

    @Override
    public void mergeBindingsAndExtensions(ResourceRefConfig[] resRefs, List<ResourceRefConfig.MergeConflict> mergeConflicts) {
        this.mergeBindingsAndExtensions(resRefs, mergeConflicts, false);
    }

    @Override
    public List<ResourceRefConfig.MergeConflict> compareBindingsAndExtensions(ResourceRefConfig resRef) {
        ArrayList<ResourceRefConfig.MergeConflict> mergeConflicts = new ArrayList<ResourceRefConfig.MergeConflict>();
        this.mergeBindingsAndExtensions(new ResourceRefConfig[]{this, resRef}, mergeConflicts, true);
        return mergeConflicts;
    }

    private void mergeBindingsAndExtensions(ResourceRefConfig[] resRefs, List<ResourceRefConfig.MergeConflict> mergeConflicts, boolean compareOnly) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        boolean strict = compareOnly;
        Attribute<String> bindingNameAttr = new Attribute<String>("binding-name", mergeConflicts, strict, null);
        Attribute<String> loginConfigurationNameAttr = new Attribute<String>("custom-login-configuration", mergeConflicts, strict, null);
        LinkedHashMap<String, Attribute<String>> loginAttrProperties = null;
        Attribute<Integer> isolationLevelAttr = new Attribute<Integer>("isolation-level", mergeConflicts, strict, ISOLATION_LEVEL_NAMES);
        Attribute<Integer> commitPriorityAttr = new Attribute<Integer>("commit-priority", mergeConflicts, strict, null);
        Attribute<Integer> branchCouplingAttr = new Attribute<Integer>("branch-coupling", mergeConflicts, strict, BRANCH_COUPLING_NAMES);
        for (int i = 0; i < resRefs.length; ++i) {
            ResourceRefConfig resRef = resRefs[i];
            if (resRef == null) continue;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("merging " + i + ": " + resRef), (Object[])new Object[0]);
            }
            bindingNameAttr.merge(i, resRef.getJNDIName());
            loginConfigurationNameAttr.merge(i, resRef.getLoginConfigurationName());
            List<? extends ResourceRefInfo.Property> loginPropertyList = resRef.getLoginPropertyList();
            if (!loginPropertyList.isEmpty()) {
                if (loginAttrProperties == null) {
                    loginAttrProperties = new LinkedHashMap<String, Attribute<String>>();
                }
                if (strict && i != 0) {
                    HashSet newNames = new HashSet();
                    for (ResourceRefInfo.Property property : loginPropertyList) {
                        newNames.add(property.getName());
                    }
                    for (Map.Entry entry : loginAttrProperties.entrySet()) {
                        if (newNames.contains(entry.getKey())) continue;
                        ((Attribute)entry.getValue()).merge(i, null);
                    }
                }
                for (ResourceRefInfo.Property property : loginPropertyList) {
                    String string = property.getName();
                    Attribute<String> attribute = (Attribute<String>)loginAttrProperties.get(string);
                    if (attribute == null) {
                        String attributeName = string.equals(AUTHENTICATION_ALIAS_LOGIN_NAME) ? "authentication-alias" : "custom-login-configuration " + string;
                        attribute = new Attribute<String>(attributeName, mergeConflicts, strict, null);
                        loginAttrProperties.put(string, attribute);
                        if (strict && i != 0) {
                            attribute.merge(0, null);
                        }
                    }
                    attribute.merge(i, property.getValue());
                }
            } else if (strict && loginAttrProperties != null) {
                for (Attribute attribute : loginAttrProperties.values()) {
                    attribute.merge(i, null);
                }
            }
            isolationLevelAttr.merge(i, resRef.getIsolationLevel());
            commitPriorityAttr.merge(i, resRef.getCommitPriority());
            int branchCouplingValue = resRef.getBranchCoupling();
            if (branchCouplingValue != -1) {
                branchCouplingAttr.merge(i, branchCouplingValue);
                continue;
            }
            if (!strict) continue;
            branchCouplingAttr.merge(i, null);
        }
        if (!compareOnly) {
            this.bindingName = (String)bindingNameAttr.ivValue;
            this.loginConfigurationName = (String)loginConfigurationNameAttr.ivValue;
            if (loginAttrProperties != null) {
                this.loginProperties = new ArrayList<ResourceRefInfo.Property>(loginAttrProperties.size());
                for (Map.Entry entry : loginAttrProperties.entrySet()) {
                    this.loginProperties.add(new PropertyImpl((String)entry.getKey(), (String)((Attribute)entry.getValue()).ivValue));
                }
            }
            if (isolationLevelAttr.ivValue != null) {
                this.isolationLevel = (Integer)isolationLevelAttr.ivValue;
            }
            if (commitPriorityAttr.ivValue != null) {
                this.setCommitPriority((Integer)commitPriorityAttr.ivValue);
            }
            if (branchCouplingAttr.ivValue != null) {
                this.branchCoupling = (Integer)branchCouplingAttr.ivValue;
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class MergeConflictImpl
    implements ResourceRefConfig.MergeConflict {
        private final String ivAttributeName;
        private final int ivIndex1;
        private final String ivValue1;
        private final int ivIndex2;
        private final String ivValue2;
        static final long serialVersionUID = 5914124696236494755L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        MergeConflictImpl(String attributeName, int index1, String value1, int index2, String value2) {
            this.ivAttributeName = attributeName;
            this.ivIndex1 = index1;
            this.ivValue1 = value1;
            this.ivIndex2 = index2;
            this.ivValue2 = value2;
        }

        public String toString() {
            return super.toString() + '[' + this.ivAttributeName + ", [" + this.ivIndex1 + "]=" + this.ivValue1 + " != [" + this.ivIndex2 + "]=" + this.ivValue2 + ']';
        }

        @Override
        public ResourceRefConfig getResourceRefConfig() {
            return ResourceRefConfigImpl.this;
        }

        @Override
        public String getAttributeName() {
            return this.ivAttributeName;
        }

        @Override
        public int getIndex1() {
            return this.ivIndex1;
        }

        @Override
        public String getValue1() {
            return this.ivValue1;
        }

        @Override
        public int getIndex2() {
            return this.ivIndex2;
        }

        @Override
        public String getValue2() {
            return this.ivValue2;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.resource.internal.ResourceRefConfigImpl$MergeConflictImpl", MergeConflictImpl.class, (String)"resource", (String)"com.ibm.ws.resource.internal.resources.Runtime");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class Attribute<T> {
        private final String ivName;
        private final List<ResourceRefConfig.MergeConflict> ivConflicts;
        private final boolean ivStrict;
        private final String[] ivNames;
        int ivIndex = -1;
        T ivValue;
        static final long serialVersionUID = 8153893450042812062L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Attribute(String name, List<ResourceRefConfig.MergeConflict> conflicts, boolean strict, String[] names) {
            this.ivName = name;
            this.ivConflicts = conflicts;
            this.ivStrict = strict;
            this.ivNames = names;
        }

        private String valueToString(Object value) {
            if (value == null) {
                return "null";
            }
            if (this.ivNames != null) {
                return this.ivNames[(Integer)value];
            }
            return String.valueOf(value);
        }

        public void merge(int index, T value) {
            if (this.ivStrict) {
                if (this.ivIndex != -1 && (value == null ? this.ivValue != null : !value.equals(this.ivValue))) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding strict conflict " + ResourceRefConfigImpl.this.getName() + "/" + this.ivName + " for " + this.ivIndex + " and " + index), (Object[])new Object[0]);
                    }
                    this.ivConflicts.add(new MergeConflictImpl(this.ivName, this.ivIndex, this.valueToString(this.ivValue), index, this.valueToString(value)));
                }
                this.ivIndex = index;
                this.ivValue = value;
                return;
            }
            if (value != null) {
                if (this.ivValue == null) {
                    this.ivIndex = index;
                    this.ivValue = value;
                } else if (!value.equals(this.ivValue)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding conflict " + ResourceRefConfigImpl.this.getName() + "/" + this.ivName + " for " + this.ivIndex + " and " + index), (Object[])new Object[0]);
                    }
                    this.ivConflicts.add(new MergeConflictImpl(this.ivName, this.ivIndex, this.valueToString(this.ivValue), index, this.valueToString(value)));
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.resource.internal.ResourceRefConfigImpl$Attribute", Attribute.class, (String)"resource", (String)"com.ibm.ws.resource.internal.resources.Runtime");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PropertyImpl
    implements ResourceRefInfo.Property {
        private final String name;
        private final String value;
        static final long serialVersionUID = -7302393935215197351L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PropertyImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return '[' + this.name + '=' + this.value + ']';
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.resource.internal.ResourceRefConfigImpl$PropertyImpl", PropertyImpl.class, (String)"resource", (String)"com.ibm.ws.resource.internal.resources.Runtime");
        }
    }
}

