/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Gauge;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import com.ibm.ws.jaxrs.monitor.RestStatsMXBean;

public class REST_Stats
extends Meter
implements RestStatsMXBean {
    private String appName;
    private String methodName;
    private Counter requestCount;
    private final StatisticsMeter responseTime;
    private final Gauge minutePreviousMinimumDuration;
    private final Gauge minutePreviousMaximumDuration;
    private final Gauge minutePrevious;
    private final Gauge minuteLatestMinimumDuration;
    private final Gauge minuteLatestMaximumDuration;
    private final Gauge minuteLatest;

    public REST_Stats(String aName, String mName) {
        this.setAppName(aName);
        this.setMethodName(mName);
        this.requestCount = new Counter();
        this.requestCount.setDescription("This shows number of requests to a Restful resource method");
        this.responseTime = new StatisticsMeter();
        this.responseTime.setDescription("Cumulative Response Time (NanoSeconds) for a Restful resource method");
        this.responseTime.setUnit("ns");
        this.minutePreviousMinimumDuration = new Gauge();
        this.minutePreviousMinimumDuration.setDescription("Lowest timed duration in the previous (i.e second most recent) recorded complete minute");
        this.minutePreviousMinimumDuration.setUnit("ns");
        this.minutePreviousMinimumDuration.setCurrentValue(0L);
        this.minutePreviousMaximumDuration = new Gauge();
        this.minutePreviousMaximumDuration.setDescription("Highest timed duration in the previous (i.e second most recent) recorded complete minute");
        this.minutePreviousMaximumDuration.setUnit("ns");
        this.minutePreviousMaximumDuration.setCurrentValue(0L);
        this.minutePrevious = new Gauge();
        this.minutePrevious.setDescription("The number of minutes since Epoch for the values recorded in the previous (i.e second most recent) recorded minute");
        this.minutePrevious.setUnit("minute");
        this.minutePrevious.setCurrentValue(0L);
        this.minuteLatestMinimumDuration = new Gauge();
        this.minuteLatestMinimumDuration.setDescription("Lowest timed duration in the latest (i.e most recent) recorded complete minute");
        this.minuteLatestMinimumDuration.setUnit("ns");
        this.minuteLatestMinimumDuration.setCurrentValue(0L);
        this.minuteLatestMaximumDuration = new Gauge();
        this.minuteLatestMaximumDuration.setDescription("Highest timed duration in the latest (i.e most recent) recorded complete minute");
        this.minuteLatestMaximumDuration.setUnit("ns");
        this.minuteLatestMaximumDuration.setCurrentValue(0L);
        this.minuteLatest = new Gauge();
        this.minuteLatest.setDescription("The number of minutes since Epoch for the values recorded in the latest (i.e second most recent) minute");
        this.minuteLatest.setUnit("minute");
        this.minuteLatest.setCurrentValue(0L);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getDescription() {
        return "Report Stats for specified Restful resource method.";
    }

    @Override
    public long getRequestCount() {
        return this.requestCount.getCurrentValue();
    }

    @Override
    public double getResponseTime() {
        return this.responseTime.getTotal();
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setRequestCount(Counter requestCount) {
        this.requestCount = requestCount;
    }

    public void incrementCountBy(int i) {
        this.requestCount.incrementBy((long)i);
    }

    public void updateRT(long elapsed) {
        this.responseTime.addDataPoint(elapsed);
    }

    public void updateMinutePreviousMaximumDuration(long max) {
        this.minutePreviousMaximumDuration.setCurrentValue(max);
    }

    public void updateMinutePreviousMinimumDuration(long min) {
        this.minutePreviousMinimumDuration.setCurrentValue(min);
    }

    public void updateMinutePrevious(long minute) {
        this.minutePrevious.setCurrentValue(minute);
    }

    public void updateMinuteLatestMaximumDuration(long max) {
        this.minuteLatestMaximumDuration.setCurrentValue(max);
    }

    public void updateMinuteLatestMinimumDuration(long min) {
        this.minuteLatestMinimumDuration.setCurrentValue(min);
    }

    public void updateMinuteLatest(long minute) {
        this.minuteLatest.setCurrentValue(minute);
    }

    @Override
    public Counter getRequestCountDetails() {
        return this.requestCount;
    }

    @Override
    public StatisticsMeter getResponseTimeDetails() {
        return this.responseTime;
    }

    @Override
    public long getMinutePreviousMinimumDuration() {
        return this.minutePreviousMinimumDuration.getCurrentValue();
    }

    @Override
    public long getMinutePreviousMaximumDuration() {
        return this.minutePreviousMaximumDuration.getCurrentValue();
    }

    @Override
    public long getMinuteLatestMinimumDuration() {
        return this.minuteLatestMinimumDuration.getCurrentValue();
    }

    @Override
    public long getMinuteLatestMaximumDuration() {
        return this.minuteLatestMaximumDuration.getCurrentValue();
    }

    @Override
    public long getMinuteLatest() {
        return this.minuteLatest.getCurrentValue();
    }

    @Override
    public long getMinutePrevious() {
        return this.minutePrevious.getCurrentValue();
    }
}

