/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.adaptable.module.structure.StructureHelper;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo;
import com.ibm.ws.app.manager.ear.internal.EARStructureHelper;
import com.ibm.ws.app.manager.module.AbstractDeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppMBeanRuntime;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoForContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.InterpretedContainer;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=ear"})
public class EARDeployedAppInfoFactoryImpl
extends AbstractDeployedAppInfoFactory {
    private static final TraceComponent _tc = Tr.register(EARDeployedAppInfoFactoryImpl.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl");
    @Reference
    protected DeployedAppServices deployedAppServices;
    protected ModuleHandler webModuleHandler;
    protected ModuleHandler ejbModuleHandler;
    protected ModuleHandler clientModuleHandler;
    protected ModuleHandler connectorModuleHandler;
    protected DeployedAppMBeanRuntime appMBeanRuntime;
    private ServiceReference<JavaEEVersion> versionRef;
    protected volatile Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    private ApplicationManager applicationManager;
    private final String DEFAULT_APP_LOCATION = "${server.config.dir}/apps/expanded/";
    static final long serialVersionUID = 5203461639080423453L;

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.versionRef = reference;
        this.platformVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    protected synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    @Reference(target="(type=web)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = handler;
    }

    protected void unsetWebModuleHandler(ModuleHandler handler) {
        this.webModuleHandler = null;
    }

    @Reference(target="(type=ejb)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEjbModuleHandler(ModuleHandler handler) {
        this.ejbModuleHandler = handler;
    }

    protected void unsetEjbModuleHandler(ModuleHandler handler) {
        this.ejbModuleHandler = null;
    }

    @Reference(target="(type=client)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setClientModuleHandler(ModuleHandler handler) {
        this.clientModuleHandler = handler;
    }

    protected void unsetClientModuleHandler(ModuleHandler handler) {
        this.clientModuleHandler = null;
    }

    @Reference(target="(type=connector)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setConnectorModuleHandler(ModuleHandler handler) {
        this.connectorModuleHandler = handler;
    }

    protected void unsetConnectorModuleHandler(ModuleHandler handler) {
        this.connectorModuleHandler = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setDeployedAppMBeanRuntime(DeployedAppMBeanRuntime appMBeanRuntime) {
        this.appMBeanRuntime = appMBeanRuntime;
    }

    protected void unsetDeployedAppMBeanRuntime(DeployedAppMBeanRuntime appMBeanRuntime) {
        this.appMBeanRuntime = null;
    }

    @Reference
    protected void setApplicationManager(ApplicationManager mgr) {
        this.applicationManager = mgr;
    }

    protected void unsetApplicationManager(ApplicationManager mgr) {
        this.applicationManager = null;
    }

    protected void prepareExpansion(String earName) throws IOException {
        try {
            WsResource expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource(this.applicationManager.getExpandLocation());
            if (expansionResource != null) {
                expansionResource.create();
            } else {
                Tr.warning((TraceComponent)_tc, (String)"warning.could.not.expand.app.loc", (Object[])new Object[]{earName, this.applicationManager.getExpandLocation()});
                expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
                expansionResource.create();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl", (String)"165", (Object)((Object)this), (Object[])new Object[]{earName});
            Tr.warning((TraceComponent)_tc, (String)"warning.could.not.expand.app.loc", (Object[])new Object[]{earName, this.applicationManager.getExpandLocation()});
            WsResource expansionResource = null;
            expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
            expansionResource.create();
        }
    }

    protected WsResource resolveExpansion(String appName) {
        return this.deployedAppServices.getLocationAdmin().resolveResource(this.applicationManager.getExpandLocation() + appName + ".ear/");
    }

    protected void expand(String name, File collapsedFile, WsResource expandedResource, File expandedFile) throws IOException {
        File failedDelete;
        if (expandedFile.exists() && (failedDelete = ZipUtils.deleteWithRetry(expandedFile)) != null) {
            if (failedDelete == expandedFile) {
                throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ]");
            }
            throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ] because [ " + failedDelete.getAbsolutePath() + " ] could not be deleted.");
        }
        expandedResource.create();
        ZipUtils.unzip(collapsedFile, expandedFile, true, collapsedFile.lastModified());
    }

    /*
     * WARNING - void declaration
     */
    public DeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> appInfo) throws UnableToAdaptException {
        Application applicationDD;
        String appPid = appInfo.getPid();
        String appName = appInfo.getName();
        String appPath = appInfo.getLocation();
        File appFile = new File(appPath);
        Tr.debug((TraceComponent)_tc, (String)("Create deployed application: PID [ " + appPid + " ] Name [ " + appName + " ] Location [ " + appPath + " ]"), (Object[])new Object[0]);
        Container appContainer = appInfo.getContainer();
        Container originalAppContainer = null;
        AbstractDeployedAppInfoFactory.BinaryType appType = this.getApplicationType(appFile, appPath);
        if (appType == AbstractDeployedAppInfoFactory.BinaryType.LOOSE) {
            Tr.info((TraceComponent)_tc, (String)"info.loose.app", (Object[])new Object[]{appName, appPath});
        } else if (appType == AbstractDeployedAppInfoFactory.BinaryType.DIRECTORY) {
            Tr.info((TraceComponent)_tc, (String)"info.directory.app", (Object[])new Object[]{appName, appPath});
        } else if (this.applicationManager.getExpandApps()) {
            try {
                this.prepareExpansion(appName);
                WsResource expandedResource = this.resolveExpansion(appName);
                File expandedFile = expandedResource.asFile();
                if (this.applicationManager.shouldExpand(expandedFile.getName(), appFile, expandedFile)) {
                    Tr.info((TraceComponent)_tc, (String)"info.expanding.app", (Object[])new Object[]{appName, appPath, expandedFile.getAbsolutePath()});
                    this.expand(appName, appFile, expandedResource, expandedFile);
                }
                NonPersistentCache initialCache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
                ApplicationInfoForContainer appContainerInfo = (ApplicationInfoForContainer)initialCache.getFromCache(ApplicationInfoForContainer.class);
                originalAppContainer = appContainer;
                appContainer = this.deployedAppServices.setupContainer(appPid, expandedFile);
                if (appContainerInfo != null) {
                    NonPersistentCache finalCache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
                    finalCache.addToCache(ApplicationInfoForContainer.class, (Object)appContainerInfo);
                }
            }
            catch (IOException expandedResource) {
                void e;
                FFDCFilter.processException((Throwable)expandedResource, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl", (String)"287", (Object)((Object)this), (Object[])new Object[]{appInfo});
                Tr.error((TraceComponent)_tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{appName, e.getMessage()});
            }
        } else {
            Tr.info((TraceComponent)_tc, (String)"info.unexpanded.app", (Object[])new Object[]{appName, appPath});
        }
        try {
            applicationDD = (Application)appContainer.adapt(Application.class);
        }
        catch (UnableToAdaptException expandedFile) {
            void e;
            FFDCFilter.processException((Throwable)expandedFile, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl", (String)"299", (Object)((Object)this), (Object[])new Object[]{appInfo});
            Tr.error((TraceComponent)_tc, (String)"error.application.parse.descriptor", (Object[])new Object[]{appName, "META-INF/application.xml", e});
            throw e;
        }
        InterpretedContainer jeeContainer = appContainer instanceof InterpretedContainer ? (InterpretedContainer)appContainer : (InterpretedContainer)appContainer.adapt(InterpretedContainer.class);
        if (applicationDD == null) {
            jeeContainer.setStructureHelper(EARStructureHelper.getUnknownRootInstance());
        } else {
            ArrayList<String> modulePaths = new ArrayList<String>();
            for (Module module : applicationDD.getModules()) {
                modulePaths.add(module.getModulePath());
            }
            jeeContainer.setStructureHelper((StructureHelper)EARStructureHelper.create(modulePaths));
        }
        appInfo.setContainer((Container)jeeContainer);
        EARDeployedAppInfo deployedApp = new EARDeployedAppInfo(appInfo, applicationDD, this, this.deployedAppServices, originalAppContainer);
        appInfo.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

