/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal;

import com.ibm.xml.xlxp2.api.stax.XMLInputFactoryImpl;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    AbstractUnmarshallerImpl() {
    }

    public final Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            AbstractUnmarshallerImpl.reportNullParameter(File.class);
        }
        return this.unmarshal(new InputSource(file.toURI().toString()));
    }

    public final Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            AbstractUnmarshallerImpl.reportNullParameter(Reader.class);
        }
        return this.unmarshal(new InputSource(reader));
    }

    public final Object unmarshal(URL uRL) throws JAXBException {
        if (uRL == null) {
            AbstractUnmarshallerImpl.reportNullParameter(URL.class);
        }
        return this.unmarshal(new InputSource(uRL.toExternalForm()));
    }

    public final Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            AbstractUnmarshallerImpl.reportNullParameter(Source.class);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setSystemId(streamSource.getSystemId());
            inputSource.setPublicId(streamSource.getPublicId());
            return this.unmarshal(inputSource);
        }
        if (source instanceof StAXSource) {
            StAXSource stAXSource = (StAXSource)source;
            XMLStreamReader xMLStreamReader = stAXSource.getXMLStreamReader();
            if (xMLStreamReader != null) {
                return this.unmarshal(xMLStreamReader);
            }
            return this.unmarshal(stAXSource.getXMLEventReader());
        }
        return this.unmarshal0(source);
    }

    public final <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        if (source == null) {
            AbstractUnmarshallerImpl.reportNullParameter(Source.class);
        }
        if (clazz == null) {
            AbstractUnmarshallerImpl.reportNullParameter(Class.class);
        }
        if (source instanceof StreamSource) {
            try {
                XMLStreamReader xMLStreamReader = XMLInputFactoryHolder.INSTANCE.createXMLStreamReader(source);
                JAXBElement jAXBElement = this.unmarshal(xMLStreamReader, clazz);
                xMLStreamReader.close();
                return jAXBElement;
            }
            catch (XMLStreamException xMLStreamException) {
                JAXBMessageProvider.throwUnmarshalException(xMLStreamException);
            }
        } else if (source instanceof StAXSource) {
            StAXSource stAXSource = (StAXSource)source;
            XMLStreamReader xMLStreamReader = stAXSource.getXMLStreamReader();
            if (xMLStreamReader != null) {
                return this.unmarshal(xMLStreamReader, clazz);
            }
            return this.unmarshal(stAXSource.getXMLEventReader(), clazz);
        }
        return this.unmarshal0(source, clazz);
    }

    protected abstract Object unmarshal0(Source var1) throws JAXBException;

    protected abstract <T> JAXBElement<T> unmarshal0(Source var1, Class<T> var2) throws JAXBException;

    protected final Object unmarshal(Unmarshaller unmarshaller, InputStream inputStream) throws JAXBException {
        try {
            XMLStreamReader xMLStreamReader = XMLInputFactoryHolder.INSTANCE.createXMLStreamReader(inputStream);
            Object object = unmarshaller.unmarshal(xMLStreamReader);
            xMLStreamReader.close();
            return object;
        }
        catch (XMLStreamException xMLStreamException) {
            JAXBMessageProvider.throwUnmarshalException(xMLStreamException);
            return null;
        }
    }

    protected final Object unmarshal(Unmarshaller unmarshaller, InputSource inputSource) throws JAXBException {
        try {
            XMLStreamReader xMLStreamReader = XMLInputFactoryHolder.INSTANCE.createXMLStreamReader(inputSource);
            Object object = unmarshaller.unmarshal(xMLStreamReader);
            xMLStreamReader.close();
            return object;
        }
        catch (XMLStreamException xMLStreamException) {
            JAXBMessageProvider.throwUnmarshalException(xMLStreamException);
            return null;
        }
    }

    static void reportNullParameter(Class<?> clazz) {
        throw new IllegalArgumentException(JAXBMessageProvider.createMessage(null, 24, clazz.getName()));
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class XMLInputFactoryHolder {
        public static final XMLInputFactoryImpl INSTANCE;

        private XMLInputFactoryHolder() {
        }

        static {
            XMLInputFactory xMLInputFactory = null;
            try {
                xMLInputFactory = XMLInputFactory.newInstance("javax.xml.stream.XMLInputFactory", AbstractUnmarshallerImpl.class.getClassLoader());
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                // empty catch block
            }
            INSTANCE = xMLInputFactory instanceof XMLInputFactoryImpl ? (XMLInputFactoryImpl)xMLInputFactory : new XMLInputFactoryImpl();
        }
    }
}

