/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgFactory;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgUnaryOp;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.codegen.Generatable;
import com.ibm.xml.xlxp2.jaxb.codegen.fcg.FCGTypeUtil;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.AttributeGroupGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.FCGSerializationStubGeneratorHelper;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.PropertyGroupGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.codegen.fcg.SimpleContentPropertyGenerator;
import com.ibm.xml.xlxp2.jaxb.marshal.impl.SerializationStub;
import com.ibm.xml.xlxp2.jaxb.model.AttributeProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementWildcardProperty;
import com.ibm.xml.xlxp2.jaxb.model.EnumClass;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.MixedContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.Property;
import com.ibm.xml.xlxp2.jaxb.model.PropertyGroup;
import com.ibm.xml.xlxp2.jaxb.model.SimpleContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.TypedProperty;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FCGSerializationStubGenerator
extends FCGSerializationStubGeneratorHelper
implements Generatable {
    private final ValueClass valueClass;
    private final Method beforeMarshalMethod;
    private final Method afterMarshalMethod;
    private final List<ElementPropertyHolder> elementProperties = new ArrayList<ElementPropertyHolder>();

    public static String getStubClassName(ValueClass valueClass) {
        return valueClass.javaType.getName() + "_JAXB_Serialization_Stub";
    }

    public FCGSerializationStubGenerator(String string, ValueClass valueClass, JAXBModel jAXBModel, ClassLoader classLoader) {
        super(string, jAXBModel, classLoader);
        this.valueClass = valueClass;
        this.beforeMarshalMethod = SerializationStub.getBeforeMarshalMethod(valueClass.javaType);
        this.afterMarshalMethod = SerializationStub.getAfterMarshalMethod(valueClass.javaType);
    }

    @Override
    public void generate(String string, OutputStream outputStream) throws IOException {
        FcgCodeGen fcgCodeGen = FcgFactory.createCodeGen(string);
        FcgClassGen fcgClassGen = this.generateClassDeclaration(fcgCodeGen);
        FcgField[] fcgFieldArray = this.generateStaticFieldDeclarations4Attributes(fcgCodeGen, fcgClassGen);
        FcgField[][][] fcgFieldArray2 = this.generateStaticFieldDeclarations4Elements(fcgCodeGen, fcgClassGen);
        FcgField[] fcgFieldArray3 = this.generateStaticFields4ElementTypeChoices(fcgCodeGen, fcgClassGen);
        FcgField[] fcgFieldArray4 = this.generateStaticFields4JAXBElementChoices(fcgCodeGen, fcgClassGen);
        FcgField fcgField = this.generateIsInitializedField(fcgCodeGen, fcgClassGen);
        Map<?, Integer>[][] mapArray = this.generateInitializeMethod(fcgCodeGen, fcgClassGen, fcgFieldArray2, fcgFieldArray, fcgFieldArray3, fcgFieldArray4, fcgField);
        this.generateIsInitializedMethod(fcgCodeGen, fcgClassGen, fcgField);
        this.generateIsCompatibleMethod(fcgCodeGen, fcgClassGen);
        this.generateConstructor(fcgCodeGen, fcgClassGen);
        boolean bl = this.generateWriteAttributesMethod(fcgCodeGen, fcgClassGen, fcgFieldArray);
        this.generateWriteMethod(fcgCodeGen, fcgClassGen, fcgFieldArray2, fcgFieldArray3, fcgFieldArray4, mapArray, bl);
        if (this.valueClass.simpleContentProperty != null) {
            this.generateWriteSimpleContentMethod(fcgCodeGen, fcgClassGen, this.valueClass.simpleContentProperty);
        }
        if (this.valueClass.idProperty != null) {
            this.generateReadIDValueMethod(fcgCodeGen, fcgClassGen, this.valueClass.idProperty);
        }
        fcgClassGen.dump(outputStream);
    }

    private FcgClassGen generateClassDeclaration(FcgCodeGen fcgCodeGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(this.stubClassName);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        FcgClassGen fcgClassGen = fcgCodeGen.newClassGen(fcgClassReferenceType, fcgClassReferenceType2, FcgAttrs.PUBLIC_FINAL);
        return fcgClassGen;
    }

    private FcgField[] generateStaticFieldDeclarations4Attributes(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        AttributeProperty[] attributePropertyArray = this.valueClass.attributeProperties;
        int n = attributePropertyArray != null ? attributePropertyArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        for (int i = 0; i < n; ++i) {
            fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC, FcgType.BYTE_ARRAY, "ATTR_" + i);
        }
        return fcgFieldArray;
    }

    private FcgField[][][] generateStaticFieldDeclarations4Elements(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[][][] fcgFieldArray = new FcgField[n][][];
        for (int i = 0; i < n; ++i) {
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            fcgFieldArray[i] = new FcgField[n2][];
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!(property instanceof ElementProperty)) continue;
                this.elementProperties.add(new ElementPropertyHolder((ElementProperty)property, i, j));
                fcgFieldArray[i][j] = new FcgField[2];
                fcgFieldArray[i][j][0] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC, FcgType.BYTE_ARRAY, "START_" + i + '_' + j);
                fcgFieldArray[i][j][1] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC, FcgType.BYTE_ARRAY, "END_" + i + '_' + j);
            }
        }
        return fcgFieldArray;
    }

    private FcgField[] generateStaticFields4ElementTypeChoices(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        block0: for (int i = 0; i < n; ++i) {
            HashSet hashSet = new HashSet();
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!property.propertyTypeInfo.isJAXBElementWrapped) {
                    if (property instanceof MixedContentProperty) {
                        hashSet.add(String.class);
                    } else if (property instanceof ElementWildcardProperty) {
                        hashSet.add(Element.class);
                        hashSet.add(JAXBElement.class);
                    } else {
                        hashSet.add(property.propertyTypeInfo.valueType.javaType);
                        if (property.propertyTypeInfo.valueType.valueClass != null && property.propertyTypeInfo.valueType.valueClass.javaType == Object.class) {
                            hashSet.add(Element.class);
                        }
                    }
                } else {
                    hashSet.add(JAXBElement.class);
                }
                if (hashSet.size() <= 1) continue;
                fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC, fcgClassReferenceType, "TYPE_CHOICE_MAP_" + i);
                continue block0;
            }
        }
        return fcgFieldArray;
    }

    private FcgField[] generateStaticFields4JAXBElementChoices(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
        PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
        int n = propertyGroupArray != null ? propertyGroupArray.length : 0;
        FcgField[] fcgFieldArray = new FcgField[n];
        block0: for (int i = 0; i < n; ++i) {
            List<Property> list = propertyGroupArray[i].properties;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Property property = list.get(j);
                if (!property.propertyTypeInfo.isJAXBElementWrapped) continue;
                fcgFieldArray[i] = fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC, fcgClassReferenceType, "JAXB_ELEMENT_CHOICE_MAP_" + i);
                continue block0;
            }
        }
        return fcgFieldArray;
    }

    private FcgField generateIsInitializedField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        return fcgClassGen.newClassField(FcgAttrs.PRIVATE_STATIC.union(FcgAttrs.VOLATILE), FcgType.BOOLEAN, "IS_INITIALIZED");
    }

    private Map<?, Integer>[][] generateInitializeMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray, FcgField[] fcgFieldArray2, FcgField[] fcgFieldArray3, FcgField[] fcgFieldArray4, FcgField fcgField) {
        int n;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.VOID, "initialize");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        int n2 = fcgFieldArray3 != null ? fcgFieldArray3.length : 0;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (fcgFieldArray3[n] == null) continue;
            ++n3;
        }
        n = fcgFieldArray4 != null ? fcgFieldArray4.length : 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (fcgFieldArray4[i] == null) continue;
            ++n4;
        }
        fcgInstructionList.beginMethod();
        Object[] objectArray = new FcgType[]{fcgClassReferenceType, fcgClassReferenceType2};
        if (fcgFieldArray2.length > 0) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), "initializeAttributeByteArrays", (FcgType)FcgType.VOID, (FcgType[])objectArray);
        }
        if (fcgFieldArray.length > 0) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), "initializeElementByteArrays", (FcgType)FcgType.VOID, (FcgType[])objectArray);
        }
        if (n3 > 0) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), "initializeElementChoiceFields", (FcgType)FcgType.VOID, (FcgType[])objectArray);
        }
        if (n4 > 0) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), "initializeJAXBElementChoiceFields", (FcgType)FcgType.VOID, (FcgType[])objectArray);
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.storeClassFieldStmt(fcgField);
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        if (fcgFieldArray2.length > 0) {
            this.generateInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, fcgFieldArray2);
        }
        if (fcgFieldArray.length > 0) {
            this.generateInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, fcgFieldArray);
        }
        objectArray = new Map[n2];
        if (n3 > 0) {
            this.generateInitializeElementChoiceFields(fcgCodeGen, fcgClassGen, fcgFieldArray3, n3, (Map<Class<?>, Integer>[])objectArray);
        }
        Map[] mapArray = new Map[n];
        if (n4 > 0) {
            this.generateInitializeJAXBElementChoiceFields(fcgCodeGen, fcgClassGen, fcgFieldArray4, n4, mapArray);
        }
        Map[][] mapArrayArray = new Map[][]{objectArray, mapArray};
        return mapArrayArray;
    }

    private void generateIsInitializedMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField fcgField) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, "isInitialized");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.loadClassField(fcgField);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
    }

    private void generateInitializeAttributeByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray) {
        int n;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeAttributeByteArrays");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        AttributeProperty[] attributePropertyArray = this.valueClass.attributeProperties;
        int n2 = n = attributePropertyArray != null ? attributePropertyArray.length : 0;
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n3 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, 0, n3, fcgFieldArray, 0, nArray);
            this.generateInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, n3, n, fcgFieldArray, 1, nArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.generateAttributeFragments(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgVariable, fcgVariable2, i);
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateInitializeElementByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeElementByteArrays");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n = this.elementProperties.size();
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n2 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, 0, n2, fcgFieldArray, 0, nArray);
            this.generateInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, n2, n, fcgFieldArray, 1, nArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.generateStartAndEndTagFragments(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgVariable, fcgVariable2, this.elementProperties.get(i));
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateInitializeElementChoiceFields(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray, int n, Map<Class<?>, Integer>[] mapArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeElementChoiceFields");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n2 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < fcgFieldArray.length; ++i) {
                if (fcgFieldArray[i] == null) continue;
                arrayList.add(i);
            }
            this.generateInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, 0, n2, fcgFieldArray, arrayList, mapArray, 0, nArray);
            this.generateInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n2, n, fcgFieldArray, arrayList, mapArray, 1, nArray);
        } else {
            for (int i = 0; i < fcgFieldArray.length; ++i) {
                this.generateElementContentChoiceMap(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgFieldArray, mapArray, i);
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateInitializeJAXBElementChoiceFields(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray, int n, Map<QName, Integer>[] mapArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeJAXBElementChoiceFields");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n2 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < fcgFieldArray.length; ++i) {
                if (fcgFieldArray[i] == null) continue;
                arrayList.add(i);
            }
            this.generateInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, 0, n2, fcgFieldArray, arrayList, mapArray, 0, nArray);
            this.generateInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n2, n, fcgFieldArray, arrayList, mapArray, 1, nArray);
        } else {
            for (int i = 0; i < fcgFieldArray.length; ++i) {
                this.generateJAXBElementChoiceMap(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgFieldArray, mapArray, i);
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateAttributeFragments(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgField[] fcgFieldArray, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        AttributeProperty attributeProperty = this.valueClass.attributeProperties[n];
        this.markPrefixUsed(attributeProperty.schemaComponentName.qName);
        this.invokeCreateAttributeFragment(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
        fcgInstructionList.storeClassFieldStmt(fcgFieldArray[n]);
    }

    private void invokeCreateAttributeFragment(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "createAttributeFragment", (FcgType)FcgType.BYTE_ARRAY, new FcgType[]{fcgClassReferenceType2, fcgClassReferenceType3, FcgType.INT});
    }

    private void generateStartAndEndTagFragments(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgField[][][] fcgFieldArray, FcgVariable fcgVariable, FcgVariable fcgVariable2, ElementPropertyHolder elementPropertyHolder) {
        ElementProperty elementProperty = elementPropertyHolder.eProperty;
        int n = elementPropertyHolder.propertyGroupId;
        int n2 = elementPropertyHolder.propertyGroupIndex;
        this.markPrefixUsed(elementProperty.schemaComponentName.qName);
        fcgInstructionList.beginScopeBlock();
        this.invokeCreateStartAndEndTagFragmentsMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, n, n2);
        FcgVariable fcgVariable3 = fcgInstructionList.defineVar(FCGTypeUtil.getFcgType(byte[][].class, fcgCodeGen), "tags_" + n + '_' + n2, true);
        this.writeElementFragmentFields(fcgInstructionList, fcgFieldArray[n][n2], fcgVariable3);
        fcgInstructionList.endScopeBlock();
    }

    private void invokeCreateStartAndEndTagFragmentsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n, int n2) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.loadLiteral(n2);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "createStartAndEndTagFragments", FCGTypeUtil.getFcgType(byte[][].class, fcgCodeGen), new FcgType[]{fcgClassReferenceType2, fcgClassReferenceType3, FcgType.INT, FcgType.INT});
    }

    private void generateElementContentChoiceMap(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgField[] fcgFieldArray, Map<Class<?>, Integer>[] mapArray, int n) {
        FcgField fcgField = fcgFieldArray[n];
        if (fcgField != null) {
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
            FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
            mapArray[n] = SerializationStub.createElementContentChoiceMap(this.valueClass, n);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(n);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "createElementContentChoiceMap", (FcgType)fcgClassReferenceType3, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.storeClassFieldStmt(fcgField);
        }
    }

    private void generateJAXBElementChoiceMap(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgField[] fcgFieldArray, Map<QName, Integer>[] mapArray, int n) {
        FcgField fcgField = fcgFieldArray[n];
        if (fcgField != null) {
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
            FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_HASH_MAP);
            mapArray[n] = SerializationStub.createJAXBElementChoiceMap(this.valueClass, n);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(n);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "createJAXBElementChoiceMap", (FcgType)fcgClassReferenceType3, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.storeClassFieldStmt(fcgField);
        }
    }

    private void generateInternalInitializeAttributeByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, FcgField[] fcgFieldArray, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeAttributeByteArrays" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.generateAttributeFragments(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgVariable, fcgVariable2, i);
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, n, n5, fcgFieldArray, n6, nArray);
            this.generateInternalInitializeAttributeByteArraysMethod(fcgCodeGen, fcgClassGen, n5, n2, fcgFieldArray, n6 + 1, nArray);
        }
    }

    private void generateInternalInitializeElementByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, FcgField[][][] fcgFieldArray, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeElementByteArrays" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.generateStartAndEndTagFragments(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgFieldArray, fcgVariable, fcgVariable2, this.elementProperties.get(i));
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, n, n5, fcgFieldArray, n6, nArray);
            this.generateInternalInitializeElementByteArraysMethod(fcgCodeGen, fcgClassGen, n5, n2, fcgFieldArray, n6 + 1, nArray);
        }
    }

    private void generateInternalInitializeElementChoiceFieldsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, FcgField[] fcgFieldArray, List<Integer> list, Map<Class<?>, Integer>[] mapArray, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeElementChoiceFields" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.generateElementContentChoiceMap(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgFieldArray, mapArray, list.get(i));
            }
        }
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n, n5, fcgFieldArray, list, mapArray, n6, nArray);
            this.generateInternalInitializeElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n5, n2, fcgFieldArray, list, mapArray, n6 + 1, nArray);
        }
    }

    private void generateInternalInitializeJAXBElementChoiceFieldsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, FcgField[] fcgFieldArray, List<Integer> list, Map<QName, Integer>[] mapArray, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.VOID, "initializeJAXBElementChoiceFields" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.generateJAXBElementChoiceMap(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgFieldArray, mapArray, list.get(i));
            }
        }
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n, n5, fcgFieldArray, list, mapArray, n6, nArray);
            this.generateInternalInitializeJAXBElementChoiceFieldsMethod(fcgCodeGen, fcgClassGen, n5, n2, fcgFieldArray, list, mapArray, n6 + 1, nArray);
        }
    }

    private void invokeInternalInitializeAttributeByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalInitializeMethod("initializeAttributeByteArrays", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalInitializeElementByteArraysMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalInitializeMethod("initializeElementByteArrays", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalInitializeElementChoiceFieldsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalInitializeMethod("initializeElementChoiceFields", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalInitializeJAXBElementChoiceFieldsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalInitializeMethod("initializeJAXBElementChoiceFields", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalInitializeMethod(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), string + n, (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType, fcgClassReferenceType2});
    }

    private void generateIsCompatibleMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        TypedProperty typedProperty;
        int n;
        AttributeProperty[] attributePropertyArray;
        int n2;
        int n3;
        ElementProperty[] elementPropertyArray;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, "isCompatible");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> elementPropertyArray2 : this.model.ns2PrefixMap.entrySet()) {
            String n5 = elementPropertyArray2.getValue();
            if ("xml".equals(n5) || "xmlns".equals(n5) || !this.prefixesUsed.contains(n5)) continue;
            arrayList.add(elementPropertyArray2);
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            this.invokeCheckNamespaceMappingsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        int n5 = (elementPropertyArray = this.valueClass.elementProperties) != null ? elementPropertyArray.length : 0;
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadLiteral(n5);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkElementPropertyCount", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
        ArrayList<PropertyHolder> arrayList2 = new ArrayList<PropertyHolder>();
        for (n3 = 0; n3 < n5; ++n3) {
            ElementProperty n22 = elementPropertyArray[n3];
            if (n22.propertyTypeInfo.valueType.valueClass == null) continue;
            arrayList2.add(new PropertyHolder(n22, n3));
        }
        n3 = arrayList2.size();
        if (n3 > 0) {
            this.invokeCheckElementPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        if ((n2 = n5 - this.valueClass.ownedElementProperties) > 0) {
            this.invokeCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        int n6 = (attributePropertyArray = this.valueClass.attributeProperties) != null ? attributePropertyArray.length : 0;
        ArrayList<PropertyHolder> arrayList3 = new ArrayList<PropertyHolder>();
        for (n = 0; n < n6; ++n) {
            typedProperty = attributePropertyArray[n];
            if (typedProperty.propertyTypeInfo.valueType.valueClass == null) continue;
            arrayList3.add(new PropertyHolder(typedProperty, n));
        }
        n = arrayList3.size();
        if (n > 0) {
            this.invokeCheckAttributePropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        if ((typedProperty = this.valueClass.simpleContentProperty) != null && ((SimpleContentProperty)typedProperty).propertyTypeInfo.valueType.valueClass != null) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(((SimpleContentProperty)typedProperty).propertyTypeInfo.valueType.valueClass.classId);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType3, "checkSimpleContentPropertyClassId", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT});
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            fcgInstructionList.beginIf();
            fcgInstructionList.loadLiteral(false);
            fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
            fcgInstructionList.endIf();
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
        if (n4 > 0) {
            this.generateCheckNamespaceMappingsMethod(fcgCodeGen, fcgClassGen, arrayList);
        }
        if (n3 > 0) {
            this.generateCheckElementPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, arrayList2);
        }
        if (n > 0) {
            this.generateCheckAttributePropertyClassIdsMethod(fcgCodeGen, fcgClassGen, arrayList3);
        }
        if (n2 > 0) {
            this.generateCheckElementPropertyNamesAndTypes(fcgCodeGen, fcgClassGen);
        }
    }

    private void generateCheckNamespaceMappingsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, List<Map.Entry<String, String>> list) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, "checkNamespaceMappings");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n = list.size();
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalCheckNamespaceMappingsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalCheckNamespaceMappingsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n2 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalCheckNamespaceMappingsMethod(fcgCodeGen, fcgClassGen, 0, n2, list, 0, nArray);
            this.generateInternalCheckNamespaceMappingsMethod(fcgCodeGen, fcgClassGen, n2, n, list, 1, nArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.invokeCheckNamespaceMapping(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, list.get(i));
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
    }

    private void generateInternalCheckNamespaceMappingsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, List<Map.Entry<String, String>> list, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.BOOLEAN, "checkNamespaceMappings" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalCheckNamespaceMappingsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalCheckNamespaceMappingsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.invokeCheckNamespaceMapping(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, list.get(i));
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalCheckNamespaceMappingsMethod(fcgCodeGen, fcgClassGen, n, n5, list, n6, nArray);
            this.generateInternalCheckNamespaceMappingsMethod(fcgCodeGen, fcgClassGen, n5, n2, list, n6 + 1, nArray);
        }
    }

    private void generateCheckElementPropertyClassIdsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, List<PropertyHolder> list) {
        this.generateCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, list, true);
    }

    private void generateCheckAttributePropertyClassIdsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, List<PropertyHolder> list) {
        this.generateCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, list, false);
    }

    private void generateCheckPropertyClassIdsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, List<PropertyHolder> list, boolean bl) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, bl ? "checkElementPropertyClassIds" : "checkAttributePropertyClassIds");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n = list.size();
        if (n > this.fMethodSplitThreshold) {
            this.invokeInternalCheckPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0, bl);
            this.invokeInternalCheckPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1, bl);
            int n2 = n / 2;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, 0, n2, list, 0, nArray, bl);
            this.generateInternalCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, n2, n, list, 1, nArray, bl);
        } else {
            for (int i = 0; i < n; ++i) {
                this.invokeCheckPropertyClassId(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, list.get(i), bl);
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
    }

    private void generateInternalCheckPropertyClassIdsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, List<PropertyHolder> list, int n3, int[] nArray, boolean bl) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.BOOLEAN, (bl ? "checkElementPropertyClassIds" : "checkAttributePropertyClassIds") + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalCheckPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6, bl);
            this.invokeInternalCheckPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1, bl);
        } else {
            for (int i = n; i < n2; ++i) {
                this.invokeCheckPropertyClassId(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, list.get(i), bl);
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, n, n5, list, n6, nArray, bl);
            this.generateInternalCheckPropertyClassIdsMethod(fcgCodeGen, fcgClassGen, n5, n2, list, n6 + 1, nArray, bl);
        }
    }

    private void generateCheckElementPropertyNamesAndTypes(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.BOOLEAN, "checkElementPropertyNamesAndTypes");
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        ElementProperty[] elementPropertyArray = this.valueClass.elementProperties;
        int n = this.valueClass.ownedElementProperties;
        int n2 = elementPropertyArray != null ? elementPropertyArray.length : 0;
        int n3 = n2 - n;
        if (n3 > this.fMethodSplitThreshold) {
            this.invokeInternalCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
            this.invokeInternalCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
            int n4 = n + n2 >>> 1;
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalCheckElementPropertyNamesAndTypesMethod(fcgCodeGen, fcgClassGen, 0, n4, 0, nArray);
            this.generateInternalCheckElementPropertyNamesAndTypesMethod(fcgCodeGen, fcgClassGen, n4, n3, 1, nArray);
        } else {
            for (int i = n; i < n2; ++i) {
                this.invokeCheckElementPropertyNameAndType(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, elementPropertyArray[i], i);
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
    }

    private void generateInternalCheckElementPropertyNamesAndTypesMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int n2, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE_STATIC, FcgType.BOOLEAN, "checkElementPropertyNamesAndTypes" + n3);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgClassReferenceType2, "model");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        ElementProperty[] elementPropertyArray = this.valueClass.elementProperties;
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.invokeInternalCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6);
            this.invokeInternalCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n6 + 1);
        } else {
            for (int i = n; i < n2; ++i) {
                this.invokeCheckElementPropertyNameAndType(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, elementPropertyArray[i], i);
            }
        }
        fcgInstructionList.loadLiteral(true);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalCheckElementPropertyNamesAndTypesMethod(fcgCodeGen, fcgClassGen, n, n5, n6, nArray);
            this.generateInternalCheckElementPropertyNamesAndTypesMethod(fcgCodeGen, fcgClassGen, n5, n2, n6 + 1, nArray);
        }
    }

    private void invokeCheckNamespaceMapping(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, Map.Entry<String, String> entry) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        String string = entry.getValue();
        String string2 = entry.getKey();
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.loadLiteral(string);
        fcgInstructionList.loadLiteral(string2);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "checkNamespaceMapping", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.STRING, FcgType.STRING});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
    }

    private void invokeCheckPropertyClassId(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, PropertyHolder propertyHolder, boolean bl) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadLiteral(propertyHolder.index);
        fcgInstructionList.loadLiteral(propertyHolder.property.propertyTypeInfo.valueType.valueClass.classId);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, bl ? "checkElementPropertyClassId" : "checkAttributePropertyClassId", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT, FcgType.INT});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
    }

    private void invokeCheckElementPropertyNameAndType(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, ElementProperty elementProperty, int n) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(FCGSerializationStubGeneratorHelper.CLASS_STUB);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.loadLiteral(elementProperty.schemaComponentName.ns);
        fcgInstructionList.loadLiteral(elementProperty.schemaComponentName.local);
        fcgInstructionList.loadLiteral(elementProperty.propertyTypeInfo.valueType.javaType.getName());
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "checkElementPropertyNameAndType", (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, FcgType.INT, FcgType.STRING, FcgType.STRING, FcgType.STRING});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
    }

    private void invokeCheckNamespaceMappingsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkNamespaceMappings", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
    }

    private void invokeInternalCheckNamespaceMappingsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkNamespaceMappings", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalCheckPropertyClassIdsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n, boolean bl) {
        if (bl) {
            this.invokeInternalCheckElementPropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
        } else {
            this.invokeInternalCheckAttributePropertyClassIdsMethodAndReturnIfFalse(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
        }
    }

    private void invokeCheckElementPropertyClassIdsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkElementPropertyClassIds", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
    }

    private void invokeInternalCheckElementPropertyClassIdsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkElementPropertyClassIds", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeCheckAttributePropertyClassIdsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkAttributePropertyClassIds", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
    }

    private void invokeInternalCheckAttributePropertyClassIdsMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkAttributePropertyClassIds", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkElementPropertyNamesAndTypes", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
    }

    private void invokeInternalCheckElementPropertyNamesAndTypesMethodAndReturnIfFalse(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse("checkElementPropertyNamesAndTypes", fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n);
    }

    private void invokeInternalIsCompatibleMethodAndReturnIfFalse(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        this.invokeInternalIsCompatibleMethodAndReturnIfFalse(string + n, fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2);
    }

    private void invokeInternalIsCompatibleMethodAndReturnIfFalse(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_JAXB_MODEL_CLASS);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.invokeClassMethod(fcgClassGen.getClassType(), string, (FcgType)FcgType.BOOLEAN, new FcgType[]{fcgClassReferenceType, fcgClassReferenceType2});
        fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(false);
        fcgInstructionList.returnInstruction(FcgType.BOOLEAN);
        fcgInstructionList.endIf();
    }

    private void generateConstructor(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(CLASS_VALUE_CLASS);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "valueClass");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_STUB);
        fcgInstructionList.invokeSuperConstructor(fcgClassReferenceType2, 1);
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private boolean generateWriteAttributesMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[] fcgFieldArray) {
        if (fcgFieldArray.length > 0 || this.valueClass.attributeWildcardProperty != null) {
            FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
            FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE, FcgType.VOID, "writeAttributes");
            FcgVariable fcgVariable = fcgMethodGen.addParameter(fcgClassReferenceType, "o");
            FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
            fcgInstructionList.beginMethod();
            AttributeGroupGenerator attributeGroupGenerator = new AttributeGroupGenerator(this, this.valueClass, fcgFieldArray);
            attributeGroupGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
            fcgInstructionList.endMethod();
            return true;
        }
        return false;
    }

    private void generateWriteMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray, FcgField[] fcgFieldArray2, FcgField[] fcgFieldArray3, Map<?, Integer>[][] mapArray, boolean bl) {
        int n;
        PropertyGroup[] propertyGroupArray;
        boolean bl2;
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "write");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (this.beforeMarshalMethod != null) {
            this.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        if (bl2 = this.requireNSContextPushAndPop()) {
            FCGSerializationStubGenerator.invokePushNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
        }
        if (bl) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "writeAttributes", (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType});
        }
        boolean bl3 = false;
        if (this.valueClass.simpleContentProperty != null) {
            propertyGroupArray = this.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            boolean bl4 = bl3 = propertyGroupArray.typeId == 18;
        }
        if (!bl3) {
            FCGSerializationStubGenerator.invokeWriteByte(fcgCodeGen, fcgClassGen, fcgInstructionList, (byte)62);
        }
        int n2 = n = (propertyGroupArray = this.valueClass.propOrder) != null ? propertyGroupArray.length : 0;
        if (n > this.fMethodSplitThreshold) {
            int n3 = n >>> 1;
            String string = "writePropertyGroups";
            this.callInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, string, 0);
            this.callInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, string, 1);
            int[] nArray = ArrayAllocator.newIntArray(1);
            nArray[0] = 2;
            this.generateInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgFieldArray2, fcgFieldArray3, mapArray, 0, n3, string, fcgVariable2, 0, nArray);
            this.generateInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgFieldArray2, fcgFieldArray3, mapArray, n3, n, string, fcgVariable2, 1, nArray);
        } else {
            for (int i = 0; i < n; ++i) {
                Map<Class<?>, Integer> map = mapArray[0][i];
                Map<QName, Integer> map2 = mapArray[1][i];
                PropertyGroupGenerator propertyGroupGenerator = new PropertyGroupGenerator(this, this.valueClass, propertyGroupArray[i], i, fcgFieldArray[i], fcgFieldArray2[i], fcgFieldArray3[i], map, map2);
                propertyGroupGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            }
        }
        if (bl2) {
            FCGSerializationStubGenerator.invokePopNSContext(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList);
        }
        if (this.afterMarshalMethod != null) {
            this.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateInternalWritePropertyGroupsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgField[][][] fcgFieldArray, FcgField[] fcgFieldArray2, FcgField[] fcgFieldArray3, Map<?, Integer>[][] mapArray, int n, int n2, String string, FcgVariable fcgVariable, int n3, int[] nArray) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE, FcgType.VOID, string + n3);
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgVariable.getType(), "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n4 = n2 - n;
        int n5 = n + n2 >>> 1;
        int n6 = nArray[0];
        if (n4 > this.fMethodSplitThreshold) {
            this.callInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, string, n6);
            this.callInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, string, n6 + 1);
        } else {
            PropertyGroup[] propertyGroupArray = this.valueClass.propOrder;
            for (int i = n; i < n2; ++i) {
                Map<Class<?>, Integer> map = mapArray[0][i];
                Map<QName, Integer> map2 = mapArray[1][i];
                PropertyGroupGenerator propertyGroupGenerator = new PropertyGroupGenerator(this, this.valueClass, propertyGroupArray[i], i, fcgFieldArray[i], fcgFieldArray2[i], fcgFieldArray3[i], map, map2);
                propertyGroupGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            }
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        if (n4 > this.fMethodSplitThreshold) {
            nArray[0] = nArray[0] + 2;
            this.generateInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgFieldArray2, fcgFieldArray3, mapArray, n, n5, string, fcgVariable, n6, nArray);
            this.generateInternalWritePropertyGroupsMethod(fcgCodeGen, fcgClassGen, fcgFieldArray, fcgFieldArray2, fcgFieldArray3, mapArray, n5, n2, string, fcgVariable, n6 + 1, nArray);
        }
    }

    private void callInternalWritePropertyGroupsMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, String string, int n) {
        fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.invokeInstanceMethod(fcgClassGen.getClassType(), string + n, (FcgType)FcgType.VOID, new FcgType[]{fcgVariable.getType()});
    }

    private void generateWriteSimpleContentMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, SimpleContentProperty simpleContentProperty) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "writeSimpleContent");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (this.beforeMarshalMethod != null) {
            this.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        FcgType fcgType = null;
        Class<?> clazz = null;
        FcgVariable fcgVariable3 = null;
        SimpleContentPropertyGenerator simpleContentPropertyGenerator = new SimpleContentPropertyGenerator(this, this.valueClass, simpleContentProperty, 0);
        if (simpleContentProperty.propertyField != null) {
            clazz = simpleContentProperty.propertyField.getType();
            fcgType = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
            if (this.mustAccessFieldUsingReflection(simpleContentProperty.propertyField)) {
                simpleContentPropertyGenerator.invokeReadPropertyField(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgType);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, simpleContentProperty.propertyField.getName(), fcgType);
            }
            fcgVariable3 = fcgInstructionList.defineVar(fcgType, "value", true);
        } else if (simpleContentProperty.accessor.readMethod != null) {
            Method method = simpleContentProperty.accessor.readMethod;
            clazz = method.getReturnType();
            fcgType = FCGTypeUtil.getFcgType(clazz, fcgCodeGen);
            if (this.mustCallMethodUsingReflection(method)) {
                simpleContentPropertyGenerator.invokeReadPropertyMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgType);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, method.getName(), fcgType, 0);
            }
            fcgVariable3 = fcgInstructionList.defineVar(fcgType, "value", true);
        }
        simpleContentPropertyGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable3);
        if (this.afterMarshalMethod != null) {
            this.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2, fcgClassReferenceType);
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateReadIDValueMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, TypedProperty typedProperty) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.STRING, "readIDValue");
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.OBJECT, "o");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGTypeUtil.getFcgType(this.valueClass.javaType, fcgCodeGen);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgClassReferenceType, "_o", true);
        if (typedProperty.propertyField != null) {
            if (this.mustAccessFieldUsingReflection(typedProperty.propertyField)) {
                this.invokeReadIDPropertyField(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, typedProperty.propertyField.getName(), FcgType.STRING);
            }
        } else if (typedProperty.accessor.readMethod != null) {
            Method method = typedProperty.accessor.readMethod;
            if (this.mustCallMethodUsingReflection(method)) {
                this.invokeReadIDPropertyMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            } else {
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, method.getName(), (FcgType)FcgType.STRING, 0);
            }
        } else {
            fcgInstructionList.loadNull();
        }
        fcgInstructionList.returnInstruction(FcgType.STRING);
        fcgInstructionList.endMethod();
    }

    private boolean requireNSContextPushAndPop() {
        int n;
        Object object;
        if (this.valueClass.simpleContentProperty != null) {
            object = this.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            EnumClass enumClass = object.enumClass;
            int n2 = n = enumClass == null ? object.typeId : enumClass.getPrimitiveEnumConstantValueTypeId();
            if (n == 18) {
                return true;
            }
        }
        int n3 = (object = this.valueClass.attributeProperties) != null ? ((AttributeProperty[])object).length : 0;
        for (n = 0; n < n3; ++n) {
            int n4;
            AttributeProperty attributeProperty = object[n];
            if (attributeProperty == null) continue;
            ValueTypeInformation valueTypeInformation = attributeProperty.propertyTypeInfo.valueType;
            EnumClass enumClass = valueTypeInformation.enumClass;
            int n5 = n4 = enumClass == null ? valueTypeInformation.typeId : enumClass.getPrimitiveEnumConstantValueTypeId();
            if (n4 != 18) continue;
            return true;
        }
        return this.valueClass.attributeWildcardProperty != null;
    }

    private void invokeReadIDPropertyField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        this.invokeReadIDPropertyCommon("readIDPropertyField", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
    }

    private void invokeReadIDPropertyMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        this.invokeReadIDPropertyCommon("readIDPropertyMethod", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable);
    }

    private void invokeReadIDPropertyCommon(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, string, (FcgType)FcgType.STRING, new FcgType[]{FcgType.OBJECT});
    }

    private void invokeBeforeMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgClassReferenceType fcgClassReferenceType) {
        if (this.mustCallMethodUsingReflection(this.beforeMarshalMethod)) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "invokeBeforeMarshalMethod", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
        } else {
            FCGSerializationStubGenerator.invokeBeforeMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgClassReferenceType);
        }
    }

    private void invokeAfterMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, FcgClassReferenceType fcgClassReferenceType) {
        if (this.mustCallMethodUsingReflection(this.afterMarshalMethod)) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "invokeAfterMarshalMethod", (FcgType)FcgType.VOID, new FcgType[]{FcgType.OBJECT});
        } else {
            FCGSerializationStubGenerator.invokeAfterMarshal(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2, fcgClassReferenceType);
        }
    }

    static void invokeBeforeMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FCGSerializationStubGenerator.invokeMarshalCallback("beforeMarshal", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType);
    }

    static void invokeAfterMarshal(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FCGSerializationStubGenerator.invokeMarshalCallback("afterMarshal", fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType);
    }

    private static void invokeMarshalCallback(String string, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType) {
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType(CLASS_MARSHALLER);
        FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGen.getClassReferenceType(CLASS_MARSHALLER_IMPL);
        FcgClassReferenceType fcgClassReferenceType4 = fcgCodeGen.getClassReferenceType(CLASS_CONTEXT);
        fcgInstructionList.loadVar(fcgVariable);
        FcgClassReferenceType fcgClassReferenceType5 = fcgInstructionList.loadThis();
        fcgInstructionList.loadInstanceField(fcgClassReferenceType5, "fContext", fcgClassReferenceType4);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType4, "marshaller", fcgClassReferenceType3);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, string, (FcgType)FcgType.VOID, new FcgType[]{fcgClassReferenceType2});
    }

    private boolean mustAccessFieldUsingReflection(Field field) {
        return this.mustAccessUsingReflection(field.getDeclaringClass(), field.getModifiers());
    }

    private boolean mustCallMethodUsingReflection(Method method) {
        return this.mustAccessUsingReflection(method.getDeclaringClass(), method.getModifiers());
    }

    private boolean mustAccessUsingReflection(Class<?> clazz, int n) {
        boolean bl = clazz.getPackage() == this.valueClass.javaType.getPackage();
        return !bl && !Modifier.isPublic(n) || Modifier.isPrivate(n);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class PropertyHolder {
        public final Property property;
        public final int index;

        public PropertyHolder(Property property, int n) {
            this.property = property;
            this.index = n;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009, 2011. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class ElementPropertyHolder {
        public final ElementProperty eProperty;
        public final int propertyGroupId;
        public final int propertyGroupIndex;

        public ElementPropertyHolder(ElementProperty elementProperty, int n, int n2) {
            this.eProperty = elementProperty;
            this.propertyGroupId = n;
            this.propertyGroupIndex = n2;
        }
    }
}

