/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSNormalizer {
    private final XMLStringBuffer fBuffer = new XMLStringBuffer();

    public XMLString replace(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.replaceUnbuffered(xMLString, validationContext);
        }
        return this.replaceBuffered(xMLString, validationContext);
    }

    public int replace(ParsedEntity parsedEntity, ValidationContext validationContext, ValidatedInfo validatedInfo, boolean[] blArray, int n) {
        DataBuffer dataBuffer = parsedEntity.buffer;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        byte by = 0;
        int n4 = n2;
        while (true) {
            if (n4 < n3) {
                by = byArray[n4];
                if (by == n) {
                    return n4;
                }
                if (by == 10 || by == 9 || by == 13) {
                    blArray[0] = false;
                    validatedInfo.actualValue = validationContext.getXMLString();
                    return this.replace2(parsedEntity, (XMLString)validatedInfo.actualValue, dataBuffer, n2, n4, n);
                }
                ++n4;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n4 = parsedEntity.offset;
            n3 = parsedEntity.endOffset;
        }
    }

    public XMLString collapse(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.collapseUnbuffered(xMLString, validationContext);
        }
        return this.collapseBuffered(xMLString, validationContext);
    }

    public int collapse(ParsedEntity parsedEntity, ValidationContext validationContext, ValidatedInfo validatedInfo, boolean[] blArray, int n) {
        DataBuffer dataBuffer = parsedEntity.buffer;
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        byte by = 0;
        int n4 = n2;
        while (true) {
            if (n4 < n3) {
                by = byArray[n4];
                if (by == n) {
                    return n4;
                }
                if (by == 10 || by == 9 || by == 13 || by == 32) {
                    blArray[0] = false;
                    validatedInfo.actualValue = validationContext.getXMLString();
                    return this.collapse2(parsedEntity, (XMLString)validatedInfo.actualValue, dataBuffer, n2, n4, n);
                }
                ++n4;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n4 = parsedEntity.offset;
            n3 = parsedEntity.endOffset;
        }
    }

    public XMLString trim(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.trimUnbuffered(xMLString, validationContext);
        }
        return this.trimBuffered(xMLString, validationContext);
    }

    private XMLString replaceUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n = xMLString.endOffset;
        byte by = 0;
        for (int i = xMLString.startOffset; i < n; ++i) {
            by = xMLString.bytes[i];
            if (by != 10 && by != 9 && by != 13) continue;
            return this.replaceUnbuffered2(xMLString, validationContext, i, n);
        }
        return xMLString;
    }

    private XMLString replaceUnbuffered2(XMLString xMLString, ValidationContext validationContext, int n, int n2) {
        int n3 = xMLString.startOffset;
        byte by = 0;
        this.fBuffer.reset(true);
        int n4 = this.fBuffer.getOffset();
        if (n3 != n) {
            if (n - n3 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n3, n);
            }
        }
        this.fBuffer.appendChar(32);
        n3 = ++n;
        while (n < n2) {
            by = xMLString.bytes[n];
            if (by == 10 || by == 9 || by == 13) {
                if (n3 != n) {
                    if (n - n3 == 1) {
                        this.fBuffer.appendChar(xMLString.bytes[n3]);
                    } else {
                        this.fBuffer.appendBytes(xMLString.bytes, n3, n);
                    }
                }
                this.fBuffer.appendChar(32);
                n3 = n + 1;
            }
            ++n;
        }
        if (n3 != n) {
            if (n - n3 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n3, n);
            }
        }
        XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        this.fBuffer.setStringValues(n4, this.fBuffer.getOffset(), xMLString2);
        return xMLString2;
    }

    private XMLString replaceBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = 0;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 10 || by == 9 || by == 13) {
                    return this.replaceBuffered2(xMLString, validationContext, dataBuffer, dataBuffer2, n, n2);
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private XMLString replaceBuffered2(XMLString xMLString, ValidationContext validationContext, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        int n3 = xMLString.startOffset;
        this.fBuffer.reset(true);
        int n4 = this.fBuffer.getOffset();
        if (dataBuffer3 != dataBuffer) {
            this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                dataBuffer4 = dataBuffer4.next;
            }
            this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
        } else if (n3 != n) {
            if (n - n3 == 1) {
                this.fBuffer.appendChar(dataBuffer.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
            }
        }
        this.fBuffer.appendChar(32);
        n3 = ++n;
        dataBuffer3 = dataBuffer;
        byte by = 0;
        while (true) {
            Object object;
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 10 || by == 9 || by == 13) {
                    if (dataBuffer3 != dataBuffer) {
                        this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
                        object = dataBuffer3.next;
                        while (object != dataBuffer) {
                            this.fBuffer.appendBytes(((DataBuffer)object).bytes, ((DataBuffer)object).startOffset, ((DataBuffer)object).endOffset);
                            object = ((DataBuffer)object).next;
                        }
                        this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
                    } else if (n3 != n) {
                        if (n - n3 == 1) {
                            this.fBuffer.appendChar(dataBuffer.bytes[n3]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n3 = n + 1;
                    dataBuffer3 = dataBuffer;
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                if (dataBuffer3 != dataBuffer) {
                    this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
                    object = dataBuffer3.next;
                    while (object != dataBuffer) {
                        this.fBuffer.appendBytes(((DataBuffer)object).bytes, ((DataBuffer)object).startOffset, ((DataBuffer)object).endOffset);
                        object = ((DataBuffer)object).next;
                    }
                    this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
                } else if (n3 != n) {
                    if (n - n3 == 1) {
                        this.fBuffer.appendChar(dataBuffer.bytes[n3]);
                    } else {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
                    }
                }
                object = validationContext != null ? validationContext.getXMLString() : new XMLString();
                this.fBuffer.setStringValues(n4, this.fBuffer.getOffset(), (XMLString)object);
                return object;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private int replace2(ParsedEntity parsedEntity, XMLString xMLString, DataBuffer dataBuffer, int n, int n2, int n3) {
        DataBuffer dataBuffer2 = parsedEntity.buffer;
        int n4 = dataBuffer2.endOffset;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        if (dataBuffer2 != dataBuffer) {
            this.fBuffer.appendBytes(dataBuffer.bytes, n, dataBuffer.endOffset);
            DataBuffer dataBuffer3 = dataBuffer.next;
            while (dataBuffer3 != dataBuffer2) {
                this.fBuffer.appendBytes(dataBuffer3.bytes, dataBuffer3.startOffset, dataBuffer3.endOffset);
                dataBuffer3 = dataBuffer3.next;
            }
            this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n2);
        } else if (n != n2) {
            if (n2 - n == 1) {
                this.fBuffer.appendChar(dataBuffer2.bytes[n]);
            } else {
                this.fBuffer.appendBytes(dataBuffer2.bytes, n, n2);
            }
        }
        this.fBuffer.appendChar(32);
        n = ++n2;
        dataBuffer = dataBuffer2;
        byte by = 0;
        while (true) {
            if (n2 < n4) {
                DataBuffer dataBuffer4;
                by = dataBuffer2.bytes[n2];
                if (by == n3) {
                    if (dataBuffer != dataBuffer2) {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n, dataBuffer.endOffset);
                        dataBuffer4 = dataBuffer.next;
                        while (dataBuffer4 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                            dataBuffer4 = dataBuffer4.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n2);
                    } else if (n != n2) {
                        if (n2 - n == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n, n2);
                        }
                    }
                    this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), xMLString);
                    return n2;
                }
                if (by == 10 || by == 9 || by == 13) {
                    if (dataBuffer2 != dataBuffer) {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n, dataBuffer.endOffset);
                        dataBuffer4 = dataBuffer.next;
                        while (dataBuffer4 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                            dataBuffer4 = dataBuffer4.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n2);
                    } else if (n != n2) {
                        if (n2 - n == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n, n2);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n = n2 + 1;
                    dataBuffer = dataBuffer2;
                }
                ++n2;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            dataBuffer2 = parsedEntity.buffer;
            n2 = parsedEntity.offset;
            n4 = parsedEntity.endOffset;
        }
    }

    private XMLString collapseUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n = xMLString.endOffset;
        byte by = 0;
        for (int i = xMLString.startOffset; i < n; ++i) {
            by = xMLString.bytes[i];
            if (by != 10 && by != 9 && by != 13 && by != 32) continue;
            return this.collapseUnbuffered2(xMLString, validationContext, i, n);
        }
        return xMLString;
    }

    private XMLString collapseUnbuffered2(XMLString xMLString, ValidationContext validationContext, int n, int n2) {
        int n3 = xMLString.startOffset;
        byte by = xMLString.bytes[n];
        boolean bl = true;
        this.fBuffer.reset(true);
        int n4 = this.fBuffer.getOffset();
        if (n3 != n) {
            bl = false;
            if (n - n3 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n3, n);
            }
        }
        boolean bl2 = by == 10 || by == 9 || by == 13 || by == 32;
        n3 = ++n;
        while (n < n2) {
            by = xMLString.bytes[n];
            if (by == 10 || by == 9 || by == 13 || by == 32) {
                if (n3 != n) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    if (n - n3 == 1) {
                        this.fBuffer.appendChar(xMLString.bytes[n3]);
                    } else {
                        this.fBuffer.appendBytes(xMLString.bytes, n3, n);
                    }
                }
                bl2 = true;
                n3 = n + 1;
            }
            ++n;
        }
        if (n3 != n) {
            if (!bl && bl2) {
                this.fBuffer.appendChar(32);
                bl2 = false;
            }
            if (n - n3 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n3, n);
            }
        }
        XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        this.fBuffer.setStringValues(n4, this.fBuffer.getOffset(), xMLString2);
        return xMLString2;
    }

    private XMLString collapseBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = 0;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 10 || by == 9 || by == 13 || by == 32) {
                    return this.collapseBuffered2(xMLString, validationContext, dataBuffer, dataBuffer2, n, n2);
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private XMLString collapseBuffered2(XMLString xMLString, ValidationContext validationContext, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        int n3 = xMLString.startOffset;
        boolean bl = true;
        this.fBuffer.reset(true);
        int n4 = this.fBuffer.getOffset();
        if (dataBuffer3 != dataBuffer) {
            bl = false;
            this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                dataBuffer4 = dataBuffer4.next;
            }
            this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
        } else if (n3 != n) {
            bl = false;
            if (n - n3 == 1) {
                this.fBuffer.appendChar(dataBuffer.bytes[n3]);
            } else {
                this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
            }
        }
        byte by = dataBuffer.bytes[n];
        boolean bl2 = by == 10 || by == 9 || by == 13 || by == 32;
        n3 = ++n;
        dataBuffer3 = dataBuffer;
        while (true) {
            Object object;
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 10 || by == 9 || by == 13 || by == 32) {
                    if (dataBuffer3 != dataBuffer) {
                        if (!bl && bl2) {
                            this.fBuffer.appendChar(32);
                            bl2 = false;
                        }
                        bl = false;
                        this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
                        object = dataBuffer3.next;
                        while (object != dataBuffer) {
                            this.fBuffer.appendBytes(((DataBuffer)object).bytes, ((DataBuffer)object).startOffset, ((DataBuffer)object).endOffset);
                            object = ((DataBuffer)object).next;
                        }
                        this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
                    } else if (n3 != n) {
                        if (!bl && bl2) {
                            this.fBuffer.appendChar(32);
                            bl2 = false;
                        }
                        bl = false;
                        if (n - n3 == 1) {
                            this.fBuffer.appendChar(dataBuffer.bytes[n3]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n3 = n + 1;
                    dataBuffer3 = dataBuffer;
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                if (dataBuffer3 != dataBuffer) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    this.fBuffer.appendBytes(dataBuffer3.bytes, n3, dataBuffer3.endOffset);
                    object = dataBuffer3.next;
                    while (object != dataBuffer) {
                        this.fBuffer.appendBytes(((DataBuffer)object).bytes, ((DataBuffer)object).startOffset, ((DataBuffer)object).endOffset);
                        object = ((DataBuffer)object).next;
                    }
                    this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n);
                } else if (n3 != n) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    if (n - n3 == 1) {
                        this.fBuffer.appendChar(dataBuffer.bytes[n3]);
                    } else {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n3, n);
                    }
                }
                object = validationContext != null ? validationContext.getXMLString() : new XMLString();
                this.fBuffer.setStringValues(n4, this.fBuffer.getOffset(), (XMLString)object);
                return object;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private int collapse2(ParsedEntity parsedEntity, XMLString xMLString, DataBuffer dataBuffer, int n, int n2, int n3) {
        DataBuffer dataBuffer2 = parsedEntity.buffer;
        int n4 = dataBuffer2.endOffset;
        boolean bl = true;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        while (true) {
            if (n2 < n4) {
                byte by = dataBuffer2.bytes[n2];
                if (by == 32 || by == 10 || by == 9 || by == 13 || by == n3) {
                    if (dataBuffer != dataBuffer2) {
                        if (!bl) {
                            this.fBuffer.appendChar(32);
                        }
                        bl = false;
                        this.fBuffer.appendBytes(dataBuffer.bytes, n, dataBuffer.endOffset);
                        DataBuffer dataBuffer3 = dataBuffer.next;
                        while (dataBuffer3 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer3.bytes, dataBuffer3.startOffset, dataBuffer3.endOffset);
                            dataBuffer3 = dataBuffer3.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n2);
                    } else if (n != n2) {
                        if (!bl) {
                            this.fBuffer.appendChar(32);
                        }
                        bl = false;
                        if (n2 - n == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n, n2);
                        }
                    }
                    if (by == n3) {
                        this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), xMLString);
                        return n2;
                    }
                    n = n2 + 1;
                    dataBuffer = dataBuffer2;
                }
                ++n2;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            dataBuffer2 = parsedEntity.buffer;
            n2 = parsedEntity.offset;
            n4 = parsedEntity.endOffset;
        }
    }

    private XMLString trimUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n = xMLString.endOffset;
        int n2 = xMLString.startOffset;
        byte by = 0;
        boolean bl = false;
        if (n2 < n) {
            by = xMLString.bytes[n2];
            if (by == 32 || by == 10 || by == 9 || by == 13) {
                bl = true;
            }
            while ((by == 32 || by == 10 || by == 9 || by == 13) && ++n2 <= n) {
                by = xMLString.bytes[n2];
            }
        }
        if (n > n2) {
            if ((by = xMLString.bytes[--n]) == 32 || by == 10 || by == 9 || by == 13) {
                bl = true;
            }
            while ((by == 32 || by == 10 || by == 9 || by == 13) && --n > n2) {
                by = xMLString.bytes[n];
            }
        }
        if (bl) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLString2.setValues(xMLString.firstBuffer, null, n2, n + 1);
            xMLString2.flags = 1;
            return xMLString2;
        }
        return xMLString;
    }

    private XMLString trimBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        boolean bl = false;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            if (by == 32 || by == 10 || by == 9 || by == 13) {
                bl = true;
            }
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n <= n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        DataBuffer dataBuffer3 = dataBuffer;
        int n3 = n;
        int n4 = n3 + 1;
        DataBuffer dataBuffer4 = dataBuffer;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                ++n;
                if (by == 32 || by == 10 || by == 9 || by == 13) continue;
                n4 = n;
                dataBuffer4 = dataBuffer;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (dataBuffer4 != dataBuffer2 || n4 != n2) {
            bl = true;
        }
        if (bl) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLString2.setValues(dataBuffer3, dataBuffer4, n3, n4);
            xMLString2.flags = 1;
            return xMLString2;
        }
        return xMLString;
    }
}

