/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype;

import com.ibm.xml.xlxp2.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XList {
    public Object[] value;
    public int length;

    public XList() {
    }

    public XList(Object[] objectArray) {
        this(objectArray, objectArray.length);
    }

    public XList(Object[] objectArray, int n) {
        this.value = objectArray;
        this.length = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XList) {
            XList xList = (XList)object;
            if (xList.length == this.length) {
                Object[] objectArray = xList.value;
                for (int i = 0; i < this.length; ++i) {
                    if (this.value[i].equals(objectArray[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            n ^= this.value[i].hashCode();
        }
        return n;
    }

    public String toString() {
        int n = this.value.length;
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            stringBuilder.append(this.value[0].toString());
        }
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(this.value[i].toString());
        }
        return stringBuilder.toString();
    }

    public boolean isEqual(XList xList, int[] nArray, int[] nArray2) {
        if (xList.length == this.length) {
            Object[] objectArray = xList.value;
            for (int i = 0; i < this.length; ++i) {
                if (nArray[i] == nArray2[i] && this.value[i].equals(objectArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

