/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.events;

import com.ibm.xml.xlxp2.api.stax.events.AttributeImpl;
import com.ibm.xml.xlxp2.api.stax.events.NamespaceImpl;
import com.ibm.xml.xlxp2.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class StartElementImpl
extends XMLEventImpl
implements StartElement {
    private final QName fName;
    private final Collection<Attribute> fAttributes;
    private final Collection<Namespace> fNamespaces;
    private final NamespaceContext fNamespaceContext;

    public StartElementImpl(QName qName, Collection<Attribute> collection, Collection<Namespace> collection2, NamespaceContext namespaceContext, Location location) {
        super(1, location);
        this.fName = qName;
        this.fAttributes = collection != null ? collection : AttributeImpl.EMPTY_LIST;
        this.fNamespaces = collection2 != null ? collection2 : NamespaceImpl.EMPTY_LIST;
        this.fNamespaceContext = namespaceContext;
    }

    public StartElementImpl(QName qName, Iterator<Attribute> iterator, Iterator<Namespace> iterator2, NamespaceContext namespaceContext, Location location) {
        this(qName, StartElementImpl.iteratorToList(iterator), StartElementImpl.iteratorToList(iterator2), namespaceContext, location);
    }

    @Override
    public QName getName() {
        return this.fName;
    }

    @Override
    public Iterator<Attribute> getAttributes() {
        return this.fAttributes.iterator();
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        return this.fNamespaces.iterator();
    }

    @Override
    public Attribute getAttributeByName(QName qName) {
        block4: {
            if (qName == null) break block4;
            if (this.fAttributes instanceof List) {
                List list = (List)this.fAttributes;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    if (!attribute.getName().equals(qName)) continue;
                    return attribute;
                }
            } else {
                for (Attribute attribute : this.fAttributes) {
                    if (!attribute.getName().equals(qName)) continue;
                    return attribute;
                }
            }
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.fName.getNamespaceURI();
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write(60);
            String string = this.fName.getPrefix();
            if (string.length() > 0) {
                writer.write(string);
                writer.write(58);
            }
            writer.write(this.fName.getLocalPart());
            for (Namespace object : this.fNamespaces) {
                writer.write(32);
                object.writeAsEncodedUnicode(writer);
            }
            for (Attribute attribute : this.fAttributes) {
                writer.write(32);
                attribute.writeAsEncodedUnicode(writer);
            }
            writer.write(62);
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }
}

