/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public final class UniqueIdentity {
    private BitArray id;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.UniqueIdentity";

    public UniqueIdentity(BitArray id) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", id);
            debug.exit(16384L, className, "UniqueIdentity");
        }
        this.id = id;
    }

    public UniqueIdentity(byte[] id) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", (Object)id);
        }
        this.id = new BitArray(id.length * 8, id);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public UniqueIdentity(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", in);
        }
        DerValue derVal = in.getDerValue();
        this.id = derVal.getUnalignedBitString(true);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public UniqueIdentity(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UniqueIdentity", derVal);
        }
        this.id = derVal.getUnalignedBitString(true);
        if (debug != null) {
            debug.exit(16384L, className, "UniqueIdentity");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "UniqueIdentity:" + this.id.toString() + "\n");
        }
        return "UniqueIdentity:" + this.id.toString() + "\n";
    }

    public void encode(DerOutputStream out, byte tag) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encode", out, new Byte(tag));
        }
        byte[] bytes = this.id.toByteArray();
        int excessBits = bytes.length * 8 - this.id.length();
        out.write(tag);
        out.putLength(bytes.length + 1);
        out.write(excessBits);
        out.write(bytes);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean[] getId() {
        if (debug != null) {
            debug.entry(16384L, className, "getId");
        }
        if (this.id == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getId_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getId_2", this.id.toBooleanArray());
        }
        return this.id.toBooleanArray();
    }
}

