/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class parseCert {
    public static void main(String[] args) {
        block15: {
            if (args.length < 1) {
                System.out.println("Usage: parseCert -file=certificateFileName [-base64] [-publickey=extractedPublicKeyfile]");
                System.exit(1);
            }
            String inputfile = null;
            String publickeyfile = null;
            boolean bbase64 = false;
            for (int i2 = 0; i2 < args.length; ++i2) {
                String param = args[i2].toLowerCase();
                boolean bfound = false;
                if (param.startsWith("-file=")) {
                    inputfile = args[i2].substring(6);
                    bfound = true;
                }
                if (param.startsWith("-publickey=")) {
                    publickeyfile = args[i2].substring(11);
                    bfound = true;
                }
                if (param.startsWith("-base64")) {
                    bbase64 = true;
                    bfound = true;
                }
                if (bfound) continue;
                System.out.println("ERROR:  Unknown parameter " + args[i2] + ".");
                System.exit(1);
            }
            if (inputfile == null) {
                System.out.println("ERROR:  input file must be specified.");
                System.exit(1);
            }
            System.out.println("parseCert invoked with:");
            System.out.println("\tInput file = " + inputfile);
            System.out.println("\tInput file in Base64 format = " + bbase64);
            System.out.println("\tPublic key store file name = " + publickeyfile);
            try {
                Certificate cert = null;
                try {
                    FileInputStream fis = new FileInputStream(inputfile);
                    if (bbase64) {
                        BASE64Decoder decoder = new BASE64Decoder();
                        byte[] bytes = decoder.decodeBuffer(fis);
                        cert = new X509CertImpl(bytes);
                    } else {
                        cert = new X509CertImpl(fis);
                    }
                    fis.close();
                    System.out.println("*** Input Certificate =\r\n" + cert);
                    parseCert.verifyCert(cert);
                    parseCert.storePublicKey(publickeyfile, cert);
                }
                catch (CertificateException ce) {
                    Content content;
                    SignedData sd;
                    Certificate[] certs;
                    ce.printStackTrace();
                    ContentInfo ci = new ContentInfo(inputfile, false);
                    if (!ci.isSignedData()) {
                        System.out.println("Not pkcs#7 signed data");
                        System.exit(1);
                    }
                    if ((certs = (sd = (SignedData)(content = ci.getContent())).getCertificates()) != null || certs.length != 0) {
                        int counter = 0;
                        for (int c2 = 0; c2 < certs.length; ++c2) {
                            cert = certs[c2];
                            System.out.println(cert);
                            parseCert.verifyCert(cert);
                            if (publickeyfile == null) continue;
                            String newpublickeyfile = publickeyfile + counter++;
                            parseCert.storePublicKey(newpublickeyfile, cert);
                        }
                        break block15;
                    }
                    System.out.println("No certificates in object");
                }
            }
            catch (Exception e2) {
                System.out.println("\r\nERROR:  Exception");
                e2.printStackTrace();
            }
        }
    }

    static void verifyCert(Certificate incert) throws CertificateNotYetValidException {
        X509CertImpl cert = (X509CertImpl)incert;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e2) {
            System.out.println("Warning: Certificate expired!");
            System.out.println(e2.getMessage());
        }
        PublicKey publickey = cert.getPublicKey();
        if (((Object)cert.getSubjectDN()).equals(cert.getIssuerDN())) {
            System.out.println("It is self signed, verifying signature ...");
            try {
                cert.verify(publickey);
                System.out.println("The signature is verified.");
            }
            catch (Exception e3) {
                System.out.println("\tThe signature can't be verified.");
                e3.printStackTrace();
            }
        }
    }

    static void storePublicKey(String filename, Certificate incert) throws IOException, FileNotFoundException {
        if (filename == null) {
            return;
        }
        X509CertImpl cert = (X509CertImpl)incert;
        PublicKey publickey = cert.getPublicKey();
        System.out.println("*** Public key = " + publickey);
        FileOutputStream fout = null;
        System.out.println("*** Writing the PublicKey object to " + filename);
        byte[] bytes = publickey.getEncoded();
        fout = new FileOutputStream(filename);
        fout.write(bytes);
        fout.close();
    }
}

