/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.util;

import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.websphere.cache.Sizeable;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.GenerateContents;
import java.util.ArrayList;
import java.util.List;

public class ObjectSizer {
    private static TraceComponent tc = Tr.register(CacheEntry.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final long FASTHASHTABLE_INITIAL_OVERHEAD = 40L;
    public static final long FASTHASHTABLE_INITIAL_PER_ENTRY_OVERHEAD = 28L;
    public static final long FASTHASHTABLE_PER_ENTRY_OVERHEAD = 64L;
    public static final long CACHEENTRY_INITIAL_PER_ENTRY_OVERHEAD = 184L;
    public static final long OBJECT_ARRAY_OVERHEAD = 24L;
    public static final long BYTE_ARRAY_OVERHEAD = 16L;
    public static final long CHAR_ARRAY_OVERHEAD = 16L;
    public static final long STRING_OVERHEAD = 48L;
    public static final long OBJECT_REF_SIZE = 16L;
    public static final long INTEGER_SIZE = 16L;
    public static final long FLOAT_SIZE = 16L;
    public static final long DOUBLE_SIZE = 24L;
    public static final long LONG_SIZE = 24L;
    public static final long SHORT_SIZE = 16L;
    public static final long BYTE_SIZE = 16L;
    public static final long BOOLEAN_SIZE = 16L;
    public static final long CHARACTER_SIZE = 16L;
    public static List<String> unsizeableObjectList = new ArrayList<String>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSize(Object object) {
        long totalSize = 0L;
        long size = 0L;
        if (object != null) {
            if (object instanceof String) {
                size = ((String)object).length() * 2;
                totalSize = 48L + ObjectSizer.adjustAlignmentFor8Boundary(size);
            } else if (object instanceof Sizeable) {
                try {
                    size = ((Sizeable)object).getObjectSize();
                }
                catch (Exception ex) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0034E", (Object[])new Object[]{"getObjectSize()", object.getClass().getName(), ex.getMessage()});
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.util.ObjectSizer", (String)"67");
                    size = -1L;
                }
                totalSize = size > 0L ? ObjectSizer.adjustAlignmentFor8Boundary(size) : -1L;
            } else if (object instanceof DistributedNioMapObject) {
                try {
                    size = ((DistributedNioMapObject)object).getCacheValueSize();
                }
                catch (Exception ex) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0034E", (Object[])new Object[]{"getCacheValueSize()", object.getClass().getName(), ex.getMessage()});
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.util.ObjectSizer", (String)"85");
                    size = -1L;
                }
                totalSize = size > 0L ? ObjectSizer.adjustAlignmentFor8Boundary(size) : -1L;
            } else if (object instanceof GenerateContents) {
                try {
                    size = ((GenerateContents)object).generateContents().length;
                    totalSize = 16L + ObjectSizer.adjustAlignmentFor8Boundary(size);
                }
                catch (Exception ex) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0034E", (Object[])new Object[]{"getCacheValueSize()", object.getClass().getName(), ex.getMessage()});
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.util.ObjectSizer", (String)"102");
                    size = -1L;
                    totalSize = -1L;
                }
            } else if (object instanceof byte[]) {
                size = ((byte[])object).length;
                totalSize = 16L + ObjectSizer.adjustAlignmentFor8Boundary(size);
            } else if (object instanceof char[]) {
                size = ((char[])object).length;
                totalSize = 16L + ObjectSizer.adjustAlignmentFor8Boundary(size * 2L);
            } else {
                totalSize = object instanceof Integer ? 16L : (object instanceof Float ? 16L : (object instanceof Double ? 24L : (object instanceof Long ? 24L : (object instanceof Short ? 16L : (object instanceof Byte ? 16L : (object instanceof Boolean ? 16L : (object instanceof Character ? 16L : -1L)))))));
            }
        }
        if (tc.isDebugEnabled() && object == null) {
            Tr.debug((TraceComponent)tc, (String)"getSize() object is null!", (Object[])new Object[0]);
        }
        if (totalSize < 1L && object != null) {
            String className = object.getClass().getName();
            List<String> list = unsizeableObjectList;
            synchronized (list) {
                if (!unsizeableObjectList.contains(className)) {
                    unsizeableObjectList.add(className);
                }
            }
        }
        return totalSize;
    }

    public static long adjustAlignmentFor8Boundary(long dataSize) {
        if (dataSize % 8L != 0L) {
            dataSize = (dataSize / 8L + 1L) * 8L;
        }
        return dataSize;
    }

    public static List getUnsizableObjectList() {
        return unsizeableObjectList;
    }
}

