/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.Bucket;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.Element;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FastHashtable
extends Dictionary {
    protected Bucket[] buckets;
    protected int size = 0;

    public FastHashtable(int expectedEntries) {
        this.buckets = new Bucket[expectedEntries];
        for (int i = 0; i < expectedEntries; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object getLock(Object key) {
        return this.getBucketForKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            return element != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, boolean incCount) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element != null) {
                CacheEntry ce = (CacheEntry)element.object;
                if (null != ce && incCount) {
                    ce.incRefCount();
                }
                return ce;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            return element != null ? element.object : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Bucket bucket = this.getBucketForKey(key);
        Element element = null;
        Object object = bucket;
        synchronized (object) {
            element = bucket.removeByKey(key);
        }
        if (element != null) {
            object = this;
            synchronized (object) {
                --this.size;
            }
            return element.object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object object) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element e = bucket.replaceByKey(key, object);
            if (e == null) {
                FastHashtable fastHashtable = this;
                synchronized (fastHashtable) {
                    ++this.size;
                }
            }
            return e != null ? e.object : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, Object object) {
        Bucket bucket;
        FastHashtable fastHashtable = this;
        synchronized (fastHashtable) {
            ++this.size;
        }
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            bucket.addByKey(key, object);
        }
    }

    public final Enumeration elements() {
        return new ObjectEnumerator();
    }

    public final Enumeration keys() {
        return new KeyEnumerator();
    }

    public synchronized void clear() {
        this.size = 0;
        this.buckets = new Bucket[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    protected final Bucket getBucketForKey(Object key) {
        return this.buckets[(key.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    class KeyEnumerator
    extends ElementEnumerator {
        KeyEnumerator() {
        }

        @Override
        public Object nextElement() {
            return ((Element)super.nextElement()).key;
        }
    }

    class ObjectEnumerator
    extends ElementEnumerator {
        ObjectEnumerator() {
        }

        @Override
        public Object nextElement() {
            return ((Element)super.nextElement()).object;
        }
    }

    class ElementEnumerator
    implements Enumeration {
        private int bucketIndex = 0;
        private Enumeration bucketContents;

        ElementEnumerator() {
        }

        @Override
        public boolean hasMoreElements() {
            if (this.bucketContents != null && this.bucketContents.hasMoreElements()) {
                return true;
            }
            return this.findNextBucket();
        }

        public Object nextElement() {
            if (!(this.bucketContents != null && this.bucketContents.hasMoreElements() || this.findNextBucket())) {
                throw new NoSuchElementException();
            }
            while (true) {
                try {
                    return this.bucketContents.nextElement();
                }
                catch (NoSuchElementException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.FastHashtable.nextElement", (String)"267", (Object)this);
                    if (this.findNextBucket()) continue;
                    throw new NoSuchElementException();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findNextBucket() {
            this.bucketContents = null;
            while (this.bucketIndex < FastHashtable.this.buckets.length) {
                Bucket bucket;
                Bucket bucket2 = bucket = FastHashtable.this.buckets[this.bucketIndex++];
                synchronized (bucket2) {
                    if (bucket.size() > 0) {
                        this.bucketContents = bucket.elements();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

