/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.krb5;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Krb5Helper {
    private static final TraceComponent tc;
    public static final String KEY_KERBEROS_EXT_SERVICE = "KerberosExtService";
    public static final String USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    public static final String KRB5_KTNAME = "KRB5_KTNAME";
    public static final String KRB5_PRINCIPAL = "com.ibm.security.krb5.principal";
    private static Oid KRB5_MECH_OID;
    private static Oid SPNEGO_MECH_OID;
    static final long serialVersionUID = 8864395532086887429L;

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromSubjectCommon(final String spn, final Subject subject, final int lifetime, final boolean delegate) throws GSSException, PrivilegedActionException {
        String token = null;
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 2436872518947490525L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws GSSException, PrivilegedActionException {
                    GSSCredential gssCred = Krb5Helper.getGSSCred(subject, null, SPNEGO_MECH_OID, 1, lifetime, lifetime);
                    return Krb5Helper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.token.krb5.Krb5Helper", (String)"71", null, (Object[])new Object[]{spn, subject, lifetime, delegate});
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    public static String buildSpnegoAuthorization(GSSCredential gssCred, String targetSpn, int lifetime, boolean delegate) throws GSSException {
        GSSContext context = Krb5Helper.createSpnegoGSSContext(gssCred, targetSpn, lifetime, delegate);
        byte[] response = null;
        int len = 0;
        byte[] request = context.initSecContext(response, 0, len);
        String token = "Negotiate " + Base64Coder.encode((byte[])request);
        context.dispose();
        return token;
    }

    public static GSSContext createSpnegoGSSContext(GSSCredential gssCred, String targetSpn, int lifetime, boolean delegate) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName backEnd = manager.createName(targetSpn, GSSName.NT_USER_NAME);
        backEnd = backEnd.canonicalize(SPNEGO_MECH_OID);
        GSSContext context = manager.createContext(backEnd, SPNEGO_MECH_OID, gssCred, lifetime);
        context.requestMutualAuth(false);
        context.requestCredDeleg(delegate);
        return context;
    }

    public static GSSCredential getGSSCred(Subject subject, String user, Oid mechOid, int usage, int initLifetime, int acceptLifetime) throws GSSException {
        GSSCredential gssCred = null;
        gssCred = subject != null ? SubjectHelper.getGSSCredentialFromSubject((Subject)subject) : Krb5Helper.createKrbMechGSSCred(user);
        Krb5Helper.addSpnegoMechGSSCred(gssCred, mechOid, usage, initLifetime, acceptLifetime);
        return gssCred;
    }

    public static void addSpnegoMechGSSCred(GSSCredential gssCred, Oid mechOid, int usage, int initLifetime, int acceptLifetime) throws GSSException {
        if (gssCred != null) {
            Oid[] mechs = gssCred.getMechs();
            if (mechOid != null && !mechOid.containedIn(mechs)) {
                GSSName gssName = gssCred.getName();
                gssCred.add(gssName, initLifetime, acceptLifetime, mechOid, usage);
            }
        } else {
            throw new GSSException(13);
        }
    }

    private static GSSCredential createKrbMechGSSCred(String user) throws GSSException {
        GSSName gssName = null;
        GSSManager manager = GSSManager.getInstance();
        if (user != null) {
            gssName = manager.createName(user, GSSName.NT_USER_NAME, KRB5_MECH_OID);
        }
        GSSCredential gssCred = manager.createCredential(gssName, Integer.MAX_VALUE, KRB5_MECH_OID, 1);
        return gssCred;
    }

    public static String setPropertyAsNeeded(final String propName, final String propValue) {
        String savedPropValue = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = -1691999775443660420L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String run() {
                String oldValue = System.getProperty(propName);
                if (oldValue == null || !oldValue.equalsIgnoreCase(propValue)) {
                    System.setProperty(propName, propValue);
                }
                return oldValue;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("javax.security.auth.useSubjectCredsOnly property previous: " + (savedPropValue != null ? savedPropValue : "<null>") + " and now: " + propValue), (Object[])new Object[0]);
        }
        return savedPropValue;
    }

    public static void serviceNotAvailableException() throws GSSException {
        Tr.error((TraceComponent)tc, (String)"KRB_OSGI_SERVICE_ERROR", (Object[])new Object[0]);
        String msg = TraceNLS.getFormattedMessage(Krb5Helper.class, (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"KRB_OSGI_SERVICE_ERROR", (Object[])new Object[]{KEY_KERBEROS_EXT_SERVICE}, (String)"CWWKS4003E: The constrained delegation OSGi service {0} is not available.");
        throw new GSSException(16, 16, msg);
    }

    public static void checkSupportJDKVendor(boolean ibmJDKVendor) throws GSSException {
        if (!ibmJDKVendor) {
            Tr.error((TraceComponent)tc, (String)"KRB_S4U2PROXY_NOT_SUPPORTED", (Object[])new Object[0]);
            String msg = TraceNLS.getFormattedMessage(Krb5Helper.class, (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"KRB_S4U2PROXY_NOT_SUPPORTED", null, (String)"CWWKS4002E: The constrained delegation (S4U2self and S4U2proxy) API requires a minimum Java runtime environment version of JavaSE 1.8.");
            throw new GSSException(16, 16, msg);
        }
    }

    public static void checkPassword(@Sensitive String password) throws GSSException {
        if (password == null || "".equals(password)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty password supplied", (Object[])new Object[0]);
            }
            throw new GSSException(13);
        }
    }

    public static Throwable getGeneralCause(PrivilegedActionException pae) {
        Throwable cause;
        Throwable retVal = pae;
        if (pae != null && (cause = pae.getCause()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deciphering a PrivilegedActionException [" + cause.getClass().getName() + "]"), (Object[])new Object[0]);
            }
            while (cause != null && cause instanceof PrivilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unravelling", (Object[])new Object[0]);
                }
                cause = cause.getCause();
            }
            if (cause != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unravelled to a " + cause.getClass().getName()), (Object[])new Object[0]);
                }
                retVal = cause;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Only PrivilegedActionException in stack.  Returning original exception.", (Object[])new Object[0]);
            }
        }
        return retVal;
    }

    public static void restorePropertyAsNeeded(final String propName, final String oldPropValue, final String newPropValue) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = 6140327416113766362L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                if (oldPropValue == null) {
                    System.clearProperty(propName);
                } else if (!oldPropValue.equalsIgnoreCase(newPropValue)) {
                    System.setProperty(propName, oldPropValue);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }

    public static void checkSpn(String spn) throws GSSException {
        if (spn == null || "".equals(spn) || !spn.contains("/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty or invalid format servicePrincipalName supplied", (Object[])new Object[0]);
            }
            throw new GSSException(3);
        }
    }

    public static void checkUpn(String upn) throws GSSException {
        if (upn == null || "".equals(upn)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty UserPrincipalName supplied", (Object[])new Object[0]);
            }
            throw new GSSException(3);
        }
    }

    public static boolean isIBMJDK() {
        return JavaInfo.vendor() == JavaInfo.Vendor.IBM;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        block2: {
            tc = Tr.register(Krb5Helper.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
            try {
                KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
                SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
            }
            catch (GSSException gSSException) {
                void ex;
                FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.token.krb5.Krb5Helper", (String)"342", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Unexpected GSSExecption: " + ex), (Object[])new Object[0]);
            }
        }
    }
}

