/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.liberty;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIRuntimeException;
import com.ibm.ws.cdi.interfaces.Application;
import com.ibm.ws.cdi.interfaces.ApplicationType;
import com.ibm.ws.cdi.interfaces.ArchiveType;
import com.ibm.ws.cdi.interfaces.CDIArchive;
import com.ibm.ws.cdi.liberty.ContainerInfoTypeUtils;
import com.ibm.ws.cdi.liberty.RuntimeFactory;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationImpl
implements Application {
    private static final TraceComponent tc = Tr.register(ApplicationImpl.class);
    private final ExtendedApplicationInfo applicationInfo;
    private final EARApplicationInfo earApplicationInfo;
    private final RuntimeFactory factory;
    private final ApplicationType type;
    private final Collection<CDIArchive> moduleArchives;
    private final Collection<CDIArchive> libraryArchives;
    static final long serialVersionUID = -8844969759824053269L;

    public ApplicationImpl(ApplicationInfo applicationInfo, RuntimeFactory factory) throws CDIException {
        this.applicationInfo = (ExtendedApplicationInfo)applicationInfo;
        this.factory = factory;
        if (applicationInfo instanceof EARApplicationInfo) {
            this.type = ApplicationType.EAR;
            this.earApplicationInfo = (EARApplicationInfo)applicationInfo;
        } else {
            this.type = ApplicationType.WAR;
            this.earApplicationInfo = null;
        }
        this.moduleArchives = this.initModuleArchives();
        this.libraryArchives = this.initLibraryArchives();
    }

    /*
     * WARNING - void declaration
     */
    private <T> T getFromCache(Class<T> clazz) throws CDIException {
        Object data = null;
        try {
            NonPersistentCache cache = (NonPersistentCache)this.applicationInfo.getContainer().adapt(NonPersistentCache.class);
            data = cache.getFromCache(clazz);
        }
        catch (UnableToAdaptException cache) {
            void e;
            FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.cdi.liberty.ApplicationImpl", (String)"84", (Object)this, (Object[])new Object[]{clazz});
            throw new CDIException((Throwable)e);
        }
        return (T)data;
    }

    private ApplicationClassesContainerInfo getApplicationClassesContainerInfo() throws CDIException {
        ApplicationClassesContainerInfo applicationClassesContainerInfo = this.getFromCache(ApplicationClassesContainerInfo.class);
        return applicationClassesContainerInfo;
    }

    @Override
    public J2EEName getJ2EEName() {
        return this.applicationInfo.getMetaData().getJ2EEName();
    }

    @Override
    public ApplicationMetaData getApplicationMetaData() {
        return this.applicationInfo.getMetaData();
    }

    @Override
    public boolean hasModules() throws CDIException {
        return this.getApplicationClassesContainerInfo() != null;
    }

    private ClassLoader getApplicationClassLoader() throws CDIException {
        ClassLoader classLoader;
        if (this.type == ApplicationType.EAR) {
            classLoader = this.earApplicationInfo.getApplicationClassLoader();
        } else {
            Collection<CDIArchive> modules = this.getModuleArchives();
            if (modules.size() == 1) {
                CDIArchive firstModule = modules.iterator().next();
                classLoader = firstModule.getClassLoader();
            } else {
                throw new CDIRuntimeException("There was more than one module in an application of type: " + (Object)((Object)this.type));
            }
        }
        return classLoader;
    }

    @Override
    public Collection<CDIArchive> getLibraryArchives() {
        return this.libraryArchives;
    }

    private Collection<CDIArchive> initLibraryArchives() throws CDIException {
        HashMap<ContainerInfo, CDIArchive> libraryArchives = new HashMap<ContainerInfo, CDIArchive>();
        ApplicationClassesContainerInfo appClassesCntrInfo = this.getApplicationClassesContainerInfo();
        if (appClassesCntrInfo != null) {
            List original = appClassesCntrInfo.getLibraryClassesContainerInfo();
            for (ContainerInfo containerInfo : original) {
                ContainerInfo.Type ciType = containerInfo.getType();
                if (ciType == ContainerInfo.Type.EAR_LIB) {
                    CDIArchive archive = (CDIArchive)libraryArchives.get(containerInfo);
                    if (archive != null) continue;
                    ArchiveType type = ArchiveType.EAR_LIB;
                    ClassLoader classLoader = this.getApplicationClassLoader();
                    archive = this.factory.newArchive(this, containerInfo, type, classLoader);
                    libraryArchives.put(containerInfo, archive);
                    continue;
                }
                if (ciType != ContainerInfo.Type.SHARED_LIB) continue;
                LibraryClassesContainerInfo libraryClassesContainerInfo = (LibraryClassesContainerInfo)containerInfo;
                LibraryContainerInfo.LibraryType libType = libraryClassesContainerInfo.getLibraryType();
                ArchiveType type = null;
                ClassLoader classLoader = null;
                if (libType == LibraryContainerInfo.LibraryType.PRIVATE_LIB) {
                    type = ArchiveType.EAR_LIB;
                    classLoader = this.getApplicationClassLoader();
                } else {
                    type = ArchiveType.SHARED_LIB;
                    classLoader = libraryClassesContainerInfo.getClassLoader();
                }
                List classesContainerInfos = libraryClassesContainerInfo.getClassesContainerInfo();
                for (ContainerInfo ci : classesContainerInfos) {
                    CDIArchive archive = (CDIArchive)libraryArchives.get(ci);
                    if (archive != null) continue;
                    archive = this.factory.newArchive(this, ci, type, classLoader);
                    libraryArchives.put(ci, archive);
                }
            }
        }
        return libraryArchives.values();
    }

    @Override
    public Collection<CDIArchive> getModuleArchives() {
        return this.moduleArchives;
    }

    private Collection<CDIArchive> initModuleArchives() throws CDIException {
        HashMap<ModuleContainerInfo, CDIArchive> moduleArchives = new HashMap<ModuleContainerInfo, CDIArchive>();
        ApplicationClassesContainerInfo appClassesCntrInfo = this.getApplicationClassesContainerInfo();
        if (appClassesCntrInfo != null) {
            List moduleClassesContainerInfos = appClassesCntrInfo.getModuleClassesContainerInfo();
            for (ModuleClassesContainerInfo ci : moduleClassesContainerInfos) {
                ModuleContainerInfo rootContainerInfo = (ModuleContainerInfo)ci;
                ArchiveType type = ContainerInfoTypeUtils.getType(rootContainerInfo.getType());
                ClassLoader classLoader = rootContainerInfo.getClassLoader();
                CDIArchive archive = this.factory.newArchive(this, (ContainerInfo)rootContainerInfo, type, classLoader);
                moduleArchives.put(rootContainerInfo, archive);
            }
        }
        return moduleArchives.values();
    }

    @Override
    public ClassLoader getClassLoader() throws CDIException {
        return this.getApplicationClassLoader();
    }

    @Override
    public ApplicationType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.applicationInfo.getName();
    }

    public String toString() {
        return "ApplicationImpl: " + this.applicationInfo.getName();
    }
}

