/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceLoaderImpl
implements ResourceLoader {
    private static final TraceComponent tc = Tr.register(ResourceLoaderImpl.class);
    private final ClassLoader delegate;
    static final long serialVersionUID = -7296640400698987676L;

    public ResourceLoaderImpl(ClassLoader classloader) {
        this.delegate = classloader;
    }

    public void cleanup() {
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public Class<?> classForName(String className) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Loading class " + className + " using classloader " + this.delegate), (Object[])new Object[0]);
        }
        try {
            return this.delegate.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.loadFromWeldBundleCL(className);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> loadFromWeldBundleCL(String className) {
        ClassLoader bundleCL = BeanManagerImpl.class.getClassLoader();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unable to load class " + className + " using classloader " + this.delegate + " Try to use the weld bundle classloader " + bundleCL), (Object[])new Object[0]);
        }
        try {
            return bundleCL.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e1;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.cdi.impl.weld.ResourceLoaderImpl", (String)"88", (Object)this, (Object[])new Object[]{className});
            throw new ResourceLoadingException(Tr.formatMessage((TraceComponent)tc, (String)"error.loading.class.CWOWB1003E", (Object[])new Object[]{className, bundleCL}), (Throwable)e1);
        }
    }

    public URL getResource(String resName) {
        return this.delegate.getResource(resName);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<URL> getResources(String resName) {
        try {
            return new EnumerationList(this.delegate.getResources(resName));
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.cdi.impl.weld.ResourceLoaderImpl", (String)"119", (Object)this, (Object[])new Object[]{resName});
            throw new ResourceLoadingException(Tr.formatMessage((TraceComponent)tc, (String)"error.loading.resource.CWOWB1005E", (Object[])new Object[]{resName}), (Throwable)e);
        }
    }
}

