/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.inject;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.inject.InjectInjectionObjectFactory;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.interfaces.CDIUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionSimpleBinding;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Inject;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InjectInjectionBinding
extends InjectionSimpleBinding<Inject> {
    private static final TraceComponent tc = Tr.register(InjectInjectionBinding.class);
    private final CDIRuntime cdiRuntime;
    private CreationalContext<Object> methodInvocationContext;
    static final long serialVersionUID = -747315935996349744L;

    public InjectInjectionBinding(Inject annotation, ComponentNameSpaceConfiguration nameSpaceConfig, CDIRuntime cdiRuntime) {
        super((Annotation)annotation, nameSpaceConfig);
        this.cdiRuntime = cdiRuntime;
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2eeName;
    }

    public boolean isResolved() {
        return true;
    }

    @ManualTrace
    public Object getInjectionObjectInstance(Object targetObject, InjectionTargetContext targetContext) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object[])new Object[0]);
        }
        WeldCreationalContext cc = null;
        if (targetContext == null) {
            if (!(targetObject instanceof Class)) {
                throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"no.injection.target.context.CWOWB1006E", (Object[])new Object[]{targetObject}));
            }
        } else {
            cc = (WeldCreationalContext)targetContext.getInjectionTargetContextData(WeldCreationalContext.class);
        }
        WeldManager beanManager = (WeldManager)this.cdiRuntime.getCurrentBeanManager();
        if (cc == null && beanManager != null) {
            cc = beanManager.createCreationalContext(null);
        }
        if (beanManager != null) {
            this.methodInvocationContext = beanManager.createCreationalContext(null);
        }
        Object retObj = InjectInjectionObjectFactory.getObjectInstance(this, targetObject, (CreationalContext<Object>)cc, this.methodInvocationContext, this.cdiRuntime);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionObjectInstance : " + Util.identity((Object)retObj)));
        }
        return retObj;
    }

    public void setInjectionClassType(Method method) throws InjectionException {
        if (method.getParameterTypes().length == 1) {
            super.setInjectionClassType(method);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializer method multi parameter Injection. InjectionClassType will be null.", (Object[])new Object[0]);
        }
    }

    public void cleanAfterMethodInvocation() {
        if (this.methodInvocationContext != null) {
            this.methodInvocationContext.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getInjectionObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        try {
            return super.getInjectionObject(targetObject, targetContext);
        }
        catch (InjectionException injectionException) {
            FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.cdi.impl.inject.InjectInjectionBinding", (String)"136", (Object)((Object)this), (Object[])new Object[]{targetObject, targetContext});
            if (!CDIUtils.isInjectionFailureIgnored()) {
                void e;
                throw e;
            }
            return null;
        }
    }
}

