/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.cdi.impl.DiscoveredBdas;
import com.ibm.ws.cdi.impl.weld.BDAFactory;
import com.ibm.ws.cdi.impl.weld.ProbeExtensionArchive;
import com.ibm.ws.cdi.impl.weld.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.impl.weld.WebSphereCDIDeployment;
import com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl;
import com.ibm.ws.cdi.interfaces.Application;
import com.ibm.ws.cdi.interfaces.ArchiveType;
import com.ibm.ws.cdi.interfaces.CDIArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.interfaces.CDIUtils;
import com.ibm.ws.cdi.interfaces.ExtensionArchive;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CDIContainerImpl
implements InjectionMetaDataListener {
    private static final TraceComponent tc = Tr.register(CDIContainerImpl.class);
    private static final ClassLoader CLASSLOADER = CDIContainerImpl.class.getClassLoader();
    private static final String EXTENSION_API_CLASSES = "api.classes";
    private static final String EXTENSION_BEAN_DEFINING_ANNOTATIONS = "bean.defining.annotations";
    private static final String EXTENSION_APP_BDAS_VISIBLE = "application.bdas.visible";
    private static final String EXTENSION_CLASSES_ONLY_MODE = "extension.classes.only";
    private static final String EXTENSION_API_CLASSES_SEPARATOR = ";";
    private Set<ExtensionArchive> runtimeExtensionSet = null;
    private final ThreadLocal<WebSphereCDIDeployment> currentDeployment = new ThreadLocal();
    private final CDIRuntime cdiRuntime;
    private static final String WELD_DISABLE_BEANSXML_VALIDATING = ConfigurationKey.DISABLE_XML_VALIDATION.get();
    static final long serialVersionUID = 1094339221485733952L;

    public CDIContainerImpl(CDIRuntime cdiRuntime) {
        this.cdiRuntime = cdiRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarting(Application application) throws CDIException {
        try {
            WebSphereCDIDeployment webSphereCDIDeployment = this.createWebSphereCDIDeployment(application, this.getExtensionArchives());
            this.currentDeployment.set(webSphereCDIDeployment);
            webSphereCDIDeployment.scan();
            this.setDeployment(application, webSphereCDIDeployment);
            if (webSphereCDIDeployment.isCDIEnabled()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"applicationStarting", (Object[])new Object[]{"CDI is enabled, starting the CDI Deployment"});
                }
                webSphereCDIDeployment.initializeInjectionServices();
                String contextID = webSphereCDIDeployment.getDeploymentID();
                final WeldBootstrap weldBootstrap = webSphereCDIDeployment.getBootstrap();
                weldBootstrap.startExtensions(webSphereCDIDeployment.getExtensions());
                weldBootstrap.startContainer(contextID, (Environment)Environments.EE_INJECT, (Deployment)webSphereCDIDeployment);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 8684619648770394180L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        weldBootstrap.startInitialization();
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
                webSphereCDIDeployment.validateJEEComponentClasses();
                weldBootstrap.deployBeans();
                weldBootstrap.validateBeans();
                weldBootstrap.endInitialization();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"applicationStarting", (Object[])new Object[]{"CDI is not enabled, shutting down CDI"});
                }
                webSphereCDIDeployment.shutdown();
                this.unsetDeployment(application);
            }
        }
        finally {
            this.currentDeployment.set(null);
        }
    }

    public void applicationStopped(Application application) throws CDIException {
        WebSphereCDIDeployment deployment = this.getDeployment(application);
        if (deployment != null) {
            try {
                deployment.shutdown();
            }
            finally {
                this.unsetDeployment(application);
            }
        }
    }

    private WebSphereCDIDeployment createWebSphereCDIDeployment(Application application, Set<ExtensionArchive> extensionArchives) throws CDIException {
        WebSphereCDIDeploymentImpl webSphereCDIDeployment = new WebSphereCDIDeploymentImpl(application, this.cdiRuntime);
        DiscoveredBdas discoveredBdas = new DiscoveredBdas(webSphereCDIDeployment);
        if (application.hasModules()) {
            Collection<CDIArchive> libraryArchives = application.getLibraryArchives();
            Collection<CDIArchive> moduleArchives = application.getModuleArchives();
            ClassLoader applicationClassLoader = application.getClassLoader();
            webSphereCDIDeployment.setClassLoader(applicationClassLoader);
            this.processLibraries(webSphereCDIDeployment, discoveredBdas, libraryArchives);
            this.processModules(webSphereCDIDeployment, discoveredBdas, moduleArchives);
            discoveredBdas.makeCrossBoundaryWiring();
            this.addRuntimeExtensions(webSphereCDIDeployment, discoveredBdas);
        }
        return webSphereCDIDeployment;
    }

    private void addRuntimeExtensions(WebSphereCDIDeployment webSphereCDIDeployment, DiscoveredBdas discoveredBdas) throws CDIException {
        Set<WebSphereBeanDeploymentArchive> extensions = this.createExtensionBDAs(webSphereCDIDeployment);
        webSphereCDIDeployment.addBeanDeploymentArchives(extensions);
        for (WebSphereBeanDeploymentArchive bda : webSphereCDIDeployment.getApplicationBDAs()) {
            for (WebSphereBeanDeploymentArchive extBDA : extensions) {
                if (bda == extBDA) continue;
                bda.addBeanDeploymentArchive(extBDA);
                if (!extBDA.extensionCanSeeApplicationBDAs() || discoveredBdas.isExcluded(bda)) continue;
                extBDA.addBeanDeploymentArchive(bda);
            }
        }
    }

    private Set<WebSphereBeanDeploymentArchive> createExtensionBDAs(WebSphereCDIDeployment applicationContext) throws CDIException {
        HashSet<WebSphereBeanDeploymentArchive> extensionBdas = new HashSet<WebSphereBeanDeploymentArchive>();
        Set<ExtensionArchive> extensions = this.getExtensionArchives();
        if (extensions != null) {
            for (ExtensionArchive extArchive : extensions) {
                WebSphereBeanDeploymentArchive moduleCDIContext = BDAFactory.createBDA(applicationContext, extArchive, this.cdiRuntime);
                extensionBdas.add(moduleCDIContext);
            }
        }
        return extensionBdas;
    }

    private void processLibraries(WebSphereCDIDeployment applicationContext, DiscoveredBdas discoveredBdas, Collection<CDIArchive> archives) throws CDIException {
        for (CDIArchive archive : archives) {
            String archiveID = applicationContext.getDeploymentID() + "#" + archive.getName();
            if (this.cdiRuntime.skipCreatingBda(archive)) continue;
            WebSphereBeanDeploymentArchive moduleCDIContext = BDAFactory.createBDA(applicationContext, archiveID, archive, this.cdiRuntime);
            discoveredBdas.addDiscoveredBda(archive.getType(), moduleCDIContext);
        }
    }

    private void processModules(WebSphereCDIDeployment applicationContext, DiscoveredBdas discoveredBdas, Collection<CDIArchive> moduleArchives) throws CDIException {
        ArrayList<WebSphereBeanDeploymentArchive> moduleBDAs = new ArrayList<WebSphereBeanDeploymentArchive>();
        for (CDIArchive archive : moduleArchives) {
            if (!this.cdiRuntime.isClientProcess() ? ArchiveType.CLIENT_MODULE == archive.getType() : ArchiveType.CLIENT_MODULE != archive.getType()) continue;
            if (applicationContext.getClassLoader() == null) {
                applicationContext.setClassLoader(archive.getClassLoader());
            }
            String archiveID = archive.getJ2EEName().toString();
            if (this.cdiRuntime.skipCreatingBda(archive)) continue;
            WebSphereBeanDeploymentArchive moduleBda = BDAFactory.createBDA(applicationContext, archiveID, archive, this.cdiRuntime);
            discoveredBdas.addDiscoveredBda(archive.getType(), moduleBda);
            moduleBDAs.add(moduleBda);
        }
        for (WebSphereBeanDeploymentArchive bda : moduleBDAs) {
            this.processModuleLibraries(bda, discoveredBdas);
        }
    }

    private Set<WebSphereBeanDeploymentArchive> processModuleLibraries(WebSphereBeanDeploymentArchive parentModule, DiscoveredBdas discoveredBdas) throws CDIException {
        CDIArchive archive = parentModule.getArchive();
        HashSet<WebSphereBeanDeploymentArchive> childBdas = new HashSet<WebSphereBeanDeploymentArchive>();
        HashSet<String> moduleArchivePaths = new HashSet<String>();
        moduleArchivePaths.add(archive.getPath());
        Collection<CDIArchive> childArchives = archive.getModuleLibraryArchives();
        ArchiveType parentType = archive.getType();
        for (CDIArchive child : childArchives) {
            ArchiveType childType = child.getType();
            String archiveID = null;
            String eeModuleDescriptorID = null;
            if (childType != ArchiveType.WEB_INF_LIB && childType != ArchiveType.MANIFEST_CLASSPATH && childType != ArchiveType.JAR_MODULE && childType != ArchiveType.SHARED_LIB) continue;
            archiveID = parentModule.getId() + "#" + (Object)((Object)childType) + "#" + child.getName();
            eeModuleDescriptorID = parentModule.getEEModuleDescriptorId();
            String childPath = child.getPath();
            if (discoveredBdas.isAlreadyAccessible(parentType, child) || moduleArchivePaths.contains(childPath) || this.cdiRuntime.skipCreatingBda(child)) continue;
            WebSphereBeanDeploymentArchive newChildBda = BDAFactory.createBDA(parentModule.getCDIDeployment(), archiveID, child, this.cdiRuntime, eeModuleDescriptorID);
            discoveredBdas.addDiscoveredBda(parentType, newChildBda);
            moduleArchivePaths.add(childPath);
            parentModule.addDescendantBda(newChildBda);
            CDIUtils.addWiring(parentModule, newChildBda);
            for (WebSphereBeanDeploymentArchive childBda : childBdas) {
                CDIUtils.addWiring(childBda, newChildBda);
            }
            childBdas.add(newChildBda);
        }
        return childBdas;
    }

    public BeanManager getCurrentBeanManager() {
        WebSphereCDIDeployment cdiDeployment = this.getCurrentDeployment();
        BeanManager beanManager = this.getCurrentBeanManagerViaStackWalk(cdiDeployment);
        if (beanManager == null) {
            beanManager = this.getCurrentModuleBeanManager();
        }
        return beanManager;
    }

    private BeanManager getCurrentBeanManagerViaStackWalk(WebSphereCDIDeployment deployment) {
        BeanManager beanManager = null;
        if (deployment != null) {
            Class<?>[] stackClasses = AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){
                static final long serialVersionUID = -6796974672750259085L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Class<?>[] run() {
                    return new SecurityManager(){
                        static final long serialVersionUID = 253187946685623892L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        protected Class<?>[] getClassContext() {
                            return super.getClassContext();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    }.getClassContext();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
            for (int i = 0; i < stackClasses.length; ++i) {
                WebSphereBeanDeploymentArchive currentBda;
                final Class<?> cls = stackClasses[i];
                ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                    static final long serialVersionUID = -1318827828849186373L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ClassLoader run() {
                        return cls.getClassLoader();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(4.class);
                    }
                });
                if (CLASSLOADER.equals(classLoader) || (currentBda = deployment.getBeanDeploymentArchiveFromClass(cls)) == null) continue;
                beanManager = currentBda.getBeanManager();
                break;
            }
        }
        return beanManager;
    }

    public BeanManager getClassBeanManager(Class<?> clazz) {
        WebSphereBeanDeploymentArchive currentBda = this.getClassBeanDeploymentArchive(clazz);
        BeanManager beanManager = null;
        if (currentBda != null) {
            beanManager = currentBda.getBeanManager();
        }
        return beanManager;
    }

    public WebSphereBeanDeploymentArchive getClassBeanDeploymentArchive(Class<?> clazz) {
        WebSphereCDIDeployment deployment = this.getCurrentDeployment();
        WebSphereBeanDeploymentArchive currentBda = null;
        if (deployment != null) {
            currentBda = deployment.getBeanDeploymentArchiveFromClass(clazz);
        }
        return currentBda;
    }

    public String getCurrentApplicationContextID() {
        WebSphereCDIDeployment cdiDeployment = this.getCurrentDeployment();
        if (cdiDeployment == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getCurrentApplicationContextID returning null.  cdiDeployment is null", (Object[])new Object[0]);
            }
            return null;
        }
        String contextID = cdiDeployment.getDeploymentID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCurrentApplicationContextID successfully found a application context ID of: " + contextID), (Object[])new Object[0]);
        }
        return contextID;
    }

    private synchronized Set<ExtensionArchive> getExtensionArchives() throws CDIException {
        if (this.runtimeExtensionSet == null) {
            this.runtimeExtensionSet = new HashSet<ExtensionArchive>();
            Iterator<ServiceAndServiceReferencePair<WebSphereCDIExtension>> extensions = this.cdiRuntime.getExtensionServices();
            while (extensions.hasNext()) {
                String[] annotations;
                String[] classes;
                ServiceAndServiceReferencePair<WebSphereCDIExtension> extension = extensions.next();
                ServiceReference sr = extension.getServiceReference();
                Bundle bundle = null;
                if (sr == null) continue;
                bundle = sr.getBundle();
                String extra_classes_blob = (String)sr.getProperty(EXTENSION_API_CLASSES);
                HashSet<String> extra_classes = new HashSet<String>();
                if (extra_classes_blob != null && (classes = extra_classes_blob.split(EXTENSION_API_CLASSES_SEPARATOR)) != null && classes.length > 0) {
                    Collections.addAll(extra_classes, classes);
                }
                String extraAnnotationsBlob = (String)sr.getProperty(EXTENSION_BEAN_DEFINING_ANNOTATIONS);
                HashSet<String> extraAnnotations = new HashSet<String>();
                if (extraAnnotationsBlob != null && (annotations = extraAnnotationsBlob.split(EXTENSION_API_CLASSES_SEPARATOR)) != null && annotations.length > 0) {
                    Collections.addAll(extraAnnotations, annotations);
                }
                String applicationBDAsVisibleStr = (String)sr.getProperty(EXTENSION_APP_BDAS_VISIBLE);
                boolean applicationBDAsVisible = Boolean.parseBoolean(applicationBDAsVisibleStr);
                String extClassesOnlyStr = (String)sr.getProperty(EXTENSION_CLASSES_ONLY_MODE);
                boolean extClassesOnly = Boolean.parseBoolean(extClassesOnlyStr);
                ExtensionArchive extensionArchive = this.cdiRuntime.getExtensionArchiveForBundle(bundle, extra_classes, extraAnnotations, applicationBDAsVisible, extClassesOnly);
                this.runtimeExtensionSet.add(extensionArchive);
            }
            if (CDIUtils.isDevelopementMode()) {
                this.runtimeExtensionSet.add(new ProbeExtensionArchive(this.cdiRuntime, null));
            }
        }
        return this.runtimeExtensionSet;
    }

    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        ReferenceContext referenceContext = injectionMetaData.getReferenceContext();
        if (referenceContext != null) {
            ApplicationMetaData appMetaData = injectionMetaData.getComponentNameSpaceConfiguration().getApplicationMetaData();
            WebSphereCDIDeployment deployment = this.getDeployment(appMetaData);
            if (deployment != null) {
                deployment.addReferenceContext(referenceContext);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"injectionMetaDataCreated()", (Object[])new Object[]{"Could not find a CDI Deployment for ReferenceContext " + injectionMetaData.getJ2EEName()});
            }
        }
    }

    public WebSphereCDIDeployment getDeployment(ApplicationMetaData applicationMetaData) {
        WebSphereCDIDeployment deployment = null;
        if (applicationMetaData != null) {
            deployment = (WebSphereCDIDeployment)applicationMetaData.getMetaData(this.cdiRuntime.getApplicationSlot());
        }
        return deployment;
    }

    public WebSphereCDIDeployment getDeployment(Application application) {
        WebSphereCDIDeployment deployment = this.getDeployment(application.getApplicationMetaData());
        return deployment;
    }

    public boolean isApplicationCDIEnabled(ApplicationMetaData applicationMetaData) {
        WebSphereCDIDeployment deployment = this.getDeployment(applicationMetaData);
        boolean enabled = false;
        if (deployment != null) {
            enabled = deployment.isCDIEnabled();
        }
        return enabled;
    }

    public boolean isCurrentApplicationCDIEnabled() {
        WebSphereCDIDeployment deployment = this.getCurrentDeployment();
        boolean enabled = false;
        if (deployment != null) {
            enabled = deployment.isCDIEnabled();
        }
        return enabled;
    }

    public boolean isModuleCDIEnabled(ModuleMetaData moduleMetaData) {
        WebSphereCDIDeployment deployment = this.getDeployment(moduleMetaData);
        boolean enabled = false;
        if (deployment != null) {
            String bdaId = moduleMetaData.getJ2EEName().toString();
            enabled = deployment.isCDIEnabled(bdaId);
        }
        return enabled;
    }

    public boolean isCurrentModuleCDIEnabled() {
        ModuleMetaData moduleMetaData = this.getCurrentModuleMetaData();
        boolean enabled = this.isModuleCDIEnabled(moduleMetaData);
        return enabled;
    }

    public ModuleMetaData getCurrentModuleMetaData() {
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        ModuleMetaData moduleMetaData = null;
        if (cmd != null) {
            moduleMetaData = cmd.getModuleMetaData();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCurrentModuleMetaData  ComponentMetaData is null", (Object[])new Object[0]);
        }
        return moduleMetaData;
    }

    public void setDeployment(Application application, WebSphereCDIDeployment webSphereCDIDeployment) throws CDIException {
        ApplicationMetaData applicationMetaData = application.getApplicationMetaData();
        applicationMetaData.setMetaData(this.cdiRuntime.getApplicationSlot(), (Object)webSphereCDIDeployment);
    }

    public void unsetDeployment(Application application) throws CDIException {
        this.setDeployment(application, null);
    }

    public void setDeployment(ApplicationMetaData applicationMetaData, WebSphereCDIDeployment webSphereCDIDeployment) throws CDIException {
        applicationMetaData.setMetaData(this.cdiRuntime.getApplicationSlot(), (Object)webSphereCDIDeployment);
    }

    public void unsetDeployment(ApplicationMetaData applicationMetaData) throws CDIException {
        this.setDeployment(applicationMetaData, null);
    }

    public WebSphereCDIDeployment getCurrentDeployment() {
        WebSphereCDIDeployment cdiDeployment = this.currentDeployment.get();
        if (cdiDeployment == null) {
            ApplicationMetaData amd;
            ModuleMetaData moduleMetaData = this.getCurrentModuleMetaData();
            ApplicationMetaData applicationMetaData = amd = moduleMetaData == null ? null : moduleMetaData.getApplicationMetaData();
            if (amd != null) {
                cdiDeployment = this.getDeployment(amd);
            }
        }
        return cdiDeployment;
    }

    public BeanManager getBeanManager(ModuleMetaData moduleMetaData) {
        BeanManager beanManager = null;
        if (moduleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getModuleBeanManager returning null.  ModuleMetaData is null", (Object[])new Object[0]);
            }
            beanManager = null;
        } else {
            WebSphereBeanDeploymentArchive bda = this.getBeanDeploymentArchive(moduleMetaData);
            if (bda == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getModuleBeanManager returning null.  bda is null", (Object[])new Object[0]);
                }
                return null;
            }
            beanManager = bda.getBeanManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getModuleBeanManager successfully found a bean manager of: " + beanManager), (Object[])new Object[0]);
        }
        return beanManager;
    }

    private WebSphereBeanDeploymentArchive getBeanDeploymentArchive(ModuleMetaData moduleMetaData) {
        WebSphereBeanDeploymentArchive bda = null;
        WebSphereCDIDeployment cdiDeployment = this.getDeployment(moduleMetaData);
        if (cdiDeployment == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getModuleBeanDeploymentArchive returning null.  cdiDeployment is null", (Object[])new Object[0]);
            }
            return null;
        }
        String moduleName = moduleMetaData.getJ2EEName().toString();
        bda = cdiDeployment.getBeanDeploymentArchive(moduleName);
        return bda;
    }

    private WebSphereCDIDeployment getDeployment(ModuleMetaData moduleMetaData) {
        WebSphereCDIDeployment cdiDeployment = null;
        if (moduleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getDeployment returning null.  moduleMetaData is null", (Object[])new Object[0]);
            }
            return null;
        }
        ApplicationMetaData applicationMetaData = moduleMetaData.getApplicationMetaData();
        cdiDeployment = this.getDeployment(applicationMetaData);
        return cdiDeployment;
    }

    public BeanManager getCurrentModuleBeanManager() {
        ModuleMetaData moduleMetaData = this.getCurrentModuleMetaData();
        BeanManager beanManager = this.getBeanManager(moduleMetaData);
        return beanManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -5269077340616074273L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                String xmlValidationDisabled = System.getProperty(WELD_DISABLE_BEANSXML_VALIDATING);
                if (xmlValidationDisabled == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CDIContainerImpl", (Object[])new Object[]{"The system property " + WELD_DISABLE_BEANSXML_VALIDATING + " was not set explicitly. Set it to be 'true' by default."});
                    }
                    System.setProperty(WELD_DISABLE_BEANSXML_VALIDATING, "true");
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CDIContainerImpl", (Object[])new Object[]{"The system property " + WELD_DISABLE_BEANSXML_VALIDATING + " was explicitly set and remained as " + xmlValidationDisabled});
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }
}

