/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.internal.AuthenticationGuard;
import com.ibm.ws.security.authentication.internal.JAASService;
import com.ibm.ws.security.authentication.internal.cache.keyproviders.BasicAuthCacheKeyProvider;
import com.ibm.ws.security.authentication.internal.cache.keyproviders.CustomCacheKeyProvider;
import com.ibm.ws.security.authentication.internal.jaas.JAASServiceImpl;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.delegation.DelegationProvider;
import com.ibm.ws.security.jaas.common.callback.CallbackHandlerAuthenticationData;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.LoginException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceOptions(traceGroups={}, traceGroup="", messageBundle="com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", traceExceptionThrow=false, traceExceptionHandling=false)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final TraceComponent tc = Tr.register(AuthenticationServiceImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    static final String CFG_ALLOW_HASHTABLE_LOGIN_WITH_ID_ONLY = "allowHashtableLoginWithIdOnly";
    static final String CFG_CACHE_ENABLED = "cacheEnabled";
    static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    static final String KEY_USER_REGISTRY_SERVICE = "userRegistryService";
    static final String KEY_DELEGATION_PROVIDER = "delegationProvider";
    static final String KEY_DEFAULT_DELEGATION_PROVIDER = "defaultDelegationProvider";
    static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    private final AtomicServiceReference<AuthCacheService> authCacheServiceRef = new AtomicServiceReference("authCacheService");
    private final AtomicServiceReference<UserRegistryService> userRegistryServiceRef = new AtomicServiceReference("userRegistryService");
    private final AtomicServiceReference<DelegationProvider> delegationProviderRef = new AtomicServiceReference("delegationProvider");
    private final AtomicServiceReference<DelegationProvider> defaultDelegationProviderRef = new AtomicServiceReference("defaultDelegationProvider");
    private final AtomicServiceReference<CredentialsService> credentialsServiceRef = new AtomicServiceReference("credentialsService");
    private JAASService jaasService;
    private ComponentContext cc;
    private boolean cacheEnabled = true;
    private boolean allowHashtableLoginWithIdOnly = false;
    private String invalidDelegationUser = "";
    private final AuthenticationGuard authenticationGuard = new AuthenticationGuard();
    static final long serialVersionUID = 8644919184246925537L;

    protected void setJaasService(JAASService jaasService) {
        this.jaasService = jaasService;
        if (jaasService instanceof JAASServiceImpl) {
            JAASServiceImpl.setAuthenticationService(this);
        }
    }

    protected void unsetJaasService(JAASService jaasService) {
        if (this.jaasService == jaasService) {
            this.jaasService = null;
            JAASServiceImpl.unsetAuthenticationService(this);
        }
    }

    protected void setAuthCacheService(ServiceReference<AuthCacheService> reference) {
        this.authCacheServiceRef.setReference(reference);
    }

    protected void unsetAuthCacheService(ServiceReference<AuthCacheService> reference) {
        this.authCacheServiceRef.unsetReference(reference);
    }

    protected void setUserRegistryService(ServiceReference<UserRegistryService> reference) {
        this.userRegistryServiceRef.setReference(reference);
    }

    protected void unsetUserRegistryService(ServiceReference<UserRegistryService> reference) {
        this.userRegistryServiceRef.unsetReference(reference);
    }

    protected void setDelegationProvider(ServiceReference<DelegationProvider> reference) {
        this.delegationProviderRef.setReference(reference);
    }

    protected void unsetDelegationProvider(ServiceReference<DelegationProvider> reference) {
        this.delegationProviderRef.unsetReference(reference);
    }

    protected void setDefaultDelegationProvider(ServiceReference<DelegationProvider> reference) {
        this.defaultDelegationProviderRef.setReference(reference);
    }

    protected void unsetDefaultDelegationProvider(ServiceReference<DelegationProvider> reference) {
        this.defaultDelegationProviderRef.unsetReference(reference);
    }

    protected void setCredentialsService(ServiceReference<CredentialsService> reference) {
        this.credentialsServiceRef.setReference(reference);
    }

    protected void unsetCredentialsService(ServiceReference<CredentialsService> reference) {
        this.credentialsServiceRef.unsetReference(reference);
    }

    private void updateCacheState(Map<String, Object> props) {
        this.getAuthenticationConfig(props);
        if (this.cacheEnabled) {
            this.authCacheServiceRef.activate(this.cc);
        } else {
            this.authCacheServiceRef.deactivate(this.cc);
        }
    }

    private void getAuthenticationConfig(Map<String, Object> props) {
        Boolean state;
        Boolean loginWithIdOnly = (Boolean)props.get(CFG_ALLOW_HASHTABLE_LOGIN_WITH_ID_ONLY);
        if (loginWithIdOnly != null) {
            this.allowHashtableLoginWithIdOnly = loginWithIdOnly;
        }
        if ((state = (Boolean)props.get(CFG_CACHE_ENABLED)) != null) {
            this.cacheEnabled = state;
        }
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.cc = cc;
        this.authCacheServiceRef.activate(cc);
        this.userRegistryServiceRef.activate(cc);
        this.delegationProviderRef.activate(cc);
        this.defaultDelegationProviderRef.activate(cc);
        this.credentialsServiceRef.activate(cc);
        this.updateCacheState(props);
    }

    protected void modified(Map<String, Object> props) {
        this.updateCacheState(props);
    }

    protected void deactivate() {
        this.authCacheServiceRef.deactivate(this.cc);
        this.userRegistryServiceRef.deactivate(this.cc);
        this.delegationProviderRef.deactivate(this.cc);
        this.defaultDelegationProviderRef.deactivate(this.cc);
        this.credentialsServiceRef.deactivate(this.cc);
        JAASServiceImpl.unsetAuthenticationService(this);
        this.cc = null;
    }

    public Subject authenticate(String jaasEntryName, Subject inputSubject) throws AuthenticationException {
        WSAuthenticationData emptyAuthenticationData = new WSAuthenticationData();
        return this.authenticate(jaasEntryName, (AuthenticationData)emptyAuthenticationData, inputSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject authenticate(String jaasEntryName, AuthenticationData authenticationData, Subject subject) throws AuthenticationException {
        ReentrantLock currentLock = this.optionallyObtainLockedLock(authenticationData);
        try {
            if (this.isBasicAuthLogin(authenticationData)) {
                Subject subject2 = this.createBasicAuthSubject(authenticationData, subject);
                return subject2;
            }
            Subject authenticatedSubject = this.findSubjectInAuthCache(authenticationData, subject);
            if (authenticatedSubject == null) {
                authenticatedSubject = this.performJAASLogin(jaasEntryName, authenticationData, subject);
                this.insertSubjectInAuthCache(authenticationData, authenticatedSubject);
            }
            Subject subject3 = authenticatedSubject;
            return subject3;
        }
        finally {
            this.releaseLock(authenticationData, currentLock);
        }
    }

    private boolean isBasicAuthLogin(AuthenticationData authenticationData) {
        boolean result = false;
        if (authenticationData != null) {
            String currentRealm = this.getRealm();
            String loginRealm = (String)authenticationData.get("REALM");
            result = loginRealm != null && !loginRealm.equals(currentRealm) && !loginRealm.equals("defaultRealm");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Subject createBasicAuthSubject(AuthenticationData authenticationData, Subject subject) throws AuthenticationException {
        Subject basicAuthSubject = subject != null ? subject : new Subject();
        String loginRealm = (String)authenticationData.get("REALM");
        String username = (String)authenticationData.get("USERNAME");
        String password = this.getPassword((char[])authenticationData.get("PASSWORD"));
        CredentialsService credentialsService = (CredentialsService)this.credentialsServiceRef.getService();
        try {
            if (credentialsService != null) {
                credentialsService.setBasicAuthCredential(basicAuthSubject, loginRealm, username, password);
            }
        }
        catch (CredentialException credentialException) {
            void e;
            FFDCFilter.processException((Throwable)credentialException, (String)"com.ibm.ws.security.authentication.internal.AuthenticationServiceImpl", (String)"237", (Object)this, (Object[])new Object[]{authenticationData, subject});
            throw new AuthenticationException(e.getMessage());
        }
        return basicAuthSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Subject authenticate(String jaasEntryName, CallbackHandler callbackHandler, Subject subject) throws AuthenticationException {
        CallbackHandlerAuthenticationData cAuthData = new CallbackHandlerAuthenticationData(callbackHandler);
        AuthenticationData authenticationData = null;
        try {
            authenticationData = cAuthData.createAuthenticationData();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.internal.AuthenticationServiceImpl", (String)"252", (Object)this, (Object[])new Object[]{jaasEntryName, callbackHandler, subject});
            throw new AuthenticationException(e.getMessage());
        }
        ReentrantLock currentLock = this.optionallyObtainLockedLock(authenticationData);
        try {
            if (this.isBasicAuthLogin(authenticationData)) {
                Subject subject2 = this.createBasicAuthSubject(authenticationData, subject);
                return subject2;
            }
            Subject authenticatedSubject = this.findSubjectInAuthCache(authenticationData, subject);
            if (authenticatedSubject == null) {
                authenticatedSubject = this.performJAASLogin(jaasEntryName, callbackHandler, subject);
                this.insertSubjectInAuthCache(authenticationData, authenticatedSubject);
            }
            Subject subject3 = authenticatedSubject;
            return subject3;
        }
        finally {
            this.releaseLock(authenticationData, currentLock);
        }
    }

    private ReentrantLock optionallyObtainLockedLock(AuthenticationData authenticationData) {
        ReentrantLock currentLock = null;
        if (this.isAuthCacheServiceAvailable()) {
            currentLock = this.authenticationGuard.requestAccess(authenticationData);
            currentLock.lock();
        }
        return currentLock;
    }

    private boolean isAuthCacheServiceAvailable() {
        AuthCacheService authCacheService = this.getAuthCacheService();
        return authCacheService != null;
    }

    private void releaseLock(AuthenticationData authenticationData, ReentrantLock currentLock) {
        this.authenticationGuard.relinquishAccess(authenticationData, currentLock);
    }

    private Subject findSubjectInAuthCache(AuthenticationData authenticationData, Subject partialSubject) throws AuthenticationException {
        Subject subject = null;
        AuthCacheService authCacheService = this.getAuthCacheService();
        if (authCacheService != null && authenticationData != null) {
            String ssoToken = (String)authenticationData.get("TOKEN64");
            if (ssoToken != null) {
                subject = this.findSubjectByTokenContents(authCacheService, ssoToken, null);
            } else {
                byte[] ssoTokenBytes = (byte[])authenticationData.get("TOKEN");
                if (ssoTokenBytes != null) {
                    subject = this.findSubjectByTokenContents(authCacheService, null, ssoTokenBytes);
                } else {
                    String userid = (String)authenticationData.get("USERNAME");
                    String password = this.getPassword((char[])authenticationData.get("PASSWORD"));
                    if (userid != null && password != null) {
                        subject = this.findSubjectByUseridAndPassword(authCacheService, userid, password);
                    } else if (partialSubject != null) {
                        subject = this.findSubjectBySubjectHashtable(authCacheService, partialSubject);
                    }
                }
            }
        }
        return subject;
    }

    private Subject findSubjectByTokenContents(AuthCacheService authCacheService, String token, byte[] ssoTokenBytes) throws AuthenticationException {
        Subject subject = null;
        if (token != null) {
            subject = authCacheService.getSubject((Object)token);
        }
        if (subject == null && ssoTokenBytes != null) {
            subject = authCacheService.getSubject((Object)ssoTokenBytes);
        }
        if (subject == null) {
            if (ssoTokenBytes == null && token != null) {
                ssoTokenBytes = Base64Coder.base64DecodeString((String)token);
            }
            if (ssoTokenBytes == null) {
                throw new AuthenticationException("Invalid LTPA Token");
            }
            String customCacheKey = CustomCacheKeyProvider.getCustomCacheKey(authCacheService, ssoTokenBytes);
            if (customCacheKey != null && (subject = authCacheService.getSubject((Object)customCacheKey)) == null) {
                throw new AuthenticationException("Custom cache key missed authentication cache. Need to re-challenge the user to login again.");
            }
        }
        return subject;
    }

    private Subject findSubjectByUseridAndPassword(AuthCacheService authCacheService, String userid, @Sensitive String password) {
        return authCacheService.getSubject((Object)BasicAuthCacheKeyProvider.createLookupKey(this.getRealm(), userid, password));
    }

    private Subject findSubjectBySubjectHashtable(AuthCacheService authCacheService, Subject partialSubject) {
        Subject subject = null;
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable hashtable = subjectHelper.getHashtableFromSubject(partialSubject, new String[]{"com.ibm.wsspi.security.cred.cacheKey"});
        if (hashtable != null) {
            String customCacheKey = (String)hashtable.get("com.ibm.wsspi.security.cred.cacheKey");
            Boolean internalCachekeyAssertion = (Boolean)hashtable.get("com.ibm.ws.authentication.internal.assertion");
            if (customCacheKey != null && internalCachekeyAssertion != null && internalCachekeyAssertion.equals(Boolean.TRUE)) {
                subject = authCacheService.getSubject((Object)customCacheKey);
                return subject;
            }
        }
        if ((hashtable = subjectHelper.getHashtableFromSubject(partialSubject, new String[]{"com.ibm.wsspi.security.cred.userId", "com.ibm.wsspi.security.cred.password"})) != null) {
            String userid = (String)hashtable.get("com.ibm.wsspi.security.cred.userId");
            String password = (String)hashtable.get("com.ibm.wsspi.security.cred.password");
            String lookupKey = password != null ? BasicAuthCacheKeyProvider.createLookupKey(this.getRealm(), userid, password) : BasicAuthCacheKeyProvider.createLookupKey(this.getRealm(), userid);
            subject = authCacheService.getSubject((Object)lookupKey);
        }
        return subject;
    }

    @Sensitive
    private String getPassword(@Sensitive char[] passwordBytes) {
        String password = null;
        if (passwordBytes != null) {
            password = String.valueOf(passwordBytes);
        }
        return password;
    }

    public AuthCacheService getAuthCacheService() {
        return (AuthCacheService)this.authCacheServiceRef.getService();
    }

    @FFDCIgnore(value={RegistryException.class})
    private String getRealm() {
        String realm;
        block3: {
            realm = "defaultRealm";
            try {
                UserRegistryService userRegistryService = (UserRegistryService)this.userRegistryServiceRef.getService();
                if (userRegistryService.isUserRegistryConfigured()) {
                    UserRegistry userRegistry = userRegistryService.getUserRegistry();
                    realm = userRegistry.getRealm();
                }
            }
            catch (RegistryException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"There was a problem getting the realm.", (Object[])new Object[]{e});
            }
        }
        return realm;
    }

    @FFDCIgnore(value={LoginException.class})
    private Subject performJAASLogin(String jaasEntryName, CallbackHandler callbackHandler, Subject subject) throws AuthenticationException {
        if (this.jaasService != null) {
            try {
                return this.jaasService.performLogin(jaasEntryName, callbackHandler, subject);
            }
            catch (LoginException e) {
                throw new AuthenticationException(e.getLocalizedMessage());
            }
        }
        Tr.error((TraceComponent)tc, (String)"AUTHENTICATION_SERVICE_JAAS_UNAVAILABLE", (Object[])new Object[0]);
        throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"AUTHENTICATION_SERVICE_JAAS_UNAVAILABLE", (Object[])new Object[0], (String)"CWWKS1000E: The JAAS Service is unavailable."));
    }

    @FFDCIgnore(value={LoginException.class})
    private Subject performJAASLogin(String jaasEntryName, AuthenticationData authenticationData, Subject subject) throws AuthenticationException {
        if (this.jaasService != null) {
            try {
                return this.jaasService.performLogin(jaasEntryName, authenticationData, subject);
            }
            catch (LoginException e) {
                throw new AuthenticationException(e.getLocalizedMessage());
            }
        }
        Tr.error((TraceComponent)tc, (String)"AUTHENTICATION_SERVICE_JAAS_UNAVAILABLE", (Object[])new Object[0]);
        throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"AUTHENTICATION_SERVICE_JAAS_UNAVAILABLE", (Object[])new Object[0], (String)"CWWKS1000E: The JAAS Service is unavailable."));
    }

    private void insertSubjectInAuthCache(AuthenticationData authenticationData, Subject authenticatedSubject) {
        AuthCacheService authCacheService = this.getAuthCacheService();
        if (authCacheService != null) {
            String userid = (String)authenticationData.get("USERNAME");
            String password = this.getPassword((char[])authenticationData.get("PASSWORD"));
            if (userid != null && password != null) {
                authCacheService.insert(authenticatedSubject, userid, password);
            } else {
                authCacheService.insert(authenticatedSubject);
            }
        }
    }

    public void setInvalidDelegationUser(String invalidUser) {
        this.invalidDelegationUser = invalidUser;
    }

    public String getInvalidDelegationUser() {
        return this.invalidDelegationUser;
    }

    public Subject delegate(String roleName, String appName) {
        Subject runAsSubject = this.getRunAsSubjectFromProvider(roleName, appName);
        return runAsSubject;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private Subject getRunAsSubjectFromProvider(String roleName, String appName) {
        Subject runAsSubject;
        block4: {
            runAsSubject = null;
            DelegationProvider delegationProvider = (DelegationProvider)this.delegationProviderRef.getService();
            try {
                if (delegationProvider == null) {
                    delegationProvider = (DelegationProvider)this.defaultDelegationProviderRef.getService();
                }
                if (delegationProvider != null) {
                    runAsSubject = delegationProvider.getRunAsSubject(roleName, appName);
                }
            }
            catch (AuthenticationException e) {
                this.setInvalidDelegationUser(delegationProvider.getDelegationUser());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Caught an authentication exception, so will run as the invocation subject.", (Object[])new Object[0]);
            }
        }
        return runAsSubject;
    }

    public Boolean isAllowHashTableLoginWithIdOnly() {
        return this.allowHashtableLoginWithIdOnly;
    }
}

