/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ConnectorModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.metadata.ConnectorModuleMetaData;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConnectorModuleMetaDataImpl
extends MetaDataImpl
implements ConnectorModuleMetaData {
    private static final String RA_CONSTANT = "ResourceAdapter";
    static final String RA_MODULE_CONSTANT = "ResourceAdapterModule";
    private final ApplicationMetaData applicationMetaData;
    private Boolean autoStart = null;
    final Dictionary<String, Object> embeddedRAConfig;
    private final String identifier;
    private final boolean isEmbedded;
    private boolean hasConfig = true;
    private final J2EEName ivJ2EEName;
    private final String moduleName;
    private final Map<String, Object> metagenConfig = new HashMap<String, Object>();
    private final ComponentMetaData metadata;
    final NestedConfigHelper config;
    final String resourceAdapterPid;
    private final String specVersion;
    static final String SOURCE_PID = "ibm.extends.source.pid";
    static final String SOURCE_FACTORY_PID = "ibm.extends.source.factoryPid";
    static final long serialVersionUID = 5745477277016825857L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ConnectorModuleMetaDataImpl(ExtendedApplicationInfo appInfo, ConnectorModuleInfo cmInfo, RaConnector connector, J2EENameFactory j2eeNameFactory, Container containerToAdapt) throws UnableToAdaptException {
        super(0);
        this.isEmbedded = appInfo == null;
        if (this.isEmbedded) {
            appInfo = (ExtendedApplicationInfo)cmInfo.getApplicationInfo();
        }
        this.applicationMetaData = appInfo.getMetaData();
        this.config = appInfo.getConfigHelper();
        this.moduleName = cmInfo.getName();
        this.embeddedRAConfig = this.isEmbedded ? this.getConfigForEmbeddedResourceAdapter() : null;
        String id = (String)this.get("id");
        if (id != null && id.startsWith("default-")) {
            id = null;
        }
        if (this.isEmbedded) {
            String nameOfAppThatEmbedsRAR = this.applicationMetaData.getName();
            String alias = (String)this.get("alias");
            if (alias == null) {
                alias = id == null || id.length() == 0 ? this.moduleName.replace('/', '.') : id;
            }
            id = nameOfAppThatEmbedsRAR + '.' + alias;
            this.metagenConfig.put("rar.embedded.in.app", nameOfAppThatEmbedsRAR);
            this.ivJ2EEName = j2eeNameFactory.create(this.applicationMetaData.getJ2EEName().getApplication(), this.moduleName, null);
        } else {
            if (id == null || "".equals(id)) {
                id = this.moduleName.replace('/', '.');
            }
            this.ivJ2EEName = j2eeNameFactory.create(this.applicationMetaData.getJ2EEName().getApplication(), RA_MODULE_CONSTANT, null);
        }
        if (!id.matches("[0-9a-zA-Z.\\-_]*")) {
            throw new UnableToAdaptException(Utils.getMessage("J2CA8814.resource.adapter.install.failed", id));
        }
        this.processConfigElementCustomizations();
        this.metagenConfig.put("adapter.name", id);
        this.metagenConfig.put("mode", "rar");
        this.metagenConfig.put("use.annotations", true);
        String[] refs = (String[])this.get("contextServiceRef");
        String filter = refs == null || refs.length == 0 ? "(service.pid=com.ibm.ws.context.manager)" : FilterUtils.createPropertyFilter((String)"service.pid", (String)refs[0]);
        this.metagenConfig.put("contextService.target", filter);
        Boolean installedByDropins = (Boolean)this.config.get(".installedByDropins");
        if (installedByDropins != null) {
            this.metagenConfig.put(".installedByDropins", installedByDropins);
        }
        this.metagenConfig.put("rar.dd", connector);
        this.metagenConfig.put("translate", false);
        this.metagenConfig.put("module.name", this.moduleName);
        this.metagenConfig.put("rar.container", containerToAdapt);
        Boolean autoStart = (Boolean)this.get("autoStart");
        this.autoStart = autoStart == null && connector != null && connector.getResourceAdapter() != null ? connector.getResourceAdapter().getAutoStart() : autoStart;
        this.identifier = id;
        this.resourceAdapterPid = this.isEmbedded ? null : (String)this.config.get("service.pid");
        this.specVersion = connector != null ? connector.getVersion() : "1.6";
        J2EEName cmdName = j2eeNameFactory.create(this.ivJ2EEName.getApplication(), this.ivJ2EEName.getModule(), RA_CONSTANT);
        this.metadata = new ResourceAdapterMetaData(this, id, this.moduleName, cmdName, this.isEmbedded);
    }

    String getDefaultInstancesXML(String alias) throws Exception {
        StringBuilder xml = new StringBuilder(200).append("\r\n<server>\r\n");
        String extendsPid = (String)this.config.get(SOURCE_PID);
        if (extendsPid != null && extendsPid.startsWith("com.ibm.ws.jca.resourceAdapter")) {
            String id = this.getIDFromSupertype(extendsPid, 31);
            xml.append(" <resourceAdapter id=\"").append(id).append("\">\r\n");
            xml.append("  <").append(alias).append("/>\r\n");
            xml.append(" </resourceAdapter>\r\n");
        } else if (this.embeddedRAConfig != null && alias != null) {
            String appElementName;
            String appId;
            if (extendsPid != null && extendsPid.startsWith("com.ibm.ws.app.manager.earappcfg")) {
                appId = this.getIDFromSupertype(extendsPid, 33);
                appElementName = "enterpriseApplication";
            } else {
                String topLevelConfigId = (String)this.config.get("config.id");
                appId = topLevelConfigId.substring(23, topLevelConfigId.length() - 1);
                appElementName = "application";
            }
            String raId = (String)this.embeddedRAConfig.get("id");
            xml.append(" <").append(appElementName).append(" id=\"").append(appId).append("\">\r\n");
            xml.append("  <resourceAdapter id=\"").append(raId).append("\">\r\n");
            xml.append("   <").append(alias).append("/>\r\n");
            xml.append("  </resourceAdapter>\r\n");
            xml.append(" </").append(appElementName).append(">\r\n");
        } else {
            this.hasConfig = false;
            return null;
        }
        xml.append("</server>");
        return xml.toString();
    }

    private String getIDFromSupertype(String raPid, int startIndex) throws Exception {
        BundleContext bundleContext = PrivHelper.getBundleContext((Bundle)FrameworkUtil.getBundle(this.getClass()));
        ServiceReference configAdminRef = PrivHelper.getServiceReference((BundleContext)bundleContext, ConfigurationAdmin.class);
        try {
            String filter = "(service.pid=" + raPid + ")";
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)PrivHelper.getService((BundleContext)bundleContext, (ServiceReference)configAdminRef);
            Configuration[] configurations = configAdmin.listConfigurations(filter);
            if (configurations != null) {
                String id = (String)configurations[0].getProperties().get("id");
                if (id != null) {
                    String string = id;
                    return string;
                }
                String configId = (String)configurations[0].getProperties().get("config.id");
                String string = configId.substring(startIndex, configId.length() - 1);
                return string;
            }
            throw new IllegalStateException("Resource Adapter " + raPid + " not found");
        }
        finally {
            bundleContext.ungetService(configAdminRef);
        }
    }

    String getDefaultInstanceTopLevelId() {
        String topLevelConfigId = (String)this.config.get("config.id");
        if (topLevelConfigId != null) {
            if (topLevelConfigId.startsWith("com.ibm.ws.jca.resourceAdapter[")) {
                return topLevelConfigId.substring(31, topLevelConfigId.length() - 1);
            }
            if (this.isEmbedded && topLevelConfigId.startsWith("com.ibm.ws.app.manager[")) {
                return topLevelConfigId.substring(23, topLevelConfigId.length() - 1);
            }
        }
        return null;
    }

    private Object get(String name) {
        if (this.isEmbedded) {
            return this.embeddedRAConfig == null ? null : this.embeddedRAConfig.get(name);
        }
        return this.config.get(name);
    }

    final Boolean getAutoStart() {
        return this.autoStart;
    }

    /*
     * WARNING - void declaration
     */
    private final Dictionary<String, Object> getConfigForEmbeddedResourceAdapter() throws UnableToAdaptException {
        BundleContext bundleContext = PrivHelper.getBundleContext((Bundle)FrameworkUtil.getBundle(this.getClass()));
        ServiceReference configAdminRef = PrivHelper.getServiceReference((BundleContext)bundleContext, ConfigurationAdmin.class);
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)PrivHelper.getService((BundleContext)bundleContext, (ServiceReference)configAdminRef);
        try {
            String filter;
            Configuration[] configurations;
            String parentPid = (String)this.config.get(SOURCE_PID);
            if (parentPid == null) {
                parentPid = (String)this.config.get("service.pid");
            }
            if ((configurations = configAdmin.listConfigurations(filter = "(&(service.factoryPid=com.ibm.ws.jca.embeddedResourceAdapter)(config.parentPID=" + parentPid + "))")) != null) {
                for (Configuration config : configAdmin.listConfigurations(filter)) {
                    Dictionary props = config.getProperties();
                    String id = (String)props.get("id");
                    if (!this.moduleName.equals(id)) continue;
                    Dictionary dictionary = props;
                    return dictionary;
                }
            }
            Configuration[] configurationArray = null;
            return configurationArray;
        }
        catch (Exception parentPid) {
            void x;
            FFDCFilter.processException((Throwable)parentPid, (String)"com.ibm.ws.jca.internal.ConnectorModuleMetaDataImpl", (String)"298", (Object)this, (Object[])new Object[0]);
            throw new UnableToAdaptException((Throwable)x);
        }
        finally {
            bundleContext.ungetService(configAdminRef);
        }
    }

    public String getName() {
        return this.moduleName;
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2EEName;
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.applicationMetaData;
    }

    public ComponentMetaData[] getComponentMetaDatas() {
        return new ComponentMetaData[]{this.metadata};
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    final long getMaxWaitForResources() {
        Long maxWait = (Long)this.get("maxWaitForResources");
        return maxWait == null ? 20000L : maxWait;
    }

    Map<String, Object> getMetaGenConfig() {
        return this.metagenConfig;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Trivial
    public boolean hasConfig() {
        return this.hasConfig;
    }

    private final void processConfigElementCustomizations() {
        HashMap<String, String> suffixOverridesByIntf = new HashMap<String, String>();
        HashMap<String, String> suffixOverridesByImpl = new HashMap<String, String>();
        HashMap<String, String> suffixOverridesByBoth = new HashMap<String, String>();
        String prefix = "customize.";
        int count = 0;
        while (this.get(prefix + count + ".config.referenceType") != null) {
            String intf = (String)this.get(prefix + count + ".interface");
            String impl = (String)this.get(prefix + count + ".implementation");
            String suffix = (String)this.get(prefix + count + ".suffix");
            String string = suffix = suffix == null ? "" : suffix;
            if (intf == null) {
                if (impl != null) {
                    suffixOverridesByImpl.put(impl, suffix);
                }
            } else if (impl == null) {
                suffixOverridesByIntf.put(intf, suffix);
            } else {
                suffixOverridesByBoth.put(intf + '-' + impl, suffix);
            }
            ++count;
        }
        this.metagenConfig.put("suffix.overrides.by.interface", suffixOverridesByIntf);
        this.metagenConfig.put("suffix.overrides.by.impl", suffixOverridesByImpl);
        this.metagenConfig.put("suffix.overrides.by.both", suffixOverridesByBoth);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConnectorModuleMetaDataImpl.class);
    }
}

