/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.runtime;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XQName;
import com.ibm.xml.xlxp2.grammar.Attribute;
import com.ibm.xml.xlxp2.grammar.Element;
import com.ibm.xml.xlxp2.grammar.ElementType;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.grammar.NamedDeclaration;
import com.ibm.xml.xlxp2.grammar.Wildcard;
import com.ibm.xml.xlxp2.runtime.ContentScanner;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;
import com.ibm.xml.xlxp2.util.BitSet;
import com.ibm.xml.xlxp2.validation.idc.EndIDC;
import com.ibm.xml.xlxp2.validation.idc.IDCContext;
import com.ibm.xml.xlxp2.validation.idc.StartIDC;
import com.ibm.xml.xlxp2.validation.msg.VMMessagesBundle;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class VMContext
extends DocumentScanner {
    public static final int STATE_STRICT = 0;
    public static final int STATE_LAX = 1;
    public static final int STATE_SKIP = 2;
    public int elementDepth;
    public int validationState;
    public int leafState;
    public Element eDecl;
    public int eDeclIndex;
    public Wildcard eWildcard;
    public ElementType eType;
    public boolean nilled;
    public boolean leafNilled;
    public final ValidatedInfo eValue = new ValidatedInfo();
    public Attribute[] aDecls = ArrayAllocator.newObjectArray(Attribute.class, 8);
    public int[] aIndex = ArrayAllocator.newIntArray(8);
    public ValidatedInfo[] aValues = ArrayAllocator.newObjectArray(ValidatedInfo.class, 8);
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XS_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String QNAME = "QName";
    private static final String TYPE = "type";
    public final boolean validating;
    public ValidationContext dvContext;
    private Grammar ir;
    private TypeValidator qnameDV;
    private int eWCIndex;
    private ValidatedInfo vcValue;
    private boolean vcFixed;
    private ElementType.DFAInfo fDFAInfo;
    private int skipDepth;
    private int xsitypeIndex = -1;
    public final BitSet attsSpecified = new BitSet(1);
    public boolean isValidated = false;
    private int contentType;
    private State currentState;
    private final State rootState = new State();
    private final XMLStringBuffer elemBuffer = new XMLStringBuffer();
    private XMLString elementString;
    private final XMLString elementStringFirst = new XMLString();
    private int elemBufferOffset = -1;
    private ContentScanner fContentScanner;
    public final IDCContext idcContext;
    public int wildIDCDepth = -1;
    private EntityDeclPool fEntityDeclPool;
    private final boolean resetObjectPools;
    private final boolean produceActualValues;

    public VMContext(DataBufferFactory dataBufferFactory, SymbolTable symbolTable, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(dataBufferFactory, symbolTable, bl);
        this.produceActualValues = bl5;
        for (int i = 0; i < 8; ++i) {
            this.aValues[i] = new ValidatedInfo();
        }
        this.validating = bl3;
        if (bl4) {
            this.dvContext = new ValidationContext();
            this.dvContext.setSchemaProcessor(this);
        }
        this.resetObjectPools = bl2;
        this.idcContext = bl3 ? new IDCContext(this) : null;
    }

    public void setValidationContext(ValidationContext validationContext) {
        if (this.dvContext != null) {
            this.dvContext.setSchemaProcessor(null);
        }
        this.dvContext = validationContext;
        if (validationContext != null) {
            validationContext.setSchemaProcessor(this);
        }
    }

    protected void initializeFrom(VMContext vMContext) {
        super.initializeFrom(vMContext);
        this.elementDepth = vMContext.elementDepth;
        this.validationState = vMContext.validationState;
        this.leafState = vMContext.leafState;
        this.eDecl = vMContext.eDecl;
        this.eDeclIndex = vMContext.eDeclIndex;
        this.eWildcard = vMContext.eWildcard;
        this.eType = vMContext.eType;
        this.nilled = vMContext.nilled;
        this.leafNilled = vMContext.leafNilled;
        this.eValue.copyValues(this.eValue);
        System.arraycopy(vMContext.aDecls, 0, this.aDecls, 0, vMContext.attrCount);
        for (int i = 0; i < vMContext.attrCount; ++i) {
            this.aValues[i].copyValues(vMContext.aValues[i]);
        }
        this.ir = vMContext.ir;
        this.qnameDV = vMContext.qnameDV;
        this.eWCIndex = vMContext.eWCIndex;
        System.arraycopy(vMContext.aIndex, 0, this.aIndex, 0, vMContext.aIndex.length);
        this.vcValue = vMContext.vcValue;
        this.vcFixed = vMContext.vcFixed;
        this.fDFAInfo = vMContext.fDFAInfo;
        this.skipDepth = vMContext.skipDepth;
        this.xsitypeIndex = vMContext.xsitypeIndex;
        vMContext.attsSpecified.copyTo(this.attsSpecified);
        this.isValidated = vMContext.isValidated;
        this.contentType = vMContext.contentType;
        this.currentState = vMContext.currentState;
        this.elementString = vMContext.elementString == null ? null : this.elementStringFirst;
        this.elementStringFirst.setValues(vMContext.elementStringFirst);
        this.elemBufferOffset = vMContext.elemBufferOffset;
        this.fContentScanner = vMContext.fContentScanner;
        this.fEntityDeclPool = vMContext.fEntityDeclPool;
        if (this.idcContext != null) {
            // empty if block
        }
        this.wildIDCDepth = vMContext.wildIDCDepth;
    }

    public final void setEntityDeclPool(EntityDeclPool entityDeclPool) {
        if (this.validating()) {
            this.fEntityDeclPool = entityDeclPool;
        }
    }

    public String toInternedString(XMLString xMLString) {
        return this.fSymbolTable.addSymbol(xMLString);
    }

    public boolean isUnparsedEntity(XMLString xMLString) {
        if (this.fEntityDeclPool == null) {
            return false;
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupEntity(this.toInternedString(xMLString));
        return entityDecl == null ? false : entityDecl.type == 5;
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.xsitypeIndex = -1;
        this.elementDepth = 0;
        this.eType = null;
        if (this.dvContext != null) {
            this.dvContext.reset(bl);
        }
        if (this.validating() && this.idcContext.idcCount > 0) {
            this.idcContext.reset();
        }
        this.leafState = 0;
        this.validationState = 0;
    }

    protected void growAttributes() {
        super.growAttributes();
        int n = this.aDecls.length;
        int n2 = n << 1;
        Attribute[] attributeArray = ArrayAllocator.newObjectArray(Attribute.class, n2);
        System.arraycopy(this.aDecls, 0, attributeArray, 0, n);
        this.aDecls = attributeArray;
        ValidatedInfo[] validatedInfoArray = ArrayAllocator.newObjectArray(ValidatedInfo.class, n2);
        System.arraycopy(this.aValues, 0, validatedInfoArray, 0, n);
        this.aValues = validatedInfoArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.aValues[i] = new ValidatedInfo();
        }
        int[] nArray = ArrayAllocator.newIntArray(n2);
        System.arraycopy(this.aIndex, 0, nArray, 0, n);
        this.aIndex = nArray;
    }

    public boolean scanContent() {
        ContentScanner contentScanner = this.fContentScanner;
        if (contentScanner != null) {
            boolean bl = contentScanner.scanContent(this.fCurrentEntity, this.content, this);
            if (this.fCurrentState == 0) {
                this.setContentOrMarkupState();
            }
            return bl;
        }
        return super.scanContent();
    }

    public final void setContentScanner(ContentScanner contentScanner) {
        this.fContentScanner = contentScanner;
        this.inElementContent = false;
    }

    private boolean matchWildcard(String string) {
        Wildcard[] wildcardArray = this.fDFAInfo.wc;
        if (wildcardArray == null) {
            return false;
        }
        for (int i = 0; i < wildcardArray.length; ++i) {
            if (!wildcardArray[i].allows(string)) continue;
            this.eWildcard = wildcardArray[i];
            this.eWCIndex = i;
            return true;
        }
        return false;
    }

    public void setIR(Grammar grammar) {
        this.ir = grammar;
        this.qnameDV = null;
    }

    public Grammar getIR() {
        return this.ir;
    }

    public void startSchemaAssessment(Grammar grammar) {
        assert (this.ir == null && (this.fCurrentEvent == 2 || this.fCurrentEvent == 3));
        this.setIR(grammar);
        this.initializeGrammarState();
        if (this.fCurrentEvent == 2) {
            this.handleStartElementEvent();
        } else {
            this.handleLeafElementEvent();
        }
    }

    public void startSchemaAssessment(Grammar grammar, ElementType elementType) {
        assert (this.ir == null && (this.fCurrentEvent == 2 || this.fCurrentEvent == 3));
        this.setIR(grammar);
        this.initializeGrammarState();
        if (this.fCurrentEvent == 2) {
            this.handleRootStartElementEventNV(elementType);
        } else {
            this.handleRootLeafElementEventNV(elementType);
        }
    }

    public void stopSchemaAssessment() {
        assert (this.ir != null && (this.fCurrentEvent == 4 || this.fCurrentEvent == 3) && this.elementDepth == 0);
        if (this.validating()) {
            this.finishValidation();
        }
        this.ir = null;
        this.qnameDV = null;
        this.setContentScanner(null);
    }

    private final void setAttrDecl(Attribute attribute, int n, int n2) {
        this.aDecls[n2] = attribute;
        this.aIndex[n2] = n;
    }

    public final boolean currentElementHasSimpleContent() {
        return this.contentType == 1;
    }

    public final boolean currentElementHasMixedContent() {
        return this.contentType == 3;
    }

    public final boolean validating() {
        return this.validating;
    }

    public final ValidatedInfo currentElementActualValue() {
        return this.eValue;
    }

    public final ValidatedInfo currentAttributeActualValue() {
        return this.aValues[this.attrCount];
    }

    public final ValidatedInfo actualAttributeValue(int n) {
        return this.aValues[n];
    }

    public final boolean strictlyAssessing() {
        return this.validationState == 0;
    }

    public final boolean laxlyAssessing() {
        return this.validationState == 1;
    }

    public final boolean skipping() {
        return this.validationState == 2;
    }

    public final boolean strictlyAssessingLeaf() {
        return this.leafState == 0;
    }

    public final boolean laxlyAssessingLeaf() {
        return this.leafState == 1;
    }

    public final boolean skippingLeaf() {
        return this.leafState == 2;
    }

    public final void generateError(int n) {
        this.reportRecoverableError(XS_NS, n);
    }

    public final void generateError(int n, String string) {
        this.setParameter(0, string);
        this.generateError(n);
    }

    public final void generateError(int n, String string, String string2) {
        this.setParameter(0, string);
        this.setParameter(1, string2);
        this.generateError(n);
    }

    public final void generateError(int n, String string, String string2, String string3) {
        this.setParameter(0, string);
        this.setParameter(1, string2);
        this.setParameter(2, string3);
        this.generateError(n);
    }

    public final void generateError(int n, XMLString xMLString) {
        this.setParameter(0, xMLString);
        this.generateError(n);
    }

    private final void setupReadElement(int n, ElementType.DFAInfo dFAInfo) {
        this.contentType = n;
        this.setInElementContent(n == 2);
        if (n == 3) {
            this.clearCharValue();
        }
        this.fDFAInfo = dFAInfo;
    }

    private final void setupReadSimple(TypeValidator typeValidator) {
        this.setContentScanner(typeValidator.isContentScanner ? typeValidator : null);
        this.clearCharValue();
        this.contentType = 1;
        this.fDFAInfo = null;
    }

    private final void setupSkip() {
        this.skipDepth = this.elementDepth;
        this.setContentScanner(null);
        this.vcValue = null;
        this.setInElementContent(false);
        this.clearCharValue();
    }

    public final XMLString getElementString() {
        if (this.elementString == null) {
            if (this.elemBufferOffset == -1) {
                if (this.elementStringFirst.firstBuffer != null) {
                    this.elementString = this.elementStringFirst;
                    return this.elementString;
                }
                NullDataBufferFactory.setEmptyStringValues(this.elementStringFirst);
            } else {
                this.elemBuffer.setStringValues(this.elemBufferOffset, this.elemBuffer.getOffset(), this.elementStringFirst);
            }
            this.elementString = this.elementStringFirst;
        }
        return this.elementString;
    }

    private void appendCharsValue(XMLString xMLString) {
        if (this.elemBufferOffset == -1) {
            if (this.elementStringFirst.firstBuffer == null) {
                this.elementStringFirst.setValues(xMLString);
                return;
            }
            this.elemBufferOffset = this.elemBuffer.getOffset();
            this.elemBuffer.appendXMLString(this.elementStringFirst);
        }
        this.elemBuffer.appendXMLString(xMLString);
    }

    private void appendCharValue(int n) {
        if (this.elemBufferOffset == -1) {
            this.elemBufferOffset = this.elemBuffer.getOffset();
            if (this.elementStringFirst.firstBuffer != null) {
                this.elemBuffer.appendXMLString(this.elementStringFirst);
            }
        }
        this.elemBuffer.appendChar(n);
    }

    private void clearCharValue() {
        this.elementString = null;
        this.elementStringFirst.clear();
        this.elemBufferOffset = -1;
        this.elemBuffer.reset(true);
    }

    public static int findQNameInChoices(NamedDeclaration[] namedDeclarationArray, NamedDeclaration.Entry[] entryArray, QName qName) {
        return VMContext.findQNameInChoices(namedDeclarationArray, entryArray, qName.nsURI, qName.localName);
    }

    public static int findQNameInChoices(NamedDeclaration[] namedDeclarationArray, NamedDeclaration.Entry[] entryArray, String string, String string2) {
        int n = namedDeclarationArray.length;
        if (n == 1) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[0];
            return string2 == namedDeclaration.localName && string == namedDeclaration.nsURI ? 0 : -1;
        }
        if (entryArray == null) {
            return VMContext.linearSearch(string, string2, n, namedDeclarationArray);
        }
        return NamedDeclaration.searchMap(string, string2, entryArray);
    }

    private static int linearSearch(String string, String string2, int n, NamedDeclaration[] namedDeclarationArray) {
        for (int i = n - 1; i >= 0; --i) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[i];
            if (string2 != namedDeclaration.localName || string != namedDeclaration.nsURI) continue;
            return i;
        }
        return -1;
    }

    protected void push(ElementType elementType) {
        State state = this.currentState.free;
        if (state == null) {
            this.currentState.free = state = new State();
            state.parent = this.currentState;
        }
        state.element = this.eDecl;
        state.wildcard = this.eWildcard;
        state.type = elementType;
        this.currentState = state;
    }

    protected void pop() {
        this.currentState = this.currentState.parent;
    }

    public boolean produceStartDocumentEvent() {
        return this.produceStartDocumentEventVMDefault();
    }

    public final boolean produceStartDocumentEventVMDefault() {
        boolean bl = super.produceStartDocumentEvent();
        if (this.ir != null) {
            this.initializeGrammarState();
        }
        return bl;
    }

    public boolean produceEndDocumentEvent() {
        return this.produceEndDocumentEventVMDefault();
    }

    public final boolean produceEndDocumentEventVMDefault() {
        if (this.ir != null && this.validating()) {
            this.finishValidation();
        }
        return super.produceEndDocumentEvent();
    }

    public boolean produceLeafElementEvent() {
        return this.produceLeafElementEventVMDefault();
    }

    public final boolean produceLeafElementEventVMDefault() {
        boolean bl = super.produceLeafElementEvent();
        if (this.ir != null) {
            this.handleLeafElementEvent();
        }
        return bl;
    }

    public boolean produceStartElementEvent() {
        return this.produceStartElementEventVMDefault();
    }

    public final boolean produceStartElementEventVMDefault() {
        boolean bl = super.produceStartElementEvent();
        if (this.ir != null) {
            this.handleStartElementEvent();
        }
        return bl;
    }

    public boolean produceEndElementEvent() {
        return this.produceEndElementEventVMDefault();
    }

    public final boolean produceEndElementEventVMDefault() {
        if (this.ir == null) {
            return super.produceEndElementEvent();
        }
        boolean bl = super.produceEndElementEvent();
        this.handleEndElementEvent();
        return bl;
    }

    public boolean produceCharactersEvent() {
        return this.produceCharactersEventVMDefault();
    }

    public final boolean produceCharactersEventVMDefault() {
        boolean bl = super.produceCharactersEvent();
        if (this.ir != null) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    public boolean produceCDATASectionEvent() {
        return this.produceCDATASectionEventVMDefault();
    }

    public final boolean produceCDATASectionEventVMDefault() {
        boolean bl = super.produceCDATASectionEvent();
        if (this.ir != null) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    public boolean produceWhitespaceEvent() {
        return this.produceWhitespaceEventVMDefault();
    }

    public final boolean produceWhitespaceEventVMDefault() {
        boolean bl = super.produceWhitespaceEvent();
        if (this.ir != null) {
            this.handleWhitespaceEvent();
        }
        return bl;
    }

    public boolean produceCharacterEvent() {
        return this.produceCharacterEventVMDefault();
    }

    public final boolean produceCharacterEventVMDefault() {
        boolean bl = super.produceCharacterEvent();
        if (this.ir != null) {
            this.handleCharacterEvent();
        }
        return bl;
    }

    public boolean producePredefinedEntityEvent() {
        return this.producePredefinedEntityEventVMDefault();
    }

    public final boolean producePredefinedEntityEventVMDefault() {
        boolean bl = super.producePredefinedEntityEvent();
        if (this.ir != null) {
            this.handleCharacterEvent();
        }
        return bl;
    }

    private final void initializeGrammarState() {
        this.currentState = this.rootState;
        this.setupReadElement(2, (ElementType.DFAState)this.ir.root);
        if (this.validating()) {
            this.idcContext.initialize(this.ir.idcCount, this.ir.xpathDFAs);
        }
    }

    private final void finishValidation() {
        String string;
        if (this.validating() && (string = this.dvContext.checkIDRefID()) != null) {
            this.generateError(9, string);
        }
    }

    private final void handleLeafElementEvent() {
        if (this.skipping()) {
            return;
        }
        ++this.elementDepth;
        this.eType = null;
        this.handleLeafElementNormal();
        --this.elementDepth;
        if (this.currentState.type != null && this.currentState.type.all == null) {
            this.setupNextScanners();
        }
        this.leafState = this.eType != null ? 0 : 2;
        this.leafNilled = this.nilled;
        this.nilled = false;
    }

    private final void handleRootLeafElementEventNV(ElementType elementType) {
        assert (elementType != null);
        ++this.elementDepth;
        this.eDecl = null;
        this.eType = elementType;
        this.clearCharValue();
        this.matchWildcard(this.elementType.nsURI);
        this.processAttributes(elementType);
        --this.elementDepth;
        this.leafState = 0;
        this.leafNilled = this.nilled;
        this.nilled = false;
    }

    private final void handleStartElementEvent() {
        ++this.elementDepth;
        if (this.skipping()) {
            return;
        }
        this.eType = null;
        this.handleStartElementNormal();
        if (this.vcFixed) {
            this.fDFAInfo = null;
        }
        this.validationState = this.eType != null ? 0 : 2;
    }

    private final void handleRootStartElementEventNV(ElementType elementType) {
        assert (elementType != null);
        ++this.elementDepth;
        this.eDecl = null;
        this.eType = elementType;
        this.matchWildcard(this.elementType.nsURI);
        this.processAttributes(elementType);
        this.push(this.eType);
        this.startElementNV(this.eType);
        this.validationState = 0;
    }

    private final void handleEndElementEvent() {
        block14: {
            block13: {
                if (this.skipping()) {
                    if (this.skipDepth == this.elementDepth) {
                        this.setupNextScanners();
                        this.validationState = 0;
                    }
                    --this.elementDepth;
                    return;
                }
                if (this.validating()) break block13;
                switch (this.contentType) {
                    case 1: {
                        this.handleEndElementValue(this.currentState.type.dv, this.getElementString());
                        break;
                    }
                    default: {
                        if (this.vcValue != null) {
                            XMLString xMLString = this.getElementString();
                            if (xMLString.length == 0) {
                                this.applyElementDefaultValue();
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block14;
            }
            switch (this.contentType) {
                case 1: {
                    this.handleEndElementSimple();
                    break;
                }
                default: {
                    this.handleEndElementV();
                }
            }
            if (this.wildIDCDepth >= 0) {
                if (this.elementDepth > this.wildIDCDepth) {
                    this.idcContext.endIDCStateHistoryContext();
                } else {
                    this.wildIDCDepth = -1;
                }
            }
        }
        this.nilled = false;
        this.vcValue = null;
        --this.elementDepth;
        this.pop();
        this.setupNextScanners();
    }

    private final void handleCharactersEvent() {
        if (this.skipping()) {
            return;
        }
        if (this.content.length == 0) {
            return;
        }
        switch (this.contentType) {
            case 1: 
            case 3: {
                this.appendCharsValue(this.content);
                break;
            }
            case 2: {
                if (!this.validating() || this.content.isAllWhitespace()) break;
                this.generateError(8);
                break;
            }
            default: {
                if (!this.validating()) break;
                this.generateError(7);
            }
        }
    }

    private final void handleWhitespaceEvent() {
        assert (this.contentType == 2);
    }

    private final void handleCharacterEvent() {
        if (this.skipping()) {
            return;
        }
        switch (this.contentType) {
            case 1: 
            case 3: {
                this.appendCharValue(this.singleCh);
                break;
            }
            case 2: {
                if (!this.validating() || this.singleCh == 9 || this.singleCh == 10 || this.singleCh == 13 || this.singleCh == 32) break;
                this.generateError(8);
                break;
            }
            default: {
                if (!this.validating()) break;
                this.generateError(7);
            }
        }
    }

    private final void applyElementDefaultValue() {
        Element element = this.eDecl;
        ElementType elementType = this.eType;
        TypeValidator typeValidator = elementType.dv;
        if (this.validating() && elementType != element.type && !element.vcSafeTypes.getBit(elementType.index)) {
            this.generateError(17, element.vcValue.actualValue.toString());
        }
        if (typeValidator != null) {
            if (this.validating() && typeValidator.idrefOrEntity && typeValidator.checkIdrefAndEntity(element.vcValue.actualValue, this.dvContext) != 0) {
                this.generateError(17, element.vcValue.actualValue.toString());
            }
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            validatedInfo.copyValues(element.vcValue);
        }
    }

    private void handleLeafElementNormal() {
        int n;
        this.clearCharValue();
        if (this.fDFAInfo == null) {
            this.eType = null;
            if (this.validating()) {
                if (this.vcValue != null && this.vcFixed) {
                    this.generateError(28);
                } else {
                    this.generateError(7);
                }
            }
            return;
        }
        NamedDeclaration[] namedDeclarationArray = this.fDFAInfo.elements;
        NamedDeclaration namedDeclaration = null;
        if (namedDeclarationArray != null && (n = VMContext.findQNameInChoices(namedDeclarationArray, this.fDFAInfo.elementTable, this.elementType)) >= 0) {
            namedDeclaration = namedDeclarationArray[n];
            this.eDeclIndex = n;
        }
        this.eDecl = namedDeclaration;
        if (namedDeclaration != null) {
            this.processAttributes(null);
            if (((Element)namedDeclaration).vcValue != null) {
                this.applyElementDefaultValue();
            }
            if (!this.validating()) {
                return;
            }
            if (this.wildIDCDepth >= 0) {
                this.idcContext.startIDCStateHistoryContext();
                this.idcContext.processActiveXPaths();
                this.idcContext.endIDCStateHistoryContext();
            }
            if (!this.nilled && !this.eType.allowEmpty && ((Element)namedDeclaration).vcValue == null) {
                this.generateError(10);
            }
            this.handleSG(this.eDecl, this.eType, true);
        } else {
            boolean bl;
            if (!this.matchWildcard(this.elementType.nsURI)) {
                if (this.validating()) {
                    this.generateError(12, this.elementType.rawName);
                }
                return;
            }
            if (this.eWildcard.processContents != 2) {
                this.processAttributes(null);
            }
            if (!this.validating()) {
                return;
            }
            Wildcard wildcard = this.eWildcard;
            boolean bl2 = bl = wildcard.processContents == 1 || wildcard.processContents == 3 && this.eType != null;
            if (wildcard.processContents == 1 && this.eType == null) {
                this.generateError(13);
                bl = false;
            }
            if (wildcard.processContents != 2 && this.eType != null && !this.eType.allowEmpty) {
                this.generateError(10);
            }
            if (bl && this.wildIDCDepth >= 0) {
                this.idcContext.startIDCStateHistoryContext();
                this.idcContext.processActiveXPaths();
                this.idcContext.endIDCStateHistoryContext();
            }
            this.handleSGW(wildcard, this.eType, true, bl);
        }
    }

    private void handleStartElementNormal() {
        int n;
        if (this.fDFAInfo == null) {
            this.eType = null;
            if (this.validating()) {
                if (this.vcValue != null && this.vcFixed) {
                    this.generateError(28);
                } else {
                    this.generateError(7);
                }
            }
            this.setupSkip();
            return;
        }
        NamedDeclaration[] namedDeclarationArray = this.fDFAInfo.elements;
        if (!this.validating()) {
            int n2;
            int n3 = n2 = namedDeclarationArray == null ? -1 : VMContext.findQNameInChoices(namedDeclarationArray, this.fDFAInfo.elementTable, this.elementType);
            if (n2 >= 0) {
                this.eDecl = namedDeclarationArray[n2];
                this.eDeclIndex = n2;
                this.processAttributes(null);
                this.push(this.eType);
                if (this.nilled) {
                    this.setupReadElement(0, null);
                } else {
                    this.startElementNV(this.eType);
                }
            } else {
                this.eDecl = null;
                if (!this.matchWildcard(this.elementType.nsURI) || this.eWildcard.processContents == 2) {
                    this.eWildcard = null;
                    this.setupSkip();
                    return;
                }
                this.processAttributes(null);
                if (this.eType == null) {
                    this.setupSkip();
                    return;
                }
                if (this.eType != null) {
                    this.push(this.eType);
                    this.startElementNV(this.eType);
                } else {
                    this.setupSkip();
                }
            }
            return;
        }
        NamedDeclaration namedDeclaration = null;
        if (namedDeclarationArray != null && (n = VMContext.findQNameInChoices(namedDeclarationArray, this.fDFAInfo.elementTable, this.elementType)) >= 0) {
            namedDeclaration = namedDeclarationArray[n];
            this.eDeclIndex = n;
        }
        this.eDecl = namedDeclaration;
        if (namedDeclaration != null) {
            this.vcValue = ((Element)namedDeclaration).vcValue;
            this.vcFixed = ((Element)namedDeclaration).fixed;
            this.processAttributes(null);
            if (this.wildIDCDepth >= 0) {
                this.idcContext.startIDCStateHistoryContext();
                this.idcContext.processActiveXPaths();
            }
            this.handleSG(this.eDecl, this.eType, false);
        } else {
            boolean bl;
            if (!this.matchWildcard(this.elementType.nsURI)) {
                this.eWildcard = null;
                this.generateError(12, this.elementType.rawName);
                this.setupSkip();
                return;
            }
            if (this.eWildcard.processContents != 2) {
                this.processAttributes(null);
            }
            Wildcard wildcard = this.eWildcard;
            boolean bl2 = bl = wildcard.processContents == 1 || wildcard.processContents == 3 && this.eType != null;
            if (wildcard.processContents == 1 && this.eType == null) {
                this.generateError(13);
                bl = false;
            }
            if (this.validating() && this.wildIDCDepth >= 0) {
                this.idcContext.startIDCStateHistoryContext();
                this.idcContext.processActiveXPaths();
            }
            this.handleSGW(wildcard, this.eType, false, bl);
        }
    }

    private void handleEndElementSimple() {
        ElementType elementType = this.currentState.type;
        if (elementType.all != null) {
            this.endAllElement();
        }
        this.handleEndElementValue(elementType.dv, this.getElementString());
        this.handleIDCOnEnd();
    }

    private void handleEndElementV() {
        if (this.fDFAInfo != null && !this.fDFAInfo.isFinal) {
            this.generateError(6);
        }
        ElementType elementType = this.currentState.type;
        if (elementType.all != null) {
            this.endAllElement();
        }
        if (this.vcValue != null) {
            XMLString xMLString = this.getElementString();
            if (xMLString.length == 0) {
                this.applyElementDefaultValue();
            } else if (this.vcFixed && !xMLString.equals(this.vcValue.actualValue)) {
                this.generateError(29, xMLString.toString(), String.valueOf(this.vcValue.actualValue));
            }
        }
        this.handleIDCOnEnd();
    }

    private void handleIDCOnEnd() {
        block4: {
            ArrayList<EndIDC> arrayList;
            Wildcard wildcard;
            block3: {
                ArrayList<EndIDC> arrayList2;
                Element element = this.currentState.element;
                wildcard = this.currentState.wildcard;
                if (element == null) break block3;
                ArrayList<EndIDC> arrayList3 = arrayList2 = this.nilled ? element.endIDCNil : element.endIDC;
                if (arrayList2 == null) break block4;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList2.get(i).execute(this);
                }
                break block4;
            }
            if (wildcard != null && (arrayList = wildcard.endIDC) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).execute(this);
                }
            }
        }
    }

    private void handleSG(Element element, ElementType elementType, boolean bl) {
        ArrayList<StartIDC> arrayList;
        ArrayList<StartIDC> arrayList2 = arrayList = this.nilled ? element.startIDCNil : element.startIDC;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).execute(this);
            }
        }
        if (bl) {
            ElementType elementType2;
            ArrayList<EndIDC> arrayList3;
            ArrayList<EndIDC> arrayList4 = arrayList3 = this.nilled ? element.endIDCNil : element.endIDC;
            if (arrayList3 != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    arrayList3.get(i).execute(this);
                }
            }
            if ((elementType2 = this.currentState.type) != null) {
                if (elementType2.dfa != null) {
                    this.dfaSubElement(true);
                } else {
                    this.allSubElement();
                }
            }
        } else {
            ElementType elementType3 = this.currentState.type;
            if (elementType3 != null) {
                if (elementType3.dfa != null) {
                    this.dfaSubElement(true);
                } else {
                    this.allSubElement();
                }
            }
            this.push(elementType);
            if (this.nilled) {
                this.setupReadElement(0, null);
            } else if (this.validating()) {
                this.startElementV(elementType);
            } else {
                this.startElementNV(elementType);
            }
        }
    }

    private void handleSGW(Wildcard wildcard, ElementType elementType, boolean bl, boolean bl2) {
        ArrayList<StartIDC> arrayList = wildcard.startIDC;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).execute(this);
            }
        }
        if (bl) {
            ElementType elementType2;
            ArrayList<EndIDC> arrayList2 = wildcard.endIDC;
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList2.get(i).execute(this);
                }
            }
            if ((elementType2 = this.currentState.type) != null) {
                if (elementType2.dfa != null) {
                    this.dfaSubElement(false);
                } else {
                    this.allSubElement();
                }
            }
        } else {
            ElementType elementType3 = this.currentState.type;
            if (elementType3 != null) {
                if (elementType3.dfa != null) {
                    this.dfaSubElement(false);
                } else {
                    this.allSubElement();
                }
            }
            if (bl2) {
                this.push(elementType);
                this.startElementV(elementType);
            } else {
                this.setupSkip();
            }
        }
    }

    private void handleEndElementValue(TypeValidator typeValidator, XMLString xMLString) {
        if (xMLString.length == 0 && this.vcValue != null) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            if (this.validating()) {
                if (this.eType != this.eDecl.type && !this.eDecl.vcSafeTypes.getBit(this.eType.index)) {
                    this.generateError(17, this.vcValue.actualValue.toString());
                } else if (typeValidator.idrefOrEntity && typeValidator.checkIdrefAndEntity(this.vcValue.actualValue, this.dvContext) != 0) {
                    this.generateError(17, this.vcValue.actualValue.toString());
                }
            }
            validatedInfo.copyValues(this.vcValue);
        } else if (!this.isValidated && this.produceActualValues) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            ValidatedInfo validatedInfo2 = this.vcValue != null && this.vcFixed ? this.vcValue : null;
            typeValidator.validate(xMLString, validatedInfo2, this.dvContext, validatedInfo);
            if (this.validating() && validatedInfo.errorCode != 0) {
                this.generateError(16, xMLString);
            }
        }
        this.isValidated = false;
    }

    private void setupNextScanners() {
        ElementType elementType = this.currentState.type;
        if (elementType != null) {
            if (this.validating() && elementType.dfa != null) {
                int n = this.currentState.curState;
                ElementType.DFAState dFAState = elementType.dfa[n];
                this.setupReadElement(elementType.contentType, dFAState);
            } else if (elementType.dv != null) {
                this.setupReadSimple(elementType.dv);
            } else {
                this.setupReadElement(elementType.contentType, elementType.all);
            }
        }
    }

    private void endAllElement() {
        BitSet bitSet = this.currentState.basicAll;
        ElementType.AllContent allContent = this.currentState.type.all;
        if (!(this.currentState.type.allowEmpty && bitSet.isZero() || bitSet.containsSet(allContent.required))) {
            int n = bitSet.getLength();
            for (int i = 0; i < n; ++i) {
                if (!allContent.required.getBit(i) || bitSet.getBit(i)) continue;
                for (int j = 0; j < allContent.indices.length; ++j) {
                    if (allContent.indices[j] != i) continue;
                    this.generateError(15, allContent.elements[j].localName);
                    return;
                }
            }
        }
    }

    private void dfaSubElement(boolean bl) {
        int n;
        ElementType.DFAState dFAState = (ElementType.DFAState)this.fDFAInfo;
        this.currentState.curState = n = bl ? dFAState.estates[this.eDeclIndex] : dFAState.wstates[this.eWCIndex];
    }

    private void allSubElement() {
        ElementType elementType = this.currentState.type;
        int n = elementType.all.indices[this.eDeclIndex];
        if (this.currentState.basicAll.getAndSetBit(n)) {
            this.generateError(14, elementType.all.elements[this.eDeclIndex].localName);
            return;
        }
    }

    private void startElementNV(ElementType elementType) {
        if (elementType.dv != null) {
            this.setupReadSimple(elementType.dv);
        } else {
            this.setupReadElement(elementType.contentType, elementType.all);
        }
    }

    private void startElementV(ElementType elementType) {
        if (elementType.dfa != null) {
            this.currentState.curState = 0;
            ElementType.DFAState dFAState = elementType.dfa[0];
            this.setupReadElement(elementType.contentType, dFAState);
        } else if (elementType.all != null) {
            ElementType.AllContent allContent = elementType.all;
            int n = allContent.elements.length;
            if (this.currentState.basicAll == null) {
                this.currentState.basicAll = new BitSet(n);
            } else {
                this.currentState.basicAll.setLength(n);
            }
            this.setupReadElement(elementType.contentType, allContent);
        } else if (elementType.dv != null) {
            this.setupReadSimple(elementType.dv);
        } else {
            this.setupReadElement(elementType.contentType, null);
        }
    }

    private final Object validateAttribute(Attribute attribute, XMLString xMLString, ValidatedInfo validatedInfo) {
        TypeValidator typeValidator = attribute.type;
        ValidatedInfo validatedInfo2 = attribute.fixed ? attribute.vcValue : null;
        typeValidator.validate(xMLString, validatedInfo2, this.dvContext, validatedInfo);
        if (this.validating() && validatedInfo.errorCode != 0) {
            return null;
        }
        Object object = validatedInfo.actualValue;
        return object;
    }

    private final void processAttributes(ElementType elementType) {
        if (this.resetObjectPools) {
            this.dvContext.resetObjectPools();
        }
        this.nilled = false;
        ElementType elementType2 = elementType;
        Element element = this.eDecl;
        boolean bl = this.validating();
        int n = this.attributeCount();
        if (n > 0 && (bl || element == null || element.xsiTypes != null)) {
            elementType2 = this.resolveType(elementType);
        }
        if (elementType2 == null && element != null) {
            elementType2 = element.type;
        }
        this.eType = elementType2;
        if (elementType2 != null) {
            if (bl && elementType2.isAbstract) {
                this.generateError(18);
            }
            this.attsSpecified.setLength(elementType2.ownedChoices.length);
            if (n > 0) {
                this.validateAttributes(elementType2);
            }
            if (bl && elementType2.required != null && !this.attsSpecified.containsSet(elementType2.required)) {
                for (int i = 0; i < elementType2.ownedChoices.length; ++i) {
                    if (!elementType2.required.getBit(i) || this.attsSpecified.getBit(i)) continue;
                    this.generateError(19, elementType2.ownedChoices[i].localName);
                }
            }
            if (bl && elementType2.wildIDs != null) {
                this.checkWildIDs(elementType2);
            }
            if (elementType2.hasVC != null) {
                this.applyDefaultAttributes(elementType2);
            }
        } else if (n > 0) {
            this.xsitypeIndex = -1;
        }
    }

    private boolean checkWildIDs(ElementType elementType) {
        if (this.attsSpecified.intersectsWith(elementType.wildIDs)) {
            int[] nArray = elementType.wildIDPositions;
            if (elementType.idIndex != -1) {
                String string = "";
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (!this.attsSpecified.getBit(n)) continue;
                    string = elementType.ownedChoices[n].localName;
                    break;
                }
                this.generateError(21, this.elementType.localName, string, elementType.ownedChoices[elementType.idIndex].localName);
                return false;
            }
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (!this.attsSpecified.getBit(n2)) continue;
                if (n == -1) {
                    n = n2;
                    continue;
                }
                this.generateError(20, this.elementType.localName, elementType.ownedChoices[n2].localName, elementType.ownedChoices[n].localName);
                return false;
            }
        }
        return true;
    }

    private void applyDefaultAttributes(ElementType elementType) {
        if (elementType.hasVC != null && !this.attsSpecified.containsSet(elementType.hasVC)) {
            int[] nArray = elementType.vcPositions;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.attsSpecified.getBit(n)) continue;
                Attribute attribute = elementType.ownedChoices[n];
                if (this.validating() && attribute.type.idrefOrEntity && attribute.type.checkIdrefAndEntity(attribute.vcValue.actualValue, this.dvContext) != 0) {
                    this.generateError(17, attribute.vcValue.actualValue.toString());
                    continue;
                }
                this.attsSpecified.setBit(n);
                this.addDefaultSchemaAttribute(attribute, n);
            }
        }
    }

    private void addDefaultSchemaAttribute(Attribute attribute, int n) {
        this.fHasDefaultAttributes = true;
        QName qName = this.currentAttributeName();
        qName.clear();
        qName.nsURI = attribute.nsURI;
        qName.localName = attribute.localName;
        this.setupCurrentAttribute(qName, false);
        this.currentAttributeValue().clear();
        this.currentAttributeActualValue().copyValues(attribute.vcValue);
        this.setAttrDecl(attribute, n, this.attrCount);
        ++this.attrCount;
    }

    private void validateAttributes(ElementType elementType) {
        NamedDeclaration[] namedDeclarationArray = elementType.ownedChoices;
        NamedDeclaration.Entry[] entryArray = elementType.ownedChoicesTable;
        int n = this.attributeCount();
        for (int i = 0; i < n; ++i) {
            if (i == this.xsitypeIndex) {
                this.setAttrDecl(namedDeclarationArray[2], 2, i);
                this.xsitypeIndex = -1;
                continue;
            }
            QName qName = this.attributeName(i);
            int n2 = VMContext.findQNameInChoices(namedDeclarationArray, entryArray, qName);
            if (n2 >= 0) {
                ValidatedInfo validatedInfo;
                XMLString xMLString;
                this.setAttrDecl((Attribute)namedDeclarationArray[n2], n2, i);
                if (3 == n2) {
                    xMLString = this.attributeValue(i);
                    Object object = this.validateAttribute((Attribute)namedDeclarationArray[n2], xMLString, validatedInfo = this.actualAttributeValue(i));
                    if (object != null) {
                        this.nilled = (Boolean)object;
                    }
                    if (!this.validating()) continue;
                    if (validatedInfo.errorCode != 0) {
                        this.generateError(24, xMLString);
                    }
                    if (this.eDecl == null || !this.eDecl.nillable) {
                        this.generateError(22);
                    }
                    if (!this.nilled || this.eDecl == null || !this.eDecl.fixed) continue;
                    this.generateError(23);
                    continue;
                }
                if (!this.produceActualValues) continue;
                this.attsSpecified.setBit(n2);
                xMLString = this.attributeValue(i);
                validatedInfo = this.actualAttributeValue(i);
                this.validateAttribute((Attribute)namedDeclarationArray[n2], xMLString, validatedInfo);
                if (!this.validating() || validatedInfo.errorCode == 0) continue;
                this.generateError(24, xMLString);
                continue;
            }
            if (this.validating() && (elementType.ownedWC == null || !elementType.ownedWC.allows(qName.nsURI))) {
                this.generateError(25, qName.localName);
                this.setAttrDecl(null, -1, i);
                continue;
            }
            this.setAttrDecl(null, Integer.MIN_VALUE, i);
        }
    }

    private ElementType resolveType(ElementType elementType) {
        Object object;
        int n = -1;
        for (int i = 0; i < this.attrCount; ++i) {
            object = this.fAttributeNames[i];
            if (((QName)object).nsURI != XSI_NS || ((QName)object).localName != TYPE) continue;
            n = i;
        }
        this.xsitypeIndex = n;
        if (n == -1) {
            return elementType;
        }
        XMLString xMLString = this.attributeValue(n);
        object = this.actualAttributeValue(n);
        if (this.qnameDV == null) {
            this.qnameDV = this.lookupType((String)XS_NS, (String)QNAME).dv;
        }
        this.qnameDV.validate(xMLString, null, this.dvContext, (ValidatedInfo)object);
        Object object2 = null;
        if (this.validating() && ((ValidatedInfo)object).errorCode != 0) {
            this.generateError(24, xMLString);
        } else {
            object2 = ((ValidatedInfo)object).actualValue;
        }
        if (object2 != null) {
            XQName xQName = (XQName)object2;
            ElementType elementType2 = this.lookupType(xQName.nsURI, xQName.localName);
            if (elementType2 != null) {
                ElementType elementType3;
                ElementType elementType4 = elementType3 = this.eDecl == null ? null : this.eDecl.type;
                if (elementType3 == null || this.eDecl.xsiTypes != null && this.eDecl.xsiTypes.getBit(elementType2.index) || this.eDecl.xsiTypes == null && elementType2 == elementType3) {
                    return elementType2;
                }
                if (this.validating()) {
                    this.generateError(26);
                }
            } else if (this.validating()) {
                this.generateError(27);
            }
        }
        return elementType;
    }

    private ElementType lookupType(String string, String string2) {
        NamedDeclaration[] namedDeclarationArray = this.ir.globalTypes;
        int n = VMContext.findQNameInChoices(namedDeclarationArray, this.ir.globalTypesTable, string, string2);
        if (n != -1) {
            return namedDeclarationArray[n];
        }
        return null;
    }

    static {
        MessageProviderRegistry.register(XS_NS, VMMessagesBundle.class.getName());
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class State {
        public Element element;
        public Wildcard wildcard;
        public ElementType type;
        public State parent;
        public State free;
        public int curState;
        public BitSet basicAll;
        public int[] allAndDFA;
    }
}

