/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UnsignedShortDV
extends TypeValidator {
    private final int totalDigits;
    private final int[] enumeration;
    private final int maxInclusive;
    private final int maxExclusive;
    private final int minInclusive;
    private final int minExclusive;

    public UnsignedShortDV(String string, String string2, String string3, String[] stringArray, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(string, string2, string3, 40, 4, stringArray, UnsignedShortDV.computeDefinedFacets(n6, n, n2, n3, n4), false);
        this.totalDigits = n5;
        this.enumeration = nArray;
        this.maxInclusive = n3;
        this.maxExclusive = n4;
        this.minInclusive = n;
        this.minExclusive = n2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XInt xInt = new XInt(UnsignedShortDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xInt;
            validatedInfo.errorCode = 0;
        }
        return xInt;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        int n = XSIntegerUtil.parseUShort(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            Object object = validatedInfo.actualValue;
            validatedInfo2.errorCode = object instanceof XInt ? (n == ((XInt)validatedInfo.actualValue).value ? 0 : 1) : (object instanceof XLong ? ((long)n == ((XLong)object).value ? 0 : 1) : (object instanceof XDecimal ? (((XDecimal)object).equals(n) ? 0 : 1) : 1));
            validatedInfo2.actualValue = object;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(n, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXInt(n);
    }

    private int checkFacets(int n, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && this.getTotalDigits(n) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && n < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && n <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && n > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && n >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x100) != 0 && n2 <= 0) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x20) != 0 && n4 >= 65535) {
            n &= 0xFFFFFFDF;
        }
        if ((n & 0x80) != 0 && n3 < 0) {
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x40) != 0 && n5 > 65535) {
            n &= 0xFFFFFFBF;
        }
        return n;
    }

    private int getTotalDigits(int n) {
        if (n < 1000) {
            return n < 10 ? 1 : (n < 100 ? 2 : 3);
        }
        return n < 10000 ? 4 : 5;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static int parse(XMLString xMLString) {
        return XSIntegerUtil.parseUShort(xMLString, dummyOneElementArray);
    }
}

