/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDouble;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DoubleDV
extends TypeValidator {
    private final double[] enumeration;
    private final double maxInclusive;
    private final double maxExclusive;
    private final double minInclusive;
    private final double minExclusive;

    public DoubleDV(String string, String string2, String string3, String[] stringArray, double[] dArray, double d, double d2, double d3, double d4, int n) {
        super(string, string2, string3, 6, 6, stringArray, n, false);
        this.enumeration = dArray;
        this.maxInclusive = d3;
        this.maxExclusive = d4;
        this.minInclusive = d;
        this.minExclusive = d2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        double d = DoubleDV.parse(xMLString);
        XDouble xDouble = new XDouble(d);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDouble;
            validatedInfo.errorCode = 0;
        }
        return xDouble;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        double d = DoubleDV.parse(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = ((XDouble)validatedInfo.actualValue).equals(d) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(d, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXDouble(d);
    }

    public int preCheckFacets(double d, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(d, xMLString);
        }
        return 0;
    }

    private int checkFacets(double d, XMLString xMLString) {
        if ((this.definedFacets & 0x100) != 0 && !(d >= this.minInclusive) && !(d != d & this.minInclusive != this.minInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && !(d > this.minExclusive)) {
            return 1;
        }
        if (!((this.definedFacets & 0x20) == 0 || d <= this.maxInclusive || d != d && this.maxInclusive != this.maxInclusive)) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && !(d < this.maxExclusive)) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!XDouble.equals(this.enumeration[i], d)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static double parse(XMLString xMLString) {
        return DoubleDV.parse(xMLString, dummyOneElementArray);
    }

    public static double parse(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0.0;
        }
        if (xMLString.bytes != null) {
            return DoubleDV.parseDoubleUnbuffered(xMLString, nArray);
        }
        return DoubleDV.parseDoubleBuffered(xMLString, nArray);
    }

    private static double parseDoubleBuffered(XMLString xMLString, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (by == 78) {
            while (true) {
                if (++n < n2) break;
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0.0;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by = dataBuffer.bytes[n];
            if (by == 97) {
                while (true) {
                    if (++n < n2) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by = dataBuffer.bytes[n];
                if (by == 78) {
                    while (true) {
                        if (++n < n2) {
                            by = dataBuffer.bytes[n];
                            break;
                        }
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if (by <= 32) {
                        while (true) {
                            if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                                by = dataBuffer.bytes[n];
                                continue;
                            }
                            if (n != n2 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n];
                        }
                    }
                    if (n < n2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    return Double.NaN;
                }
            }
            nArray[0] = 1;
            return 0.0;
        }
        boolean bl = false;
        if (by == 45 || by == 73) {
            boolean bl2 = bl = by == 45;
            if (bl) {
                while (true) {
                    if (++n < n2) {
                        by = dataBuffer.bytes[n];
                        break;
                    }
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
            }
            if (by == 73) {
                while (true) {
                    if (++n < n2) break;
                    if (dataBuffer == dataBuffer2) {
                        nArray[0] = 1;
                        return 0.0;
                    }
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                by = dataBuffer.bytes[n];
                if (by == 78) {
                    while (true) {
                        if (++n < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n];
                    if (by == 70) {
                        while (true) {
                            if (++n < n2) {
                                by = dataBuffer.bytes[n];
                                break;
                            }
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset - 1;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                        }
                        if (by <= 32) {
                            while (true) {
                                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                                    by = dataBuffer.bytes[n];
                                    continue;
                                }
                                if (n != n2 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n = dataBuffer.startOffset;
                                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by = dataBuffer.bytes[n];
                            }
                        }
                        if (n < n2) {
                            nArray[0] = 1;
                            return 0.0;
                        }
                        return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                }
                nArray[0] = 1;
                return 0.0;
            }
        }
        StringBuilder stringBuilder = new StringBuilder((n2 - n) * 2);
        if (by >= 48 && by <= 57 || by == 46) {
            stringBuilder.append((char)by);
            while (true) {
                if (++n < n2) {
                    by = dataBuffer.bytes[n];
                    if ((by >= 48 && by <= 57 || by == 46 || by == 69 || by == 101 || by == 43 || by == 45) && by != 32 && by != 10 && by != 9 && by != 13) {
                        stringBuilder.append((char)by);
                        continue;
                    }
                    if (by == 32 || by == 10 || by == 9 || by == 13) break;
                    nArray[0] = 1;
                    return 0.0;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                nArray[0] = 1;
                return 0.0;
            }
            try {
                double d = Double.parseDouble(stringBuilder.toString());
                return bl ? -d : d;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                return 0.0;
            }
        }
        nArray[0] = 1;
        return 0.0;
    }

    private static double parseDoubleUnbuffered(XMLString xMLString, int[] nArray) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        byte by = xMLString.bytes[n];
        int n3 = n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2);
        if (by == 78 && n + 2 <= n2 && xMLString.bytes[++n] == 97 && xMLString.bytes[++n] == 78) {
            if (++n < n2 && (n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.NaN;
        }
        if (by == 73 && n + 2 <= n2 && xMLString.bytes[++n] == 78 && xMLString.bytes[++n] == 70) {
            if (++n < n2 && (n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                nArray[0] = 1;
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (by == 45 && xMLString.bytes[n + 1] == 73 && ++n + 2 <= n2 && xMLString.bytes[++n] == 78 && xMLString.bytes[++n] == 70) {
            if (++n < n2) {
                by = xMLString.bytes[n];
                if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                    nArray[0] = 1;
                    return 0.0;
                }
            }
            return Double.NEGATIVE_INFINITY;
        }
        while (n < n2) {
            if (((by = xMLString.bytes[n++]) < 48 || by > 57) && by != 46 && by != 69 && by != 101 && by != 43 && by != 45 && by != 32 && by != 10 && by != 9 && by != 13) {
                nArray[0] = 1;
                return 0.0;
            }
            if (by != 32 && by != 10 && by != 9 && by != 13) continue;
        }
        int n4 = n;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
            nArray[0] = 1;
            return 0.0;
        }
        try {
            double d = Double.parseDouble(new String(xMLString.bytes, n3, n4 - n3, "UTF-8"));
            return d;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            nArray[0] = 1;
            return 0.0;
        }
    }

    private int parseDoubleUnbuffered(ParsedEntity parsedEntity, XDouble xDouble, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = DoubleDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        byte by = byArray[n];
        if (by == 78 && n + 2 < n2 && byArray[++n] == 97 && byArray[++n] == 78) {
            ++n;
            if ((n = DoubleDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xDouble.value = Double.NaN;
            return n;
        }
        if (by == 73 && n + 2 < n2 && byArray[++n] == 78 && byArray[++n] == 70) {
            ++n;
            if ((n = DoubleDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xDouble.value = Double.POSITIVE_INFINITY;
            return n;
        }
        if (by == 45 && n + 3 < n2 && byArray[n + 1] == 73 && byArray[n += 2] == 78 && byArray[++n] == 70) {
            ++n;
            if ((n = DoubleDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xDouble.value = Double.NEGATIVE_INFINITY;
            return n;
        }
        int n3 = n;
        while ((by >= 48 && by <= 57 || by == 46 || by == 69 || by == 101 || by == 43 || by == 45) && ++n < n2) {
            by = byArray[n];
        }
        int n4 = n;
        if ((n = DoubleDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        try {
            xDouble.value = Double.parseDouble(new String(byArray, n3, n4 - n3, "UTF-8"));
            return n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: UTF-8 not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDouble xDouble = vMContext.dvContext.getXDouble(0.0);
        int n = this.parseDoubleUnbuffered(parsedEntity, xDouble, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xDouble;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets(((XDouble)object).value, xMLString);
    }
}

