/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ImmutableArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final ImmutableArrayList<?> EMPTY_LIST = new ImmutableArrayList<Object>(EMPTY_ARRAY, 0);
    private static final ListIterator<Object> EMPTY_ITERATOR = new ListIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    };
    private final E[] fArray;
    private final int fLength;

    public ImmutableArrayList(E[] EArray, int n) {
        this.fArray = EArray;
        this.fLength = n;
    }

    public static <E> List<E> emptyList() {
        return EMPTY_LIST;
    }

    @Override
    public boolean contains(Object object) {
        return object == null ? this.containsNull() : this.containsObject(object);
    }

    @Override
    public E get(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fArray[n];
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator0(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator0(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.listIterator0(n);
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    @Override
    public int size() {
        return this.fLength;
    }

    @Override
    public E[] toArray() {
        Object[] objectArray = ArrayAllocator.newObjectArray(this.fLength);
        if (this.fLength > 0) {
            System.arraycopy(this.fArray, 0, objectArray, 0, this.fLength);
        }
        return objectArray;
    }

    private ListIterator<E> listIterator0(int n) {
        return this.fLength == 0 ? EMPTY_ITERATOR : new ImmutableArrayListIterator(n);
    }

    private boolean containsObject(Object object) {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (!object.equals(this.fArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean containsNull() {
        for (int i = this.fLength - 1; i >= 0; --i) {
            if (this.fArray[i] != null) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class ImmutableArrayListIterator
    implements ListIterator<E> {
        int index;

        public ImmutableArrayListIterator(int n) {
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < ImmutableArrayList.this.fLength;
        }

        @Override
        public E next() {
            if (this.index < ImmutableArrayList.this.fLength) {
                return ImmutableArrayList.this.fArray[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            if (this.index > 0) {
                return ImmutableArrayList.this.fArray[--this.index];
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

