/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.javasrc;

import com.ibm.fcg.FcgArrayType;
import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.fcg.ifacecore.FcgVarMutableInternal;
import com.ibm.fcg.impl.FinalCodeGenerator;
import com.ibm.fcg.javasrc.FcgClassGenJavaSrc;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class FcgInstructionListJavaSrc
extends FinalCodeGenerator
implements FcgInstructionList {
    protected final FcgClassGen m_classGen;
    protected final StringBuffer m_code = new StringBuffer();
    private String _classname;
    protected boolean m_staticContext = false;
    protected final HashMap m_operatorMapsToMethod = new HashMap();
    protected final StringBuffer m_debugBuf;
    protected boolean m_atStartOfLine = true;
    protected boolean m_useParentIndentLevel = false;
    HashMap m_Name2Type = new HashMap();

    public FcgInstructionListJavaSrc(FcgClassGenJavaSrc fcgClassGenJavaSrc) {
        super(fcgClassGenJavaSrc);
        this.m_debugBuf = new StringBuffer();
        this.m_classGen = fcgClassGenJavaSrc;
    }

    public FcgInstructionListJavaSrc(FcgClassGenJavaSrc fcgClassGenJavaSrc, FcgMethodGen fcgMethodGen) {
        super(fcgClassGenJavaSrc, fcgMethodGen);
        this.m_debugBuf = new StringBuffer();
        this.m_classGen = fcgClassGenJavaSrc;
    }

    private FcgInstructionListJavaSrc() {
        super(null);
        this.m_debugBuf = null;
        this.m_classGen = null;
    }

    protected void genCode_comment(String string) {
        boolean bl = false;
        this.print(this.m_code, "/*");
        if (string != null) {
            char[] cArray = string.toCharArray();
            block4: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (c) {
                    case '*': {
                        if (i + 1 >= cArray.length || cArray[i + 1] != '/') continue block4;
                        this.print(this.m_code, '@');
                        continue block4;
                    }
                    case '\n': {
                        this.println(this.m_code, "");
                        bl = true;
                        this.print(this.m_code, " * ");
                        continue block4;
                    }
                    default: {
                        this.print(this.m_code, c);
                    }
                }
            }
            if (bl) {
                this.println(this.m_code, "");
                this.print(this.m_code, " ");
            }
        } else {
            this.print(this.m_code, ' ');
        }
        this.println(this.m_code, "*/");
    }

    protected final void genCode_defineLocalVariable(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable, FinalCodeGenerator.StackValue stackValue2) {
        FcgAttrs fcgAttrs = fcgVariable.getAttrs();
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.NONE;
        }
        String string = fcgVariable.getName();
        FcgType fcgType = fcgVariable.getType();
        this.print(this.m_code, ((FcgClassGenJavaSrc)this.m_classGen).createDeclaration(string, fcgAttrs, fcgType));
        if (stackValue2 != null) {
            this.print(this.m_code, " = ");
            this.print(this.m_code, stackValue2.getCodeData());
        }
        this.println(this.m_code, ';');
    }

    protected final void genCode_undefineLocalVariable(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable) {
    }

    protected void genCode_printOut(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "System.out.println(");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ");");
    }

    protected void genCode_printErr(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "System.err.println(");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ");");
        this.println(this.m_code, "System.err.flush();");
    }

    protected void genCode_endMethod(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
    }

    protected void genCode_endClass(FinalCodeGenerator.StackValue stackValue) {
    }

    protected Object genCode_loadInstanceField(FinalCodeGenerator.StackValue stackValue, FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType) {
        String string2 = (String)stackValue.getCodeData();
        String string3 = "this".equals(string2) ? "this." + string : "(" + string2 + ")." + string;
        return string3;
    }

    protected Object genCode_loadClassVariable(String string, String string2, FcgType fcgType) {
        String string3 = string + '.' + string2;
        return string3;
    }

    protected Object genCode_loadThis() {
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && this.m_staticContext) {
            String string = "Cannot use 'this' in a static context.";
            FcgInstructionListJavaSrc.error(string);
        }
        return "this";
    }

    protected Object genCode_loadNull() {
        return "null";
    }

    protected Object genCode_loadFromArrayElement(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        return "(" + stackValue.getCodeData() + ")[" + stackValue2.getCodeData() + ']';
    }

    protected Object genCode_loadLiteralValue(boolean bl) {
        return bl ? "true" : "false";
    }

    protected Object genCode_loadLiteralValue(long l) {
        String string = l < 0L ? "(" + Long.toString(l) + "l)" : Long.toString(l) + 'l';
        return string;
    }

    protected Object genCode_loadLiteralValue(int n) {
        String string = n < 0 ? "(" + Integer.toString(n) + ')' : Integer.toString(n);
        return string;
    }

    protected final Object genCode_loadLiteralValue(short s) {
        String string = "((short)" + Short.toString(s) + ")";
        return string;
    }

    protected final Object genCode_loadLiteralValue(byte by) {
        String string = "((byte)" + Byte.toString(by) + ")";
        return string;
    }

    protected Object genCode_loadLiteralValue(char c) {
        return "'" + FcgInstructionListJavaSrc.escape(String.valueOf(c)) + '\'';
    }

    protected Object genCode_loadLiteralValue(String string) {
        string = FcgInstructionListJavaSrc.escape(string);
        return "\"" + string + '\"';
    }

    private static String escape(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = null;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c != '\b' && c != '\t' && c != '\n' && c != '\f' && c != '\r' && c != '\\' && c != '\'' && c != '\"' && c < '\u0080') continue;
            stringBuffer = new StringBuffer(string.substring(0, n));
            break;
        }
        if (n < string.length()) {
            while (n < string.length()) {
                c = string.charAt(n);
                switch (c) {
                    case '\b': {
                        stringBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        break;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        break;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        break;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("\\'");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        break;
                    }
                    default: {
                        if (c >= '\u0080') {
                            String string2 = Integer.toHexString(c);
                            stringBuffer.append("\\u");
                            stringBuffer.append("000".substring(string2.length() - 1));
                            stringBuffer.append(string2);
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
                ++n;
            }
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    protected Object genCode_loadLiteralValue(float f) {
        String string;
        if (Float.isNaN(f)) {
            string = "Float.NaN";
        } else if (f == Float.POSITIVE_INFINITY) {
            string = "Float.POSITIVE_INFINITY";
        } else if (f == Float.NEGATIVE_INFINITY) {
            string = "Float.NEGATIVE_INFINITY";
        } else if (f < 0.0f) {
            string = '(' + Float.toString(f) + "f)";
        } else {
            string = Float.toString(f);
            string = string + 'f';
        }
        return string;
    }

    protected Object genCode_loadLiteralValue(double d) {
        String string = Double.isNaN(d) ? "Double.NaN" : (d == Double.POSITIVE_INFINITY ? "Double.POSITIVE_INFINITY" : (d == Double.NEGATIVE_INFINITY ? "Double.NEGATIVE_INFINITY" : (d < 0.0 ? '(' + Double.toString(d) + "d)" : Double.toString(d) + 'd')));
        return string;
    }

    private String prepareArgumentList(FinalCodeGenerator.StackValue[] stackValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (stackValueArray != null && stackValueArray.length > 0) {
            stringBuffer.append(stackValueArray[0].getCodeData());
            for (int i = 1; i < stackValueArray.length; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(stackValueArray[i].getCodeData());
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected Object genCode_storeLocalVariableExpr(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable, FinalCodeGenerator.StackValue stackValue2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(fcgVariable.getName()).append(" = ").append(stackValue2.getCodeData()).append(')');
        String string = stringBuffer.toString();
        return string;
    }

    protected void genCode_storeAt(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FinalCodeGenerator.StackValue stackValue3) {
        this.print(this.m_code, stackValue2.getCodeData());
        this.print(this.m_code, '=');
        this.print(this.m_code, stackValue3.getCodeData());
        this.println(this.m_code, ';');
    }

    protected Object genCode_startConditionalLoop(String string, FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        if (string == null) {
            string = "loop" + ++this.m_loopCount;
        }
        this.print(this.m_code, string);
        this.print(this.m_code, ": for (;");
        if (stackValue == null) {
            this.print(this.m_code, "true;");
        } else {
            this.print(this.m_code, stackValue.getCodeData());
            this.print(this.m_code, ';');
        }
        if (stackValue2 != null) {
            this.print(this.m_code, stackValue2.getCodeData());
        }
        this.println(this.m_code, ") {");
        return string;
    }

    protected void genCode_endLoop(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.println(this.m_code, '}');
    }

    protected void genCode_breakFromLoop(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "break ");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ';');
    }

    protected void genCode_nextIterationOfLoop(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "if (true) {");
        this.print(this.m_code, "continue ");
        this.print(this.m_code, stackValue2.getCodeData());
        this.print(this.m_code, ';');
        this.println(this.m_code, "}");
    }

    protected Object genCode_beginChoice(FinalCodeGenerator.StackValue stackValue) {
        this.print(this.m_code, "switch (");
        this.print(this.m_code, stackValue.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    protected Object genCode_beginChoiceBlock(char c, FinalCodeGenerator.StackValue stackValue) {
        this.print(this.m_code, "case ");
        this.print(this.m_code, this.genCode_loadLiteralValue(c));
        this.println(this.m_code, ": {");
        return null;
    }

    protected Object genCode_beginChoiceBlock(int n, FinalCodeGenerator.StackValue stackValue) {
        this.print(this.m_code, "case ");
        this.print(this.m_code, n);
        this.println(this.m_code, ": {");
        return null;
    }

    protected Object genCode_beginChoiceBlockDefault(FinalCodeGenerator.StackValue stackValue) {
        this.println(this.m_code, "default: {");
        return null;
    }

    protected Object genCode_endChoiceBlock(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, boolean bl) {
        if (bl) {
            this.println(this.m_code, "  break;");
        }
        this.println(this.m_code, '}');
        return null;
    }

    protected void genCode_endChoice(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.println(this.m_code, '}');
    }

    public final Object genCode_BINARY_LOGICAL_CONDITIONAL_OR(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "||" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_LOGICAL_CONDITIONAL_AND(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "&&" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_LOGICAL_XOR(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "^" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_LOGICAL_OR_EVALBOTH(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "|" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_LOGICAL_AND_EVALBOTH(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "&" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_ORDER_PRIMITIVE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2, int n) {
        String string;
        switch (n) {
            case 153: {
                string = "<";
                break;
            }
            case 154: {
                string = "<=";
                break;
            }
            case 155: {
                string = ">";
                break;
            }
            case 156: {
                string = ">=";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue.getCodeData();
        String string4 = "(" + string3 + string + string2 + ')';
        return string4;
    }

    public final Object genCode_BINARY_COMPARE_ORDER_STRING(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, int n) {
        String string;
        switch (n) {
            case 153: {
                string = "<";
                break;
            }
            case 154: {
                string = "<=";
                break;
            }
            case 155: {
                string = ">";
                break;
            }
            case 156: {
                string = ">=";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue.getCodeData();
        String string4 = "((" + string3 + ").compareTo(" + string2 + ")" + string + " 0)";
        return string4;
    }

    public final Object genCode_BINARY_COMPARE_ORDER_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2, int n) {
        String string;
        switch (n) {
            case 153: {
                string = "<";
                break;
            }
            case 154: {
                string = "<=";
                break;
            }
            case 155: {
                string = ">";
                break;
            }
            case 156: {
                string = ">=";
                break;
            }
            default: {
                string = null;
            }
        }
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue.getCodeData();
        String string4 = "((" + string3 + ").compareTo(" + string2 + ")" + string + " 0)";
        return string4;
    }

    public final Object genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "!=" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "!=" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_NOT_EQ_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "((" + string2 + ").compareTo(" + string + ") != 0)";
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_NOT_EQ_STRING(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "((" + string2 + ").equals(" + string + ") == false)";
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_EQ_PRIMITIVE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "==" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_EQ_REFERENCE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "==" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_EQ_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "((" + string2 + ").compareTo(" + string + ") == 0)";
        return string3;
    }

    public final Object genCode_BINARY_COMPARE_EQ_STRING(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, FcgType fcgType2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "((" + string2 + ").equals(" + string + "))";
        return string3;
    }

    public final Object genCode_BINARY_BITWISE_XOR(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "^" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_BITWISE_XOR_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").xor(" + string + ")";
        return string3;
    }

    public final Object genCode_BINARY_BITWISE_OR(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string;
        if (fcgType == FcgType.BIG_INTEGER) {
            String string2 = (String)stackValue2.getCodeData();
            String string3 = (String)stackValue.getCodeData();
            string = "(" + string3 + ").or(" + string2 + ")";
        } else {
            String string4 = (String)stackValue2.getCodeData();
            String string5 = (String)stackValue.getCodeData();
            string = "(" + string5 + "|" + string4 + ')';
        }
        return string;
    }

    public final Object genCode_BINARY_BITWISE_AND(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string;
        if (fcgType == FcgType.BIG_INTEGER) {
            String string2 = (String)stackValue2.getCodeData();
            String string3 = (String)stackValue.getCodeData();
            string = "(" + string3 + ").and(" + string2 + ")";
        } else {
            String string4 = (String)stackValue2.getCodeData();
            String string5 = (String)stackValue.getCodeData();
            string = "(" + string5 + "&" + string4 + ')';
        }
        return string;
    }

    public final Object genCode_BINARY_SHIFT_RIGHT_UNSIGNED(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ">>>" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_SHIFT_RIGHT(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ">>" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_SHIFT_LEFT(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + "<<" + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_MODULO(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '%' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_MODULO_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").mod(" + string + ")";
        return string3;
    }

    public final Object genCode_BINARY_DIVIDE(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '/' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_DIVIDE_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").divide(" + string + ")";
        return string3;
    }

    public final Object genCode_BINARY_MULTIPLY_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").multiply(" + string + ")";
        return string3;
    }

    public final Object genCode_BINARY_MULTIPLY(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '*' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_SUBTRACT(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '-' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_SUBTRACT_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").subtract(" + string + ")";
        return string3;
    }

    public final Object genCode_BINARY_ADD_STRING(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '+' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_ADD(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgType fcgType, int n) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + '+' + string + ')';
        return string3;
    }

    public final Object genCode_BINARY_ADD_BIG(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        String string = (String)stackValue2.getCodeData();
        String string2 = (String)stackValue.getCodeData();
        String string3 = "(" + string2 + ").add(" + string + ")";
        return string3;
    }

    protected Object genCode_createArray(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(fcgType);
        String string2 = null;
        if (fcgType instanceof FcgArrayType) {
            int n = string.indexOf(91);
            string2 = "new " + string.substring(0, n) + '[' + stackValue.getCodeData() + ']' + string.substring(n);
        } else {
            string2 = "new " + string + '[' + stackValue.getCodeData() + ']';
        }
        return string2;
    }

    protected Object genCode_createArray(FcgType fcgType, FinalCodeGenerator.StackValue[] stackValueArray) {
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(fcgType));
        stringBuffer.append("[] {");
        for (int i = 0; i < stackValueArray.length; ++i) {
            stringBuffer.append(stackValueArray[i].getCodeData());
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected final Object genCode_createObject(FcgType fcgType, FinalCodeGenerator.StackValue[] stackValueArray, FcgType[] fcgTypeArray) {
        String string = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(fcgType);
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(string);
        stringBuffer.append(this.prepareArgumentList(stackValueArray));
        return stringBuffer.toString();
    }

    protected Object genCode_beginIf(FinalCodeGenerator.StackValue stackValue) {
        this.print(this.m_code, "if (");
        this.print(this.m_code, stackValue.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    protected Object genCode_elseIf(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "} else if (");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    protected Object genCode_beginElse(FinalCodeGenerator.StackValue stackValue) {
        this.useParentIndentLevel();
        this.println(this.m_code, "  } else {");
        return null;
    }

    protected void genCode_endIf(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.println(this.m_code, '}');
    }

    protected void genCode_returnInstruction(FinalCodeGenerator.StackValue stackValue) {
        this.println(this.m_code, "return;");
    }

    protected void genCode_returnInstruction(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "return ");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ';');
    }

    protected void print(StringBuffer stringBuffer, String string) {
        if (this.m_atStartOfLine) {
            this.m_atStartOfLine = false;
            int n = 2 + this.getActiveNonValueConstructsCount();
            if (this.m_useParentIndentLevel) {
                --n;
                this.m_useParentIndentLevel = false;
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("  ");
                this.m_debugBuf.append("  ");
            }
        }
        stringBuffer.append(string);
        this.m_debugBuf.append(string);
        this.stop_debugger();
    }

    protected void print(StringBuffer stringBuffer, Object object) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        }
        stringBuffer.append(object.toString());
        this.m_debugBuf.append(object);
        this.stop_debugger();
    }

    protected void print(StringBuffer stringBuffer, char c) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        } else if (c == '\n') {
            this.m_atStartOfLine = true;
        }
        stringBuffer.append(c);
        this.m_debugBuf.append(c);
        this.stop_debugger();
    }

    protected void println(StringBuffer stringBuffer, char c) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        }
        stringBuffer.append(c);
        stringBuffer.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(c).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void println(StringBuffer stringBuffer, String string) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        }
        stringBuffer.append(string);
        stringBuffer.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(string).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void println(StringBuffer stringBuffer, Object object) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        }
        stringBuffer.append(object.toString());
        stringBuffer.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(object).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void print(StringBuffer stringBuffer, int n) {
        if (this.m_atStartOfLine) {
            this.print(stringBuffer, "");
        }
        stringBuffer.append(n);
        this.m_debugBuf.append(n);
        this.stop_debugger();
    }

    private void useParentIndentLevel() {
        this.m_useParentIndentLevel = true;
    }

    private void unimplemented(String string) {
        FcgInstructionListJavaSrc.error(string);
    }

    protected final Object genCode_invokeMethod(boolean bl, boolean bl2, boolean bl3, FinalCodeGenerator.StackValue stackValue, String string, String string2, FinalCodeGenerator.StackValue[] stackValueArray, FcgType fcgType, FcgType[] fcgTypeArray) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string3 = stackValue.getCodeData().toString();
            if ("this".equals(string3)) {
                stringBuffer.append("this.");
            } else {
                stringBuffer.append('(').append(string3).append(").");
            }
        } else {
            stringBuffer.append(string).append('.');
        }
        stringBuffer.append(string2).append(this.prepareArgumentList(stackValueArray));
        if (!bl3) {
            stringBuffer.append(';');
            this.println(this.m_code, stringBuffer.toString());
            string3 = null;
        } else {
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    private void stop_debugger() {
        StringBuffer stringBuffer = this.m_debugBuf;
    }

    protected void genCode_throwObject(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, "throw (");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ");");
    }

    protected final void genCode_invokeSuper(FcgClassReferenceType fcgClassReferenceType, FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue[] stackValueArray) {
        this.print(this.m_code, "super(");
        for (int i = 0; i < stackValueArray.length; ++i) {
            this.print(this.m_code, stackValueArray[i].getCodeData());
            if (i + 1 >= stackValueArray.length) continue;
            this.print(this.m_code, ',');
        }
        this.println(this.m_code, ");");
    }

    StringBuffer getCode() {
        return this.m_code;
    }

    protected void genCode_storeInstanceVariableStmt(FinalCodeGenerator.StackValue stackValue, String string, String string2, FcgType fcgType, FinalCodeGenerator.StackValue stackValue2) {
        this.print(this.m_code, (String)stackValue.getCodeData());
        this.print(this.m_code, '.');
        this.print(this.m_code, string2);
        this.print(this.m_code, " = ");
        this.print(this.m_code, (String)stackValue2.getCodeData());
        this.println(this.m_code, ';');
    }

    protected final void genCode_storeLocalVariableStmt(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable, FinalCodeGenerator.StackValue stackValue2) {
        String string = stackValue2.getCodeData().toString();
        if (string.equals("\"___unreachableTailRecursionReturnValue_doNotAssign___\"")) {
            return;
        }
        this.print(this.m_code, fcgVariable.getName());
        this.print(this.m_code, " = ");
        this.print(this.m_code, stackValue2.getCodeData());
        this.println(this.m_code, ';');
    }

    protected void genCode_beginMethod(FcgMethodGen fcgMethodGen) {
    }

    public final FcgClassGen getFcgClassGen() {
        return this.m_classGen;
    }

    public void setStaticContext(boolean bl) {
        this.m_staticContext = bl;
    }

    public final boolean isClassContext() {
        return this.m_staticContext;
    }

    protected Object genCode_beginTryBlock() {
        this.println(this.m_code, "try {");
        return null;
    }

    public Object genCode_beginCatchBlock(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FcgVariable fcgVariable) {
        this.println(this.m_code, "} catch(" + fcgVariable.getType().getTypeName() + ' ' + fcgVariable.getName() + ") {");
        return null;
    }

    protected void genCode_endTry(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.println(this.m_code, '}');
    }

    protected Object genCode_loadClassRef(String string) {
        return string;
    }

    protected Object genCode_loadLiteralValue(Character c) {
        char c2 = c.charValue();
        String string = "new Character('" + FcgInstructionListJavaSrc.escape(String.valueOf(c2)) + "')";
        return string;
    }

    protected Object genCode_loadLiteralValue(Boolean bl) {
        String string = bl != false ? "java.lang.Boolean.TRUE" : "java.lang.Boolean.FALSE";
        return string;
    }

    protected Object genCode_arrayLengthExpr(FinalCodeGenerator.StackValue stackValue) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)stackValue.getCodeData();
        stringBuffer.append('(').append(string).append(')').append(".length");
        return stringBuffer.toString();
    }

    protected void genCode_storeArrayElemStmt(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FinalCodeGenerator.StackValue stackValue3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)stackValue.getCodeData();
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue3.getCodeData();
        stringBuffer.append(string).append('[').append(string2).append(']');
        stringBuffer.append(" = ").append(string3).append(';');
        this.println(this.m_code, stringBuffer);
    }

    public String toString() {
        String string = super.toString();
        int n = this.m_code.toString().length();
        int n2 = n - 9950 + string.length();
        if (n2 < 0) {
            n2 = 0;
        }
        string = string + "CODE CURRENTLY IN THIS INSTRUCTION LIST:\n" + this.m_code.toString().substring(n2);
        return string;
    }

    protected void genCode_storeStaticFieldStmt(String string, FcgType fcgType, String string2, FinalCodeGenerator.StackValue stackValue) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)stackValue.getCodeData();
        stringBuffer.append(string).append('.').append(string2).append(" = ").append(string3).append(';');
        this.println(this.m_code, stringBuffer);
    }

    protected void genCode_fillStmt(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FinalCodeGenerator.StackValue stackValue3, FinalCodeGenerator.StackValue stackValue4) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)stackValue.getCodeData();
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue3.getCodeData();
        String string4 = (String)stackValue4.getCodeData();
        stringBuffer.append("java.util.Arrays.fill(" + string + ',' + string2 + ',' + string3 + ',' + string4 + ");");
        this.println(this.m_code, stringBuffer);
    }

    protected void genCode_streamElemCopyStmt(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2, FinalCodeGenerator.StackValue stackValue3, FinalCodeGenerator.StackValue stackValue4, FinalCodeGenerator.StackValue stackValue5) {
        String string = (String)stackValue.getCodeData();
        String string2 = (String)stackValue2.getCodeData();
        String string3 = (String)stackValue3.getCodeData();
        String string4 = (String)stackValue4.getCodeData();
        String string5 = (String)stackValue5.getCodeData();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java.lang.System.arraycopy(").append(string).append(',').append(string2);
        stringBuffer.append(',').append(string3).append(',').append(string4);
        stringBuffer.append(',').append(string5).append(");");
        String string6 = stringBuffer.toString();
        this.println(this.m_code, string6);
    }

    public final boolean isEmpty() {
        boolean bl = this.m_code.length() <= 0;
        return bl;
    }

    public final Object genCode_createInnerClass(FcgType fcgType, FinalCodeGenerator.StackValue[] stackValueArray, FcgClassGen fcgClassGen) {
        String string = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(fcgType);
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(string);
        stringBuffer.append(this.prepareArgumentList(stackValueArray));
        try {
            StringWriter stringWriter = new StringWriter();
            ((FcgClassGenJavaSrc)fcgClassGen).dumpContents(stringWriter);
            stringBuffer.append(stringWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public final FcgVarMutableInternal newFcgVariable() {
        return new LocalVarRecord();
    }

    protected final void genCode_beginScopeBlock() {
        this.println(this.m_code, "{");
    }

    protected final void genCode_endScopeBlock(FinalCodeGenerator.StackValue stackValue, FinalCodeGenerator.StackValue stackValue2) {
        this.println(this.m_code, '}');
    }

    protected final Object genCode_runtimeTypeCheck(FinalCodeGenerator.StackValue stackValue, FcgReferenceType fcgReferenceType) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)stackValue.getCodeData();
        stringBuffer.append('(').append(string).append(" instanceof ").append(fcgReferenceType.getTypeName()).append(')');
        return stringBuffer.toString();
    }

    protected Object genCode_loadLiteralValue(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        String string = "new java.math.BigDecimal(" + d + ")";
        return string;
    }

    protected Object genCode_loadLiteralValue(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        String string = "" + l;
        String string2 = "new java.math.BigDecimal(" + string + ")";
        return string2;
    }

    public final Object genCode_UNARY_ABS_BIG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = string + ".abs()";
        return string2;
    }

    public final Object genCode_UNARY_ABS_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.abs(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ABS_FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.abs(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ABS_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.abs(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ABS_LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.abs(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ARRAY_LENGTH_ARRAY(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = string + ".length";
        return string2;
    }

    public final Object genCode_UNARY_ARRAY_LENGTH_STRING(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = string + ".length()";
        return string2;
    }

    public final Object genCode_UNARY_BITWISE_NOT_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(~" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_BITWISE_NOT_LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(~" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_CEILING_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.ceil(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_CEILING_FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.ceil(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_CEILING_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.ceil(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_CEILING_LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.ceil(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_FLOOR_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.floor(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_FLOOR_FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.floor(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_FLOOR_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.floor(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_FLOOR_LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.floor(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_IS_NAN__FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Float.isNaN(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_IS_NAN__LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Double.isNaN((double)" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_IS_NAN_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Double.isNaN((double)" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_IS_NAN_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Double.isNaN((double)" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_LOGICAL_NOT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(!" + string + ')';
        return string2;
    }

    public final Object gencode_UNARY_NEGATE_BIG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = string + ".negate()";
        return string2;
    }

    public final Object genCode_UNARY_NEGATE_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(-" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_NEGATE_FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(-" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_NEGATE_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(-" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_NEGATE_LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(-" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ROUND_BIG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "new java.math.BigDecimal(java.lang.Math.round( (" + string + ").doubleValue() ))";
        return string2;
    }

    public final Object genCode_UNARY_ROUND_DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.round(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ROUND_FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.round(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_ROUND_INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Math.round(" + string + ')';
        return string2;
    }

    public final Object genCode_UNARY_TO_CHAR_ARRAY_STRING(FinalCodeGenerator.StackValue stackValue, FcgType fcgType) {
        String string = (String)stackValue.getCodeData();
        String string2 = string + ".toCharArray()";
        return string2;
    }

    public final Object genCode_COERCE_2REFERENCE_TYPE(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((" + fcgType.getTypeName() + ')' + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_2REFERENCE_TYPE2(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((" + fcgType.getTypeName() + ')' + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2BOOLEAN(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".longValue() != 0)";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2BYTE(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((byte)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2CHAR(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((char)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2DOUBLE(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".doubleValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2LONG(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".longValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2BOOLEAN(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".longValue() != 0)";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2BYTE(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((byte)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2CHAR(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((char)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2DOUBLE(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".doubleValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2FLOAT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".floatValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2INT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".intValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2LONG(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".longValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_INTEGER2SHORT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (byte)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (int)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (float)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (long)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BOOLEAN2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short)(" + string + " ? 1 : 0))";
        return string2;
    }

    public final Object genCode_COERCE_BYTE2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + " != 0)";
        return string2;
    }

    public final Object genCode_COERCE_BYTE2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_BYTE2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_BYTE2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_BYTE2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_BYTE2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.String.valueOf(" + string + ").equals(\"true\")";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((byte)java.lang.Integer.parseInt(java.lang.String.valueOf(" + string + ")))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Double.parseDouble(java.lang.String.valueOf(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Float.parseFloat(java.lang.String.valueOf(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Integer.parseInt(java.lang.String.valueOf(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Long.parseLong(java.lang.String.valueOf(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.Short.parseShort(java.lang.String.valueOf(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_CHAR_ARRAY2STRING(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "java.lang.String.valueOf(" + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_CHAR2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2BIG_DECIMAL(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(new java.math.BigDecimal(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + "!=0 && !java.lang.Double.isNaN(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((int) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_DOUBLE2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2BIG_DECIMAL(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( new java.math.BigDecimal(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (int) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2BIG_DECIMAL(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(new java.math.BigDecimal(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_INT2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_INT2STRING(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(java.lang.Integer.toString(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_LONG2BIG_DECIMAL(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(new java.math.BigDecimal(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_LONG2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (int) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2SHORT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (short) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_LONG2STRING(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(java.lang.Long.toString(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_SHORT2BYTE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (byte) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_SHORT2CHAR(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (char) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_SHORT2DOUBLE(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (double) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_SHORT2FLOAT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (float) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_SHORT2LONG(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (long) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_STRING2CHAR_ARRAY(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".toCharArray())";
        return string2;
    }

    public final Object genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".toString().toCharArray())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2FLOAT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".floatValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2INT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + ".intValue())";
        return string2;
    }

    public final Object genCode_COERCE_BIG_DECIMAL2SHORT(FcgType fcgType, FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "((short)(" + string + ".intValue()))";
        return string2;
    }

    public final Object genCode_COERCE_BYTE2INT(FinalCodeGenerator.StackValue stackValue) {
        return null;
    }

    public final Object genCode_COERCE_CHAR2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (int) " + string + ')';
        return string2;
    }

    public final Object genCode_COERCE_FLOAT2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (" + string + " != 0.0) && java.lang.Float.isNaN(" + string + "))";
        return string2;
    }

    public final Object genCode_COERCE_INT2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + "!=0)";
        return string2;
    }

    public final Object genCode_COERCE_INT2CHAR_ARRAY(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(java.lang.Integer.toString(" + string + ").toCharArray())";
        return string2;
    }

    public final Object genCode_COERCE_LONG2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + "!=0)";
        return string2;
    }

    public final Object genCode_COERCE_SHORT2BOOLEAN(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(" + string + "!=0)";
        return string2;
    }

    public final Object genCode_COERCE_SHORT2CHAR_ARRAY(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "(java.lang.Integer.toString(" + string + ").toCharArray())";
        return string2;
    }

    public final Object genCode_COERCE_SHORT2INT(FinalCodeGenerator.StackValue stackValue) {
        String string = (String)stackValue.getCodeData();
        String string2 = "( (int)" + string + ')';
        return string2;
    }

    protected Object genCode_loadLocalVariable(FcgVariable fcgVariable) {
        String string = fcgVariable.getName();
        return string;
    }

    protected Object genCode_preIncrementAndLoadLocalVariable(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable) {
        String string = "++" + fcgVariable.getName();
        return string;
    }

    protected void genCode_incrementLocalVarStmt(FinalCodeGenerator.StackValue stackValue, FcgVariable fcgVariable) {
        this.println(this.m_code, "++" + fcgVariable.getName() + ';');
    }

    private static class LocalVarRecord
    implements FcgVarMutableInternal,
    FcgVariable {
        String m_varname;
        FcgType m_varType;
        FcgAttrs m_varAttrs;

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Name: ").append(this.m_varname);
            return stringBuffer.toString();
        }

        public final String setName(String string) {
            String string2 = this.m_varname;
            this.m_varname = string;
            return string2;
        }

        public final FcgAttrs setAttrs(FcgAttrs fcgAttrs) {
            FcgAttrs fcgAttrs2 = this.m_varAttrs;
            this.m_varAttrs = fcgAttrs;
            return fcgAttrs2;
        }

        public final FcgType setType(FcgType fcgType) {
            FcgType fcgType2 = this.m_varType;
            this.m_varType = fcgType;
            return fcgType2;
        }

        public final String getName() {
            return this.m_varname;
        }

        public final FcgAttrs getAttrs() {
            return this.m_varAttrs;
        }

        public final FcgType getType() {
            return this.m_varType;
        }
    }
}

