/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wlp.ant;

import com.ibm.websphere.wlp.ant.AbstractTask;
import java.io.File;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class UndeployTask
extends AbstractTask {
    private String fileName;
    private String timeout;
    private static final long APP_STOP_TIMEOUT_DEFAULT = 30000L;

    public void execute() {
        super.initTask();
        if (this.fileName == null) {
            this.stopServer(this.getTimeout());
            throw new BuildException(messages.getString("erro.undeploy.filename.set"));
        }
        try {
            File fileUndeploy = new File(this.serverConfigRoot, "dropins/" + this.fileName);
            if (!fileUndeploy.exists()) {
                throw new BuildException(MessageFormat.format(messages.getString("error.undeploy.file.noexist"), fileUndeploy.getCanonicalPath()));
            }
            this.log(MessageFormat.format(messages.getString("info.undeploy"), fileUndeploy.getCanonicalPath()));
            FileUtils.delete((File)fileUndeploy);
            String stopMessage = "CWWKZ0009I.*" + this.fileName.substring(0, this.fileName.length() - 4);
            long appStopTimeout = 30000L;
            if (this.timeout != null && !this.timeout.equals("")) {
                appStopTimeout = Long.valueOf(this.timeout);
            }
            if (this.waitForStringInLog(stopMessage, appStopTimeout, this.getLogFile()) == null) {
                this.stopServer(this.getTimeout());
                throw new BuildException(MessageFormat.format(messages.getString("error.undeploy.fail"), this.fileName));
            }
        }
        catch (Exception e) {
            this.stopServer(this.getTimeout());
            throw new BuildException((Throwable)e);
        }
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        this.ref = ref;
    }
}

