/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wlp.ant;

import com.ibm.websphere.wlp.ant.AbstractTask;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class ServerTask
extends AbstractTask {
    private String operation;
    private boolean clean = true;
    private File archive;
    private String timeout;
    private String wlp;
    private static final long SERVER_START_TIMEOUT_DEFAULT = 30000L;
    private static final long SERVER_STOP_TIMEOUT_DEFAULT = 30000L;

    @Override
    protected void initTask() {
        super.initTask();
        if (isWindows) {
            this.wlp = this.installDir + "\\bin\\server.bat";
            this.processBuilder.environment().put("EXIT_ALL", "1");
        } else {
            this.wlp = this.installDir + "/bin/server";
        }
        Properties sysp = System.getProperties();
        String javaHome = sysp.getProperty("java.home");
        this.processBuilder.directory(this.installDir);
        this.processBuilder.environment().put("JAVA_HOME", javaHome);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void execute() {
        if (this.operation == null || this.operation.length() <= 0) {
            throw new BuildException(MessageFormat.format(messages.getString("error.server.operation.validate"), "operation"));
        }
        this.initTask();
        Process p = null;
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(this.wlp);
            commands.add(this.operation);
            if (this.serverName != null && !this.serverName.equals("")) {
                if (!this.serverConfigRoot.exists() && this.operation.equals("start")) {
                    this.log(MessageFormat.format(messages.getString("info.server.create"), this.serverName));
                    commands.clear();
                    commands.add(this.wlp);
                    commands.add("create");
                    commands.add(this.serverName);
                    this.processBuilder.command(commands);
                    p = this.processBuilder.start();
                    this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
                    commands.clear();
                    commands.add(this.wlp);
                    commands.add(this.operation);
                }
                commands.add(this.serverName);
            }
            if (this.operation.equals("package") && this.archive != null) {
                if (this.archive.isDirectory()) {
                    throw new BuildException(messages.getString("error.server.packag"));
                }
                commands.add("--archive=" + this.getArchive());
            }
            if (this.isClean()) {
                commands.add("--clean");
            }
            this.processBuilder.command(commands);
            p = this.processBuilder.start();
            if (this.operation.equals("start")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
                long startTimeout = 30000L;
                if (this.timeout != null && !this.timeout.equals("")) {
                    startTimeout = Long.valueOf(this.timeout);
                }
                this.validateServerStarted(this.getLogFile(), startTimeout);
            } else if (this.operation.equals("stop")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
            } else if (this.operation.equals("package")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
            } else if (this.operation.equals("create")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
            } else if (this.operation.equals("status")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
            } else if (this.operation.equals("debug")) {
                this.checkReturnCode(p, this.processBuilder.command().toString(), AbstractTask.ReturnCode.OK.getValue());
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

