/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wlp.ant;

import com.ibm.websphere.wlp.ant.AbstractTask;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class DeployTask
extends AbstractTask {
    private final List<FileSet> apps = new ArrayList<FileSet>();
    private String filePath;
    private File dropInFolder;
    private String timeout;
    private static long APP_START_TIMEOUT_DEFAULT = 30000L;

    public void execute() {
        super.initTask();
        if (this.filePath == null && this.apps.size() == 0) {
            this.stopServer(this.getTimeout());
            throw new BuildException(messages.getString("error.fileset.set"), this.getLocation());
        }
        List<File> files = this.scanFileSets();
        try {
            this.dropInFolder = new File(this.serverConfigRoot, "dropins/");
            for (File f : files) {
                String startMessage;
                File destFile = new File(this.dropInFolder, f.getName());
                this.log(MessageFormat.format(messages.getString("info.deploy.app"), f.getCanonicalPath()));
                FileUtils.getFileUtils().copyFile(f, destFile, null, true);
                String appName = f.getName();
                long appStartTimeout = APP_START_TIMEOUT_DEFAULT;
                if (this.timeout != null && !this.timeout.equals("")) {
                    appStartTimeout = Long.valueOf(this.timeout);
                }
                if (this.waitForStringInLog(startMessage = "CWWKZ0001I.*" + appName.substring(0, appName.indexOf(".")), appStartTimeout, this.getLogFile()) != null) continue;
                this.stopServer(this.getTimeout());
                throw new BuildException(MessageFormat.format(messages.getString("error.deploy.fail"), f.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            this.stopServer(this.getTimeout());
            throw new BuildException((Throwable)e);
        }
    }

    public void addFileset(FileSet fs) {
        this.apps.add(fs);
    }

    public void setFile(File app) {
        this.filePath = app.getAbsolutePath();
    }

    private List<File> scanFileSets() {
        ArrayList<File> list = new ArrayList<File>();
        if (this.filePath != null && new File(this.filePath).exists()) {
            list.add(new File(this.filePath));
        }
        for (int i = 0; i < this.apps.size(); ++i) {
            String[] names;
            FileSet fs = this.apps.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            for (String element : names = ds.getIncludedFiles()) {
                list.add(new File(ds.getBasedir(), element));
            }
        }
        return list;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        this.ref = ref;
    }
}

