/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.statemodel;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class ListStatistics
implements Statistics {
    private static TraceComponent tc = SibTr.register(ListStatistics.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int MOVING_AVERAGE_LENGTH = 20;
    private long _countAdding = 0L;
    private long _countAvailable = 0L;
    private long _countExpiring = 0L;
    private long _countLocked = 0L;
    private long _countRemoving = 0L;
    private long _countTotal = 0L;
    private long _countTotalBytes = 0L;
    private long _countUpdating = 0L;
    private final int _movingAverageHighLimit;
    private final int _movingAverageLowLimit;
    private long _movingTotal = 0L;
    private final LinkOwner _owningStreamLink;
    private final long _totalSizeHighLimit;
    private final long _totalSizeLowLimit;
    private boolean _spilling = false;
    private long _watermarkBytesHigh = 0L;
    private long _watermarkBytesLow = 0L;
    private long _watermarkCountHigh = 0L;
    private long _watermarkCountLow = 0L;

    public ListStatistics(LinkOwner owner) {
        this._owningStreamLink = owner;
        MessageStoreImpl messageStore = ((AbstractItemLink)this._owningStreamLink).getMessageStoreImpl();
        this._movingAverageHighLimit = messageStore.getSpillUpperLimit();
        this._movingAverageLowLimit = messageStore.getSpillLowerLimit();
        this._totalSizeHighLimit = messageStore.getSpillUpperSizeLimit();
        this._totalSizeLowLimit = messageStore.getSpillLowerSizeLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkSpillLimits() {
        long currentSize;
        long currentTotal;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            currentTotal = this._countTotal;
            currentSize = this._countTotalBytes;
        }
        if (!this._spilling) {
            this._movingTotal += currentTotal;
            long movingAverage = this._movingTotal / 20L;
            this._movingTotal -= movingAverage;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stream is NOT SPILLING");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current size  :" + currentSize));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current total :" + currentTotal));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Moving average:" + movingAverage));
            }
            if (movingAverage >= (long)this._movingAverageHighLimit || currentSize >= this._totalSizeHighLimit) {
                this._spilling = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stream has STARTED SPILLING");
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stream is SPILLING");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current size   :" + currentSize));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current total  :" + currentTotal));
            }
            if (currentTotal <= (long)this._movingAverageLowLimit && currentSize <= this._totalSizeLowLimit) {
                this._spilling = false;
                this._movingTotal = this._movingAverageLowLimit * 19;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stream has STOPPED SPILLING");
                }
            }
        }
    }

    public final synchronized boolean canDelete(int removesUnderTransaction) {
        boolean canDelete = true;
        long totalItems = this._countTotal;
        if (totalItems > 0L) {
            canDelete = false;
            long removesFromMe = this._countRemoving;
            if (totalItems == removesFromMe && removesFromMe == (long)removesUnderTransaction) {
                canDelete = true;
            }
        }
        return canDelete;
    }

    public final synchronized void incrementAdding() {
        ++this._countAdding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementAdding(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            ++this._countAdding;
            doCallback = this._incrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void decrementAdding() {
        --this._countAdding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementAdding(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            --this._countAdding;
            doCallback = this._decrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized long getAddingItemCount() {
        return this._countAdding;
    }

    public final synchronized void incrementAvailable() {
        ++this._countAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementAvailable(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            ++this._countAvailable;
            doCallback = this._incrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void decrementAvailable() {
        --this._countAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementAvailable(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            --this._countAvailable;
            doCallback = this._decrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized long getAvailableItemCount() {
        return this._countAvailable;
    }

    public final synchronized long getUnavailableItemCount() {
        return this._countTotal - this._countAvailable;
    }

    public final synchronized void incrementExpiring() {
        ++this._countExpiring;
    }

    public final synchronized void decrementExpiring() {
        --this._countExpiring;
    }

    public final synchronized long getExpiringItemCount() {
        return this._countExpiring;
    }

    public final synchronized void incrementLocked() {
        ++this._countLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementLocked(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            ++this._countLocked;
            doCallback = this._incrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void decrementLocked() {
        --this._countLocked;
    }

    public final synchronized long getLockedItemCount() {
        return this._countLocked;
    }

    public final synchronized void incrementUpdating() {
        ++this._countUpdating;
    }

    public final synchronized void decrementUpdating() {
        --this._countUpdating;
    }

    public final synchronized long getUpdatingItemCount() {
        return this._countUpdating;
    }

    public final synchronized void incrementRemoving() {
        ++this._countRemoving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementRemoving(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            ++this._countRemoving;
            doCallback = this._incrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void decrementRemoving() {
        --this._countRemoving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementRemoving(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            --this._countRemoving;
            doCallback = this._decrementTotal(sizeInBytes);
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized long getRemovingItemCount() {
        return this._countRemoving;
    }

    public final void incrementTotal(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = this._incrementTotal(sizeInBytes);
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    private final synchronized boolean _incrementTotal(int sizeInBytes) {
        boolean doCallback = false;
        ++this._countTotal;
        if (this._watermarkCountHigh == this._countTotal) {
            doCallback = true;
        }
        boolean wasBelowHighLimit = this._countTotalBytes < this._watermarkBytesHigh;
        this._countTotalBytes += (long)sizeInBytes;
        if (wasBelowHighLimit && this._countTotalBytes >= this._watermarkBytesHigh) {
            doCallback = true;
        }
        return doCallback;
    }

    public final void decrementTotal(int sizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = this._decrementTotal(sizeInBytes);
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    private final synchronized boolean _decrementTotal(int sizeInBytes) {
        boolean doCallback = false;
        --this._countTotal;
        if (this._watermarkCountLow == this._countTotal) {
            doCallback = true;
        }
        boolean wasAboveLowLimit = this._countTotalBytes >= this._watermarkBytesLow;
        this._countTotalBytes -= (long)sizeInBytes;
        if (wasAboveLowLimit && this._countTotalBytes < this._watermarkBytesLow) {
            doCallback = true;
        }
        return doCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTotal(int oldSizeInBytes, int newSizeInBytes) throws SevereMessageStoreException {
        boolean doCallback = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            boolean wasBelowHighLimit = this._countTotalBytes < this._watermarkBytesHigh;
            boolean wasAboveLowLimit = this._countTotalBytes >= this._watermarkBytesLow;
            this._countTotalBytes += (long)(newSizeInBytes - oldSizeInBytes);
            if (wasBelowHighLimit && this._countTotalBytes >= this._watermarkBytesHigh || wasAboveLowLimit && this._countTotalBytes < this._watermarkBytesLow) {
                doCallback = true;
            }
        }
        if (doCallback) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized long getTotalItemCount() {
        return this._countTotal;
    }

    public final boolean isSpilling() {
        return this._spilling;
    }

    public final synchronized void setWatermarks(long countLow, long countHigh, long bytesLow, long bytesHigh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWatermarks", (Object)new Object[]{"Count Low=" + countLow, "Count High=" + countHigh, "Bytes Low=" + bytesLow, "Bytes High=" + bytesHigh});
        }
        this._watermarkCountHigh = countHigh;
        this._watermarkCountLow = countLow;
        this._watermarkBytesHigh = bytesHigh;
        this._watermarkBytesLow = bytesLow;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
        }
    }
}

