/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractList;
import com.ibm.ws.objectManager.AbstractListView;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.CollectionNotEmptyException;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.List;
import com.ibm.ws.objectManager.ListIterator;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.SubListEntryNotInListException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionCheckpointLogRecord;
import com.ibm.ws.objectManager.TransactionOptimisticReplaceLogRecord;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractList
implements List,
SimplifiedSerialization,
Printable {
    private static final Class cclass = LinkedList.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLists");
    private static final long serialVersionUID = 4680368684147217734L;
    public static final boolean gatherStatistics = false;
    protected Token head;
    protected transient Token availableHead;
    protected Token tail;
    transient java.util.List managedObjectsToAdd;
    transient java.util.List managedObjectsToReplace;
    transient java.util.List tokensToNotify;
    transient long reservedSpaceInStore;
    private long size = 0L;
    private transient long availableSize = 0L;
    private transient Object availableSizeLock = new Object();
    protected long maximumAvailableSize = 0L;
    private static final byte simpleSerialVersion = 0;

    public LinkedList(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{transaction, objectStore});
        }
        objectStore.allocate(this);
        this.reservedSpaceInStore = LinkedList.maximumSerializedSize() + (long)this.owningToken.objectStore.getAddSpaceOverhead();
        this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, true);
        transaction.add(this);
        this.owningToken.objectStore.reserve(-((int)this.reservedSpaceInStore), false);
        this.managedObjectsToAdd = new ArrayList(1);
        this.managedObjectsToReplace = new ArrayList(3);
        this.tokensToNotify = new ArrayList(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    static long logSpaceForAdd() {
        return TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + LinkedList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + TransactionCheckpointLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 3L;
    }

    static long logSpaceForDelete() {
        return TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 1L + LinkedList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 4L;
    }

    long storeSpaceForRemove() {
        return LinkedList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + (long)(3 * this.owningToken.objectStore.getAddSpaceOverhead());
    }

    long storeSpaceForAdd() {
        return LinkedList.maximumSerializedSize() + 3L * Link.maximumSerializedSize() + (long)(4 * this.owningToken.objectStore.getAddSpaceOverhead()) + this.storeSpaceForRemove();
    }

    protected final void incrementSize() {
        ++this.size;
    }

    protected final void decrementSize() {
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementAvailableSize() {
        Object object = this.availableSizeLock;
        synchronized (object) {
            ++this.availableSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementAvailableSize() {
        Object object = this.availableSizeLock;
        synchronized (object) {
            --this.availableSize;
        }
    }

    public Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap<String, String> statistics = new HashMap<String, String>();
        statistics.put("maximumAvailableSize", Long.toString(this.maximumAvailableSize));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", new Object[]{statistics});
        }
        return statistics;
    }

    @Override
    public boolean add(Token token, Transaction transaction) throws ObjectManagerException {
        this.addEntry(token, transaction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List.Entry addEntry(Token token, Transaction transaction) throws ObjectManagerException {
        String methodName = "addEntry";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addEntry", new Object[]{token, transaction});
        }
        Link newLink = null;
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            LinkedList linkedList = this;
            synchronized (linkedList) {
                if (!(this.state == 8 || this.state == 2 && this.lockedBy(transaction))) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "addEntry", new Object[]{new Integer(this.state), stateNames[this.state]});
                    }
                    throw new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                }
                this.managedObjectsToAdd.clear();
                this.managedObjectsToReplace.clear();
                this.reservedSpaceInStore = this.storeSpaceForAdd();
                this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, false);
                newLink = new Link(this, token, this.tail, null, transaction);
                this.managedObjectsToAdd.add(newLink);
                if (this.head == null) {
                    this.availableHead = this.head = newLink.getToken();
                } else {
                    Link tailLink = (Link)this.tail.getManagedObject();
                    tailLink.next = newLink.getToken();
                    this.managedObjectsToReplace.add(tailLink);
                }
                this.tail = newLink.getToken();
                this.incrementSize();
                this.managedObjectsToReplace.add(this);
                try {
                    transaction.optimisticReplace(this.managedObjectsToAdd, this.managedObjectsToReplace, null, null, LinkedList.logSpaceForDelete());
                    this.owningToken.objectStore.reserve((int)(this.storeSpaceForRemove() - this.reservedSpaceInStore), false);
                }
                catch (InvalidStateException exception) {
                    this.undoAdd(newLink);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "addEntry", exception);
                    }
                    throw exception;
                }
                catch (LogFileFullException exception) {
                    this.undoAdd(newLink);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "addEntry", exception);
                    }
                    throw exception;
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addEntry", new Object[]{newLink});
        }
        return newLink;
    }

    protected Link insert(Token newToken, Link insertPoint, Transaction transaction) throws ObjectManagerException {
        String methodName = "insert";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "insert", new Object[]{newToken, insertPoint, transaction});
        }
        if (!(this.state == 8 || this.state == 2 && this.lockedBy(transaction))) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "insert", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
            throw new InvalidStateException((Object)this, this.state, stateNames[this.state]);
        }
        this.managedObjectsToAdd.clear();
        this.managedObjectsToReplace.clear();
        this.reservedSpaceInStore = this.storeSpaceForAdd();
        this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, false);
        Link newLink = new Link(this, newToken, insertPoint.previous, insertPoint.owningToken, transaction);
        this.managedObjectsToAdd.add(newLink);
        if (insertPoint.previous == null) {
            if (this.head == null) {
                this.tail = newLink.getToken();
            } else {
                insertPoint.previous = newLink.getToken();
                this.managedObjectsToReplace.add(insertPoint);
            }
            this.head = newLink.getToken();
        } else {
            Link previousLink = (Link)insertPoint.previous.getManagedObject();
            previousLink.next = newLink.getToken();
            this.managedObjectsToReplace.add(previousLink);
            if (insertPoint.owningToken == this.tail) {
                this.tail = newLink.getToken();
            } else {
                insertPoint.previous = newLink.getToken();
                this.managedObjectsToReplace.add(insertPoint);
            }
        }
        this.availableHead = this.head;
        this.skipToBeDeleted();
        this.incrementSize();
        this.managedObjectsToReplace.add(this);
        try {
            transaction.optimisticReplace(this.managedObjectsToAdd, this.managedObjectsToReplace, null, null, LinkedList.logSpaceForDelete());
            this.owningToken.objectStore.reserve((int)(this.storeSpaceForRemove() - this.reservedSpaceInStore), false);
        }
        catch (InvalidStateException exception) {
            this.undoAdd(newLink);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "insert", exception);
            }
            throw exception;
        }
        catch (LogFileFullException exception) {
            this.undoAdd(newLink);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "insert", exception);
            }
            throw exception;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "insert", new Object[]{newLink});
        }
        return newLink;
    }

    void undoAdd(Link newLink) throws ObjectManagerException {
        String methodName = "undoAdd";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "undoAdd", new Object[]{newLink});
        }
        if (newLink.next == null) {
            this.tail = newLink.previous;
        } else {
            Link nextLink = (Link)newLink.next.getManagedObject();
            nextLink.previous = newLink.previous;
        }
        if (newLink.previous == null) {
            this.head = newLink.next;
        } else {
            Link previousLink = (Link)newLink.previous.getManagedObject();
            previousLink.next = newLink.next;
        }
        this.availableHead = this.head;
        this.skipToBeDeleted();
        this.decrementSize();
        this.owningToken.objectStore.reserve((int)(-this.reservedSpaceInStore), false);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "undoAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token getFirst(Transaction transaction) throws ObjectManagerException {
        Token tokenToReturn;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getFirst", new Object[]{transaction});
        }
        LinkedList linkedList = this;
        synchronized (linkedList) {
            Link first = this.nextLink(null, transaction, this.getTransactionUnlockSequence());
            if (first == null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "getFirst", new Object[]{first});
                }
                throw new NoSuchElementException();
            }
            tokenToReturn = first.data;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getFirst", new Object[]{tokenToReturn});
        }
        return tokenToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Token token, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, transaction});
        }
        Iterator iterator = this.iterator();
        boolean removed = false;
        Iterator iterator2 = iterator;
        synchronized (iterator2) {
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                LinkedList linkedList = this;
                synchronized (linkedList) {
                    try {
                        while (iterator.next(transaction) != token) {
                        }
                        iterator.remove(transaction);
                        removed = true;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "remove", new Object[]{new Boolean(removed)});
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token removeFirst(Transaction transaction) throws ObjectManagerException {
        Token tokenToReturn;
        String methodName = "removeFirst";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "removeFirst", new Object[]{transaction});
        }
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            Link first;
            LinkedList linkedList = this;
            synchronized (linkedList) {
                first = this.nextLink(null, transaction, this.getTransactionUnlockSequence());
                if (first == null) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "removeFirst", "via java.util.NoSuchElementException");
                    }
                    throw new NoSuchElementException();
                }
                tokenToReturn = first.data;
                first.requestDelete(transaction);
                if (!first.isLocked()) {
                    this.decrementAvailableSize();
                }
            }
            try {
                transaction.delete(first, LinkedList.logSpaceForDelete());
            }
            catch (LogFileFullException exception) {
                this.unRemove(first);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "removeFirst", exception);
                }
                throw exception;
            }
            catch (InvalidStateException exception) {
                ObjectManager.ffdc.processException(this, cclass, "removeFirst", exception, "1:698:1.40");
                this.unRemove(first);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "removeFirst", exception);
                }
                throw exception;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "removeFirst", new Object[]{tokenToReturn});
        }
        return tokenToReturn;
    }

    private synchronized void unRemove(Link link) throws StateErrorException, ObjectManagerException {
        link.setState(Link.nextStateForRequestUnDelete);
        this.availableHead = this.head;
        this.skipToBeDeleted();
        if (link.state == 3) {
            this.incrementAvailableSize();
            this.owningToken.objectStore.reserve(-((int)this.storeSpaceForRemove()), false);
        }
    }

    @Override
    public synchronized boolean isEmpty(Transaction transaction) throws ObjectManagerException {
        boolean isEmpty;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "isEmpty", new Object[]{transaction});
        }
        boolean bl = isEmpty = this.nextLink(null, transaction, Long.MAX_VALUE) == null;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "isEmpty", new Object[]{new Boolean(isEmpty)});
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Transaction transaction) throws ObjectManagerException {
        long listLength;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "size", new Object[]{transaction});
        }
        LinkedList linkedList = this;
        synchronized (linkedList) {
            Object object = this.availableSizeLock;
            synchronized (object) {
                listLength = this.availableSize;
            }
            if (transaction != null) {
                Token nextToken = this.head;
                while (nextToken != null) {
                    Link nextLink = (Link)nextToken.getManagedObject();
                    if (nextLink.state == 2 && nextLink.lockedBy(transaction)) {
                        ++listLength;
                    }
                    nextToken = nextLink.next;
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", "returns listLength=" + listLength + "(long)");
        }
        return listLength;
    }

    @Override
    public long size() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "size");
        }
        long listLength = this.size;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", "returns listLength=" + listLength + "(int)");
        }
        return listLength;
    }

    @Override
    public List subList(List.Entry fromEntry, List.Entry toEntry) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "subList", new Object[]{fromEntry, toEntry});
        }
        SubList subList = new SubList(this, (Link)fromEntry, (Link)toEntry);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "subList", new Object[]{subList});
        }
        return subList;
    }

    @Override
    public Set entrySet() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "entrySet");
        }
        EntrySet entrySet = new EntrySet();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "entrySet", new Object[]{entrySet});
        }
        return entrySet;
    }

    @Override
    public Iterator iterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "iterator");
        }
        Iterator iterator = this.subList(null, null).iterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "iterator", new Object[]{iterator});
        }
        return iterator;
    }

    @Override
    public ListIterator listIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "listIterator");
        }
        ListIterator listIterator = this.subList(null, null).listIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "listIterator", new Object[]{listIterator});
        }
        return listIterator;
    }

    @Override
    public Iterator entryIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "entryIterator");
        }
        Iterator entryIterator = this.subList(null, null).entryIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "entryIterator", new Object[]{entryIterator});
        }
        return entryIterator;
    }

    protected Link nextLink(Link start, Transaction transaction, long transactionUnlockPoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "nextLink", new Object[]{start, transaction, new Long(transactionUnlockPoint), this.head, this.availableHead});
        }
        Token nextToken = null;
        Link nextLink = null;
        if (start == null) {
            if (this.availableHead == null) {
                this.availableHead = this.head;
                this.skipToBeDeleted();
            }
            nextToken = this.availableHead;
        } else {
            if (start.state == 7 || start.state == 8) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "nextLink", "returns null start link is deleted");
                }
                return null;
            }
            nextToken = start.next;
        }
        while (nextToken != null) {
            nextLink = (Link)nextToken.getManagedObject();
            if (nextLink.state == 3 && !nextLink.wasLocked(transactionUnlockPoint) || nextLink.state == 2 && transaction != null && nextLink.lockedBy(transaction)) break;
            nextToken = nextLink.next;
        }
        if (nextToken == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextLink", "returns null empty list");
            }
            return null;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "nextLink", new Object[]{nextLink});
        }
        return nextLink;
    }

    protected Link previousLink(Link start, Transaction transaction, long transactionUnlockPoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "previousLink", new Object[]{start, transaction, new Long(transactionUnlockPoint)});
        }
        Token previousToken = null;
        Link previousLink = null;
        if (start == null) {
            previousToken = this.tail;
        } else {
            if (start.state == 7 || start.state == 8) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "previousLink", "returns null start link is deleted");
                }
                return null;
            }
            previousToken = start.previous;
        }
        while (previousToken != null) {
            previousLink = (Link)previousToken.getManagedObject();
            if (previousLink.state == 3 && !previousLink.wasLocked(transactionUnlockPoint) || previousLink.state == 2 && transaction != null && previousLink.lockedBy(transaction)) break;
            previousToken = previousLink.next;
        }
        if (previousToken == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextLink", "returns null empty list");
            }
            return null;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "previousLink", new Object[]{previousLink});
        }
        return previousLink;
    }

    protected Link nextLink(Link start) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "nextLink", new Object[]{start});
        }
        Token nextToken = null;
        nextToken = start == null ? this.head : start.next;
        Link nextLink = null;
        if (nextToken != null) {
            nextLink = (Link)nextToken.getManagedObject();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "nextLink", new Object[]{nextLink});
        }
        return nextLink;
    }

    protected Link previousLink(Link start) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "previousLink", new Object[]{start});
        }
        Token previousToken = null;
        previousToken = start == null ? this.head : start.next;
        Link previousLink = null;
        if (previousToken != null) {
            previousLink = (Link)previousToken.getManagedObject();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "previousLink", new Object[]{previousLink});
        }
        return previousLink;
    }

    protected Link firstAvailableLink() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "firstAvailableLink");
        }
        if (this.availableHead == null) {
            this.availableHead = this.head;
            this.skipToBeDeleted();
        }
        Link nextLink = null;
        if (this.availableHead != null) {
            nextLink = (Link)this.availableHead.getManagedObject();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "firstAvailableLink", "returns nextLink=" + nextLink + "(Link)");
        }
        return nextLink;
    }

    protected void skipToBeDeleted() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "skipToBeDeleted");
        }
        Token nextToken = this.availableHead;
        while (nextToken != null) {
            Link nextLink = (Link)nextToken.getManagedObject();
            if (nextLink.state != 5 && nextLink.state != 6) break;
            nextToken = nextLink.next;
        }
        this.availableHead = nextToken;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "skipToBeDeleted");
        }
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        printWriter.println("State Dump for:" + cclass.getName() + " head=" + this.head + "(Token) availableHead=" + this.availableHead + "(Token) tail=" + this.tail + "(Token)\n size=" + this.size + "(long) availableSize=" + this.availableSize + "(long) maximumAvailableSize=" + this.maximumAvailableSize);
        printWriter.println();
        printWriter.println("Links in order...");
        try {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                printWriter.println(link.toString());
            }
        }
        catch (ObjectManagerException objectManagerException) {
            printWriter.println("Caught objectManagerException=" + objectManagerException);
            objectManagerException.printStackTrace(printWriter);
        }
        printWriter.println();
    }

    @Override
    public synchronized boolean validate(PrintStream printStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "validate", new Object[]{printStream});
        }
        boolean valid = true;
        Link tailLink = null;
        if (this.tail != null) {
            tailLink = (Link)this.tail.getManagedObject();
            if (tailLink.next != null) {
                printStream.println("tail link.next=" + tailLink.next + " not null");
                valid = false;
            }
        }
        long numberOfLinks = 0L;
        Token nextToken = this.head;
        Link nextLink = null;
        while (nextToken != null) {
            ++numberOfLinks;
            nextLink = (Link)nextToken.getManagedObject();
            nextToken = nextLink.next;
        }
        if (numberOfLinks != this.size) {
            printStream.println("counted=" + numberOfLinks + " not equal to size=" + this.size);
            valid = false;
        }
        if (nextLink != tailLink) {
            printStream.println("final link=" + nextLink + "not equal tail=" + tailLink);
            valid = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "validate", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    public synchronized Object clone(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "clone", new Object[]{transaction, objectStore});
        }
        LinkedList clonedList = new LinkedList(transaction, objectStore);
        long unlockPoint = this.getTransactionUnlockSequence();
        Link nextLink = this.nextLink(null, transaction, unlockPoint);
        while (nextLink != null) {
            clonedList.add(nextLink.data, transaction);
            nextLink = this.nextLink(nextLink, transaction, unlockPoint);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "clone", new Object[]{clonedList});
        }
        return clonedList;
    }

    @Override
    void reserveSpaceInStore(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (this.owningToken.getObjectStore().getObjectManagerState().getObjectManagerStateState() == 2) {
            super.reserveSpaceInStore(byteArrayOutputStream);
        } else {
            int currentSerializedSize = byteArrayOutputStream.getCount() + this.owningToken.objectStore.getAddSpaceOverhead();
            if (currentSerializedSize > this.latestSerializedSize) {
                this.latestSerializedSizeDelta = currentSerializedSize - this.latestSerializedSize;
                this.reservedSpaceInStore -= (long)this.latestSerializedSizeDelta;
                this.latestSerializedSize = currentSerializedSize;
            }
        }
    }

    @Override
    public void becomeCloneOf(ManagedObject other) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", "other=" + other + "(ManagedObject)");
        }
        if (!this.backingOut) {
            LinkedList otherList = (LinkedList)other;
            this.head = otherList.head;
            this.availableHead = otherList.availableHead;
            this.tail = otherList.tail;
            this.size = otherList.size;
            this.availableSize = otherList.availableSize;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    @Override
    public synchronized void preDelete(Transaction transaction) throws ObjectManagerException {
        String methodName = "preDelete";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preDelete", new Object[]{transaction});
        }
        if (transaction.getObjectManagerStateState() != 2) {
            Token nextToken = this.head;
            while (nextToken != null) {
                Link nextLink = (Link)nextToken.getManagedObject();
                if (nextLink.willBeDeleted(transaction)) {
                    nextToken = nextLink.next;
                    continue;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "preDelete", "via CollentionNotEmptyExceptionsize=" + this.size + "(long) nextLink.state=" + nextLink.state + "(int) " + Link.stateNames[nextLink.state] + "\n nextLink.getTransactionLock()=" + nextLink.getTransactionLock() + "(transactionLock)");
                }
                throw new CollectionNotEmptyException((Object)this, this.size, transaction);
            }
        }
        super.preDelete(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preDelete");
        }
    }

    LinkedList() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
        }
        this.managedObjectsToAdd = new ArrayList(1);
        this.managedObjectsToReplace = new ArrayList(3);
        this.tokensToNotify = new ArrayList(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected static long maximumSerializedSize() {
        return 1L + ManagedObject.maximumSerializedSize() + 1L + 2L * Link.maximumSerializedSize() + 8L;
    }

    @Override
    public int getSignature() {
        return 5;
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        String methodName = "writeObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", new Object[]{dataOutputStream});
        }
        try {
            dataOutputStream.writeByte(0);
            super.writeObject(dataOutputStream);
            if (this.head == null) {
                dataOutputStream.writeByte(0);
            } else {
                dataOutputStream.writeByte(1);
                this.head.writeObject(dataOutputStream);
                this.tail.writeObject(dataOutputStream);
            }
            dataOutputStream.writeLong(this.size);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:1565:1.40");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", new Object[]{new Byte(version)});
            }
            super.readObject(dataInputStream, objectManagerState);
            if (dataInputStream.readByte() == 1) {
                this.head = Token.restore(dataInputStream, objectManagerState);
                this.tail = Token.restore(dataInputStream, objectManagerState);
            }
            this.size = dataInputStream.readLong();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:1620:1.40");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", new Object[]{exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.availableHead = null;
        this.availableSize = this.size;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "objectInputStream=" + objectInputStream + "(java.io.ObjectInputStream)");
        }
        objectInputStream.defaultReadObject();
        this.availableHead = null;
        this.availableSize = this.size;
        this.availableSizeLock = new Object();
        this.managedObjectsToAdd = new ArrayList(1);
        this.managedObjectsToReplace = new ArrayList(3);
        this.tokensToNotify = new ArrayList(1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    @Override
    public String toString() {
        return new String("LinkedList(size=" + this.size + " availableSize=" + this.availableSize + ") " + super.toString());
    }

    static class Link
    extends ManagedObject
    implements List.Entry,
    SimplifiedSerialization {
        private static final Class cclass = Link.class;
        private static final long serialVersionUID = 4680368684147217734L;
        static final int stateError = 0;
        static final int stateConstructed = 1;
        static final int stateToBeAdded = 2;
        static final int stateAdded = 3;
        static final int stateNotAdded = 4;
        static final int stateToBeDeleted = 5;
        static final int stateMustBeDeleted = 6;
        static final int stateRemoved = 7;
        static final int stateDeleted = 8;
        static final String[] stateNames = new String[]{"Error", "Constructed", "ToBeAdded", "Added", "NotAdded", "ToBeDeleted", "MustBeDeleted", "Removed", "Deleted"};
        static final int[] nextStateForRequestAdd = new int[]{0, 2, 2, 2, 0, 0, 0, 0, 0};
        static final int[] nextStateForRequestDelete = new int[]{0, 0, 6, 5, 0, 5, 6, 0, 0};
        static final int[] nextStateForRequestUnDelete = new int[]{0, 0, 0, 0, 0, 3, 2, 0, 0};
        static final int[] nextStateForRemove = new int[]{0, 0, 4, 7, 0, 7, 7, 0, 0};
        static final int[] nextStateForCommit = new int[]{0, 0, 3, 0, 0, 0, 0, 8, 0};
        static final int[] nextStateForBackout = new int[]{0, 0, 0, 0, 8, 3, 0, 8, 0};
        static final int[] nextStateForError = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        volatile transient int state;
        private transient int previousState;
        private Token listToken;
        protected transient LinkedList list;
        protected Token data;
        protected Token next;
        protected Token previous;
        transient Token uncommitedData;
        private static final byte SimpleSerialVersion = 0;

        Link(LinkedList list, Token data, Token previous, Token next, Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{list, data, previous, next, transaction});
            }
            this.listToken = list.owningToken;
            this.list = list;
            this.data = data;
            this.previous = previous;
            this.next = next;
            this.state = 1;
            this.previousState = -1;
            this.listToken.getObjectStore().allocate(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        protected void requestDelete(Transaction transaction) throws ObjectManagerException {
            String methodName = "requestDelete";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "requestDelete", new Object[]{transaction});
            }
            this.testState(nextStateForRequestDelete);
            if (this.state == 3) {
                this.owningToken.objectStore.reserve((int)this.list.storeSpaceForRemove(), false);
            }
            this.setState(nextStateForRequestDelete);
            if (this.owningToken == this.list.availableHead) {
                this.list.skipToBeDeleted();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "requestDelete");
            }
        }

        final boolean willBeDeleted(Transaction transaction) {
            return (this.state == 5 || this.state == 6) && this.lockedBy(transaction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromList(Transaction transaction) throws ObjectManagerException {
            String methodName = "removeFromList";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "removeFromList", new Object[]{transaction});
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.managedObjectsToReplace.clear();
                this.list.tokensToNotify.clear();
                this.list.reservedSpaceInStore = (int)this.list.storeSpaceForRemove();
                if (this.next == null) {
                    this.list.tail = this.previous;
                } else {
                    Link nextLink = (Link)this.next.getManagedObject();
                    nextLink.previous = this.previous;
                    this.list.managedObjectsToReplace.add(nextLink);
                }
                if (this.previous == null) {
                    this.list.head = this.next;
                } else {
                    Link previousLink = (Link)this.previous.getManagedObject();
                    previousLink.next = this.next;
                    this.list.managedObjectsToReplace.add(previousLink);
                }
                this.list.decrementSize();
                this.list.managedObjectsToReplace.add(this.list);
                this.list.tokensToNotify.add(this.owningToken);
                transaction.optimisticReplace(null, this.list.managedObjectsToReplace, null, this.list.tokensToNotify, -LinkedList.logSpaceForDelete());
                if (transaction.getObjectManagerStateState() != 2) {
                    this.owningToken.objectStore.reserve(-((int)this.list.reservedSpaceInStore), false);
                }
            }
            this.listToken = null;
            this.data = null;
            this.next = null;
            this.previous = null;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "removeFromList");
            }
        }

        @Override
        void reserveSpaceInStore(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
            if (this.owningToken.getObjectStore().getObjectManagerState().getObjectManagerStateState() == 2) {
                super.reserveSpaceInStore(byteArrayOutputStream);
            } else {
                int currentSerializedSize = byteArrayOutputStream.getCount() + this.owningToken.objectStore.getAddSpaceOverhead();
                if (currentSerializedSize > this.latestSerializedSize) {
                    this.latestSerializedSizeDelta = currentSerializedSize - this.latestSerializedSize;
                    this.list.reservedSpaceInStore -= (long)this.latestSerializedSizeDelta;
                    this.latestSerializedSize = currentSerializedSize;
                }
            }
        }

        @Override
        public void becomeCloneOf(ManagedObject other) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "becomeCloneOf", "other=" + other + "(ManagedObject)");
            }
            if (!this.backingOut) {
                Link otherLink = (Link)other;
                this.listToken = otherLink.listToken;
                this.list = otherLink.list;
                this.data = otherLink.data;
                this.next = otherLink.next;
                this.previous = otherLink.previous;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "becomeCloneOf");
            }
        }

        @Override
        public void postAdd(Transaction transaction, boolean logged) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "postAdd", "transaction=" + transaction + "(Transaction) logged=" + logged + "(boolean)");
            }
            super.postAdd(transaction, logged);
            if (logged) {
                this.setState(nextStateForRequestAdd);
                transaction.requestCallback(this.owningToken);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "postAdd");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postDelete(Transaction transaction, boolean logged) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "postDelete", new Object[]{transaction, new Boolean(logged)});
            }
            super.postDelete(transaction, logged);
            if (logged) {
                if (transaction.getObjectManagerStateState() == 2) {
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        this.setState(nextStateForRequestDelete);
                    }
                }
                transaction.requestCallback(this.owningToken);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "postDelete");
            }
        }

        @Override
        public void optimisticReplaceLogged(Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "optimisticReplaceLogged", "transaction=" + transaction + "(Transaction)");
            }
            super.optimisticReplaceLogged(transaction);
            this.setState(nextStateForRemove);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "optimisticReplaceLogged");
            }
        }

        @Override
        public void preCommit(Transaction transaction) throws ObjectManagerException {
            String methodName = "preCommit";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "preCommit", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            super.preCommit(transaction);
            switch (this.state) {
                case 2: {
                    if (transaction.getObjectManagerStateState() == 2) break;
                    this.owningToken.objectStore.reserve(-((int)this.list.storeSpaceForRemove()), false);
                    break;
                }
                case 5: 
                case 6: {
                    this.removeFromList(transaction);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    this.setState(nextStateForError);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preCommit", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBackout(Transaction transaction) throws ObjectManagerException {
            String methodName = "preBackout";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "preBackout", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            super.preBackout(transaction);
            switch (this.state) {
                case 2: 
                case 6: {
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        this.removeFromList(transaction);
                        if (this.getToken() == this.list.availableHead) {
                            this.list.availableHead = this.list.head;
                            this.list.skipToBeDeleted();
                        }
                        break;
                    }
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (transaction.getObjectManagerStateState() == 2) break;
                    this.owningToken.objectStore.reserve(-((int)this.list.storeSpaceForRemove()), false);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    this.setState(nextStateForError);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preBackout", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        @Override
        protected void commit(Transaction transaction, ObjectManagerByteArrayOutputStream serializedBytes, long logSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "commit", new Object[]{transaction, serializedBytes, new Long(logSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
            }
            super.commit(transaction, serializedBytes, logSequenceNumber, requiresCurrentCheckpoint);
            switch (this.state) {
                case 2: {
                    this.setState(nextStateForCommit);
                    if (transaction.getObjectManagerStateState() == 2) break;
                    this.list.incrementAvailableSize();
                    break;
                }
                default: {
                    this.setState(nextStateForCommit);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "commit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backout(Transaction transaction, long logSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "backout", new Object[]{transaction, new Long(logSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
            }
            super.backout(transaction, logSequenceNumber, requiresCurrentCheckpoint);
            switch (this.state) {
                case 5: {
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        this.setState(nextStateForBackout);
                        if (transaction.getObjectManagerStateState() == 2) {
                            this.list.availableHead = null;
                        } else {
                            this.list.incrementAvailableSize();
                            this.list.availableHead = this.list.head;
                            this.list.skipToBeDeleted();
                        }
                        break;
                    }
                }
                default: {
                    this.setState(nextStateForBackout);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "backout");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recoveryCompleted(Transaction transaction) throws ObjectManagerException {
            String methodName = "recoveryCompleted";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "recoveryCompleted", new Object[]{transaction, new Integer(this.state), stateNames[this.state]});
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                switch (this.state) {
                    case 2: {
                        this.list.decrementAvailableSize();
                        this.owningToken.objectStore.reserve((int)this.list.storeSpaceForRemove(), false);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.list.decrementAvailableSize();
                        if (this.owningToken == this.list.availableHead) {
                            this.list.skipToBeDeleted();
                        }
                        this.owningToken.objectStore.reserve((int)this.list.storeSpaceForRemove(), false);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        this.setState(nextStateForError);
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "recoveryCompleted");
            }
        }

        private void testState(int[] nextState) throws InvalidStateException {
            int newState;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "testState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
            }
            if ((newState = nextState[this.state]) == 0) {
                InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "testState", new Object[]{invalidStateException, new Integer(newState), stateNames[newState]});
                }
                throw invalidStateException;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "testState");
            }
        }

        protected void setState(int[] nextState) throws StateErrorException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
            }
            this.previousState = this.state;
            this.state = nextState[this.state];
            if (this.state == 0) {
                StateErrorException stateErrorException = new StateErrorException((Object)this, this.previousState, stateNames[this.previousState]);
                ObjectManager.ffdc.processException(this, cclass, "setState", stateErrorException, "1:3471:1.40");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "setState", new Object[]{stateErrorException, new Integer(this.state), stateNames[this.state]});
                }
                throw stateErrorException;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setState", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
        }

        @Override
        public Token getValue() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "getValue");
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getValue", new Object[]{this.data});
            }
            return this.data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Token setValue(Token newToken, Transaction transaction) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "setValue", new Object[]{newToken, transaction, this.data});
            }
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    this.list.insert(newToken, this, transaction);
                    this.remove(transaction);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setValue");
            }
            return this.data;
        }

        @Override
        public int getEntryState() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "getEntryState");
            }
            int stateToReturn = this.state;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getEntryState", "returns statetoReturn=" + stateToReturn + "(int) " + stateNames[stateToReturn] + "(String)");
            }
            return stateToReturn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(Transaction transaction) throws ObjectManagerException {
            String methodName = "remove";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "remove", new Object[]{transaction});
            }
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    if (this.state == 3) {
                        this.requestDelete(transaction);
                        this.list.decrementAvailableSize();
                    } else if (this.state == 2 && this.lockedBy(transaction)) {
                        this.requestDelete(transaction);
                    } else {
                        InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "remove", new Object[]{invalidStateException, new Integer(this.state), stateNames[this.state]});
                        }
                        throw invalidStateException;
                    }
                }
                try {
                    transaction.delete(this, LinkedList.logSpaceForDelete());
                }
                catch (LogFileFullException exception) {
                    this.list.unRemove(this);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "remove", exception);
                    }
                    throw exception;
                }
                catch (InvalidStateException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "remove", exception, "1:3619:1.40");
                    this.list.unRemove(this);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "remove", exception);
                    }
                    throw exception;
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "remove");
            }
        }

        Link() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        protected static long maximumSerializedSize() {
            return 1L + ManagedObject.maximumSerializedSize() + 2L + 4L * Token.maximumSerializedSize();
        }

        @Override
        public int getSignature() {
            return 6;
        }

        @Override
        public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "writeObject", "dataOutputStream=" + dataOutputStream + "(java.io.DataOutputStream)");
            }
            try {
                dataOutputStream.writeByte(0);
                super.writeObject(dataOutputStream);
                this.listToken.writeObject(dataOutputStream);
                this.data.writeObject(dataOutputStream);
                if (this.next == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    this.next.writeObject(dataOutputStream);
                }
                if (this.previous == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    dataOutputStream.writeByte(1);
                    this.previous.writeObject(dataOutputStream);
                }
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, ".writeObject", exception, "1:3716:1.40");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "writeObject", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeObject");
            }
        }

        @Override
        public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "readObject", "dataInputStream=" + dataInputStream + "(java.io.DataInputStream) objectManagerState=" + objectManagerState + "(ObjectManagerState)");
            }
            try {
                byte version = dataInputStream.readByte();
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "readObject", new Object[]{new Byte(version)});
                }
                super.readObject(dataInputStream, objectManagerState);
                this.listToken = Token.restore(dataInputStream, objectManagerState);
                this.data = Token.restore(dataInputStream, objectManagerState);
                if (dataInputStream.readByte() == 1) {
                    this.next = Token.restore(dataInputStream, objectManagerState);
                }
                if (dataInputStream.readByte() == 1) {
                    this.previous = Token.restore(dataInputStream, objectManagerState);
                }
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, ".readObject", exception, "1:3775:1.40");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
                }
                throw new PermanentIOException((Object)this, exception);
            }
            this.list = (LinkedList)this.listToken.getManagedObject();
            if (this.list == null) {
                this.list = new LinkedList();
            }
            this.state = 3;
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readObject");
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "readObject", "objectInputStream=" + objectInputStream + "(java.io.ObjectInputStream)");
            }
            objectInputStream.defaultReadObject();
            try {
                this.list = (LinkedList)this.listToken.getManagedObject();
                if (this.list == null) {
                    this.list = new LinkedList();
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3835:1.40");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", exception);
                }
                throw new ClassNotFoundException(exception.toString());
            }
            this.state = 3;
            this.previousState = -1;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readObject");
            }
        }

        @Override
        public String toString() {
            return new String("LinkedList.Link(data=" + this.data + ")/" + stateNames[this.state] + " " + super.toString());
        }
    }

    class EntrySet
    extends AbstractSetView {
        EntrySet() {
        }

        @Override
        public Iterator iterator() throws ObjectManagerException {
            SubList subList = (SubList)LinkedList.this.subList(null, null);
            return subList.entryIterator();
        }

        @Override
        public long size(Transaction transaction) throws ObjectManagerException {
            return LinkedList.this.size(transaction);
        }

        @Override
        public long size() throws ObjectManagerException {
            return LinkedList.this.size();
        }
    }

    static class SubList
    extends AbstractListView {
        LinkedList list;
        Link head;
        Link tail;

        private SubList(LinkedList list, Link head, Link tail) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{list, head, tail});
            }
            this.list = list;
            this.head = head;
            this.tail = tail;
            if (head != null && (head.list != list || head.state == 7 || head.state == 8)) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "subList");
                }
                throw new SubListEntryNotInListException(this, head);
            }
            if (tail != null && (tail.list != list || tail.state == 7 || tail.state == 8)) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "subList");
                }
                throw new SubListEntryNotInListException(this, tail);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        public Iterator iterator() throws ObjectManagerException {
            return new SubListIterator(1);
        }

        @Override
        public ListIterator listIterator() throws ObjectManagerException {
            return new SubListIterator(1);
        }

        @Override
        public Iterator entryIterator() throws ObjectManagerException {
            return new SubListIterator(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List.Entry addEntry(Token token, Transaction transaction) throws ObjectManagerException {
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    Link newLink = this.list.insert(token, this.tail, transaction);
                    return newLink;
                }
            }
        }

        @Override
        public List subList(List.Entry fromEntry, List.Entry toEntry) throws ObjectManagerException {
            return new SubList(this.list, (Link)fromEntry, (Link)toEntry);
        }

        @Override
        public Set entrySet() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "entrySet");
            }
            EntrySet entrySet = new EntrySet();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "entrySet", new Object[]{entrySet});
            }
            return entrySet;
        }

        protected Link nextLink(Link start) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "nextLink", new Object[]{start});
            }
            Token nextToken = null;
            nextToken = start == null ? (this.head == null ? this.list.head : this.head.next) : start.next;
            Link nextLink = null;
            if (nextToken != null) {
                nextLink = (Link)nextToken.getManagedObject();
            }
            if (nextLink == this.tail) {
                nextLink = null;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextLink", new Object[]{nextLink});
            }
            return nextLink;
        }

        protected Link nextLink(Link start, Transaction transaction, long transactionUnlockPoint) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "nextLink", new Object[]{start, transaction, new Long(transactionUnlockPoint)});
            }
            Token nextToken = null;
            Link nextLink = null;
            if (start == null) {
                if (this.head == null) {
                    if (this.list.availableHead == null) {
                        this.list.availableHead = this.list.head;
                        this.list.skipToBeDeleted();
                    }
                    nextToken = this.list.availableHead;
                } else {
                    nextToken = this.head.next;
                }
            } else {
                if (start.state == 7 || start.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "nextLink", "returns null start link is deleted");
                    }
                    return null;
                }
                nextToken = start.next;
            }
            while (nextToken != null) {
                nextLink = (Link)nextToken.getManagedObject();
                if (nextLink == this.tail) {
                    nextToken = null;
                    break;
                }
                if (nextLink.state == 3 && !nextLink.wasLocked(transactionUnlockPoint) || nextLink.state == 2 && transaction != null && nextLink.lockedBy(transaction)) break;
                nextToken = nextLink.next;
            }
            if (nextToken == null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "nextLink", "returns null empty list");
                }
                return null;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "nextLink", new Object[]{nextLink});
            }
            return nextLink;
        }

        class EntrySet
        extends AbstractSetView {
            EntrySet() {
            }

            @Override
            public Iterator iterator() throws ObjectManagerException {
                return SubList.this.entryIterator();
            }
        }

        class SubListIterator
        implements ListIterator {
            static final int VALUES = 1;
            static final int ENTRIES = 2;
            private int type;
            static final int FORWARD = 0;
            static final int BACKWARD = 1;
            Link currentEntry = null;
            Link nextEntry = null;
            boolean beyondEndOfList = false;

            SubListIterator(int type) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "<init>,", new Object[]{new Integer(type)});
                }
                this.type = type;
                if (SubList.this.head != null) {
                    this.currentEntry = SubList.this.head;
                    if (SubList.this.head.state == 7 || SubList.this.head.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit(this, cclass, "<intit>");
                        }
                        throw new SubListEntryNotInListException(SubList.this, SubList.this.head);
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "<init>");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean hasNext(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasNext", new Object[]{transaction});
                }
                boolean returnValue = false;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    Link nextAvailableEntry;
                    if (!this.beyondEndOfList && (nextAvailableEntry = this.nextAvailable(transaction, 0)) != null) {
                        returnValue = true;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasNext", new Object[]{new Boolean(returnValue)});
                }
                return returnValue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean hasNext() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasNext", new Object[]{this.currentEntry});
                }
                boolean returnValue = false;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    Link nextAvailableEntry;
                    if (!this.beyondEndOfList && (nextAvailableEntry = this.nextAvailable(0)) != null) {
                        returnValue = true;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasNext", new Object[]{new Boolean(returnValue)});
                }
                return returnValue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Object next(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "next", new Object[]{transaction, this.currentEntry});
                }
                SimplifiedSerialization currentObject = null;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    if (!this.beyondEndOfList) {
                        this.currentEntry = this.nextAvailable(transaction, 0);
                        this.nextEntry = null;
                        if (this.currentEntry == null) {
                            this.beyondEndOfList = true;
                        }
                    }
                    if (this.beyondEndOfList) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                        }
                        throw new NoSuchElementException();
                    }
                    switch (this.type) {
                        case 1: {
                            currentObject = this.currentEntry.data;
                            break;
                        }
                        case 2: {
                            currentObject = this.currentEntry;
                        }
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "next", new Object[]{currentObject});
                }
                return currentObject;
            }

            Link nextAvailable(Transaction transaction, int direction) throws ObjectManagerException {
                Link nextAvailableEntry;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "nextAvailable", new Object[]{this.currentEntry, this.nextEntry, transaction, new Integer(direction)});
                }
                long unlockPoint = SubList.this.list.getTransactionUnlockSequence();
                if (this.nextEntry != null) {
                    if (this.nextEntry.state == 3 || this.nextEntry.state == 2 && this.nextEntry.lockedBy(transaction)) {
                        nextAvailableEntry = this.nextEntry;
                    } else {
                        if (this.nextEntry.state == 7 || this.nextEntry.state == 8) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                            }
                            throw new ConcurrentModificationException();
                        }
                        nextAvailableEntry = direction == 0 ? SubList.this.nextLink(this.nextEntry, transaction, unlockPoint) : SubList.this.list.previousLink(this.nextEntry, transaction, unlockPoint);
                    }
                } else if (this.currentEntry == null) {
                    nextAvailableEntry = SubList.this.nextLink(null, transaction, unlockPoint);
                } else {
                    if (this.currentEntry.state == 7 || this.currentEntry.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                        }
                        throw new ConcurrentModificationException();
                    }
                    nextAvailableEntry = SubList.this.nextLink(this.currentEntry, transaction, unlockPoint);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "nextAvailable", new Object[]{nextAvailableEntry});
                }
                return nextAvailableEntry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Object next() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "next", new Object[]{this.currentEntry});
                }
                SimplifiedSerialization currentObject = null;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    if (!this.beyondEndOfList) {
                        this.currentEntry = this.nextAvailable(0);
                        this.nextEntry = null;
                        if (this.currentEntry == null) {
                            this.beyondEndOfList = true;
                        }
                    }
                    if (this.beyondEndOfList) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                        }
                        throw new NoSuchElementException();
                    }
                    switch (this.type) {
                        case 1: {
                            currentObject = this.currentEntry.data;
                            break;
                        }
                        case 2: {
                            currentObject = this.currentEntry;
                        }
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "next", new Object[]{currentObject});
                }
                return currentObject;
            }

            Link nextAvailable(int direction) throws ObjectManagerException {
                Link nextAvailableEntry;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "nextAvailable", new Object[]{new Integer(direction), this.currentEntry, this.nextEntry});
                }
                if (this.nextEntry != null) {
                    if (this.nextEntry.state == 7 || this.nextEntry.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                        }
                        throw new ConcurrentModificationException();
                    }
                    nextAvailableEntry = direction == 0 ? SubList.this.nextLink(this.nextEntry) : SubList.this.list.previousLink(this.nextEntry);
                } else if (this.currentEntry == null) {
                    nextAvailableEntry = direction == 0 ? SubList.this.nextLink(null) : SubList.this.list.previousLink(null);
                } else {
                    if (this.currentEntry.state == 7 || this.currentEntry.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "nextAvailable", "via java.util.ConcurrentModificationException");
                        }
                        throw new ConcurrentModificationException();
                    }
                    nextAvailableEntry = SubList.this.nextLink(this.currentEntry);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "nextAvailable", new Object[]{nextAvailableEntry});
                }
                return nextAvailableEntry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Object remove(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "remove", new Object[]{transaction});
                }
                if (this.currentEntry == null || this.beyondEndOfList) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "remove", "via IllegalStateException");
                    }
                    throw new IllegalStateException();
                }
                InternalTransaction internalTransaction = transaction.internalTransaction;
                synchronized (internalTransaction) {
                    LinkedList linkedList = SubList.this.list;
                    synchronized (linkedList) {
                        this.currentEntry.remove(transaction);
                        this.nextEntry = SubList.this.nextLink(this.currentEntry, transaction, SubList.this.list.getTransactionUnlockSequence());
                        if (this.nextEntry == null) {
                            this.beyondEndOfList = true;
                        }
                    }
                }
                SimplifiedSerialization returnObject = null;
                switch (this.type) {
                    case 1: {
                        returnObject = this.currentEntry.data;
                        break;
                    }
                    case 2: {
                        returnObject = this.currentEntry;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", new Object[]{returnObject});
                }
                return returnObject;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPrevious(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasPrevious", new Object[]{transaction});
                }
                boolean returnValue = false;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    Link nextAvailableEntry;
                    if ((this.beyondEndOfList || this.currentEntry != null) && (nextAvailableEntry = this.nextAvailable(transaction, 1)) != null) {
                        returnValue = true;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasPrevious", new Object[]{new Boolean(returnValue)});
                }
                return returnValue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean hasPrevious() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasPrevious", new Object[]{this.currentEntry});
                }
                boolean returnValue = false;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    Link nextAvailableEntry;
                    if ((this.beyondEndOfList || this.currentEntry != null) && (nextAvailableEntry = this.nextAvailable(1)) != null) {
                        returnValue = true;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasPrevious", new Object[]{new Boolean(returnValue)});
                }
                return returnValue;
            }

            @Override
            public synchronized Object previous(Transaction transaction) {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized Object previous() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "previous", new Object[]{this.currentEntry});
                }
                SimplifiedSerialization currentObject = null;
                LinkedList linkedList = SubList.this.list;
                synchronized (linkedList) {
                    if (this.beyondEndOfList || this.currentEntry != null) {
                        this.currentEntry = this.nextAvailable(1);
                        this.nextEntry = null;
                        if (this.currentEntry == null) {
                            this.beyondEndOfList = true;
                        }
                    }
                    if (!this.beyondEndOfList && this.currentEntry == null) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                        }
                        throw new NoSuchElementException();
                    }
                    switch (this.type) {
                        case 1: {
                            currentObject = this.currentEntry.data;
                            break;
                        }
                        case 2: {
                            currentObject = this.currentEntry;
                        }
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "next", new Object[]{currentObject});
                }
                return currentObject;
            }

            @Override
            public long nextIndex(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long previousIndex(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Token newToken, Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "set", new Object[]{newToken, transaction});
                }
                if (this.currentEntry == null || this.beyondEndOfList) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "set", "via IllegalStateException");
                    }
                    throw new IllegalStateException();
                }
                this.currentEntry.setValue(newToken, transaction);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "set");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void add(Token newToken, Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "add", new Object[]{newToken, transaction});
                }
                InternalTransaction internalTransaction = transaction.internalTransaction;
                synchronized (internalTransaction) {
                    LinkedList linkedList = SubList.this.list;
                    synchronized (linkedList) {
                        if (this.beyondEndOfList) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "remove", "via IllegalStateException");
                            }
                            throw new IllegalStateException();
                        }
                        if (this.currentEntry.state == 7 || this.currentEntry.state == 8) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "add", "via java.util.ConcurrentModificationException");
                            }
                            throw new ConcurrentModificationException();
                        }
                        this.currentEntry = SubList.this.list.insert(newToken, this.currentEntry, transaction);
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "add");
                }
            }
        }
    }
}

