/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractList;
import com.ibm.ws.objectManager.AbstractListView;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.CollectionNotEmptyException;
import com.ibm.ws.objectManager.ConcurrentSubList;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.LinkedList;
import com.ibm.ws.objectManager.List;
import com.ibm.ws.objectManager.ListIterator;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.SubListEntryNotInListException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ConcurrentLinkedList
extends AbstractList
implements List,
SimplifiedSerialization,
Printable {
    private static final Class cclass = ConcurrentLinkedList.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(ConcurrentLinkedList.class, "ObjectManagerLists");
    private static final long serialVersionUID = 1260307151888854043L;
    private int activeSubListCount = 0;
    private transient ConcurrentSubList[] subLists;
    private Token[] subListTokens;
    protected transient long headSequenceNumber;
    transient HeadSequenceNumberLock headSequenceNumberLock;
    private transient long tailSequenceNumber;
    transient TailSequenceNumberLock tailSequenceNumberLock;
    private transient boolean tailSequenceNumberSet = false;
    protected transient long removeFirstPredictedSubListCount = 0L;
    protected transient long removeFirstFullSearchCount = 0L;
    protected transient long removeUncontendedCount = 0L;
    protected transient long removeContendedCount = 0L;
    private static final byte SimpleSerialVersion = 0;

    public ConcurrentLinkedList(Transaction transaction, ObjectStore objectStore, int subListCount) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{transaction, objectStore, new Integer(subListCount)});
        }
        Token objectManagerList = objectStore.allocate(this);
        this.activeSubListCount = subListCount;
        this.subLists = new ConcurrentSubList[subListCount];
        this.subListTokens = new Token[subListCount];
        this.headSequenceNumber = 0L;
        this.headSequenceNumberLock = new HeadSequenceNumberLock();
        this.tailSequenceNumber = 0L;
        this.tailSequenceNumberLock = new TailSequenceNumberLock();
        this.tailSequenceNumberSet = true;
        for (int i = 0; i < this.subLists.length; ++i) {
            this.subLists[i] = new ConcurrentSubList(objectManagerList, transaction, objectStore);
            this.subListTokens[i] = this.subLists[i].getToken();
        }
        transaction.add(this);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public int getActiveSublistCount() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getActiveSublistCount");
            trace.exit((Object)this, cclass, "getActiveSublistCount", "return=" + this.activeSubListCount);
        }
        return this.activeSubListCount;
    }

    public void incrementHeadSequenceNumber(ConcurrentSubList.Link link) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "incrementheadSequenceNumber", new Object[]{link});
        }
        if (link.next == null) {
            ++this.headSequenceNumber;
        } else {
            ConcurrentSubList.Link nextLink = (ConcurrentSubList.Link)link.next.getManagedObject();
            if (nextLink.sequenceNumber != this.headSequenceNumber) {
                ++this.headSequenceNumber;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "incrementHeadSequenceNumber", new Object[]{new Long(this.headSequenceNumber)});
        }
    }

    private final ConcurrentSubList getSublist(long sequenceNumber) {
        return this.subLists[(int)(sequenceNumber % (long)this.activeSubListCount)];
    }

    private void resetTailSequenceNumber() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "resetTailSequenceNumber");
        }
        for (int i = 0; i < this.subListTokens.length; ++i) {
            this.subLists[i] = (ConcurrentSubList)this.subListTokens[i].getManagedObject();
            Token tailToken = this.subLists[i].tail;
            if (tailToken == null) continue;
            ConcurrentSubList.Link tail = (ConcurrentSubList.Link)tailToken.getManagedObject();
            this.tailSequenceNumber = Math.max(this.tailSequenceNumber, tail.sequenceNumber);
        }
        this.tailSequenceNumberSet = true;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "resetHeadSequenceNumber");
        }
    }

    public Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        long maximumAvailableSizeOfAnySublist = 0L;
        for (int i = 0; i < this.subLists.length; ++i) {
            maximumAvailableSizeOfAnySublist = Math.max(maximumAvailableSizeOfAnySublist, this.subLists[i].maximumAvailableSize);
        }
        HashMap<String, String> statistics = new HashMap<String, String>();
        statistics.put("removeFirstPredictedSubListRemoveCount", Long.toString(this.removeFirstPredictedSubListCount));
        statistics.put("removeFirstFullSearchCount", Long.toString(this.removeFirstFullSearchCount));
        statistics.put("maximumAvailableSizeOfAnySublist", Long.toString(maximumAvailableSizeOfAnySublist));
        statistics.put("removeContendedCount", Long.toString(this.removeContendedCount));
        statistics.put("removeUncontendedCount", Long.toString(this.removeUncontendedCount));
        this.removeFirstPredictedSubListCount = 0L;
        this.removeFirstFullSearchCount = 0L;
        this.removeUncontendedCount = 0L;
        this.removeContendedCount = 0L;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", "returns statistics=" + statistics + "(java.util.Map)");
        }
        return statistics;
    }

    @Override
    public long size(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "size", "Transaction=" + transaction);
        }
        long totalSize = 0L;
        for (int i = 0; i < this.subLists.length; ++i) {
            totalSize += this.subLists[i].size(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", "return=" + totalSize);
        }
        return totalSize;
    }

    @Override
    public long size() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "size");
        }
        long totalSize = 0L;
        for (int i = 0; i < this.subLists.length; ++i) {
            totalSize += this.subLists[i].size();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", "return=" + totalSize);
        }
        return totalSize;
    }

    @Override
    public boolean isEmpty(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "isEmpty", "Transaction=" + transaction);
        }
        boolean empty = true;
        for (int i = 0; i < this.subLists.length; ++i) {
            if (this.subLists[i].isEmpty(transaction)) continue;
            empty = false;
            break;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "size", "return=" + empty);
        }
        return empty;
    }

    @Override
    public Iterator iterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "iterator");
        }
        Iterator iterator = this.subList(null, null).iterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "iterator", new Object[]{iterator});
        }
        return iterator;
    }

    @Override
    public ListIterator listIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "listIterator");
        }
        ListIterator listIterator = this.subList(null, null).listIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "listIterator", new Object[]{listIterator});
        }
        return listIterator;
    }

    @Override
    public Iterator entryIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "entryIterator");
        }
        Iterator entryIterator = this.subList(null, null).entryIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "entryIterator", new Object[]{entryIterator});
        }
        return entryIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Token token, Transaction transaction) throws ObjectManagerException {
        boolean modified;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{token, transaction});
        }
        ConcurrentSubList.Link newEntry = null;
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            this.tailSequenceNumberLock.lock();
            try {
                if (!this.tailSequenceNumberSet) {
                    this.resetTailSequenceNumber();
                }
                long usableTailSequenceNumber = ++this.tailSequenceNumber;
                ConcurrentSubList list = this.getSublist(usableTailSequenceNumber);
                newEntry = list.addEntry(token, transaction, usableTailSequenceNumber);
            }
            finally {
                if (this.tailSequenceNumberLock.isHeldByCurrentThread()) {
                    this.tailSequenceNumberLock.unlock();
                }
            }
        }
        boolean bl = modified = newEntry != null;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "add", new Object[]{new Boolean(modified)});
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List.Entry addEntry(Token token, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addEntry", new Object[]{token, transaction});
        }
        ConcurrentSubList.Link newEntry = null;
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            this.tailSequenceNumberLock.lock();
            try {
                if (!this.tailSequenceNumberSet) {
                    this.resetTailSequenceNumber();
                }
                long usableTailSequenceNumber = ++this.tailSequenceNumber;
                ConcurrentSubList list = this.getSublist(usableTailSequenceNumber);
                newEntry = list.addEntry(token, transaction, usableTailSequenceNumber);
            }
            finally {
                if (this.tailSequenceNumberLock.isHeldByCurrentThread()) {
                    this.tailSequenceNumberLock.unlock();
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addEntry", new Object[]{newEntry});
        }
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentSubList.Link insert(Token token, ConcurrentSubList.Link insertPoint, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "insert", new Object[]{token, insertPoint, transaction});
        }
        ConcurrentSubList.Link newLink = null;
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            long sequenceNumber = insertPoint.sequenceNumber;
            ConcurrentSubList list = this.getSublist(--sequenceNumber);
            this.tailSequenceNumberLock.lock();
            try {
                newLink = list.addEntry(token, transaction, sequenceNumber);
            }
            finally {
                if (this.tailSequenceNumberLock.isHeldByCurrentThread()) {
                    this.tailSequenceNumberLock.unlock();
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "insert", new Object[]{newLink});
        }
        return newLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token removeFirst(Transaction transaction) throws ObjectManagerException {
        String methodName = "removeFirst";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "removeFirst", new Object[]{transaction});
        }
        ConcurrentSubList.Link firstLink = null;
        Token tokenToReturn = null;
        ConcurrentSubList subListForRemoval = null;
        HeadSequenceNumberLock headSequenceNumberLock = this.headSequenceNumberLock;
        synchronized (headSequenceNumberLock) {
            long unlockPoint = this.getTransactionUnlockSequence();
            ConcurrentSubList concurrentSubList = subListForRemoval = this.getSublist(this.headSequenceNumber);
            synchronized (concurrentSubList) {
                firstLink = (ConcurrentSubList.Link)subListForRemoval.nextLink(null, transaction, unlockPoint);
                if (firstLink != null) {
                    if (firstLink.sequenceNumber == this.headSequenceNumber) {
                        firstLink.requestDelete(transaction);
                        if (!firstLink.isLocked()) {
                            subListForRemoval.decrementAvailableSize();
                        }
                        this.incrementHeadSequenceNumber(firstLink);
                        tokenToReturn = firstLink.data;
                    } else {
                        firstLink = null;
                    }
                }
            }
            if (firstLink == null) {
                this.tailSequenceNumberLock.lock();
                try {
                    if (this.headSequenceNumber == this.tailSequenceNumber + 1L) {
                        throw new NoSuchElementException();
                    }
                    if (!this.tailSequenceNumberSet) {
                        this.resetTailSequenceNumber();
                    }
                    this.headSequenceNumber = this.tailSequenceNumber + 1L;
                    long fullSearchHeadSequenceNumber = Long.MAX_VALUE;
                    for (int i = 0; i < this.subLists.length; ++i) {
                        ConcurrentSubList concurrentSubList2 = this.subLists[i];
                        synchronized (concurrentSubList2) {
                            ConcurrentSubList.Link head;
                            ConcurrentSubList.Link first = (ConcurrentSubList.Link)this.subLists[i].nextLink(null, transaction, unlockPoint);
                            if (first != null && first.sequenceNumber < fullSearchHeadSequenceNumber) {
                                fullSearchHeadSequenceNumber = first.sequenceNumber;
                                subListForRemoval = this.subLists[i];
                                firstLink = first;
                                tokenToReturn = firstLink.data;
                            }
                            if ((head = (ConcurrentSubList.Link)this.subLists[i].firstAvailableLink()) != null) {
                                this.headSequenceNumber = Math.min(this.headSequenceNumber, head.sequenceNumber);
                            }
                            continue;
                        }
                    }
                }
                finally {
                    if (this.tailSequenceNumberLock.isHeldByCurrentThread()) {
                        this.tailSequenceNumberLock.unlock();
                    }
                }
                if (firstLink == null) {
                    NoSuchElementException exception = new NoSuchElementException();
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "removeFirst", exception);
                    }
                    throw exception;
                }
                ConcurrentSubList concurrentSubList3 = subListForRemoval;
                synchronized (concurrentSubList3) {
                    firstLink.requestDelete(transaction);
                    if (!firstLink.isLocked()) {
                        subListForRemoval.decrementAvailableSize();
                    }
                    if (firstLink.sequenceNumber == this.headSequenceNumber) {
                        this.incrementHeadSequenceNumber(firstLink);
                    }
                }
            }
        }
        try {
            transaction.delete(firstLink, ConcurrentSubList.logSpaceForDelete());
        }
        catch (LogFileFullException exception) {
            firstLink.unRemove(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "removeFirst", exception);
            }
            throw exception;
        }
        catch (InvalidStateException exception) {
            ObjectManager.ffdc.processException(this, cclass, "removeFirst", exception, "1:793:1.26");
            firstLink.unRemove(this);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "removeFirst", exception);
            }
            throw exception;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "removeFirst", new Object[]{tokenToReturn});
        }
        return tokenToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Token token, Transaction transaction) throws ObjectManagerException {
        String methodName = "remove";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, transaction});
        }
        ConcurrentSubList.Link linkToRemove = this.findLink(token, transaction);
        boolean found = false;
        if (linkToRemove != null) {
            LinkedList linkedList;
            HeadSequenceNumberLock headSequenceNumberLock = this.headSequenceNumberLock;
            synchronized (headSequenceNumberLock) {
                linkedList = linkToRemove.list;
                synchronized (linkedList) {
                    if (linkToRemove.state == 3 || linkToRemove.state == 2 && linkToRemove.lockedBy(transaction)) {
                        linkToRemove.requestDelete(transaction);
                        if (!linkToRemove.isLocked()) {
                            linkToRemove.list.decrementAvailableSize();
                        }
                        found = true;
                        if (linkToRemove.sequenceNumber == this.headSequenceNumber) {
                            this.incrementHeadSequenceNumber(linkToRemove);
                        }
                    }
                }
            }
            if (!found) {
                headSequenceNumberLock = this.headSequenceNumberLock;
                synchronized (headSequenceNumberLock) {
                    linkToRemove = this.findLink(token, transaction);
                    if (linkToRemove != null) {
                        linkedList = linkToRemove.list;
                        synchronized (linkedList) {
                            linkToRemove.requestDelete(transaction);
                            if (!linkToRemove.isLocked()) {
                                linkToRemove.list.decrementAvailableSize();
                            }
                            found = true;
                            if (linkToRemove.sequenceNumber == this.headSequenceNumber) {
                                this.incrementHeadSequenceNumber(linkToRemove);
                            }
                        }
                    }
                }
            }
        }
        if (linkToRemove != null) {
            try {
                transaction.delete(linkToRemove, ConcurrentSubList.logSpaceForDelete());
            }
            catch (LogFileFullException exception) {
                linkToRemove.unRemove(this);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", exception);
                }
                throw exception;
            }
            catch (InvalidStateException exception) {
                ObjectManager.ffdc.processException(this, cclass, "remove", exception, "1:912:1.26");
                linkToRemove.unRemove(this);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", exception);
                }
                throw exception;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "remove", new Object[]{new Boolean(found)});
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentSubList.Link findLink(Object existingObject, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "findLink", "ExistingObject=" + existingObject + ", Transaction=" + transaction);
        }
        ConcurrentSubList.Link foundLink = null;
        long linkSequenceNumber = Long.MAX_VALUE;
        long unlockPoint = this.getTransactionUnlockSequence();
        for (int i = 0; i < this.subLists.length; ++i) {
            ConcurrentSubList concurrentSubList = this.subLists[i];
            synchronized (concurrentSubList) {
                ConcurrentSubList.Link nextLink = null;
                nextLink = (ConcurrentSubList.Link)this.subLists[i].nextLink(null, transaction, unlockPoint);
                while (nextLink != null && nextLink.data != existingObject) {
                    nextLink = (ConcurrentSubList.Link)this.subLists[i].nextLink(nextLink, transaction, unlockPoint);
                }
                if (nextLink != null && nextLink.sequenceNumber < linkSequenceNumber) {
                    linkSequenceNumber = nextLink.sequenceNumber;
                    foundLink = nextLink;
                }
                continue;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "findLink", "return=" + foundLink);
        }
        return foundLink;
    }

    @Override
    public List subList(List.Entry fromEntry, List.Entry toEntry) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "subList", new Object[]{fromEntry, toEntry});
        }
        SubList subList = new SubList(this, (ConcurrentSubList.Link)fromEntry, (ConcurrentSubList.Link)toEntry);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "subList", subList);
        }
        return subList;
    }

    @Override
    public Set entrySet() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "entrySet");
        }
        EntrySet entrySet = new EntrySet();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "entrySet", new Object[]{entrySet});
        }
        return entrySet;
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        printWriter.println("State Dump for:" + cclass.getName() + " headSequenceNumber=" + this.headSequenceNumber + "(long) tailSequenceNumber=" + this.tailSequenceNumber + "(long)");
        printWriter.println();
        printWriter.println("Sublists...");
        for (int i = 0; i < this.subLists.length; ++i) {
            this.subLists[i].print(printWriter);
        }
    }

    @Override
    public synchronized boolean validate(PrintStream printStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "validate", new Object[]{printStream});
        }
        boolean valid = true;
        for (int i = 0; i < this.subLists.length; ++i) {
            if (this.subLists[i].validate(printStream)) continue;
            valid = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "validate", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    @Override
    public void becomeCloneOf(ManagedObject other) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", "Other=" + other);
        }
        ConcurrentLinkedList otherConcurrentLinkedList = (ConcurrentLinkedList)other;
        this.subLists = otherConcurrentLinkedList.subLists;
        this.headSequenceNumber = otherConcurrentLinkedList.headSequenceNumber;
        this.tailSequenceNumber = otherConcurrentLinkedList.tailSequenceNumber;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDelete(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preDelete", "transaction=" + transaction + "(Transaction)");
        }
        HeadSequenceNumberLock headSequenceNumberLock = this.headSequenceNumberLock;
        synchronized (headSequenceNumberLock) {
            this.tailSequenceNumberLock.lock();
            try {
                if (transaction.getObjectManagerStateState() != 2) {
                    for (int i = 0; i < this.subLists.length; ++i) {
                        Token nextToken = this.subLists[i].head;
                        while (nextToken != null) {
                            LinkedList.Link nextLink = (LinkedList.Link)nextToken.getManagedObject();
                            if (nextLink.willBeDeleted(transaction)) {
                                nextToken = nextLink.next;
                                continue;
                            }
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "preDelete", "via CollentionNotEmptyExceptionsize()=" + this.size() + "(long) nextLink.state=" + nextLink.state + "(int) " + LinkedList.Link.stateNames[nextLink.state] + "\n nextLink.getTransactionLock()=" + nextLink.getTransactionLock() + "(TransactionLock)");
                            }
                            throw new CollectionNotEmptyException((Object)this, this.size(), transaction);
                        }
                    }
                }
                super.preDelete(transaction);
                if (transaction.getObjectManagerStateState() != 2) {
                    transaction.optimisticReplace(null, null, Arrays.asList(this.subLists), null);
                }
            }
            finally {
                if (this.tailSequenceNumberLock.isHeldByCurrentThread()) {
                    this.tailSequenceNumberLock.unlock();
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preDelete");
        }
    }

    ConcurrentLinkedList() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public int getSignature() {
        return 7;
    }

    @Override
    public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", "dataOutputStream=" + dataOutputStream);
        }
        try {
            dataOutputStream.writeByte(0);
            super.writeObject(dataOutputStream);
            dataOutputStream.writeInt(this.activeSubListCount);
            for (int i = 0; i < this.subListTokens.length; ++i) {
                this.subListTokens[i].writeObject(dataOutputStream);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:1229:1.26");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "DataInputStream=" + dataInputStream + ", ObjectManagerState=" + objectManagerState);
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", "version=" + version + "(byte)");
            }
            super.readObject(dataInputStream, objectManagerState);
            this.activeSubListCount = dataInputStream.readInt();
            this.subListTokens = new Token[this.activeSubListCount];
            for (int i = 0; i < this.subListTokens.length; ++i) {
                this.subListTokens[i] = Token.restore(dataInputStream, objectManagerState);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:1280:1.26");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.headSequenceNumber = Long.MAX_VALUE;
        this.headSequenceNumberLock = new HeadSequenceNumberLock();
        this.tailSequenceNumber = 0L;
        this.tailSequenceNumberLock = new TailSequenceNumberLock();
        this.subLists = new ConcurrentSubList[this.subListTokens.length];
        for (int i = 0; i < this.subListTokens.length; ++i) {
            ManagedObject managedObject = this.subListTokens[i].getManagedObject();
            if (!(managedObject instanceof ConcurrentSubList)) continue;
            this.subLists[i] = (ConcurrentSubList)managedObject;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    protected static class ReentrantLock {
        private int locked = 0;
        private Thread lockingThread;
        private int waiters = 0;

        private ReentrantLock() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void lock() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "lock", new Object[]{new Integer(this.locked), this.lockingThread, new Integer(this.waiters)});
            }
            Thread thisThread = Thread.currentThread();
            ReentrantLock reentrantLock = this;
            synchronized (reentrantLock) {
                while (this.lockingThread != thisThread && this.lockingThread != null) {
                    ++this.waiters;
                    while (true) {
                        try {
                            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                trace.debug((Object)this, cclass, "lock", new Object[]{"About to wait():2174", new Integer(this.waiters)});
                            }
                            this.wait();
                        }
                        catch (InterruptedException exception) {
                            ObjectManager.ffdc.processException(this, cclass, "lock", exception, "1:2185:1.26");
                            if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) continue;
                            trace.event(this, cclass, "addBuffers", exception);
                            continue;
                        }
                        break;
                    }
                    --this.waiters;
                }
                ++this.locked;
                this.lockingThread = thisThread;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "lock");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unlock() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "unlock", new Object[]{new Integer(this.waiters)});
            }
            ReentrantLock reentrantLock = this;
            synchronized (reentrantLock) {
                if (this.lockingThread != Thread.currentThread()) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "unlock", new Object[]{this.lockingThread});
                    }
                    throw new IllegalMonitorStateException("Holder:" + this.lockingThread);
                }
                --this.locked;
                if (this.locked == 0) {
                    this.lockingThread = null;
                    if (this.waiters > 0) {
                        this.notify();
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "unlock");
            }
        }

        boolean isHeldByCurrentThread() {
            return this.lockingThread == Thread.currentThread();
        }
    }

    class EntrySet
    extends AbstractSetView {
        EntrySet() {
        }

        @Override
        public Iterator iterator() throws ObjectManagerException {
            return ConcurrentLinkedList.this.entryIterator();
        }

        @Override
        public long size(Transaction transaction) throws ObjectManagerException {
            return ConcurrentLinkedList.this.size(transaction);
        }

        @Override
        public long size() throws ObjectManagerException {
            return ConcurrentLinkedList.this.size();
        }
    }

    static class SubList
    extends AbstractListView {
        ConcurrentLinkedList list;
        ConcurrentSubList.Link head;
        long headSequenceNumber = 0L;
        ConcurrentSubList.Link tail;
        long tailSequenceNumber = Long.MAX_VALUE;

        private SubList(ConcurrentLinkedList list, ConcurrentSubList.Link head, ConcurrentSubList.Link tail) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{list, head, tail});
            }
            this.list = list;
            this.head = head;
            this.tail = tail;
            if (head != null) {
                if (((ConcurrentSubList)head.list).concurrentListToken != list.getToken() || head.state == 7 || head.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(this, cclass, "subList");
                    }
                    throw new SubListEntryNotInListException(this, head);
                }
                this.headSequenceNumber = head.sequenceNumber;
            }
            if (tail != null) {
                if (((ConcurrentSubList)tail.list).concurrentListToken != list.getToken() || tail.state == 7 || tail.state == 8) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(this, cclass, "subList");
                    }
                    throw new SubListEntryNotInListException(this, tail);
                }
                this.tailSequenceNumber = tail.sequenceNumber;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        public Iterator iterator() throws ObjectManagerException {
            return new SubListIterator(1);
        }

        @Override
        public ListIterator listIterator() throws ObjectManagerException {
            return new SubListIterator(1);
        }

        @Override
        public Iterator entryIterator() throws ObjectManagerException {
            return new SubListIterator(2);
        }

        @Override
        public List.Entry addEntry(Token token, Transaction transaction) throws ObjectManagerException {
            ConcurrentSubList.Link newLink = this.list.insert(token, this.tail, transaction);
            return newLink;
        }

        @Override
        public List subList(List.Entry fromEntry, List.Entry toEntry) throws ObjectManagerException {
            return new SubList(this.list, (ConcurrentSubList.Link)fromEntry, (ConcurrentSubList.Link)toEntry);
        }

        @Override
        public Set entrySet() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "entrySet");
            }
            EntrySet entrySet = new EntrySet();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "entrySet", new Object[]{entrySet});
            }
            return entrySet;
        }

        class EntrySet
        extends AbstractSetView {
            EntrySet() {
            }

            @Override
            public Iterator iterator() throws ObjectManagerException {
                return new SubListIterator(2);
            }
        }

        class SubListIterator
        implements ListIterator {
            static final int VALUES = 1;
            static final int ENTRIES = 2;
            private int type;
            private LinkedList.SubList.SubListIterator[] subListIterator;
            private int currentSubListIndex;
            private long currentSequenceNumber;

            SubListIterator(int type) throws ObjectManagerException {
                int i;
                this.subListIterator = new LinkedList.SubList.SubListIterator[SubList.this.list.subLists.length];
                this.currentSubListIndex = 0;
                this.currentSequenceNumber = 0L;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "<init>", new Object[]{new Integer(type)});
                }
                this.type = type;
                for (i = 0; i < SubList.this.list.subLists.length; ++i) {
                    this.subListIterator[i] = (LinkedList.SubList.SubListIterator)SubList.this.list.subLists[i].entrySet().iterator();
                }
                if (SubList.this.head != null) {
                    if (SubList.this.head.state == 7 || SubList.this.head.state == 8) {
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit(this, cclass, "<intit>");
                        }
                        throw new SubListEntryNotInListException(SubList.this, SubList.this.head);
                    }
                    this.currentSequenceNumber = SubList.this.head.sequenceNumber;
                    block1: for (i = 0; i < SubList.this.list.subLists.length; ++i) {
                        if (SubList.this.list.subLists[i] == SubList.this.head.list) {
                            this.currentSubListIndex = i;
                            this.subListIterator[i].currentEntry = SubList.this.head;
                            continue;
                        }
                        while (this.subListIterator[i].hasNext()) {
                            ConcurrentSubList.Link next = (ConcurrentSubList.Link)this.subListIterator[i].next();
                            if (next.sequenceNumber <= SubList.this.head.sequenceNumber) continue;
                            this.subListIterator[i].previous();
                            continue block1;
                        }
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "<init>");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean hasNext(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasNext", new Object[]{transaction});
                }
                boolean nextExists = false;
                for (int i = 0; i < SubList.this.list.subLists.length && !nextExists; ++i) {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[i];
                    synchronized (concurrentSubList) {
                        if (!this.subListIterator[i].beyondEndOfList) {
                            this.resetCursorIfNoLongerInList(i);
                            ConcurrentSubList.Link nextAvailableEntry = (ConcurrentSubList.Link)this.subListIterator[i].nextAvailable(transaction, 0);
                            if (nextAvailableEntry != null && nextAvailableEntry != SubList.this.tail && nextAvailableEntry.sequenceNumber <= SubList.this.tailSequenceNumber) {
                                nextExists = true;
                            }
                        }
                        continue;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasNext", "return=" + nextExists);
                }
                return nextExists;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean hasNext() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, cclass, "hasNext");
                }
                boolean nextExists = false;
                for (int i = 0; i < SubList.this.list.subLists.length && !nextExists; ++i) {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[i];
                    synchronized (concurrentSubList) {
                        if (!this.subListIterator[i].beyondEndOfList) {
                            this.resetCursorIfNoLongerInList(i);
                            ConcurrentSubList.Link nextAvailableEntry = (ConcurrentSubList.Link)this.subListIterator[i].nextAvailable(0);
                            if (nextAvailableEntry != null && nextAvailableEntry != SubList.this.tail && nextAvailableEntry.sequenceNumber <= SubList.this.tailSequenceNumber) {
                                nextExists = true;
                            }
                        }
                        continue;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasNext", new Object[]{new Boolean(nextExists)});
                }
                return nextExists;
            }

            @Override
            public synchronized Object next(Transaction transaction) throws ObjectManagerException {
                return this.next(true, transaction);
            }

            @Override
            public synchronized Object next() throws ObjectManagerException {
                return this.next(false, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object next(boolean clean, Transaction transaction) throws ObjectManagerException {
                int index;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "next", new Object[]{transaction});
                }
                long nextSequenceNumber = this.currentSequenceNumber;
                long bestSequenceNumber = Long.MAX_VALUE;
                int firstIndex = index = this.currentSubListIndex;
                int bestIndex = -1;
                ConcurrentSubList.Link overallNext = null;
                Object returnObject = null;
                do {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[index];
                    synchronized (concurrentSubList) {
                        if (this.subListIterator[index].beyondEndOfList) {
                            ConcurrentSubList.Link link = (ConcurrentSubList.Link)SubList.this.list.subLists[index].previousLink(null);
                            while (link != null && link.sequenceNumber >= nextSequenceNumber) {
                                this.subListIterator[index].currentEntry = link;
                                this.subListIterator[index].beyondEndOfList = false;
                                link = (ConcurrentSubList.Link)SubList.this.list.subLists[index].previousLink(link);
                            }
                        }
                        if (!this.subListIterator[index].beyondEndOfList) {
                            this.resetCursorIfNoLongerInList(index);
                            ConcurrentSubList.Link next = null;
                            next = clean ? (ConcurrentSubList.Link)this.subListIterator[index].nextAvailable(transaction, 0) : (ConcurrentSubList.Link)this.subListIterator[index].nextAvailable(0);
                            if (next != null && next != SubList.this.tail) {
                                if (next.sequenceNumber == nextSequenceNumber) {
                                    bestSequenceNumber = next.sequenceNumber;
                                    bestIndex = index;
                                    overallNext = next;
                                    returnObject = this.returnObject(overallNext);
                                    break;
                                }
                                if (next.sequenceNumber < bestSequenceNumber && next.sequenceNumber <= SubList.this.tailSequenceNumber) {
                                    bestSequenceNumber = next.sequenceNumber;
                                    bestIndex = index;
                                    overallNext = next;
                                    returnObject = this.returnObject(overallNext);
                                }
                            }
                        }
                    }
                    ++nextSequenceNumber;
                    if (++index != SubList.this.list.subLists.length) continue;
                    index = 0;
                } while (index != firstIndex);
                if (overallNext == null) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "next", "via java.util.NoSuchElementException");
                    }
                    throw new NoSuchElementException();
                }
                this.currentSequenceNumber = bestSequenceNumber;
                this.currentSubListIndex = bestIndex;
                this.subListIterator[bestIndex].currentEntry = overallNext;
                this.subListIterator[bestIndex].nextEntry = null;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "next", "return=" + returnObject);
                }
                return returnObject;
            }

            private void resetCursorIfNoLongerInList(int index) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "resetCursorIfNoLongerInList", new Object[]{this.subListIterator[index].currentEntry});
                }
                if (this.subListIterator[index].currentEntry != null && (this.subListIterator[index].currentEntry.state == 7 || this.subListIterator[index].currentEntry.state == 8)) {
                    ConcurrentSubList.Link next = null;
                    ConcurrentSubList.Link previous = null;
                    next = (ConcurrentSubList.Link)SubList.this.list.subLists[index].nextLink(next);
                    while (next != null && next.sequenceNumber < this.currentSequenceNumber) {
                        previous = next;
                        next = (ConcurrentSubList.Link)SubList.this.list.subLists[index].nextLink(next);
                    }
                    this.subListIterator[index].currentEntry = previous;
                    this.subListIterator[index].nextEntry = null;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "resetCursorIfNoLongerInList", new Object[]{this.subListIterator[index].currentEntry});
                }
            }

            @Override
            public synchronized Object remove(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "remove", "Transaction=" + transaction);
                }
                ConcurrentSubList.Link link = (ConcurrentSubList.Link)this.subListIterator[this.currentSubListIndex].remove(transaction);
                Object returnObject = this.returnObject(link);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "remove", new Object[]{returnObject});
                }
                return returnObject;
            }

            private Object returnObject(ConcurrentSubList.Link link) {
                switch (this.type) {
                    case 1: {
                        return link.data;
                    }
                    case 2: {
                        return link;
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPrevious(Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "hasPrevious", new Object[]{transaction});
                }
                boolean nextExists = false;
                for (int i = 0; i < SubList.this.list.subLists.length && !nextExists; ++i) {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[i];
                    synchronized (concurrentSubList) {
                        ConcurrentSubList.Link nextAvailableEntry;
                        if ((this.subListIterator[i].beyondEndOfList || this.subListIterator[i].currentEntry != null) && (nextAvailableEntry = (ConcurrentSubList.Link)this.subListIterator[i].nextAvailable(transaction, 1)) != null && nextAvailableEntry != SubList.this.head && nextAvailableEntry.sequenceNumber >= SubList.this.headSequenceNumber) {
                            nextExists = true;
                        }
                        continue;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasPrevious", new Object[]{new Boolean(nextExists)});
                }
                return nextExists;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPrevious() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, cclass, "hasPrevious");
                }
                boolean nextExists = false;
                for (int i = 0; i < SubList.this.list.subLists.length && !nextExists; ++i) {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[i];
                    synchronized (concurrentSubList) {
                        ConcurrentSubList.Link nextAvailableEntry;
                        if ((this.subListIterator[i].beyondEndOfList || this.subListIterator[i].currentEntry != null) && (nextAvailableEntry = (ConcurrentSubList.Link)this.subListIterator[i].nextAvailable(1)) != null && nextAvailableEntry != SubList.this.head && nextAvailableEntry.sequenceNumber <= SubList.this.headSequenceNumber) {
                            nextExists = true;
                        }
                        continue;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "hasPrevious", new Object[]{new Boolean(nextExists)});
                }
                return nextExists;
            }

            @Override
            public Object previous(Transaction transaction) {
                return null;
            }

            @Override
            public Object previous() {
                return null;
            }

            @Override
            public long nextIndex(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long previousIndex(Transaction transaction) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Token newToken, Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "set", new Object[]{newToken, transaction});
                }
                this.subListIterator[this.currentSubListIndex].set(newToken, transaction);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "set");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void add(Token newToken, Transaction transaction) throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, cclass, "add", new Object[]{newToken, transaction});
                }
                InternalTransaction internalTransaction = transaction.internalTransaction;
                synchronized (internalTransaction) {
                    ConcurrentSubList concurrentSubList = SubList.this.list.subLists[this.currentSubListIndex];
                    synchronized (concurrentSubList) {
                        if (this.subListIterator[this.currentSubListIndex].beyondEndOfList) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "remove", "via IllegalStateException");
                            }
                            throw new IllegalStateException();
                        }
                        if (this.subListIterator[this.currentSubListIndex].currentEntry.state == 7 || this.subListIterator[this.currentSubListIndex].currentEntry.state == 8) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "add", "via java.util.ConcurrentModificationException");
                            }
                            throw new ConcurrentModificationException();
                        }
                        ConcurrentSubList.Link newLink = SubList.this.list.insert(newToken, (ConcurrentSubList.Link)this.subListIterator[this.currentSubListIndex].currentEntry, transaction);
                        for (int i = 0; i < SubList.this.list.subLists.length; ++i) {
                            if (SubList.this.list.subLists[i] == newLink.list) continue;
                            this.subListIterator[this.currentSubListIndex].currentEntry = newLink;
                            this.currentSubListIndex = i;
                            break;
                        }
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "add");
                }
            }
        }
    }

    class TailSequenceNumberLock
    extends java.util.concurrent.locks.ReentrantLock {
        private static final long serialVersionUID = 7094411719880377822L;

        TailSequenceNumberLock() {
        }
    }

    class HeadSequenceNumberLock {
        HeadSequenceNumberLock() {
        }
    }
}

