/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Collection;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileUpdateMonitor
extends UpdateMonitor {
    private boolean exists = false;
    private long monitoredTime = 0L;
    private long monitoredSize = 0L;
    static final long serialVersionUID = -8937614448314067906L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected FileUpdateMonitor(File monitoredFile) {
        super(monitoredFile, UpdateMonitor.MonitorType.FILE);
    }

    @Override
    public void init(Collection<File> baseline) {
        this.exists = this.monitoredFile.isFile();
        this.performScan(this.monitoredFile);
        if (this.exists) {
            this.addToList(baseline, this.monitoredFile);
        }
    }

    @Override
    protected void destroy() {
    }

    @Override
    public void scanForUpdates(Collection<File> created, Collection<File> modified, Collection<File> deleted) {
        if (this.monitoredFile.isFile()) {
            if (this.performScan(this.monitoredFile)) {
                if (this.exists) {
                    this.addToList(modified, this.monitoredFile);
                } else {
                    this.exists = true;
                    this.addToList(created, this.monitoredFile);
                }
            }
        } else if (this.exists) {
            this.addToList(deleted, this.monitoredFile);
            this.exists = false;
            this.monitoredTime = 0L;
            this.monitoredSize = 0L;
        }
    }

    private boolean performScan(File monitoredFile) {
        long newTime = monitoredFile.lastModified();
        long newSize = monitoredFile.length();
        if (newTime != this.monitoredTime || newSize != this.monitoredSize) {
            this.monitoredTime = newTime;
            this.monitoredSize = newSize;
            return true;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FileUpdateMonitor.class);
    }
}

