/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AlpineTracingClassAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AlpineTracingMethodAdapter
extends AbstractRasMethodAdapter<AbstractTracingRasClassAdapter> {
    boolean skipTraces = false;
    boolean modifiedMethod = false;

    public AlpineTracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(classAdapter, true, visitor, access, methodName, descriptor, signature, exceptions);
    }

    public AlpineTracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, boolean skipTraces, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        this(classAdapter, visitor, access, methodName, descriptor, signature, exceptions);
        this.skipTraces = skipTraces;
    }

    private void setModifiedMethod(boolean modified) {
        this.modifiedMethod = modified;
    }

    public boolean isModifiedMethod() {
        return this.modifiedMethod;
    }

    @Override
    public boolean onMethodEntry() {
        if (this.skipTraces || this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        if (this.isStatic() || this.isConstructor() || this.isStaticInitializer()) {
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.createTraceArrayForParameters();
            this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "entry", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}));
        } else {
            this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.createTraceArrayForParameters();
            this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "entry", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}));
        }
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onMethodReturn() {
        if (this.skipTraces || this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isEntryEnabled", skipTraceLabel);
        boolean traceValueOnStack = this.setupReturnObjectValueForExitTrace();
        if (traceValueOnStack) {
            if (this.isStatic()) {
                this.visitGetTraceObjectField();
                this.visitInsn(95);
                this.visitLoadMethodName();
                this.visitInsn(95);
                this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}));
            } else {
                this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
                this.visitInsn(95);
                this.visitGetTraceObjectField();
                this.visitInsn(95);
                this.visitLoadMethodName();
                this.visitInsn(95);
                this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object.class)}));
            }
        } else if (this.isStatic()) {
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class)}));
        } else {
            this.visitVarInsn(((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassType().getOpcode(21), 0);
            this.visitGetTraceObjectField();
            this.visitLoadMethodName();
            this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "exit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class)}));
        }
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onThrowInstruction() {
        if (this.skipTraces || !((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnThrow() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        this.visitInsn(89);
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is rasing exception");
        this.visitInsn(95);
        this.visitLdcInsn(4);
        this.visitTypeInsn(189, "java/lang/Object");
        this.visitInsn(90);
        this.visitInsn(95);
        this.visitInsn(3);
        this.visitInsn(95);
        this.visitInsn(83);
        this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "debug", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, Type.getType(String.class), Type.getType(Object[].class)}));
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public boolean onExceptionHandlerEntry(Type exception, int var) {
        if (this.skipTraces || !((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnHandling() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isDebugEnabled", skipTraceLabel);
        if (var == -1) {
            this.visitInsn(89);
        } else {
            this.visitVarInsn(25, var);
        }
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLdcInsn(this.getMethodName() + " is handling exception");
        this.visitInsn(95);
        this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "debug", "(Lcom/ibm/websphere/ras/TraceComponent;Ljava/lang/String;Ljava/lang/Object;)V");
        this.visitLabel(skipTraceLabel);
        this.setModifiedMethod(true);
        return true;
    }

    @Override
    public void initializeTraceObjectField() {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceObjectFieldInitializationRequired() || this.isAlreadyTraced()) {
            return;
        }
        this.visitGetClassForType(Type.getObjectType((String)((AbstractTracingRasClassAdapter)this.getClassAdapter()).getClassInternalName()));
        this.visitMethodInsn(184, AlpineTracingClassAdapter.TR_TYPE.getInternalName(), "register", Type.getMethodDescriptor((Type)AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE, (Type[])new Type[]{Type.getType(Class.class)}));
        this.visitSetTraceObjectField();
        this.setModifiedMethod(true);
    }

    private void visitInvokeTraceGuardMethod(String guardMethodName, Label skipTraceLabel) {
        this.visitMethodInsn(184, AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), "isAnyTracingEnabled", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]));
        this.visitJumpInsn(153, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitJumpInsn(198, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitMethodInsn(182, AlpineTracingClassAdapter.TRACE_COMPONENT_TYPE.getInternalName(), guardMethodName, Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]));
        this.visitJumpInsn(153, skipTraceLabel);
    }

    @Override
    protected void boxSensitive(Type type) {
        if (type.getSort() == 9 || type.getSort() == 10) {
            this.visitMethodInsn(184, "com/ibm/websphere/ras/DataFormatHelper", "sensitiveToString", "(Ljava/lang/Object;)Ljava/lang/String;");
        } else {
            super.boxSensitive(type);
        }
    }
}

