/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.BERInputStream;
import com.ibm.ws.transport.iiop.asn1.DERBMPString;
import com.ibm.ws.transport.iiop.asn1.DERBitString;
import com.ibm.ws.transport.iiop.asn1.DERBoolean;
import com.ibm.ws.transport.iiop.asn1.DERConstructedSequence;
import com.ibm.ws.transport.iiop.asn1.DERConstructedSet;
import com.ibm.ws.transport.iiop.asn1.DEREnumerated;
import com.ibm.ws.transport.iiop.asn1.DERGeneralString;
import com.ibm.ws.transport.iiop.asn1.DERGeneralizedTime;
import com.ibm.ws.transport.iiop.asn1.DERIA5String;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERNull;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DEROctetString;
import com.ibm.ws.transport.iiop.asn1.DERPrintableString;
import com.ibm.ws.transport.iiop.asn1.DERT61String;
import com.ibm.ws.transport.iiop.asn1.DERTaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERTags;
import com.ibm.ws.transport.iiop.asn1.DERUTCTime;
import com.ibm.ws.transport.iiop.asn1.DERUTF8String;
import com.ibm.ws.transport.iiop.asn1.DERUniversalString;
import com.ibm.ws.transport.iiop.asn1.DERUnknownTag;
import com.ibm.ws.transport.iiop.asn1.DERVisibleString;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DERInputStream
extends FilterInputStream
implements DERTags {
    static final long serialVersionUID = 7465015924868526396L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DERInputStream(InputStream is) {
        super(is);
    }

    protected int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
        }
        return length;
    }

    protected void readFully(byte[] bytes) throws IOException {
        int left = bytes.length;
        if (left == 0) {
            return;
        }
        while (left > 0) {
            int l = this.read(bytes, bytes.length - left, left);
            if (l < 0) {
                throw new EOFException("unexpected end of stream");
            }
            left -= l;
        }
    }

    protected DERObject buildObject(int tag, byte[] bytes) throws IOException {
        switch (tag) {
            case 5: {
                return null;
            }
            case 48: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                DERConstructedSequence seq = new DERConstructedSequence();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        seq.addObject(obj);
                    }
                }
                catch (EOFException obj) {
                    FFDCFilter.processException((Throwable)obj, (String)"com.ibm.ws.transport.iiop.asn1.DERInputStream", (String)"138", (Object)this, (Object[])new Object[]{tag, bytes});
                    return seq;
                }
            }
            case 49: {
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
                BERInputStream dIn = new BERInputStream(bIn);
                ASN1EncodableVector v = new ASN1EncodableVector();
                try {
                    while (true) {
                        DERObject obj = dIn.readObject();
                        v.add(obj);
                    }
                }
                catch (EOFException obj) {
                    FFDCFilter.processException((Throwable)obj, (String)"com.ibm.ws.transport.iiop.asn1.DERInputStream", (String)"157", (Object)this, (Object[])new Object[]{tag, bytes});
                    return new DERConstructedSet(v);
                }
            }
            case 1: {
                return new DERBoolean(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                byte padBits = bytes[0];
                byte[] data = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
                return new DERBitString(data, (int)padBits);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            if ((tag & 0x1F) == 31) {
                throw new IOException("unsupported high tag encountered");
            }
            if (bytes.length == 0) {
                if ((tag & 0x20) == 0) {
                    return new DERTaggedObject(false, tag & 0x1F, new DERNull());
                }
                return new DERTaggedObject(false, tag & 0x1F, new DERConstructedSequence());
            }
            if ((tag & 0x20) == 0) {
                return new DERTaggedObject(false, tag & 0x1F, new DEROctetString(bytes));
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            BERInputStream dIn = new BERInputStream(bIn);
            DERObject dObj = dIn.readObject();
            if (dIn.available() == 0) {
                return new DERTaggedObject(tag & 0x1F, dObj);
            }
            DERConstructedSequence seq = new DERConstructedSequence();
            seq.addObject(dObj);
            try {
                while (true) {
                    dObj = dIn.readObject();
                    seq.addObject(dObj);
                }
            }
            catch (EOFException eOFException) {
                FFDCFilter.processException((Throwable)eOFException, (String)"com.ibm.ws.transport.iiop.asn1.DERInputStream", (String)"259", (Object)this, (Object[])new Object[]{tag, bytes});
                return new DERTaggedObject(false, tag & 0x1F, seq);
            }
        }
        return new DERUnknownTag(tag, bytes);
    }

    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.readLength();
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DERInputStream.class);
    }
}

