/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import com.ibm.ws.kernel.service.util.JavaInfo;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class SSLUtils {
    private static SSLContext defaultSSLContext;

    public static SSLSocketFactory createDefaultSSLSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLUtils.createDefaultSSLContext();
        return sslContext.getSocketFactory();
    }

    public static SSLContext createDefaultSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        if (defaultSSLContext == null) {
            defaultSSLContext = SSLUtils.isIBMJVM() ? SSLUtils.newSSLContext("SSL_TLSv2", "TLSv1.1") : SSLUtils.newSSLContext("TLSv1.2", "TLSv1.1");
        }
        return defaultSSLContext;
    }

    private static SSLContext newSSLContext(String primaryProtocol, String defaultProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(primaryProtocol);
        }
        catch (NoSuchAlgorithmException e) {
            sslContext = SSLContext.getInstance(defaultProtocol);
        }
        sslContext.init(null, null, null);
        return sslContext;
    }

    private static boolean isIBMJVM() {
        return JavaInfo.vendor() == JavaInfo.Vendor.IBM;
    }
}

