/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class JsonUtils {
    public static String serialize(JsonStructure json) {
        StringWriter stWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stWriter);
        jsonWriter.write(json);
        jsonWriter.close();
        return stWriter.toString();
    }

    public static JsonObject deserialize(String json) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        return jsonReader.readObject();
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        if (jsonValue instanceof JsonObject) {
            return (JsonObject)jsonValue;
        }
        return null;
    }

    public static String getString(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        if (jsonValue instanceof JsonString) {
            return ((JsonString)jsonValue).getString();
        }
        return null;
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String name) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
        if (jsonValue instanceof JsonArray) {
            return (JsonArray)jsonValue;
        }
        return null;
    }

    public static Object jsonValueToObject(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                JsonArray array = (JsonArray)jsonValue;
                for (JsonValue item : array) {
                    list.add(JsonUtils.jsonValueToObject(item));
                }
                return list;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)jsonValue;
                if (number.isIntegral()) {
                    return number.longValue();
                }
                return number.doubleValue();
            }
            case OBJECT: {
                JsonObject innerObject = (JsonObject)jsonValue;
                return JsonUtils.jsonObjectToMap(innerObject);
            }
            case STRING: {
                JsonString string = (JsonString)jsonValue;
                return string.getString();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static Map<String, Object> jsonObjectToMap(JsonObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            Object value = JsonUtils.jsonValueToObject((JsonValue)entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    public static JsonArray listToJsonArray(List<?> list) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Object value : list) {
            if (value == null) {
                builder.addNull();
                continue;
            }
            if (value instanceof Boolean) {
                builder.add(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                builder.add(((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                builder.add(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                builder.add((String)value);
                continue;
            }
            if (value instanceof List) {
                builder.add((JsonValue)JsonUtils.listToJsonArray((List)value));
                continue;
            }
            if (value instanceof Map) {
                builder.add((JsonValue)JsonUtils.mapToJsonObject((Map)value));
                continue;
            }
            throw new RuntimeException("unsupported");
        }
        return builder.build();
    }

    public static JsonObject mapToJsonObject(Map<String, ?> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                builder.addNull(key);
                continue;
            }
            if (value instanceof Boolean) {
                builder.add(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                builder.add(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                builder.add(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                builder.add(key, (String)value);
                continue;
            }
            if (value instanceof List) {
                builder.add(key, (JsonValue)JsonUtils.listToJsonArray((List)value));
                continue;
            }
            if (value instanceof Map) {
                builder.add(key, (JsonValue)JsonUtils.mapToJsonObject((Map)value));
                continue;
            }
            throw new RuntimeException("unsupported");
        }
        return builder.build();
    }
}

