/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;

public class CreateServiceAction
extends BaseAction {
    private static final Option KEY_NAME_OPT = new Option("credentialName", true);

    public CreateServiceAction() {
        this.registerOption(KEY_NAME_OPT);
        this.registerArguments("serviceType", "servicePlan", "serviceName");
    }

    @Override
    public String getActionName() {
        return "createService";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        String serviceType = arguments.getPositionalArguments().get(0);
        String plan = arguments.getPositionalArguments().get(1);
        String serviceInstance = arguments.getPositionalArguments().get(2);
        String serviceKeyName = arguments.getOption(KEY_NAME_OPT);
        if (serviceKeyName == null) {
            serviceKeyName = "credential-1";
        }
        BluemixClient client = BluemixClient.getBluemixClient();
        CloudFoundryServiceInstance service = null;
        try {
            service = client.createService(serviceType, plan, serviceInstance);
            this.stdout.println(NLS.getOption("createService.service.created", serviceInstance));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("CWWKR0242E")) {
                service = client.getService(serviceInstance);
                if (!(serviceType.equals(service.getService().getLabel()) && plan.equals(service.getPlan().getName()) && service.getServiceKeys().isEmpty())) {
                    throw e;
                }
            }
            throw e;
        }
        CloudFoundryServiceKey key = client.createServiceKey(service.getGuid(), serviceKeyName);
        this.stdout.println(NLS.getOption("createService.key.created", key.getName(), service.getName()));
        return ReturnCode.OK;
    }
}

