/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.AdminScriptResourceImpl;
import com.ibm.ws.repository.resources.internal.ConfigSnippetResourceImpl;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.internal.IfixResourceImpl;
import com.ibm.ws.repository.resources.internal.ProductResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.SampleResourceImpl;
import com.ibm.ws.repository.resources.internal.ToolResourceImpl;
import com.ibm.ws.repository.transport.model.Asset;

public class ResourceFactory {
    private static ResourceFactory _instance;

    private ResourceFactory() {
    }

    public static synchronized ResourceFactory getInstance() {
        if (_instance == null) {
            _instance = new ResourceFactory();
        }
        return _instance;
    }

    public RepositoryResourceImpl createResourceFromAsset(Asset ass, RepositoryConnection connection) throws RepositoryBackendException {
        RepositoryResourceImpl result = null == ass.getWlpInformation() || ass.getType() == null ? new RepositoryResourceImpl(connection, ass){} : (RepositoryResourceImpl)this.createResource(ass.getType(), connection, ass);
        result.parseAttachmentsInAsset();
        return result;
    }

    public <T extends RepositoryResource> T createResource(ResourceType type, RepositoryConnection connection, Asset ass) {
        RepositoryResourceImpl resource = null;
        switch (type) {
            case ADMINSCRIPT: {
                resource = new AdminScriptResourceImpl(connection, ass);
                break;
            }
            case CONFIGSNIPPET: {
                resource = new ConfigSnippetResourceImpl(connection, ass);
                break;
            }
            case FEATURE: {
                resource = new EsaResourceImpl(connection, ass);
                break;
            }
            case IFIX: {
                resource = new IfixResourceImpl(connection, ass);
                break;
            }
            case ADDON: 
            case INSTALL: {
                ProductResourceImpl product = new ProductResourceImpl(connection, ass);
                product.setType(type);
                resource = product;
                break;
            }
            case OPENSOURCE: 
            case PRODUCTSAMPLE: {
                SampleResourceImpl sample = new SampleResourceImpl(connection, ass);
                sample.setType(type);
                resource = sample;
                break;
            }
            case TOOL: {
                resource = new ToolResourceImpl(connection, ass);
                break;
            }
            default: {
                resource = new RepositoryResourceImpl(connection, ass){};
            }
        }
        return (T)resource;
    }
}

