/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources;

import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.DownloadPolicy;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;

public interface RepositoryResource {
    public RepositoryConnection getRepositoryConnection();

    public String getId();

    public String getName();

    public String getProviderName();

    public String getProviderUrl();

    public ResourceType getType();

    public String getDescription();

    public String getVersion();

    public long getMainAttachmentSize();

    public String getMainAttachmentSHA256();

    public DownloadPolicy getDownloadPolicy();

    public String getFeaturedWeight();

    public String getAppliesToVersions(Collection<ProductDefinition> var1);

    public AttachmentResource getMainAttachment() throws RepositoryBackendException, RepositoryResourceException;

    public AttachmentResource getAttachment(String var1) throws RepositoryBackendException, RepositoryResourceException;

    public Collection<AttachmentResource> getAttachments() throws RepositoryBackendException, RepositoryResourceException;

    public AttachmentResource getLicense(Locale var1) throws RepositoryBackendException, RepositoryResourceException;

    public AttachmentResource getLicenseAgreement(Locale var1) throws RepositoryBackendException, RepositoryResourceException;

    public AttachmentResource getLicenseInformation(Locale var1) throws RepositoryBackendException, RepositoryResourceException;

    public LicenseType getLicenseType();

    public String getLicenseId();

    public String getShortDescription();

    public DisplayPolicy getDisplayPolicy();

    public String getWlpInformationVersion();

    public void writeDiskRepoJSONToStream(OutputStream var1) throws RepositoryResourceException;

    public void dump(OutputStream var1);
}

