/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.InfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.PackageInfo;
import java.text.MessageFormat;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PackageInfoImpl
extends InfoImpl
implements PackageInfo {
    private static final TraceComponent tc = Tr.register(PackageInfoImpl.class);
    public static final String CLASS_NAME = PackageInfoImpl.class.getName();
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    protected boolean isArtificial = false;
    protected boolean forFailedLoad = false;
    static final long serialVersionUID = 2177381707592473332L;

    public static boolean isPackageName(String className) {
        return className.endsWith(PACKAGE_INFO_CLASS_NAME);
    }

    public static String stripPackageNameFromClassName(String className) {
        return className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
    }

    public static String addClassNameToPackageName(String packageName) {
        return packageName + "." + PACKAGE_INFO_CLASS_NAME;
    }

    public PackageInfoImpl(String name, int modifiers, InfoStoreImpl infoStore) {
        super(name, modifiers, infoStore);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init> Created [ {0} ]", (Object[])new Object[]{this.getHashText()});
        }
    }

    @Override
    protected String internName(String name) {
        return this.getInfoStore().internPackageName(name);
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        if (logger.isDebugEnabled()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format(" Package [ {0} ]", this.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  isArtifical [ {0} ]", this.getIsArtificial()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  forFailedLoad [ {0} ]", this.getForFailedLoad()), (Object[])new Object[0]);
            this.logAnnotations(logger);
        }
    }

    @Override
    public boolean getIsArtificial() {
        return this.isArtificial;
    }

    protected void setIsArtificial(boolean isArtificial) {
        this.isArtificial = isArtificial;
    }

    @Override
    public boolean getForFailedLoad() {
        return this.forFailedLoad;
    }

    public void setForFailedLoad(boolean forFailedLoad) {
        this.forFailedLoad = forFailedLoad;
    }
}

