/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ScanCounts;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ClassSourceImpl
implements ClassSource {
    private static final TraceComponent tc = Tr.register(ClassSourceImpl.class);
    public static final String CLASS_NAME = ClassSourceImpl.class.getName();
    protected final String hashText;
    protected final ClassSourceImpl_Factory factory;
    protected final String name;
    protected final String canonicalName;
    protected ClassSource parentSource;
    protected final Util_InternMap internMap;
    protected final ClassSourceImpl_ScanCounts scanCounts;
    protected int resourceExclusionCount;
    protected int classExclusionCount;
    protected int classInclusionCount;
    static final long serialVersionUID = 283037046212447331L;

    @Override
    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    public String toString() {
        return this.hashText;
    }

    protected ClassSourceImpl(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, String hashTextSuffix) {
        this.factory = factory;
        this.internMap = internMap;
        this.name = name;
        this.canonicalName = factory.getCanonicalName(this.name);
        this.parentSource = null;
        String useHashText = AnnotationServiceImpl_Logging.getBaseHash(this);
        useHashText = useHashText + "(" + this.canonicalName;
        if (hashTextSuffix != null) {
            useHashText = useHashText + ", " + hashTextSuffix;
        }
        this.hashText = useHashText = useHashText + ")";
        this.scanCounts = new ClassSourceImpl_ScanCounts();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] InternMap [ {1} ]", this.hashText, internMap.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public ClassSourceImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    public String getName() {
        return this.name;
    }

    @Override
    @Trivial
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    @Trivial
    public ClassSource getParentSource() {
        return this.parentSource;
    }

    @Override
    public void setParentSource(ClassSource parentSource) {
        this.parentSource = parentSource;
    }

    @Trivial
    public boolean getConvertResourceNames() {
        return false;
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        return externalResourceName;
    }

    @Override
    public String outconvertResourceName(String resourceName) {
        return resourceName;
    }

    @Override
    @Trivial
    public Util_InternMap getInternMap() {
        return this.internMap;
    }

    protected String internClassName(String className) {
        return this.getInternMap().intern(className);
    }

    @Override
    public abstract void open() throws ClassSource_Exception;

    @Override
    public abstract void close() throws ClassSource_Exception;

    @Override
    @Trivial
    public boolean isDirectoryResource(String resourceName) {
        return resourceName.endsWith("/");
    }

    @Override
    @Trivial
    public boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    @Override
    public String getClassNameFromResourceName(String resourceName) {
        int endingOffset = resourceName.length() - ".class".length();
        String className = resourceName.substring(0, endingOffset);
        className = className.replace('/', '.');
        return className;
    }

    @Override
    public String getResourceNameFromClassName(String className) {
        return className.replace('.', '/') + ".class";
    }

    @Override
    public String resourceAppend(String head, String tail) {
        if (head.isEmpty()) {
            return tail;
        }
        return head + '/' + tail;
    }

    @Override
    @Trivial
    public ClassSourceImpl_ScanCounts getScanResults() {
        return this.scanCounts;
    }

    protected void markResult(ClassSource_ScanCounts.ResultField resultField) {
        this.scanCounts.increment(resultField);
    }

    protected void addResults(ClassSource_ScanCounts seepCounts) {
        this.scanCounts.addResults(seepCounts);
    }

    @Override
    @Trivial
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return this.scanCounts.getResult(resultField);
    }

    @Override
    public abstract void scanClasses(ClassSource_Streamer var1, Set<String> var2, ClassSource_Aggregate.ScanPolicy var3);

    @Override
    @Trivial
    public boolean scanSpecificSeedClass(String className, ClassSource_Streamer streamer) throws ClassSource_Exception {
        return this.scanClass(streamer, className, ClassSource_Aggregate.ScanPolicy.SEED);
    }

    @Override
    @Trivial
    public boolean scanReferencedClass(String referencedClassName, ClassSource_Streamer streamer) throws ClassSource_Exception {
        return this.scanClass(streamer, referencedClassName, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected boolean scanClass(ClassSource_Streamer streamer, String className, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        Object[] logParms;
        String methodName = "scanClass";
        if (tc.isEntryEnabled()) {
            logParms = new Object[]{this.getHashText(), className};
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] Name [ {1} ]", logParms)});
        } else {
            logParms = null;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            if (logParms != null) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ false ]: Filtered by streamer", logParms));
            }
            return false;
        }
        String resourceName = this.getResourceNameFromClassName(className);
        InputStream inputStream = this.openResourceStream(className, resourceName);
        if (inputStream == null) {
            if (logParms != null) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ false ]: No resource is available", logParms));
            }
            return false;
        }
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, inputStream);
        }
        if (logParms != null) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ true ]", logParms));
        }
        return true;
    }

    @Trivial
    protected boolean i_maybeAdd(String i_resourceName, Set<String> i_seedClassNamesSet) {
        String methodName = "i_maybeAdd";
        boolean didAdd = !i_seedClassNamesSet.contains(i_resourceName);
        if (didAdd) {
            i_seedClassNamesSet.add(i_resourceName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] Resource [ {1} ]: [ {2} ]", this.getHashText(), i_resourceName, didAdd)});
        }
        return didAdd;
    }

    @Override
    public InputStream openClassStream(String className) throws ClassSource_Exception {
        String resourceName = this.getResourceNameFromClassName(className);
        return this.openResourceStream(className, resourceName);
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) {
        String resourceName = this.getResourceNameFromClassName(className);
        this.closeResourceStream(className, resourceName, inputStream);
    }

    @Override
    public abstract InputStream openResourceStream(String var1, String var2) throws ClassSource_Exception;

    @Override
    public abstract void closeResourceStream(String var1, String var2, InputStream var3);

    protected void incrementResourceExclusionCount() {
        ++this.resourceExclusionCount;
    }

    @Override
    @Trivial
    public int getResourceExclusionCount() {
        return this.resourceExclusionCount;
    }

    protected void incrementClassExclusionCount() {
        ++this.classExclusionCount;
    }

    @Override
    @Trivial
    public int getClassExclusionCount() {
        return this.classExclusionCount;
    }

    protected void incrementClassInclusionCount() {
        ++this.classInclusionCount;
    }

    @Override
    @Trivial
    public int getClassInclusionCount() {
        return this.classInclusionCount;
    }

    @Override
    @Trivial
    public void logState() {
        TraceComponent stateLogger = AnnotationServiceImpl_Logging.stateLogger;
        if (stateLogger.isDebugEnabled()) {
            this.log(stateLogger);
        }
    }

    @Override
    public abstract void log(TraceComponent var1);

    @Trivial
    protected void logCounts(TraceComponent logger) {
        if (logger.isDebugEnabled()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Included classes: [ {0} ]", this.getClassInclusionCount()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Excluded classes: [ {0} ]", this.getClassExclusionCount()), (Object[])new Object[0]);
        }
    }
}

