/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsMessageHandle;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class JsMessageHandleImpl
implements JsMessageHandle,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short versionNumber = 1;
    private static final TraceComponent tc = SibTr.register(JsMessageHandleImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private transient SIBUuid8 uuid;
    private Long value;
    private transient int hashcode;

    JsMessageHandleImpl(SIBUuid8 uuid, Long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{uuid, value});
        }
        this.uuid = uuid;
        this.value = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    JsMessageHandleImpl(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{value});
        }
        this.uuid = null;
        this.value = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public final SIBUuid8 getSystemMessageSourceUuid() {
        return this.uuid;
    }

    @Override
    public final long getSystemMessageValue() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj.hashCode() != this.hashCode()) {
            return false;
        }
        JsMessageHandleImpl other = (JsMessageHandleImpl)obj;
        if (!this.value.equals(other.value)) {
            return false;
        }
        if (this.uuid == other.uuid) {
            return true;
        }
        return this.uuid != null && this.uuid.equals((Object)other.uuid);
    }

    public final int hashCode() {
        if (this.hashcode == 0) {
            long hashval = 0L;
            if (this.uuid != null) {
                hashval = this.uuid.hashCode();
            }
            hashval += this.value.longValue();
            this.hashcode = (int)(hashval %= Integer.MAX_VALUE);
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.uuid == null ? "null" : this.uuid.toString());
        buff.append("_");
        buff.append(this.value.toString());
        return new String(buff);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeObject");
        }
        out.defaultWriteObject();
        byte[] id = null;
        if (this.uuid != null) {
            id = this.uuid.toByteArray();
        }
        out.writeObject(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readObject");
        }
        in.defaultReadObject();
        byte[] id = (byte[])in.readObject();
        if (id != null) {
            this.uuid = new SIBUuid8(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readObject");
        }
    }

    @Override
    public String getSystemMessageId() {
        if (this.uuid != null) {
            StringBuilder buff = new StringBuilder(this.uuid.toString());
            buff.append("_");
            buff.append(this.value);
            return new String(buff);
        }
        return null;
    }

    @Override
    public byte[] flattenToBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flattenToBytes");
        }
        int uuidBytesLength = 0;
        byte[] uuidBytes = null;
        if (this.uuid != null) {
            uuidBytes = this.uuid.toByteArray();
            uuidBytesLength = uuidBytes.length;
        }
        int totalArraySize = 6 + uuidBytesLength + 8;
        byte[] flattenedBytes = new byte[totalArraySize];
        int offset = 0;
        ArrayUtil.writeShort(flattenedBytes, offset, (short)1);
        ArrayUtil.writeInt(flattenedBytes, offset += 2, uuidBytesLength);
        offset += 4;
        if (this.uuid != null) {
            ArrayUtil.writeBytes(flattenedBytes, offset, uuidBytes);
            offset += uuidBytesLength;
        }
        ArrayUtil.writeLong(flattenedBytes, offset, this.value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flattenToBytes");
        }
        return flattenedBytes;
    }

    @Override
    public String flattenToString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flattenToString");
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = this.flattenToBytes();
        HexString.binToHex((byte[])bytes, (int)0, (int)bytes.length, (StringBuffer)buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flattenToString");
        }
        return new String(buffer);
    }
}

