/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.metatype;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.config.xml.internal.metatype.WSObjectClassDefinitionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.EquinoxObjectClassDefinition;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ExtendedObjectClassDefinitionImpl
implements ExtendedObjectClassDefinition {
    private static final List<String> EXPOSED_FILTERS;
    private final ObjectClassDefinition delegate;
    private final String parentPid;
    private final String alias;
    private final boolean extraProperties;
    private String action;
    private String localization;
    private final boolean supportsExtensions;
    private final boolean supportsHiddenExtensions;
    private final String extendsAlias;
    private final String extendsAttribute;
    private final String childAlias;
    private int anyCount;
    private String excludedChildren;
    private List<String> objectClass;
    private boolean requireExplicitConfiguration;
    private String pid;
    private boolean beta;
    static final long serialVersionUID = -5356085438660987379L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public static ExtendedObjectClassDefinitionImpl newExtendedObjectClassDefinition(ObjectClassDefinition ocd, String bundleLocation) {
        if (ocd instanceof EquinoxObjectClassDefinition) {
            return new ExtendedObjectClassDefinitionImpl((EquinoxObjectClassDefinition)ocd, bundleLocation);
        }
        if (ocd instanceof WSObjectClassDefinitionImpl) {
            return new ExtendedObjectClassDefinitionImpl((WSObjectClassDefinitionImpl)ocd, bundleLocation);
        }
        return new ExtendedObjectClassDefinitionImpl(ocd);
    }

    private ExtendedObjectClassDefinitionImpl(WSObjectClassDefinitionImpl ocd, String bundleLocation) {
        this.delegate = ocd;
        this.parentPid = ocd.getParentPID();
        this.alias = ExtendedObjectClassDefinitionImpl.getAliasName(ocd.getAlias(), bundleLocation);
        this.extraProperties = false;
        this.supportsExtensions = ocd.supportsExtensions() || ocd.supportsHiddenExtensions();
        this.supportsHiddenExtensions = ocd.supportsHiddenExtensions();
        this.childAlias = ocd.getChildAlias();
        this.extendsAlias = ocd.getExtendsAlias();
        this.extendsAttribute = ocd.getExtends();
        this.objectClass = ocd.getObjectClass();
        if (ocd instanceof ExtendedObjectClassDefinition) {
            this.anyCount = ((ExtendedObjectClassDefinition)((Object)ocd)).getXsdAny();
            this.excludedChildren = ((ExtendedObjectClassDefinition)((Object)ocd)).getExcludedChildren();
            this.action = ((ExtendedObjectClassDefinition)((Object)ocd)).getAction();
            this.requireExplicitConfiguration = !((ExtendedObjectClassDefinition)((Object)ocd)).hasAllRequiredDefaults();
            this.beta = ((ExtendedObjectClassDefinition)((Object)ocd)).isBeta();
        }
    }

    private ExtendedObjectClassDefinitionImpl(EquinoxObjectClassDefinition extendedOcd, String bundleLocation) {
        String anyVal;
        this.delegate = extendedOcd;
        Set supportedExtensions = extendedOcd.getExtensionUris();
        Map extensions = supportedExtensions != null && supportedExtensions.contains("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0") ? extendedOcd.getExtensionAttributes("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0") : Collections.emptyMap();
        Map uiExtensions = supportedExtensions != null && supportedExtensions.contains("http://www.ibm.com/xmlns/appservers/osgi/metatype/ui/v1.0.0") ? extendedOcd.getExtensionAttributes("http://www.ibm.com/xmlns/appservers/osgi/metatype/ui/v1.0.0") : Collections.emptyMap();
        this.parentPid = (String)extensions.get("parentPid");
        this.alias = ExtendedObjectClassDefinitionImpl.getAliasName((String)extensions.get("alias"), bundleLocation);
        this.extraProperties = "true".equalsIgnoreCase((String)uiExtensions.get("extraProperties"));
        this.action = (String)extensions.get("action");
        this.localization = (String)uiExtensions.get("localization");
        this.supportsExtensions = extensions.get("supportExtensions") != null || extensions.get("supportHiddenExtensions") != null;
        this.supportsHiddenExtensions = extensions.get("supportHiddenExtensions") != null;
        this.extendsAlias = (String)extensions.get("extendsAlias");
        this.extendsAttribute = (String)extensions.get("extends");
        this.childAlias = (String)extensions.get("childAlias");
        this.excludedChildren = (String)extensions.get("excludeChildren");
        this.requireExplicitConfiguration = "true".equalsIgnoreCase((String)extensions.get("requireExplicitConfiguration"));
        this.beta = "true".equalsIgnoreCase((String)extensions.get("beta"));
        for (EquinoxAttributeDefinition ad : extendedOcd.getAttributeDefinitions(-1)) {
            if (!EXPOSED_FILTERS.contains(ad.getID())) continue;
            if (this.objectClass == null) {
                this.objectClass = Collections.singletonList(ad.getID());
                continue;
            }
            if (this.objectClass.size() == 1) {
                this.objectClass = new ArrayList<String>(this.objectClass);
            }
            this.objectClass.add(ad.getID());
        }
        String objectcl = (String)extensions.get("objectClass");
        if (objectcl != null) {
            if (this.objectClass == null) {
                this.objectClass = Arrays.asList(objectcl.split("[, ]+"));
            } else {
                if (this.objectClass.size() == 1) {
                    this.objectClass = new ArrayList<String>(this.objectClass);
                }
                for (String service : objectcl.split("[, ]+")) {
                    if (this.objectClass.contains(service)) continue;
                    this.objectClass.add(service);
                }
            }
        }
        if ((anyVal = (String)extensions.get("any")) != null) {
            try {
                this.anyCount = Integer.parseInt(anyVal);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinitionImpl", (String)"162", (Object)this, (Object[])new Object[]{extendedOcd, bundleLocation});
            }
        }
    }

    private ExtendedObjectClassDefinitionImpl(ObjectClassDefinition delegate) {
        this.delegate = delegate;
        this.parentPid = null;
        this.alias = null;
        this.extraProperties = false;
        this.localization = null;
        this.supportsExtensions = false;
        this.supportsHiddenExtensions = false;
        this.extendsAlias = null;
        this.extendsAttribute = null;
        this.childAlias = null;
        this.excludedChildren = null;
        this.requireExplicitConfiguration = false;
    }

    public String toString() {
        return super.toString() + '[' + this.delegate.getID() + ']';
    }

    @Trivial
    public String getName() {
        return this.delegate.getName();
    }

    @Trivial
    public String getID() {
        return this.delegate.getID();
    }

    @Trivial
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Trivial
    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        return this.delegate.getAttributeDefinitions(filter);
    }

    @Trivial
    public InputStream getIcon(int size) throws IOException {
        return this.delegate.getIcon(size);
    }

    @Override
    @Trivial
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Trivial
    public List<String> getObjectClass() {
        return this.objectClass;
    }

    @Override
    @Trivial
    public String getParentPID() {
        return this.parentPid;
    }

    @Override
    @Trivial
    public boolean hasExtraProperties() {
        return this.extraProperties;
    }

    @Override
    @Trivial
    public String getLocalization() {
        return this.localization;
    }

    @Override
    @Trivial
    public ObjectClassDefinition getDelegate() {
        return this.delegate;
    }

    @Override
    @Trivial
    public Map<String, ExtendedAttributeDefinition> getAttributeMap() {
        Map<String, ExtendedAttributeDefinition> map = null;
        AttributeDefinition[] attrDefs = this.getAttributeDefinitions(-1);
        if (attrDefs != null) {
            map = new HashMap();
            for (AttributeDefinition attrDef : attrDefs) {
                map.put(attrDef.getID(), new ExtendedAttributeDefinitionImpl(attrDef));
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    @Override
    @Trivial
    public boolean hasAllRequiredDefaults() {
        AttributeDefinition[] attrDefs;
        if (this.requireExplicitConfiguration) {
            return false;
        }
        AttributeDefinition[] requiredAttributes = this.getAttributeDefinitions(1);
        if (requiredAttributes != null) {
            for (AttributeDefinition attrDef : requiredAttributes) {
                String[] defaultValues = attrDef.getDefaultValue();
                if (defaultValues != null) continue;
                return false;
            }
        }
        if ((attrDefs = this.getAttributeDefinitions(-1)) != null) {
            for (AttributeDefinition attrDef : attrDefs) {
                String[] defaultValues = attrDef.getDefaultValue();
                if (defaultValues == null || defaultValues.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Trivial
    public List<AttributeDefinition> getRequiredAttributes() {
        return Arrays.asList(this.getAttributeDefinitions(1));
    }

    @Override
    public String getExtendsAlias() {
        return this.extendsAlias;
    }

    @Override
    @Trivial
    public String getExtends() {
        return this.extendsAttribute;
    }

    @Override
    @Trivial
    public String getChildAlias() {
        return this.childAlias;
    }

    @Override
    @Trivial
    public boolean supportsExtensions() {
        return this.supportsExtensions;
    }

    @Override
    @Trivial
    public boolean supportsHiddenExtensions() {
        return this.supportsHiddenExtensions;
    }

    private static String getAliasName(String alias, String bundleLocation) {
        String newAlias = alias;
        if (alias != null && !alias.isEmpty()) {
            try {
                if (bundleLocation != null && !bundleLocation.isEmpty() && !bundleLocation.startsWith("kernel@")) {
                    if (bundleLocation.startsWith("feature@")) {
                        int index = bundleLocation.indexOf("productExtension:");
                        if (index != -1) {
                            int endIndex = bundleLocation.indexOf(":", index += "productExtension:".length());
                            String productName = bundleLocation.substring(index, endIndex);
                            newAlias = productName + "_" + alias;
                        }
                    } else if (!bundleLocation.startsWith("ConnectorModuleMetatype@")) {
                        newAlias = null;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinitionImpl", (String)"409", null, (Object[])new Object[]{alias, bundleLocation});
            }
        }
        return newAlias;
    }

    @Override
    public int getXsdAny() {
        return this.anyCount;
    }

    @Override
    public String getExcludedChildren() {
        return this.excludedChildren;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Override
    public boolean isBeta() {
        return this.beta;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ExtendedObjectClassDefinitionImpl.class);
        EXPOSED_FILTERS = Arrays.asList("com.ibm.ws.zos.connect.interceptorType", "com.ibm.ws.zos.connect.dataXformType", "com.ibm.ws.zos.connect.serviceType");
    }
}

