/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.url.contexts.javacolon.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jndi.url.contexts.javacolon.internal.JavaURLEnumeration;
import com.ibm.ws.jndi.url.contexts.javacolon.internal.JavaURLName;
import com.ibm.ws.jndi.url.contexts.javacolon.internal.JavaURLNameParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JavaURLContext
implements Context {
    private final ConcurrentServiceReferenceSet<JavaColonNamingHelper> helperServices;
    private final Map<String, Object> environment = new ConcurrentHashMap<String, Object>();
    private static final JavaURLNameParser parser;
    private final Name base;
    static final long serialVersionUID = 1145284768051667081L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    private static CompositeName newCompositeName(String nameString) throws NameNotFoundException {
        CompositeName name;
        try {
            name = new CompositeName(nameString);
        }
        catch (InvalidNameException invalidNameException) {
            void ine;
            FFDCFilter.processException((Throwable)invalidNameException, (String)"com.ibm.ws.jndi.url.contexts.javacolon.internal.JavaURLContext", (String)"60", null, (Object[])new Object[]{nameString});
            NameNotFoundException nnfe = new NameNotFoundException(nameString);
            nnfe.initCause((Throwable)ine);
            throw nnfe;
        }
        return name;
    }

    JavaURLContext(Hashtable<?, ?> envmt, ConcurrentServiceReferenceSet<JavaColonNamingHelper> helperServices) {
        this.environment.putAll(envmt);
        this.base = null;
        this.helperServices = helperServices;
    }

    JavaURLContext(Hashtable<?, ?> envmt, ConcurrentServiceReferenceSet<JavaColonNamingHelper> helperServices, Name base) {
        this.environment.putAll(envmt);
        this.base = base;
        this.helperServices = helperServices;
    }

    private JavaURLContext(Name base, JavaURLContext copy) {
        this.environment.putAll(copy.environment);
        this.base = base;
        this.helperServices = copy.helperServices;
    }

    Name getBase() {
        return this.base;
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.environment.put(s, o);
    }

    @Override
    public void bind(Name n, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Name composeName(Name n, Name pfx) throws NamingException {
        return ((Name)pfx.clone()).addAll(n);
    }

    @Override
    public String composeName(String s, String pfx) throws NamingException {
        return this.composeName(JavaURLContext.newCompositeName(s), parser.parse(pfx)).toString();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Context createSubcontext(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, Object> envmt = new Hashtable<String, Object>();
        envmt.putAll(this.environment);
        return envmt;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.base == null ? "java:" : this.base.toString();
    }

    @Override
    public NameParser getNameParser(Name n) throws NamingException {
        return parser;
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return parser;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name n) throws NamingException {
        HashSet<NameClassPair> allInstances = new HashSet<NameClassPair>();
        NameUtil nameUtil = new NameUtil(n);
        if (nameUtil.getNamespace() == NamingConstants.JavaColonNamespace.COMP) {
            allInstances.add(new NameClassPair("env", Context.class.getName()));
            allInstances.add(new NameClassPair("websphere", Context.class.getName()));
        } else if ("java:".equals(nameUtil.getNamespace().toString())) {
            allInstances.add(new NameClassPair("comp", Context.class.getName()));
        }
        Iterator it = this.helperServices.getServices();
        while (it.hasNext()) {
            JavaColonNamingHelper helperService = (JavaColonNamingHelper)it.next();
            allInstances.addAll(helperService.listInstances(nameUtil.getNamespace(), nameUtil.getNameInContext()));
        }
        if (allInstances.isEmpty()) {
            throw new NameNotFoundException(n.toString());
        }
        return new JavaURLEnumeration<NameClassPair>(allInstances);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
        return this.list(JavaURLContext.newCompositeName(s));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name n) throws NamingException {
        HashSet<Binding> bindings = new HashSet<Binding>();
        NamingEnumeration<NameClassPair> pairs = this.list(n);
        if (pairs.hasMore()) {
            Context ctx = (Context)this.lookup(n);
            while (pairs.hasMore()) {
                NameClassPair pair = pairs.next();
                Binding binding = new Binding(pair.getName(), pair.getClassName(), ctx.lookup(pair.getName()));
                bindings.add(binding);
            }
        }
        return new JavaURLEnumeration<Binding>(bindings);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
        return this.listBindings(JavaURLContext.newCompositeName(s));
    }

    @Override
    public Object lookup(Name inName) throws NamingException {
        JavaColonNamingHelper helperService;
        JavaColonNamingHelper helperService2;
        NameUtil nameUtil = new NameUtil(inName);
        Object toReturn = null;
        if (nameUtil.getStringNameWithoutPrefix().equals("")) {
            return new JavaURLContext(nameUtil.getName(), this);
        }
        Iterator it = this.helperServices.getServices();
        while (it.hasNext() && (toReturn = (helperService2 = (JavaColonNamingHelper)it.next()).getObjectInstance(nameUtil.getNamespace(), nameUtil.getNameInContext())) == null) {
        }
        if (toReturn != null) {
            return toReturn;
        }
        boolean hasPrefix = false;
        Iterator it2 = this.helperServices.getServices();
        while (it2.hasNext() && !(hasPrefix = (helperService = (JavaColonNamingHelper)it2.next()).hasObjectWithPrefix(nameUtil.getNamespace(), nameUtil.getNameInContext()))) {
        }
        if (!hasPrefix) {
            throw new NameNotFoundException(NameNotFoundException.class.getName() + ": " + nameUtil.getName().toString());
        }
        return new JavaURLContext(nameUtil.getName(), this);
    }

    @Override
    public Object lookup(String s) throws NamingException {
        if (s == null) {
            throw new InvalidNameException();
        }
        return this.lookup(JavaURLContext.newCompositeName(s));
    }

    @Override
    public Object lookupLink(Name n) throws NamingException {
        return this.lookup(n);
    }

    @Override
    public Object lookupLink(String s) throws NamingException {
        return this.lookup(s);
    }

    @Override
    public void rebind(Name n, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return this.environment.remove(s);
    }

    @Override
    public void rename(Name nOld, Name nNew) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String sOld, String sNew) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JavaURLContext.class);
        parser = new JavaURLNameParser();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class NameUtil {
        private final Name name;
        private final NamingConstants.JavaColonNamespace namespace;
        private final String nameInContext;
        private final String stringNameWithoutPrefix;
        static final long serialVersionUID = 5809327288527065888L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameUtil(Name n) throws NamingException {
            if (n == null) {
                throw new InvalidNameException();
            }
            if (JavaURLContext.this.base != null) {
                n = JavaURLContext.this.composeName(n, JavaURLContext.this.base);
            }
            if (!(n instanceof JavaURLName)) {
                n = parser.parse(n);
            }
            this.namespace = parser.getJavaNamespaceFromName(n);
            this.nameInContext = parser.getStringNameWithoutPrefix(n);
            this.stringNameWithoutPrefix = parser.getStringNameWithoutPrefix(n);
            this.name = n;
        }

        public String getStringNameWithoutPrefix() {
            return this.stringNameWithoutPrefix;
        }

        public String getNameInContext() {
            return this.nameInContext;
        }

        public NamingConstants.JavaColonNamespace getNamespace() {
            return this.namespace;
        }

        public Name getName() throws NamingException {
            return this.name;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NameUtil.class);
        }
    }
}

